/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.notifyPacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.NotifyPacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.net.internal.SimplePacketIdentifier;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class Ack
extends NotifyPacket {
    public static final int LENGTH_FIXED = 30;
    public static final int LENGTH_VARIABLE = 6;
    private int __m_ContiguousFromMessageId;
    private int __m_ContiguousFromMessagePartIndex;
    private int __m_NewestFromMessageId;
    private int __m_NewestFromMessagePartIndex;
    private int __m_NewestToMessageId;
    private int __m_NewestToMessagePartIndex;
    private int __m_PreferredAckSize;

    public Ack() {
        this(null, null, true);
    }

    public Ack(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setPacketType(232718545);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public synchronized void addPacket(int nMsgId, int nMsgPart) {
        super.addPacket(nMsgId, nMsgPart);
    }

    public synchronized void addPacket(MessagePacket packet) {
        super.addPacket(packet);
    }

    public void close(Member member) {
        if (member != null) {
            this.flush(member);
            this.setNewestToPacketId(member.getNewestToPacketId());
            Member$FlowControl fc = member.getFlowControl();
            this.setPreferredAckSize(fc == null ? 65535 : Math.max(1, (fc.getOutstandingPacketThreshold() << 3) / 10));
        }
    }

    public void flush(Member member) {
        if (!(member != null) ? false : this.isFlushed() ^ true) {
            this.setNewestFromPacketId(member.getNewestFromPacketId());
            this.setContiguousFromPacketId(member.getContiguousFromPacketId());
            if (member.getPacketAck() == this) {
                member.setPacketAck(null);
            }
        }
    }

    public int getContiguousFromMessageId() {
        return this.__m_ContiguousFromMessageId;
    }

    public int getContiguousFromMessagePartIndex() {
        return this.__m_ContiguousFromMessagePartIndex;
    }

    public PacketIdentifier getContiguousFromPacketId(long lCurrent) {
        int iMsgId = this.getContiguousFromMessageId();
        if (iMsgId == 0) {
            return null;
        }
        long lMsgId = Packet.translateTrint(iMsgId, lCurrent);
        return new SimplePacketIdentifier(lMsgId, this.getContiguousFromMessagePartIndex());
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("NewestTo=").append(this.getNewestToMessageId()).append(':').append(this.getNewestToMessagePartIndex());
        sb.append(", ");
        sb.append("NewestFrom=").append(this.getNewestFromMessageId()).append(':').append(this.getNewestFromMessagePartIndex());
        sb.append(", ");
        sb.append("ContiguousFrom=").append(this.getContiguousFromMessageId()).append(':').append(this.getContiguousFromMessagePartIndex());
        sb.append(", ").append(super.getDescription());
        return sb.toString();
    }

    public int getNewestFromMessageId() {
        return this.__m_NewestFromMessageId;
    }

    public int getNewestFromMessagePartIndex() {
        return this.__m_NewestFromMessagePartIndex;
    }

    public PacketIdentifier getNewestFromPacketId(long lCurrent) {
        int iMsgId = this.getNewestFromMessageId();
        if (iMsgId == 0) {
            return null;
        }
        long lMsgId = Packet.translateTrint(iMsgId, lCurrent);
        return new SimplePacketIdentifier(lMsgId, this.getNewestFromMessagePartIndex());
    }

    public int getNewestToMessageId() {
        return this.__m_NewestToMessageId;
    }

    public int getNewestToMessagePartIndex() {
        return this.__m_NewestToMessagePartIndex;
    }

    public PacketIdentifier getNewestToPacketId(long lCurrent) {
        int iMsgId = this.getNewestToMessageId();
        if (iMsgId == 0) {
            return null;
        }
        long lMsgId = Packet.translateTrint(iMsgId, lCurrent);
        return new SimplePacketIdentifier(lMsgId, this.getNewestToMessagePartIndex());
    }

    public int getPreferredAckSize() {
        return this.__m_PreferredAckSize;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/notifyPacket/Ack".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Ack();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isFlushed() {
        return this.getNewestFromMessageId() != 0;
    }

    public void readBody(ReadBuffer.BufferInput input) throws IOException {
        this.setNewestToMessageId(Packet.readUnsignedTrint(input));
        this.setNewestToMessagePartIndex(Packet.readUnsignedTrint(input));
        this.setNewestFromMessageId(Packet.readUnsignedTrint(input));
        this.setNewestFromMessagePartIndex(Packet.readUnsignedTrint(input));
        this.setContiguousFromMessageId(Packet.readUnsignedTrint(input));
        this.setContiguousFromMessagePartIndex(Packet.readUnsignedTrint(input));
        this.setPreferredAckSize(input.readUnsignedShort());
        super.readBody(input);
    }

    public void setContiguousFromMessageId(int pContiguousFromMessageId) {
        this.__m_ContiguousFromMessageId = pContiguousFromMessageId;
    }

    public void setContiguousFromMessagePartIndex(int pContiguousFromMessageId) {
        this.__m_ContiguousFromMessagePartIndex = pContiguousFromMessageId;
    }

    public void setContiguousFromPacketId(PacketIdentifier ptid) {
        if (ptid == null) {
            this.setContiguousFromMessageId(0);
            this.setContiguousFromMessagePartIndex(0);
        } else {
            this.setContiguousFromMessageId(Packet.makeTrint(ptid.getFromMessageId()));
            this.setContiguousFromMessagePartIndex(ptid.getMessagePartIndex());
        }
    }

    public void setNewestFromMessageId(int pMaxSentId) {
        this.__m_NewestFromMessageId = pMaxSentId;
    }

    public void setNewestFromMessagePartIndex(int pMaxSentId) {
        this.__m_NewestFromMessagePartIndex = pMaxSentId;
    }

    public void setNewestFromPacketId(PacketIdentifier ptid) {
        if (ptid == null) {
            this.setNewestFromMessageId(0);
            this.setNewestFromMessagePartIndex(0);
        } else {
            this.setNewestFromMessageId(Packet.makeTrint(ptid.getFromMessageId()));
            this.setNewestFromMessagePartIndex(ptid.getMessagePartIndex());
        }
    }

    public void setNewestToMessageId(int pNewestToMessageId) {
        this.__m_NewestToMessageId = pNewestToMessageId;
    }

    public void setNewestToMessagePartIndex(int pMaxSentId) {
        this.__m_NewestToMessagePartIndex = pMaxSentId;
    }

    public void setNewestToPacketId(PacketIdentifier ptid) {
        if (ptid == null) {
            this.setNewestToMessageId(0);
            this.setNewestToMessagePartIndex(0);
        } else {
            this.setNewestToMessageId(Packet.makeTrint(ptid.getFromMessageId()));
            this.setNewestToMessagePartIndex(ptid.getMessagePartIndex());
        }
    }

    public void setPreferredAckSize(int cPackets) {
        this.__m_PreferredAckSize = cPackets;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        long cbSkip = 24L;
        long cbSkipped = input.skip(cbSkip);
        Component._assert(cbSkipped == cbSkip);
        NotifyPacket.skipBody(input);
    }

    public void writeBody(WriteBuffer.BufferOutput output) throws IOException {
        Packet.writeTrint(output, this.getNewestToMessageId());
        Packet.writeTrint(output, this.getNewestToMessagePartIndex());
        Packet.writeTrint(output, this.getNewestFromMessageId());
        Packet.writeTrint(output, this.getNewestFromMessagePartIndex());
        Packet.writeTrint(output, this.getContiguousFromMessageId());
        Packet.writeTrint(output, this.getContiguousFromMessagePartIndex());
        output.writeShort(this.getPreferredAckSize());
        super.writeBody(output);
    }
}

