/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$TcpRing;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Date;

public class ClusterService$NewMemberAnnounceReply
extends DiscoveryMessage {
    private long __m_PrevRecvTimestamp;
    private long __m_PrevSentTimestamp;
    private transient long __m_ThisRecvTimestamp;
    private long __m_ThisSentTimestamp;
    private static long __s_LastTraceMillis;

    public ClusterService$NewMemberAnnounceReply() {
        this(null, null, true);
    }

    public ClusterService$NewMemberAnnounceReply(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(8);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        long lPrevSentTimestamp = this.getPrevSentTimestamp();
        long lPrevRecvTimestamp = this.getPrevRecvTimestamp();
        long lThisSentTimestamp = this.getThisSentTimestamp();
        long lThisRecvTimestamp = this.getThisRecvTimestamp();
        String sPrevSentTimestamp = lPrevSentTimestamp == 0L ? "none" : new Date(lPrevSentTimestamp).toString();
        String sPrevRecvTimestamp = lPrevRecvTimestamp == 0L ? "none" : new Date(lPrevRecvTimestamp).toString();
        String sThisSentTimestamp = lThisSentTimestamp == 0L ? "none" : new Date(lThisSentTimestamp).toString();
        String sThisRecvTimestamp = lThisRecvTimestamp == 0L ? "none" : new Date(lThisRecvTimestamp).toString();
        return String.valueOf("ToMember=") + this.getToMember() + "\nPrevSentTimestamp=" + sPrevSentTimestamp + "\nPrevRecvTimestamp=" + sPrevRecvTimestamp + "\nThisSentTimestamp=" + sThisSentTimestamp + "\nThisRecvTimestamp=" + sThisRecvTimestamp + "\nMaxDeliveryVariance=" + this.getMaxDeliveryVariance();
    }

    public static long getLastTraceMillis() {
        return __s_LastTraceMillis;
    }

    protected int getMaxDeliveryVariance() {
        ClusterService service = (ClusterService)this.getService();
        return service.getTimestampMaxVariance();
    }

    public long getPrevRecvTimestamp() {
        return this.__m_PrevRecvTimestamp;
    }

    public long getPrevSentTimestamp() {
        return this.__m_PrevSentTimestamp;
    }

    protected long getThisRecvTimestamp() {
        return this.__m_ThisRecvTimestamp;
    }

    public long getThisSentTimestamp() {
        return this.__m_ThisSentTimestamp;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberAnnounceReply".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberAnnounceReply();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member memberFrom = this.getFromMember();
        Member memberTo = this.getToMember();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(-ClusterService.REJECT_VERSION, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                if (memberTo.equals(service.getAnnounceMember())) {
                    service.resetBroadcastCounter(null, this);
                    Cluster cluster = (Cluster)service.getCluster();
                    ClusterDependencies config = cluster.getDependencies();
                    if (cluster.isAuthorizedHost(memberFrom.getAddress()) ^ true) {
                        service.onMemberRejected(-ClusterService.REJECT_SENIOR, memberFrom);
                        throw new EventDeathException("Unauthorized senior");
                    }
                    ClusterService$TcpRing ring = service.getTcpRing();
                    if (!ring.isEnabled() ? false : ring.verifyReachable(memberFrom, 1000) ^ true) {
                        service.resetBroadcastCounter(String.valueOf("TcpRing failed to connect to") + " senior " + memberFrom + "; if this persists it is" + " likely the result of a local or remote firewall rule" + " blocking connections to TCP port " + memberFrom.getPort(), null);
                        return;
                    }
                    if (!(!config.isIpMonitorEnabled() ? false : memberFrom.getAddress().equals(memberTo.getAddress()) ^ true) ? false : cluster.getIpMonitor().verifyReachable(memberFrom) ^ true) {
                        service.resetBroadcastCounter(String.valueOf("IpMontor failed to verify ") + "the reachability of senior " + memberFrom + "; if this " + "persists it is likely the result of a local or remote " + "firewall rule blocking either ICMP pings, or " + "connections to TCP port 7", null);
                        return;
                    }
                    long cPrevSentMillis = this.getPrevSentTimestamp();
                    long cPrevRecvMillis = this.getPrevRecvTimestamp();
                    long cThisSentMillis = this.getThisSentTimestamp();
                    long cThisRecvMillis = this.getThisRecvTimestamp();
                    long cMillisGoing = cPrevRecvMillis - cPrevSentMillis;
                    long cMillisComing = cThisSentMillis - cThisRecvMillis;
                    long cMillisMaxVar = this.getMaxDeliveryVariance();
                    long cMillisVar = Math.abs(cMillisGoing - cMillisComing);
                    if (cMillisVar <= cMillisMaxVar) {
                        long cMillisDif = (cMillisGoing + cMillisComing) / (long)2;
                        service.setTimestampAdjustment(cMillisDif);
                        Member memberTemp = service.getAnnounceMember();
                        Member memberThis = service.instantiateMember();
                        memberThis.configure(memberTemp, service.getTimestamp());
                        service.setRequestMember(memberThis);
                        service.setState(ClusterService.STATE_JOINING);
                        break;
                    }
                    long lMillis = Base.getSafeTimeMillis();
                    int nLevel = 5;
                    if (lMillis - ClusterService$NewMemberAnnounceReply.getLastTraceMillis() >= (long)service.getBroadcastTimeoutMillis()) {
                        ClusterService$NewMemberAnnounceReply.setLastTraceMillis(lMillis);
                        nLevel = 3;
                    }
                    Component._trace(String.valueOf("Failed to satisfy the variance: allowed=") + cMillisMaxVar + ", actual=" + (cMillisGoing - cMillisComing), nLevel);
                    int cNewVariance = (int)Math.min(cMillisMaxVar + Math.max((cMillisVar - cMillisMaxVar) / (long)8, (long)1), (long)1000);
                    if (!((long)cNewVariance != cMillisMaxVar)) break;
                    service.setTimestampMaxVariance(cNewVariance);
                    Component._trace(String.valueOf("Increasing allowable variance to ") + cNewVariance, nLevel);
                    break;
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 1: {
                if (this.isReadError()) {
                    service.onMemberRejected(-ClusterService.REJECT_VERSION, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 2: {
                service.validateSeniorBroadcast(this, null);
                break;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        MessagePacket packet;
        super.read(input);
        this.setPrevSentTimestamp(input.readLong());
        this.setPrevRecvTimestamp(input.readLong());
        this.setThisSentTimestamp(input.readLong());
        MessagePacket[] aPacket = this.getPacket();
        if ((!(aPacket != null) ? false : aPacket.length > 0) && (packet = aPacket[0]) != null) {
            this.setThisRecvTimestamp(((ClusterService)this.getService()).calcTimestamp(packet.getReceivedMillis()));
        }
        this.ensureEOS(input);
    }

    protected static void setLastTraceMillis(long lMillis) {
        __s_LastTraceMillis = lMillis;
    }

    public void setPrevRecvTimestamp(long cMillis) {
        this.__m_PrevRecvTimestamp = cMillis;
    }

    public void setPrevSentTimestamp(long cMillis) {
        this.__m_PrevSentTimestamp = cMillis;
    }

    protected void setThisRecvTimestamp(long ldt) {
        this.__m_ThisRecvTimestamp = ldt;
    }

    public void setThisSentTimestamp(long cMillis) {
        this.__m_ThisSentTimestamp = cMillis;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        long lMillis = ((ClusterService)this.getService()).getTimestamp();
        this.setThisSentTimestamp(lMillis);
        output.writeLong(this.getPrevSentTimestamp());
        output.writeLong(this.getPrevRecvTimestamp());
        output.writeLong(this.getThisSentTimestamp());
    }
}

