/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.EmptyMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.message.CacheMessage;
import com.tangosol.coherence.component.net.message.LeaseMessage;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.requestMessage.LeaseRequest;
import com.tangosol.coherence.component.util.CacheHandler;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$BackingMapContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$CacheConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$CacheHandler;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$CacheUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$CacheUpdateRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$CatalogHandler;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$ConverterFromInternal;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$ConverterToInternal;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseIssue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseIssueRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseLock;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseLockRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseRemove;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseRemoveRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseUnlock;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseUnlockRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$LeaseUpdateRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache$NotifyServiceLeft;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullFilter;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ReplicatedCache
extends Grid
implements CacheService {
    private transient ReplicatedCache$BackingMapContext __m_BackingMapContext;
    private transient BackingMapManager __m_BackingMapManager;
    private transient CacheHandler[] __m_CacheHandler;
    private List __m_LockRequestQueue;
    private transient long __m_LockingNextMillis;
    private transient MemberSet __m_UpdatingMemberSet;
    private static ListMap __mapChildren;

    static {
        ReplicatedCache.__initStatic();
    }

    public ReplicatedCache() {
        this(null, null, true);
    }

    public ReplicatedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLockingNextMillis(Long.MAX_VALUE);
            this.setLockRequestQueue(new LinkedList());
            this.setMessageClassMap(new HashMap());
            this.setSerializerMap(new WeakHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new ReplicatedCache$CacheConfig("CacheConfig", this, true), "CacheConfig");
        this._addChild(new ReplicatedCache$CatalogHandler("CatalogHandler", this, true), "CatalogHandler");
        this._addChild(new Grid$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid$Guard("Guard", this, true), "Guard");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BackingMapContext", ReplicatedCache$BackingMapContext.get_CLASS());
        Class clazz3 = __mapChildren.put("CacheHandler", ReplicatedCache$CacheHandler.get_CLASS());
        Class clazz4 = __mapChildren.put("CacheUpdate", ReplicatedCache$CacheUpdate.get_CLASS());
        Class clazz5 = __mapChildren.put("CacheUpdateRequest", ReplicatedCache$CacheUpdateRequest.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz7 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz8 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz9 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz10 = __mapChildren.put("ConverterFromInternal", ReplicatedCache$ConverterFromInternal.get_CLASS());
        Class clazz11 = __mapChildren.put("ConverterToInternal", ReplicatedCache$ConverterToInternal.get_CLASS());
        Class clazz12 = __mapChildren.put("DispatchEvent", ReplicatedCache$DispatchEvent.get_CLASS());
        Class clazz13 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz14 = __mapChildren.put("LeaseIssue", ReplicatedCache$LeaseIssue.get_CLASS());
        Class clazz15 = __mapChildren.put("LeaseIssueRequest", ReplicatedCache$LeaseIssueRequest.get_CLASS());
        Class clazz16 = __mapChildren.put("LeaseLock", ReplicatedCache$LeaseLock.get_CLASS());
        Class clazz17 = __mapChildren.put("LeaseLockRequest", ReplicatedCache$LeaseLockRequest.get_CLASS());
        Class clazz18 = __mapChildren.put("LeaseRemove", ReplicatedCache$LeaseRemove.get_CLASS());
        Class clazz19 = __mapChildren.put("LeaseRemoveRequest", ReplicatedCache$LeaseRemoveRequest.get_CLASS());
        Class clazz20 = __mapChildren.put("LeaseUnlock", ReplicatedCache$LeaseUnlock.get_CLASS());
        Class clazz21 = __mapChildren.put("LeaseUnlockRequest", ReplicatedCache$LeaseUnlockRequest.get_CLASS());
        Class clazz22 = __mapChildren.put("LeaseUpdate", ReplicatedCache$LeaseUpdate.get_CLASS());
        Class clazz23 = __mapChildren.put("LeaseUpdateRequest", ReplicatedCache$LeaseUpdateRequest.get_CLASS());
        Class clazz24 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz25 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz26 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz27 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz28 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz29 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz31 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz32 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz33 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz34 = __mapChildren.put("NotifyServiceJoined", Grid$NotifyServiceJoined.get_CLASS());
        Class clazz35 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz36 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz37 = __mapChildren.put("NotifyServiceLeft", ReplicatedCache$NotifyServiceLeft.get_CLASS());
        Class clazz38 = __mapChildren.put("NotifyShutdown", Grid$NotifyShutdown.get_CLASS());
        Class clazz39 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz40 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz41 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz42 = __mapChildren.put("ReceiveQueue", Grid$ReceiveQueue.get_CLASS());
        Class clazz43 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz44 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    public void _imports() {
    }

    protected void checkStatus() {
        if (this.getServiceState() != Service.SERVICE_STARTED) {
            throw new IllegalStateException(String.valueOf("Service is not running: ") + this);
        }
    }

    protected CacheHandler cloneCacheHandler(CacheHandler handler, ClassLoader loader) {
        CacheHandler handlerClone = (CacheHandler)this._newChild("CacheHandler");
        handlerClone.setNextHandler(handler);
        handlerClone.setClassLoader(loader);
        handlerClone.setLeaseMap(handler.getLeaseMap());
        handlerClone.setResourceMap(handler.getResourceMap());
        handlerClone.setStandardLeaseMillis(handler.getStandardLeaseMillis());
        handlerClone.setCacheIndex(handler.getCacheIndex());
        handlerClone.setCacheName(handler.getCacheName());
        return handlerClone;
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml != null) {
            this.getCacheConfig().fromXml(xml);
        }
    }

    public void destroyCache(NamedCache map) {
        block7: {
            Component._assert(map instanceof CacheHandler, "Invalid map");
            CacheHandler handler = (CacheHandler)map;
            CacheHandler hCatalog = this.getCacheHandler(0);
            if (handler == hCatalog) {
                return;
            }
            if (this.getThread() == Thread.currentThread()) {
                while (true) {
                    handler.invalidate();
                    CacheHandler hNext = handler.getNextHandler();
                    if (!(hNext == null)) {
                        handler.setNextHandler(null);
                        handler = hNext;
                        continue;
                    }
                    break block7;
                    break;
                }
            }
            String sCacheName = handler.getCacheName();
            String sCatalogName = hCatalog.getCacheName();
            Component._assert(!(sCacheName != null) ? false : sCacheName.equals(sCatalogName) ^ true);
            this.lockResource(hCatalog, sCatalogName, 0L, -1L);
            try {
                this.removeResource(hCatalog, sCacheName, false);
            }
            finally {
                Object var7_7 = null;
                this.unlockResource(hCatalog, sCatalogName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NamedCache ensureCache(String sName, ClassLoader loader) {
        this.checkStatus();
        if (sName == null != false ? true : sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
            Component._assert(loader != null, "ContextClassLoader is missing");
        }
        if (sName.equals(sCatalog = (hCatalog = this.getCacheHandler(0)).getCacheName())) {
            return hCatalog;
        }
        aHandler = this.getCacheHandler();
        iCache = 1;
        c = aHandler.length;
        while (iCache < c) {
            handler = aHandler[iCache];
            if (handler != null == false ? false : sName.equals(handler.getCacheName())) {
                do {
                    if (!(loader == handler.getClassLoader())) continue;
                    return handler;
                } while ((handler = handler.getNextHandler()) != null);
            }
            ++iCache;
        }
        this.lockResource(hCatalog, sCatalog, 0L, -1L);
        try {
            cEnsureCacheTimeout = Base.getSafeTimeMillis() + this.getCacheConfig().getEnsureCacheTimeout();
            var9_13 = hCatalog;
            synchronized (var9_13) {
                aHandler = this.getCacheHandler();
                iCache = 1;
                c = aHandler.length;
                while (iCache < c) {
                    block22: {
                        handler = aHandler[iCache];
                        if (!(handler == null)) ** GOTO lbl49
                        break block22;
lbl-1000:
                        // 1 sources

                        {
                            if (this.getServiceOldestMember() == this.getThisMember()) {
                                handler.getLeaseMap().clear();
                                handler.setResourceMap(new SafeHashMap());
                                break block22;
                            }
                            if (Base.getSafeTimeMillis() > cEnsureCacheTimeout) {
                                throw new IllegalStateException("Timeout waiting for catalog update");
                            }
                            Component._trace(String.valueOf("Waiting for catalog update: ") + iCache, 3);
                            try {
                                hCatalog.wait(1000);
                                handler = aHandler[iCache];
                                if (!(handler == null)) continue;
                                break block22;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new WrapperException(e);
                            }
lbl49:
                            // 2 sources

                            ** while (handler.getCacheName() == null == false ? false : handler.isValid())
                        }
lbl50:
                        // 1 sources

                        if (sName.equals(handler.getCacheName())) {
                            if (!handler.isValid()) {
                                this.setCacheHandler(iCache, null);
                                break;
                            }
                            ** break block23
                        }
                    }
                    ++iCache;
                }
                handler = this.instantiateCacheHandler(-1, sName, loader);
                handler.setStandardLeaseMillis(this.getCacheConfig().getStandardLeaseMillis());
                this.setCacheHandler(handler.getCacheIndex(), handler);
                ** if (!(hCatalog.getCachedResource((Object)sCatalog) == null)) goto lbl64
            }
lbl-1000:
            // 1 sources

            {
                this.updateResource(hCatalog, sCatalog, hCatalog.toXml(), 0L, false, false);
            }
lbl64:
            // 2 sources

            this.updateResource(hCatalog, sName, handler.toXml(), 0L, true, false);
            var9_13 = handler;
            var15_24 = null;
            this.unlockResource(hCatalog, sCatalog);
            return var9_13;
lbl-1000:
            // 1 sources

            {
                handlerNext = handler;
                do {
                    if ((loaderCache = handlerNext.getClassLoader()) == null) {
                        handlerNext.setClassLoader(loader);
                        var14_19 = handlerNext;
                        var15_21 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 11, 12] lbl79 : MonitorExitStatement: MONITOREXIT : var9_13
                        var15_21 = null;
                        this.unlockResource(hCatalog, sCatalog);
                        return var14_19;
                    }
                    if (!(loaderCache == loader)) continue;
                    var14_20 = handlerNext;
                    var15_22 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 11] lbl89 : MonitorExitStatement: MONITOREXIT : var9_13
                    var15_22 = null;
                    this.unlockResource(hCatalog, sCatalog);
                    return var14_20;
                } while ((handlerNext = handlerNext.getNextHandler()) != null);
                handlerNext = this.cloneCacheHandler(handler, loader);
                this.setCacheHandler(iCache, handlerNext);
                var13_18 = handlerNext;
                var15_23 = null;
            }
            var15_23 = null;
            this.unlockResource(hCatalog, sCatalog);
            return var13_18;
        }
        catch (Throwable var6_9) {
            var15_25 = null;
            this.unlockResource(hCatalog, sCatalog);
            throw var6_9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheHandler ensureCacheHandler(int iCache) {
        CacheHandler handler = this.getCacheHandler(iCache);
        if (handler == null) {
            CacheHandler hCatalog = this.getCacheHandler(0);
            Component._assert(hCatalog != null, "Catalog is missing");
            CacheHandler cacheHandler = hCatalog;
            synchronized (cacheHandler) {
                handler = this.getCacheHandler(iCache);
                if (handler == null) {
                    handler = this.instantiateCacheHandler(iCache, null, this.getContextClassLoader());
                    this.setCacheHandler(iCache, handler);
                }
            }
        }
        return handler;
    }

    protected void evaluateLockRequests() {
        long lTime = this.getClusterTime();
        long lNext = Long.MAX_VALUE;
        this.setLockingNextMillis(lNext);
        List listPending = this.getLockRequestQueue();
        int cPending = listPending.size();
        if (cPending > 0) {
            ReplicatedCache$LeaseLockRequest msgLockRequest;
            ArrayList<ReplicatedCache$LeaseLockRequest> listRetry = new ArrayList<ReplicatedCache$LeaseLockRequest>(cPending);
            Iterator iter = listPending.iterator();
            block5: while (iter.hasNext()) {
                msgLockRequest = (ReplicatedCache$LeaseLockRequest)iter.next();
                Member member = msgLockRequest.getFromMember();
                if (this.getServiceMemberSet().contains(member) ^ true) {
                    iter.remove();
                    continue;
                }
                long lTimeout = msgLockRequest.getWaitTimeout();
                if (lTimeout <= lTime) {
                    iter.remove();
                    listRetry.add(msgLockRequest);
                    continue;
                }
                Lease leaseRequest = msgLockRequest.getLease();
                Object oKey = leaseRequest.getResourceKey();
                int iCache = leaseRequest.getCacheIndex();
                Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
                leaseCurrent.validate();
                switch (leaseCurrent.getStatus()) {
                    case 3: {
                        lTimeout = Math.min(lTimeout, leaseCurrent.getExpirationTime());
                        break;
                    }
                    default: {
                        iter.remove();
                        listRetry.add(msgLockRequest);
                        continue block5;
                    }
                }
                if (!(lTimeout != Long.MAX_VALUE)) continue;
                lNext = Math.min(lNext, lTimeout);
            }
            iter = listRetry.iterator();
            while (iter.hasNext()) {
                msgLockRequest = (ReplicatedCache$LeaseLockRequest)iter.next();
                try {
                    this.onLeaseLockRequest(msgLockRequest);
                }
                catch (EventDeathException e) {
                    // empty catch block
                }
            }
        }
        if (lNext != Long.MAX_VALUE) {
            this.scheduleLockEvaluation(lNext - lTime);
        }
    }

    protected void firePendingLocks(Lease lease) {
        ReplicatedCache$LeaseLockRequest msgLockRequest;
        Iterator iter;
        ArrayList<ReplicatedCache$LeaseLockRequest> listRetry = null;
        List listPending = this.getLockRequestQueue();
        int cPending = listPending.size();
        if (cPending > 0) {
            listRetry = new ArrayList<ReplicatedCache$LeaseLockRequest>(cPending);
            iter = listPending.iterator();
            while (iter.hasNext()) {
                msgLockRequest = (ReplicatedCache$LeaseLockRequest)iter.next();
                Lease leaseRequest = msgLockRequest.getLease();
                int iCache = leaseRequest.getCacheIndex();
                Object oKey = leaseRequest.getResourceKey();
                if (!(!(iCache == lease.getCacheIndex()) ? false : Base.equals(oKey, lease.getResourceKey()))) continue;
                iter.remove();
                leaseRequest.copyVersion(lease);
                listRetry.add(msgLockRequest);
            }
        }
        if (!(listRetry != null) ? false : listRetry.isEmpty() ^ true) {
            iter = listRetry.iterator();
            while (iter.hasNext()) {
                msgLockRequest = (ReplicatedCache$LeaseLockRequest)iter.next();
                try {
                    this.onLeaseLockRequest(msgLockRequest);
                }
                catch (EventDeathException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicatedCache$BackingMapContext getBackingMapContext() {
        ReplicatedCache$BackingMapContext context = this.__m_BackingMapContext;
        if (context == null) {
            ReplicatedCache replicatedCache = this;
            synchronized (replicatedCache) {
                context = this.__m_BackingMapContext;
                if (context == null) {
                    context = (ReplicatedCache$BackingMapContext)this._newChild("BackingMapContext");
                    this.setBackingMapContext(context);
                }
            }
        }
        return context;
    }

    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public ReplicatedCache$CacheConfig getCacheConfig() {
        return (ReplicatedCache$CacheConfig)this._findName("CacheConfig");
    }

    protected CacheHandler[] getCacheHandler() {
        return this.__m_CacheHandler;
    }

    public CacheHandler getCacheHandler(int iCache) {
        CacheHandler[] aHandler = this.getCacheHandler();
        int cHandlers = aHandler == null ? 0 : aHandler.length;
        return iCache >= cHandlers ? null : aHandler[iCache];
    }

    public Enumeration getCacheNames() {
        this.checkStatus();
        CacheHandler[] aHandler = this.getCacheHandler();
        int cHandlers = aHandler.length;
        Object[] aName = new String[cHandlers];
        int i = 1;
        while (i < cHandlers) {
            CacheHandler handler = aHandler[i];
            if (!(handler != null) ? false : handler.isValid()) {
                aName[i] = handler.getCacheName();
            }
            ++i;
        }
        return new FilterEnumerator(aName, (Filter)NullFilter.getInstance());
    }

    public List getLockRequestQueue() {
        return this.__m_LockRequestQueue;
    }

    public long getLockingNextMillis() {
        return this.__m_LockingNextMillis;
    }

    public String getServiceType() {
        return "ReplicatedCache";
    }

    public String getServiceVersion() {
        return "3.0";
    }

    public int getThreadStatus(Lease lease) {
        lease.validate();
        int nStatus = lease.getStatus();
        if (this.getCacheConfig().getLeaseGranularity() == Lease.BY_MEMBER) {
            return nStatus;
        }
        return (!(nStatus == Lease.LEASE_LOCKED) ? false : Lease.getCurrentThreadId() != lease.getHolderThreadId()) ? Lease.LEASE_DIRTY : nStatus;
    }

    public MemberSet getUpdatingMemberSet() {
        return this.__m_UpdatingMemberSet;
    }

    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long cWait2 = Math.max(1L, this.getLockingNextMillis() - Base.getSafeTimeMillis());
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ReplicatedCache();
    }

    private final Component get_Module() {
        return this;
    }

    protected CacheHandler instantiateCacheHandler(int iCache, String sName, ClassLoader loader) {
        CacheHandler handler = (CacheHandler)this._newChild("CacheHandler");
        if (iCache == -1) {
            CacheHandler[] aHandler = this.getCacheHandler();
            iCache = 1;
            int c = aHandler.length;
            while (!(iCache < c) ? false : aHandler[iCache] != null) {
                ++iCache;
            }
        }
        handler.setCacheIndex(iCache);
        handler.setCacheName(sName);
        handler.setClassLoader(loader);
        return handler;
    }

    public Converter instantiateConverterFromInternal(ClassLoader loader) {
        ReplicatedCache$ConverterFromInternal conv = (ReplicatedCache$ConverterFromInternal)this._newChild("ConverterFromInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    public Converter instantiateConverterToInternal(ClassLoader loader) {
        ReplicatedCache$ConverterToInternal conv = (ReplicatedCache$ConverterToInternal)this._newChild("ConverterToInternal");
        conv.setSerializer(this.ensureSerializer(loader));
        return conv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean lockCache(CacheHandler handler, long cLeaseMillis, long cWaitMillis) {
        boolean bl;
        String sCacheName;
        CacheHandler hCatalog = this.getCacheHandler(0);
        if (!this.lockResource(hCatalog, sCacheName = handler.getCacheName(), 0L, cWaitMillis)) return false;
        boolean fDirty = false;
        try {
            Enumeration enumeration = handler.getLeaseKeys();
            while (enumeration.hasMoreElements()) {
                Object oKey = enumeration.nextElement();
                Lease lease = handler.getLease(oKey);
                if (!(lease != null)) continue;
                while (!(fDirty = this.getThreadStatus(lease) == Lease.LEASE_DIRTY) ? false : cWaitMillis != (long)0) {
                    cWaitMillis = this.waitForUnlock(lease, cWaitMillis);
                }
                if (!fDirty) continue;
                bl = false;
                Object var13_12 = null;
                if (!fDirty) return bl;
                this.unlockResource(hCatalog, sCacheName);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!fDirty) throw throwable;
            this.unlockResource(hCatalog, sCacheName);
            throw throwable;
        }
        {
            return bl;
        }
        Object var13_13 = null;
        if (!fDirty) return true;
        this.unlockResource(hCatalog, sCacheName);
        return true;
    }

    public boolean lockResource(CacheHandler handler, Object oKey, long cLeaseMillis, long cWaitMillis) {
        if (oKey == ConcurrentMap.LOCK_ALL) {
            return this.lockCache(handler, cLeaseMillis, cWaitMillis);
        }
        CacheHandler hCatalog = this.getCacheHandler(0);
        String sCacheName = handler.getCacheName();
        long lWaitTimeout = this.adjustWaitTime(cWaitMillis, Grid.TIME_SAFE);
        block6: while (true) {
            Lease leaseCache;
            if (!((leaseCache = hCatalog.getLease(sCacheName)) != null) ? false : this.getThreadStatus(leaseCache) == Lease.LEASE_DIRTY) {
                if (cWaitMillis == (long)0) {
                    return false;
                }
                cWaitMillis = this.waitForUnlock(leaseCache, cWaitMillis);
                continue;
            }
            Lease lease = handler.ensureLease(oKey);
            switch (this.getThreadStatus(lease)) {
                case 1: {
                    this.requestIssue(lease);
                    break;
                }
                case 2: {
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) continue block6;
                    if (!this.requestLock(lease, memberIssuer, cLeaseMillis, cWaitMillis, false)) continue block6;
                    return true;
                }
                case 3: {
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    if (!this.requestLock(lease, memberIssuer, cLeaseMillis, cWaitMillis, true)) continue block6;
                    return true;
                }
                case 4: {
                    if (Base.getSafeTimeMillis() >= lWaitTimeout) {
                        return false;
                    }
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null && (memberIssuer = this.getServiceMemberSet().getMember(lease.getHolderId())) == null) continue block6;
                    if (!this.requestLock(lease, memberIssuer, cLeaseMillis, cWaitMillis, false)) continue block6;
                    return true;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected void notifyLease(Lease lease, LeaseRequest msgRequest, LeaseMessage msgResponse) {
        if (msgResponse == null) {
            msgResponse = (ReplicatedCache$LeaseIssue)this.instantiateMessage("LeaseIssue");
        }
        msgResponse.respondTo(msgRequest);
        msgResponse.setLease(lease);
        this.post(msgResponse);
    }

    public void onCacheUpdateRequest(RequestMessage msgRequest) {
        CacheHandler[] aHandler = this.getCacheHandler();
        int cHandlers = aHandler.length;
        SingleMemberSet setTo = SingleMemberSet.instantiate(msgRequest.getFromMember());
        Message msg = null;
        int cbSize = 102400;
        int i = 0;
        while (i < cHandlers) {
            CacheHandler handler = aHandler[i];
            if (!(handler != null) ? false : handler.isValid()) {
                Enumeration enumMore = null;
                do {
                    if (!(msg != null) ? false : ((CacheMessage)msg).getLeaseCount() > 0) {
                        this.send(msg);
                        Thread.yield();
                    }
                    msg = (ReplicatedCache$CacheUpdate)this.instantiateMessage("CacheUpdate");
                    msg.setToMemberSet(setTo);
                    ((CacheMessage)msg).setCacheIndex(i);
                } while ((enumMore = handler.populateUpdateMessage((CacheMessage)msg, cbSize, enumMore)) != null);
            }
            ++i;
        }
        Component._assert(msg != null);
        msg.respondTo(msgRequest);
        this.post(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCatalogRemove(XmlElement xml) {
        CacheHandler hCatalog;
        CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        synchronized (cacheHandler) {
            int iCache = xml.getElement("CacheIndex").getInt();
            Component._assert(iCache > 0, "Attempt to remove the catalog");
            CacheHandler handler = this.getCacheHandler(iCache);
            if (handler != null) {
                this.destroyCache(handler);
            }
            hCatalog.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCatalogUpdate(XmlElement xml) {
        CacheHandler hCatalog;
        CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        synchronized (cacheHandler) {
            int iCache = xml.getElement("CacheIndex").getInt();
            String sName = xml.getElement("CacheName").getString();
            CacheHandler handler = this.getCacheHandler(iCache);
            if (handler == null ? true : handler.isValid() ^ true) {
                handler = this.instantiateCacheHandler(iCache, sName, null);
                this.setCacheHandler(iCache, handler);
            }
            handler.fromXml(xml);
            hCatalog.notifyAll();
        }
    }

    protected void onExit() {
        super.onExit();
        CacheHandler[] aHandler = this.getCacheHandler();
        if (aHandler != null) {
            int i = aHandler.length - 1;
            while (i >= 0) {
                CacheHandler handler = aHandler[i];
                if (handler != null) {
                    handler.invalidate();
                }
                --i;
            }
            this.setCacheHandler(new CacheHandler[0]);
        }
    }

    public void onLeaseIssueRequest(ReplicatedCache$LeaseIssueRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        leaseCurrent.validate();
        if (leaseCurrent.getStatus() == Lease.LEASE_UNISSUED) {
            Member memberFrom = msgRequest.getFromMember();
            if (this.getCacheConfig().isMobileIssues()) {
                leaseCurrent.setIssuerId(memberFrom.getId());
            } else {
                leaseCurrent.setIssuerId(this.getThisMember().getId());
            }
            leaseCurrent.incrementLeaseVersion();
            MemberSet setOther = this.getOthersMemberSet();
            setOther.remove(memberFrom);
            if (setOther.isEmpty() ^ true) {
                ReplicatedCache$LeaseIssue msg = (ReplicatedCache$LeaseIssue)this.instantiateMessage("LeaseIssue");
                msg.setToMemberSet(setOther);
                msg.setLease(leaseCurrent);
                this.post(msg);
            }
        }
        this.notifyLease(leaseCurrent, msgRequest, null);
    }

    public void onLeaseLockRequest(ReplicatedCache$LeaseLockRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        boolean fReject = false;
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                leaseCurrent.setIssuerId(nThisId);
            }
            case 2: {
                if (leaseCurrent.getIssuerId() != nThisId) {
                    fReject = true;
                    break;
                }
                leaseRequest.copyVersion(leaseCurrent);
                fReject = this.performLock(msgRequest) ^ true;
                break;
            }
            case 3: 
            case 4: {
                long lVariance;
                if (leaseCurrent.getIssuerId() != nThisId) {
                    fReject = true;
                    break;
                }
                if (!(leaseCurrent.getHolderId() == msgRequest.getFromMember().getId()) ? false : leaseCurrent.getHolderThreadId() == leaseRequest.getHolderThreadId()) {
                    fReject = this.performLock(msgRequest) ^ true;
                    break;
                }
                long lWaitTimeout = msgRequest.getWaitTimeout();
                long lTime = this.getClusterTime();
                if (lTime + (lVariance = (long)this.getClusterTimeVariance()) < lWaitTimeout) {
                    this.getLockRequestQueue().add(msgRequest);
                    long lExpirationTime = leaseCurrent.getExpirationTime();
                    if (!(lWaitTimeout != Long.MAX_VALUE ? true : lExpirationTime != Long.MAX_VALUE)) break;
                    this.scheduleLockEvaluation(Math.min(lWaitTimeout - lTime, lExpirationTime - lTime));
                    break;
                }
                fReject = true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fReject) {
            Component._trace(String.valueOf("Rejecting lock: ") + leaseCurrent + "\n by member=" + msgRequest.getFromMember().getId() + ", " + leaseRequest, 4);
            this.notifyLease(leaseCurrent, msgRequest, null);
        }
    }

    public void onLeaseRemoveRequest(ReplicatedCache$LeaseRemoveRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                leaseCurrent.setIssuerId(nThisId);
            }
            case 2: {
                if (!(leaseCurrent.getIssuerId() != nThisId ? true : this.performRemove(msgRequest) ^ true)) break;
                this.notifyLease(leaseCurrent, msgRequest, null);
                break;
            }
            case 3: 
            case 4: {
                if (!((leaseCurrent.getIssuerId() != nThisId ? true : leaseCurrent.getHolderId() != msgRequest.getFromMember().getId()) ? true : this.performRemove(msgRequest) ^ true)) break;
                this.notifyLease(leaseCurrent, msgRequest, null);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void onLeaseUnlockRequest(ReplicatedCache$LeaseUnlockRequest msgRequest) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        CacheHandler handler = this.ensureCacheHandler(iCache);
        Lease leaseCurrent = handler.ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        boolean fReject = false;
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                leaseCurrent.setIssuerId(nThisId);
            }
            case 2: {
                fReject = leaseCurrent.getIssuerId() != nThisId ? true : this.performUnlock(msgRequest) ^ true;
                break;
            }
            case 3: 
            case 4: {
                if (leaseCurrent.getIssuerId() != nThisId) {
                    fReject = true;
                    break;
                }
                if (!(leaseCurrent.getHolderId() == msgRequest.getFromMember().getId()) ? false : leaseCurrent.getHolderThreadId() == leaseRequest.getHolderThreadId()) {
                    fReject = this.performUnlock(msgRequest) ^ true;
                    break;
                }
                List listPending = this.getLockRequestQueue();
                Iterator iter = listPending.iterator();
                while (iter.hasNext()) {
                    ReplicatedCache$LeaseLockRequest msgLockRequest = (ReplicatedCache$LeaseLockRequest)iter.next();
                    Lease leaseLockRequest = msgLockRequest.getLease();
                    if (!(!(!(!(leaseLockRequest.getCacheIndex() == iCache) ? false : Base.equals(leaseLockRequest.getResourceKey(), oKey)) ? false : leaseLockRequest.getHolderId() == msgRequest.getFromMember().getId()) ? false : leaseLockRequest.getHolderThreadId() == leaseRequest.getHolderThreadId())) continue;
                    iter.remove();
                    this.notifyLease(leaseCurrent, msgLockRequest, null);
                }
                fReject = true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fReject) {
            Component._trace(String.valueOf("Rejecting unlock: ") + leaseCurrent + "\n by member=" + msgRequest.getFromMember().getId() + ", " + leaseRequest, 4);
            this.notifyLease(leaseCurrent, msgRequest, null);
        }
    }

    public void onLeaseUpdateRequest(ReplicatedCache$LeaseUpdateRequest msgRequest, Object oResource, Binary binResource) {
        Lease leaseRequest = msgRequest.getLease();
        Object oKey = leaseRequest.getResourceKey();
        int iCache = leaseRequest.getCacheIndex();
        Lease leaseCurrent = this.ensureCacheHandler(iCache).ensureLease(oKey);
        int nThisId = this.getThisMember().getId();
        boolean fReject = false;
        leaseCurrent.validate();
        switch (leaseCurrent.getStatus()) {
            case 1: {
                int nIssuerId = leaseRequest.getIssuerId();
                leaseCurrent.setIssuerId(nIssuerId == 0 ? nThisId : nIssuerId);
            }
            case 2: {
                fReject = leaseCurrent.getIssuerId() != nThisId ? true : this.performUpdate(msgRequest, oResource, binResource) ^ true;
                break;
            }
            case 3: 
            case 4: {
                fReject = (leaseCurrent.getIssuerId() != nThisId ? true : leaseCurrent.getHolderId() != msgRequest.getFromMember().getId()) ? true : this.performUpdate(msgRequest, oResource, binResource) ^ true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fReject) {
            Component._trace(String.valueOf("Rejecting update: ") + leaseCurrent + "\n by member=" + msgRequest.getFromMember().getId() + ", " + leaseRequest, 4);
            this.notifyLease(leaseCurrent, msgRequest, null);
        }
    }

    protected void onNotify() {
        super.onNotify();
        if (this.isRunning() && Base.getSafeTimeMillis() >= this.getLockingNextMillis()) {
            this.evaluateLockRequests();
        }
    }

    public void onNotifyServiceLeft(Member member) {
        CacheHandler[] aHandler = this.getCacheHandler();
        int i = 0;
        int c = aHandler.length;
        while (i < c) {
            CacheHandler handler = aHandler[i];
            if (!(handler != null) ? false : handler.isValid()) {
                handler.onFarewell(member);
            }
            ++i;
        }
        this.evaluateLockRequests();
    }

    public void onServiceStarted() {
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            ReplicatedCache$BackingMapContext ctx = this.getBackingMapContext();
            ctx.setManager(manager);
            manager.init(ctx);
        }
        this.setAcceptingOthers(true);
        this.requestCacheUpdate();
    }

    protected boolean performLock(ReplicatedCache$LeaseLockRequest msgRequest) {
        Lease lease = msgRequest.getLease();
        long cLeaseMillis = msgRequest.getLeaseMillis();
        lease.incrementLeaseVersion();
        lease.setExpirationTime(this.adjustWaitTime(cLeaseMillis - 1L, Grid.TIME_CLUSTER));
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, false, null, 0L);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (setOther.isEmpty() ^ true) {
            ReplicatedCache$LeaseLock msg = (ReplicatedCache$LeaseLock)this.instantiateMessage("LeaseLock");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            this.post(msg);
        }
        this.notifyLease(lease, msgRequest, (ReplicatedCache$LeaseLock)this.instantiateMessage("LeaseLock"));
        return true;
    }

    protected boolean performRemove(ReplicatedCache$LeaseRemoveRequest msgRequest) {
        Lease lease = msgRequest.getLease();
        lease.incrementResourceVersion();
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseRemove(lease);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (setOther.isEmpty() ^ true) {
            ReplicatedCache$LeaseRemove msg = (ReplicatedCache$LeaseRemove)this.instantiateMessage("LeaseRemove");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            this.post(msg);
        }
        this.notifyLease(lease, msgRequest, (ReplicatedCache$LeaseRemove)this.instantiateMessage("LeaseRemove"));
        return true;
    }

    protected boolean performUnlock(ReplicatedCache$LeaseUnlockRequest msgRequest) {
        Lease lease = msgRequest.getLease();
        lease.unlock();
        lease.incrementLeaseVersion();
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, false, null, 0L);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (setOther.isEmpty() ^ true) {
            ReplicatedCache$LeaseUnlock msg = (ReplicatedCache$LeaseUnlock)this.instantiateMessage("LeaseUnlock");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            this.post(msg);
        }
        this.notifyLease(lease, msgRequest, (ReplicatedCache$LeaseUnlock)this.instantiateMessage("LeaseUnlock"));
        this.firePendingLocks(lease);
        return true;
    }

    protected boolean performUpdate(ReplicatedCache$LeaseUpdateRequest msgRequest, Object oResource, Binary binResource) {
        Lease lease = msgRequest.getLease();
        long cExpiry = msgRequest.getResourceExpiry();
        lease.incrementResourceVersion();
        try {
            this.ensureCacheHandler(lease.getCacheIndex()).onLeaseUpdate(lease, true, oResource, cExpiry);
        }
        catch (EventDeathException e) {
            return false;
        }
        MemberSet setOther = this.getOthersMemberSet();
        setOther.remove(msgRequest.getFromMember());
        if (setOther.isEmpty() ^ true) {
            ReplicatedCache$LeaseUpdate msg = (ReplicatedCache$LeaseUpdate)this.instantiateMessage("LeaseUpdate");
            msg.setToMemberSet(setOther);
            msg.setLease(lease);
            msg.setResource(oResource);
            msg.setResourceBinary(binResource);
            msg.setResourceExpiry(cExpiry);
            this.post(msg);
        }
        ReplicatedCache$LeaseUpdate msgResponse = (ReplicatedCache$LeaseUpdate)this.instantiateMessage("LeaseUpdate");
        msgResponse.setResource(oResource);
        msgResponse.setResourceBinary(binResource);
        msgResponse.setResourceExpiry(cExpiry);
        this.notifyLease(lease, msgRequest, msgResponse);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void releaseCache(NamedCache map) {
        CacheHandler hCatalog;
        Component._assert(map instanceof CacheHandler, "Invalid map");
        ReplicatedCache$CacheHandler handler = (ReplicatedCache$CacheHandler)map;
        CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        // MONITORENTER : cacheHandler
        int iCache = handler.getCacheIndex();
        CacheHandler[] aHandler = this.getCacheHandler();
        CacheHandler hNext = aHandler[iCache];
        CacheHandler hPrev = null;
        while (hNext != null) {
            if (hNext == handler) {
                hNext = hNext.getNextHandler();
                if (hPrev == null) {
                    if (hNext != null) {
                        aHandler[iCache] = hNext;
                    }
                } else {
                    hPrev.setNextHandler(hNext);
                }
                handler.releaseIndexMap();
                handler.releaseClassLoader();
                Object var9_9 = null;
                // MONITOREXIT : cacheHandler
                return;
            }
            hPrev = hNext;
            hNext = hNext.getNextHandler();
        }
        // MONITOREXIT : cacheHandler
    }

    public Object removeResource(CacheHandler handler, Object oKey, boolean fReturn) throws ConcurrentModificationException {
        CacheHandler hCatalog = this.getCacheHandler(0);
        String sCacheName = handler.getCacheName();
        block6: while (true) {
            Lease leaseCache;
            if (!((leaseCache = hCatalog.getLease(sCacheName)) != null) ? false : this.getThreadStatus(leaseCache) == Lease.LEASE_DIRTY) {
                throw new ConcurrentModificationException(String.valueOf("Cache \"") + sCacheName + "\" is locked by another thread or member: " + leaseCache);
            }
            Lease lease = handler.ensureLease(oKey);
            switch (this.getThreadStatus(lease)) {
                case 1: {
                    this.requestIssue(lease);
                    break;
                }
                case 2: {
                    Object oValue;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) continue block6;
                    Object object = oValue = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestRemove(lease, memberIssuer)) continue block6;
                    return oValue;
                }
                case 3: {
                    Object oValue;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    Object object = oValue = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestRemove(lease, memberIssuer)) continue block6;
                    return oValue;
                }
                case 4: {
                    throw new ConcurrentModificationException(String.valueOf("Cache \"") + sCacheName + "\": Resource is locked by another thread or member: " + lease);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public void requestCacheUpdate() {
        MemberSet setOther = this.getOthersMemberSet();
        if (setOther.isEmpty()) {
            this.setAcceptingOthers(true);
            this.setAcceptingClients(true);
        } else {
            DependentMemberSet setUpdating = new DependentMemberSet();
            setUpdating.setBaseSet(setOther);
            this.setUpdatingMemberSet(setUpdating);
            ReplicatedCache$CacheUpdateRequest msg = (ReplicatedCache$CacheUpdateRequest)this.instantiateMessage("CacheUpdateRequest");
            msg.setToMemberSet(setOther);
            this.post(msg);
        }
    }

    protected boolean requestIssue(Lease lease) {
        this.checkStatus();
        ReplicatedCache$LeaseIssueRequest msg = (ReplicatedCache$LeaseIssueRequest)this.instantiateMessage("LeaseIssueRequest");
        msg.addToMember(this.getServiceOldestMember());
        msg.setLease(lease);
        this.poll(msg);
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected boolean requestLock(Lease lease, Member memberIssuer, long cLeaseMillis, long cWaitMillis, boolean fRenew) {
        this.checkStatus();
        long lCurrentTime = this.getClusterTime();
        long lExpirationTime = this.adjustWaitTime(cLeaseMillis - 1L, lCurrentTime);
        if (!fRenew ? false : lExpirationTime <= lease.getExpirationTime()) {
            return true;
        }
        ReplicatedCache$LeaseLockRequest msg = (ReplicatedCache$LeaseLockRequest)this.instantiateMessage("LeaseLockRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setWaitMillis(cWaitMillis);
        msg.setLeaseMillis(cLeaseMillis);
        msg.setLease(lease);
        Lease leaseMsg = msg.getLease();
        long lThreadId = this.getCacheConfig().getLeaseGranularity() == Lease.BY_THREAD ? Lease.getCurrentThreadId() : 0L;
        leaseMsg.setIssuerId(memberIssuer.getId());
        leaseMsg.setHolderId(this.getThisMember().getId());
        leaseMsg.setHolderThreadId(lThreadId);
        if (fRenew ^ true) {
            leaseMsg.setEffectiveTime(lCurrentTime);
        }
        try {
            long cTimeout = this.getRequestTimeout();
            if (cTimeout > 0L) {
                cTimeout = this.adjustWaitTime(cWaitMillis, cTimeout);
            }
            this.poll(msg, cTimeout);
            return !msg.getRequestPoll().getLeftMemberSet().isEmpty() ? false : this.getThreadStatus(lease) == Lease.LEASE_LOCKED;
        }
        catch (RuntimeException e) {
            boolean fInterrupt = Thread.interrupted();
            try {
                this.requestUnlock(leaseMsg, memberIssuer, false);
            }
            catch (RuntimeException x) {
                // empty catch block
            }
            if (fInterrupt) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
    }

    protected boolean requestRemove(Lease lease, Member memberIssuer) {
        this.checkStatus();
        ReplicatedCache$LeaseRemoveRequest msg = (ReplicatedCache$LeaseRemoveRequest)this.instantiateMessage("LeaseRemoveRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setLease(lease);
        this.poll(msg);
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected boolean requestUnlock(Lease lease, Member memberIssuer, boolean fWait) {
        this.checkStatus();
        ReplicatedCache$LeaseUnlockRequest msg = (ReplicatedCache$LeaseUnlockRequest)this.instantiateMessage("LeaseUnlockRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setLease(lease);
        Lease leaseMsg = msg.getLease();
        long lThreadId = this.getCacheConfig().getLeaseGranularity() == Lease.BY_THREAD ? Lease.getCurrentThreadId() : 0L;
        leaseMsg.setIssuerId(memberIssuer.getId());
        leaseMsg.setHolderId(this.getThisMember().getId());
        leaseMsg.setHolderThreadId(lThreadId);
        if (fWait) {
            this.poll(msg);
        } else {
            this.send(msg);
        }
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected boolean requestUpdate(Lease lease, Member memberIssuer, Object oResource, long lResourceExpiry, boolean fResetEffective, boolean fResetExpire) {
        this.checkStatus();
        ReplicatedCache$LeaseUpdateRequest msg = (ReplicatedCache$LeaseUpdateRequest)this.instantiateMessage("LeaseUpdateRequest");
        msg.setToMemberSet(SingleMemberSet.instantiate(memberIssuer));
        msg.setLease(lease);
        msg.setResource(oResource);
        msg.setResourceExpiry(lResourceExpiry);
        if (this.getServiceMemberSet().size() > 1) {
            msg.setResourceBinary(oResource instanceof Binary ? (Binary)oResource : ExternalizableHelper.toBinary(oResource, this.ensureSerializer()));
        }
        Lease leaseMsg = msg.getLease();
        leaseMsg.setIssuerId(memberIssuer.getId());
        if (fResetEffective) {
            leaseMsg.setEffectiveTime(this.getClusterTime());
        }
        if (fResetExpire) {
            leaseMsg.setExpirationTime(this.getClusterTime());
        }
        this.poll(msg);
        return msg.getRequestPoll().getLeftMemberSet().isEmpty();
    }

    protected synchronized void scheduleLockEvaluation(long cMillis) {
        long lNext = cMillis == Long.MAX_VALUE ? cMillis : Base.getSafeTimeMillis() + cMillis;
        this.setLockingNextMillis(Math.min(this.getLockingNextMillis(), lNext));
    }

    public synchronized void setAcceptingClients(boolean fAccepting) {
        this.setUpdatingMemberSet(fAccepting ? this.getServiceMemberSet() : (MemberSet)EmptyMemberSet.get_Instance());
        super.setAcceptingClients(fAccepting);
    }

    protected void setBackingMapContext(ReplicatedCache$BackingMapContext ctx) {
        this.__m_BackingMapContext = ctx;
    }

    public synchronized void setBackingMapManager(BackingMapManager manager) {
        if (this.isRunning()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_BackingMapManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCacheHandler(int iCache, CacheHandler handler) {
        CacheHandler hCatalog;
        CacheHandler cacheHandler = hCatalog = this.getCacheHandler(0);
        synchronized (cacheHandler) {
            boolean fBeyondBounds;
            CacheHandler[] aHandler = this.getCacheHandler();
            boolean bl = fBeyondBounds = aHandler == null ? true : iCache >= aHandler.length;
            if (!(handler != null) ? false : fBeyondBounds) {
                CacheHandler[] aHandlerNew = new CacheHandler[iCache + 2];
                if (aHandler != null) {
                    System.arraycopy(aHandler, 0, aHandlerNew, 0, aHandler.length);
                }
                aHandler = aHandlerNew;
                this.setCacheHandler(aHandler);
                fBeyondBounds = false;
            }
            if (fBeyondBounds ^ true) {
                aHandler[iCache] = handler;
            }
        }
    }

    protected void setCacheHandler(CacheHandler[] aHandler) {
        this.__m_CacheHandler = aHandler;
    }

    protected void setLockRequestQueue(List list) {
        this.__m_LockRequestQueue = list;
    }

    public void setLockingNextMillis(long ltMillis) {
        this.__m_LockingNextMillis = ltMillis;
    }

    public void setUpdatingMemberSet(MemberSet setMember) {
        this.__m_UpdatingMemberSet = setMember;
    }

    public synchronized void start() {
        CacheHandler[] aHandler = new CacheHandler[2];
        CacheHandler hCatalog = (CacheHandler)this._findChild("CatalogHandler");
        ClassLoader loader = this.getContextClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
                Component._assert(loader != null, "ContextClassLoader is missing");
            }
            this.setContextClassLoader(loader);
        }
        hCatalog.setClassLoader(loader);
        aHandler[0] = hCatalog;
        this.setCacheHandler(aHandler);
        this.setUpdatingMemberSet((MemberSet)EmptyMemberSet.get_Instance());
        super.start();
    }

    public boolean unlockResource(CacheHandler handler, Object oKey) {
        if (oKey == ConcurrentMap.LOCK_ALL) {
            CacheHandler hCatalog = this.getCacheHandler(0);
            String sCacheName = handler.getCacheName();
            return this.unlockResource(hCatalog, sCacheName);
        }
        boolean fWasLocked = false;
        block5: while (true) {
            Lease lease;
            if ((lease = handler.getLease(oKey)) == null) {
                return true;
            }
            switch (this.getThreadStatus(lease)) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
                case 3: {
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    if (this.requestUnlock(lease, memberIssuer, true)) {
                        return true;
                    }
                    fWasLocked = true;
                    continue block5;
                }
                case 4: {
                    return fWasLocked;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public Object updateResource(CacheHandler handler, Object oKey, Object oValue, long cExpireMillis, boolean fFinal, boolean fReturn) throws ConcurrentModificationException {
        CacheHandler hCatalog = this.getCacheHandler(0);
        String sCacheName = handler.getCacheName();
        block6: while (true) {
            Lease leaseCache;
            if (!((leaseCache = hCatalog.getLease(sCacheName)) != null) ? false : this.getThreadStatus(leaseCache) == Lease.LEASE_DIRTY) {
                throw new ConcurrentModificationException(String.valueOf("Cache \"") + sCacheName + "\" is locked by another thread or member: " + leaseCache);
            }
            Lease lease = handler.ensureLease(oKey);
            switch (this.getThreadStatus(lease)) {
                case 1: {
                    Member memberIssuer;
                    if (this.getCacheConfig().isMobileIssues()) {
                        memberIssuer = this.getThisMember();
                        if (!this.requestUpdate(lease, memberIssuer, oValue, cExpireMillis, true, false)) continue block6;
                        return null;
                    }
                    this.requestIssue(lease);
                    break;
                }
                case 2: {
                    Object oValueOld;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) continue block6;
                    Object object = oValueOld = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestUpdate(lease, memberIssuer, oValue, cExpireMillis, true, false)) continue block6;
                    return oValueOld;
                }
                case 3: {
                    Object oValueOld;
                    Member memberIssuer = this.getServiceMemberSet().getMember(lease.getIssuerId());
                    if (memberIssuer == null) {
                        memberIssuer = this.getThisMember();
                    }
                    Object object = oValueOld = fReturn ? handler.getCachedResource(oKey) : null;
                    if (!this.requestUpdate(lease, memberIssuer, oValue, cExpireMillis, false, fFinal)) continue block6;
                    return oValueOld;
                }
                case 4: {
                    throw new ConcurrentModificationException(String.valueOf("Cache \"") + sCacheName + "\": Resource is locked by another thread or member: " + lease);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waitForUnlock(Lease lease, long cWaitMillis) {
        this.checkStatus();
        long lTime = Base.getSafeTimeMillis();
        Lease lease2 = lease;
        synchronized (lease2) {
            try {
                lease.wait(1000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
        }
        if (cWaitMillis > (long)0) {
            cWaitMillis -= Base.getSafeTimeMillis() - lTime;
            cWaitMillis = Math.max((long)0, cWaitMillis);
        }
        return cWaitMillis;
    }
}

