/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel;

import com.tangosol.coherence.mvel.ErrorDetail;
import com.tangosol.coherence.mvel.util.ParseTools;
import com.tangosol.coherence.mvel.util.StringAppender;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileException
extends RuntimeException {
    private char[] expr;
    private int cursor = 0;
    private int msgOffset = 0;
    private int lineNumber = 1;
    private int column = 0;
    private int lastLineStart = 0;
    private List<ErrorDetail> errors;

    public CompileException() {
    }

    public CompileException(String message) {
        super(message);
    }

    public CompileException(String message, List<ErrorDetail> errors) {
        super(message);
        this.errors = errors;
    }

    public CompileException(String message, int cursor) {
        super(message);
        this.cursor = cursor;
    }

    @Override
    public String toString() {
        return this.generateErrorMessage();
    }

    public CompileException(String message, char[] expr, int cursor, Throwable e) {
        super(message, e);
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, char[] expr, int cursor) {
        super(message);
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, Throwable cause) {
        super(message, cause);
    }

    public CompileException(Throwable cause) {
        super(cause);
    }

    @Override
    public String getMessage() {
        return this.generateErrorMessage();
    }

    private CharSequence showCodeNearError(char[] expr, int cursor) {
        if (expr == null) {
            return "Unknown";
        }
        int start = cursor - 10;
        int end = cursor + 20;
        if (end > expr.length) {
            end = expr.length - 1;
            start -= 20;
        }
        if (start < 0) {
            start = 0;
        }
        while (start < end && ParseTools.isWhitespace(expr[start])) {
            ++start;
        }
        String cs = null;
        try {
            cs = String.copyValueOf(expr, start, end - start);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("");
            throw e;
        }
        this.msgOffset = start;
        return cs;
    }

    private String generateErrorMessage() {
        StringAppender appender = new StringAppender().append("[Error: " + super.getMessage() + "]\n");
        int offset = appender.length();
        appender.append("[Near : {... ");
        offset = appender.length() - offset;
        appender.append(this.showCodeNearError(this.expr, this.cursor)).append(" ....}]\n").append(ParseTools.repeatChar(' ', offset));
        offset = this.cursor - this.msgOffset - 1;
        if (offset < 0) {
            offset = 0;
        }
        appender.append(ParseTools.repeatChar(' ', offset)).append("^");
        if (this.lineNumber != -1) {
            appender.append('\n').append("[Line: " + this.lineNumber + ", Column: " + this.column + "]");
        }
        return appender.toString();
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getCursor() {
        return this.cursor;
    }

    public List<ErrorDetail> getErrors() {
        return this.errors != null ? this.errors : new ArrayList(0);
    }

    public void setErrors(List<ErrorDetail> errors) {
        this.errors = errors;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setExpr(char[] expr) {
        this.expr = expr;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public int getLastLineStart() {
        return this.lastLineStart;
    }

    public void setLastLineStart(int lastLineStart) {
        this.lastLineStart = lastLineStart;
    }
}

