/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.ast;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.MVEL;
import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.ast.ASTNode;
import com.tangosol.coherence.mvel.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.ParseTools;

public class AssertNode
extends ASTNode {
    public ExecutableStatement assertion;
    public ExecutableStatement fail;

    public AssertNode(char[] expr, int fields, ParserContext pCtx) {
        this.name = expr;
        if ((fields & 0x10) != 0) {
            this.assertion = (ExecutableStatement)ParseTools.subCompileExpression(expr, pCtx);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (!((Boolean)this.assertion.getValue(ctx, thisValue, factory)).booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.name)));
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement");
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (!((Boolean)MVEL.eval(this.name, ctx, factory)).booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.name)));
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement");
        }
    }
}

