/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.ast;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.ast.ASTNode;
import com.tangosol.coherence.mvel.ast.Safe;
import com.tangosol.coherence.mvel.compiler.AbstractParser;
import com.tangosol.coherence.mvel.compiler.EndWithValue;
import com.tangosol.coherence.mvel.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel.compiler.ExpressionCompiler;
import com.tangosol.coherence.mvel.integration.VariableResolver;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import com.tangosol.coherence.mvel.integration.impl.FunctionVariableResolverFactory;
import com.tangosol.coherence.mvel.util.ParseTools;
import java.util.Map;

public class Function
extends ASTNode
implements Safe {
    protected String name;
    protected ExecutableStatement compiledBlock;
    protected String[] parameters;
    protected int parmNum;
    protected boolean cMode = false;

    public Function(String name, char[] parameters, char[] block, int fields, ParserContext pCtx) {
        this.name = name;
        if (this.name == null || name.length() == 0) {
            this.name = null;
        }
        this.parameters = ParseTools.parseParameterDefList(parameters, 0, parameters.length);
        this.parmNum = this.parameters.length;
        pCtx.declareFunction(this);
        ParserContext ctx = new ParserContext(pCtx.getParserConfiguration());
        for (String s : this.parameters) {
            ctx.addVariable(s, Object.class);
            ctx.addIndexedVariable(s);
        }
        ctx.setIndexAllocation(false);
        ExpressionCompiler compiler = new ExpressionCompiler(block);
        compiler.setVerifyOnly(true);
        compiler.compile(ctx);
        ctx.setIndexAllocation(true);
        if (pCtx.getVariables() != null) {
            for (Map.Entry<String, Class> e : pCtx.getVariables().entrySet()) {
                ctx.getVariables().remove(e.getKey());
                ctx.addInput(e.getKey(), e.getValue());
            }
            ctx.processTables();
        }
        ctx.addIndexedVariables(ctx.getVariables().keySet());
        ctx.getVariables().clear();
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(block, ctx);
        AbstractParser.setCurrentThreadParserContext(pCtx);
        this.parameters = new String[ctx.getIndexedVariables().size()];
        int i = 0;
        for (String s : ctx.getIndexedVariables()) {
            this.parameters[i++] = s;
        }
        this.cMode = (fields & 0x10) != 0;
        this.egressType = this.compiledBlock.getKnownEgressType();
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.name != null) {
            if (factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name);
            }
            factory.createVariable(this.name, this);
        }
        return this;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.name != null) {
            if (factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name);
            }
            factory.createVariable(this.name, this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(Object ctx, Object thisValue, VariableResolverFactory factory, Object[] parms) {
        try {
            if (parms != null && parms.length != 0) {
                if (!(factory instanceof FunctionVariableResolverFactory)) return this.compiledBlock.getValue(ctx, thisValue, new FunctionVariableResolverFactory(this, factory, this.parameters, parms));
                if (((FunctionVariableResolverFactory)factory).getIndexedVariableResolvers().length != parms.length) return this.compiledBlock.getValue(ctx, thisValue, new FunctionVariableResolverFactory(this, factory, this.parameters, parms));
                FunctionVariableResolverFactory fvrf = (FunctionVariableResolverFactory)factory;
                if (!fvrf.getFunction().equals(this)) return this.compiledBlock.getValue(ctx, thisValue, new FunctionVariableResolverFactory(this, factory, this.parameters, parms));
                VariableResolver[] swapVR = fvrf.getIndexedVariableResolvers();
                fvrf.updateParameters(parms);
                try {
                    Object object = this.compiledBlock.getValue(ctx, thisValue, fvrf);
                    return object;
                }
                finally {
                    fvrf.setIndexedVariableResolvers(swapVR);
                }
            }
            if (!this.cMode) return this.compiledBlock.getValue(ctx, thisValue, new DefaultLocalVariableResolverFactory(factory));
            return this.compiledBlock.getValue(ctx, thisValue, new DefaultLocalVariableResolverFactory(factory, this.parameters));
        }
        catch (EndWithValue end) {
            return end.getValue();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length != 0;
    }

    public void checkArgumentCount(int passing) {
        if (passing != this.parmNum) {
            throw new CompileException("bad number of arguments in function call: " + passing + " (expected: " + (this.parmNum == 0 ? "none" : Integer.valueOf(this.parmNum)) + ")");
        }
    }

    public ExecutableStatement getCompiledBlock() {
        return this.compiledBlock;
    }

    public String toString() {
        return "FunctionDef:" + (this.name == null ? "Anonymous" : this.name);
    }
}

