/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.router;

import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.composition.CompositionManager;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public abstract class AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private Message m_message;
    private String m_sEndpointAddress;

    protected AbstractProcessor() {
    }

    protected AbstractProcessor(Message msg, String sAddr) {
        this.m_message = msg;
        this.m_sEndpointAddress = sAddr;
    }

    protected String getEndpointAddress() {
        return this.m_sEndpointAddress;
    }

    protected Message getMessage() {
        return this.m_message;
    }

    protected Message doProcess(Message msg) {
        String sService = msg.getOperation().getServiceName();
        CompositionManager manager = ServiceContext.getContext(sService).getCompositionManager();
        Endpoint ep = manager.getEndpoint(this.m_sEndpointAddress);
        return ep.dispatch(msg);
    }

    protected Message getMessage(Set setEntries) {
        Message msg = new Message(this.m_message.getOperation());
        Results results = new Results();
        results.combine(this.m_message.getResults());
        msg.setContext(setEntries);
        msg.setResults(results);
        msg.addBindings(this.m_message.getBindings());
        return msg;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_message = (Message)ExternalizableHelper.readExternalizableLite(in);
        this.m_sEndpointAddress = (String)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeExternalizableLite(out, this.m_message);
        ExternalizableHelper.writeObject(out, this.m_sEndpointAddress);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_message = (Message)in.readObject(1);
        this.m_sEndpointAddress = in.readString(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(1, this.m_message);
        out.writeString(2, this.m_sEndpointAddress);
    }
}

