/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.JmxTableStats;
import com.tangosol.coherence.transaction.internal.storage.TransactionalCache;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Service;
import com.tangosol.net.management.Registry;
import java.util.HashMap;
import java.util.Map;

public class JmxStats {
    private volatile long m_lTotalCommitted;
    private volatile long m_lTotalRolledback;
    private volatile long m_lTotalRecovered;
    private volatile long m_lTotalActive;
    private volatile long m_lTotalMillis;
    private final Map<String, JmxTableStats> m_mapTableStats = new HashMap<String, JmxTableStats>();

    public static JmxStats initialize(Service service) {
        String sServiceName = service.getInfo().getServiceName();
        JmxStats jmxStats = new JmxStats();
        try {
            Registry registry = service.getCluster().getManagement();
            if (registry != null) {
                String sName = String.format("%s,service=%s", "type=TransactionManager", sServiceName);
                registry.register(registry.ensureGlobalName(sName), jmxStats);
            }
        }
        catch (Throwable e) {
            String s = String.format("Failed to register transaction manager for service %s: %s ", sServiceName, e);
            CacheFactory.log(s, 2);
            CacheFactory.log(e);
        }
        return jmxStats;
    }

    private JmxStats() {
    }

    public long getTotalCommits() {
        return this.m_lTotalCommitted;
    }

    public void incrementCommitCount() {
        ++this.m_lTotalCommitted;
        this.decrementActiveCount();
    }

    public long getTotalRolledback() {
        return this.m_lTotalRolledback;
    }

    public void incrementRollbackCount() {
        ++this.m_lTotalRolledback;
        this.decrementActiveCount();
    }

    public long getTotalRecovered() {
        return this.m_lTotalRecovered;
    }

    public void incrementRecoveredCount() {
        ++this.m_lTotalRecovered;
    }

    public long getTotalActive() {
        return this.m_lTotalActive;
    }

    public void incrementActiveCount() {
        ++this.m_lTotalActive;
    }

    public void decrementActiveCount() {
        --this.m_lTotalActive;
    }

    public long getTotalTransactionMillis() {
        return this.m_lTotalMillis;
    }

    public void incrementTotalTransactionMillis(long lMillis) {
        this.m_lTotalMillis += lMillis;
    }

    public void registerCache(String sTable, Service service) {
        this.getTableStats(sTable, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmxTableStats getTableStats(String sTable, Service service) {
        Map<String, JmxTableStats> map = this.m_mapTableStats;
        synchronized (map) {
            JmxTableStats stats = this.m_mapTableStats.get(sTable);
            if (stats == null) {
                String sService = service.getInfo().getServiceName();
                stats = new JmxTableStats();
                this.m_mapTableStats.put(sTable, stats);
                TransactionalCache cache = new TransactionalCache(sTable, sService, stats);
                try {
                    Registry registry = service.getCluster().getManagement();
                    if (registry != null) {
                        String sName = String.format("%s,tier=back", registry.ensureGlobalName(String.format("%s,service=%s,name=%s", "type=Cache", sService, sTable)));
                        registry.register(sName, cache);
                    }
                }
                catch (Throwable e) {
                    String s = String.format("Failed to register cache with JMX %s: %s ", sTable, e);
                    CacheFactory.log(s, 2);
                    CacheFactory.log(e);
                }
            }
            return stats;
        }
    }

    public void reset() {
        this.m_lTotalCommitted = 0L;
        this.m_lTotalRolledback = 0L;
        this.m_lTotalRecovered = 0L;
        this.m_lTotalActive = 0L;
        this.m_lTotalMillis = 0L;
        for (JmxTableStats tableStats : this.m_mapTableStats.values()) {
            tableStats.reset();
        }
    }
}

