/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.JmxStats;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalMemberState {
    private static volatile Map<String, LocalMemberState> s_mapMembers = new HashMap<String, LocalMemberState>();
    private final Map<Integer, LocalPartitionState> m_mapPartitions = new ConcurrentHashMap<Integer, LocalPartitionState>();
    private long m_lCRVersion;
    private volatile long m_lCurrentVersion = -1L;
    private JmxStats m_jmxStats;
    public final Object VERSION_LOCK = new Object[0];

    public LocalMemberState(JmxStats jmxStats) {
        this.m_jmxStats = jmxStats;
    }

    public static void register(String sService, JmxStats jmxStats) {
        s_mapMembers.put(sService, new LocalMemberState(jmxStats));
    }

    public static LocalMemberState getMemberState(String sService) {
        return s_mapMembers.get(sService);
    }

    public synchronized LocalPartitionState ensureLocalPartitionState(int iPartition) {
        LocalPartitionState partitionState = this.getLocalPartitionState(iPartition);
        if (partitionState == null) {
            partitionState = new LocalPartitionState(iPartition, this);
            this.m_mapPartitions.put(iPartition, partitionState);
        }
        return partitionState;
    }

    public LocalPartitionState getLocalPartitionState(int iPartition) {
        return this.m_mapPartitions.get(iPartition);
    }

    public void removeLocalPartitionState(int iPartition) {
        this.m_mapPartitions.remove(iPartition);
    }

    public Collection<LocalPartitionState> getAllPartitions() {
        return this.m_mapPartitions.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsistentReadVersion(long lVersion) {
        LocalMemberState localMemberState = this;
        synchronized (localMemberState) {
            long lCRVersion = this.m_lCRVersion;
            if (lVersion > lCRVersion) {
                this.m_lCRVersion = lVersion;
            }
        }
    }

    public synchronized long getConsistentReadVersion() {
        return this.m_lCRVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentWriteVersion(long lVersion) {
        Object object = this.VERSION_LOCK;
        synchronized (object) {
            if (lVersion > this.m_lCurrentVersion) {
                this.m_lCurrentVersion = lVersion;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentWriteVersion() {
        Object object = this.VERSION_LOCK;
        synchronized (object) {
            return this.m_lCurrentVersion;
        }
    }

    public JmxStats getJmxStats() {
        return this.m_jmxStats;
    }
}

