/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.ThrowablePofSerializer;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PortableException
extends RuntimeException
implements PortableObject {
    protected String m_sName = this.getClass().getName();
    protected String m_sMessage;
    protected String[] m_asStackRemote;

    protected PortableException() {
    }

    protected PortableException(String sMessage) {
        super(sMessage);
        this.m_sMessage = sMessage;
    }

    protected PortableException(Throwable e) {
        super(e);
    }

    protected PortableException(String sMessage, Throwable e) {
        super(sMessage, e);
        this.m_sMessage = sMessage;
    }

    public String getName() {
        Class<?> clazz = this.getClass();
        String sName = this.m_sName;
        if (sName != null && clazz == PortableException.class) {
            String sPrefix = "Portable(";
            if (sName.startsWith(sPrefix)) {
                return sName;
            }
            return sPrefix + sName + ')';
        }
        return clazz.getName();
    }

    public String[] getFullStackTrace() {
        int ofLocal;
        String[] asStackFull;
        String[] asStackRemote = this.m_asStackRemote;
        StackTraceElement[] aoStackLocal = this.getStackTrace();
        int cLocal = aoStackLocal.length;
        if (asStackRemote == null) {
            asStackFull = new String[cLocal];
            ofLocal = 0;
        } else {
            int cRemote = asStackRemote.length;
            asStackFull = new String[cRemote + cLocal + 1];
            System.arraycopy(asStackRemote, 0, asStackFull, 0, cRemote);
            asStackFull[cRemote] = "at <process boundary>";
            ofLocal = cRemote + 1;
        }
        for (int i = 0; i < cLocal; ++i) {
            asStackFull[ofLocal + i] = "at " + aoStackLocal[i];
        }
        return asStackFull;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sName = in.readString(0);
        this.m_sMessage = in.readString(1);
        this.m_asStackRemote = in.readCollection(2, new ArrayList(64)).toArray(new String[0]);
        this.initCause((Throwable)in.readObject(3));
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        ThrowablePofSerializer.writeThrowable(out, this);
    }

    @Override
    public String getMessage() {
        return this.m_sMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(stream);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter writer) {
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            writer.println(this);
            String[] asStackFull = this.getFullStackTrace();
            int c = asStackFull.length;
            for (int i = 0; i < c; ++i) {
                writer.println("\t" + asStackFull[i]);
            }
            Throwable tCause = this.getCause();
            if (tCause != null) {
                writer.print("Caused by: ");
                tCause.printStackTrace(writer);
            }
        }
    }

    @Override
    public String toString() {
        String sPrefix = this.getName();
        String sMessage = this.getMessage();
        return sMessage == null ? sPrefix : sPrefix + ": " + sMessage;
    }
}

