/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Base;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLException;

public class TcpDatagramSocket
extends DatagramSocket {
    public static final int IO_EXCEPTIONS_LOG_LEVEL = Integer.parseInt(System.getProperty("tangosol.coherence.tcpdatagram.log.level", "-1"));
    protected Impl m_impl;

    public TcpDatagramSocket() throws SocketException {
        this(new InetSocketAddress(0));
    }

    public TcpDatagramSocket(SocketAddress addr) throws SocketException {
        this(new Impl());
        if (addr != null) {
            this.bind(addr);
        }
    }

    public TcpDatagramSocket(int nPort) throws SocketException {
        this(nPort, null);
    }

    public TcpDatagramSocket(int nPort, InetAddress addr) throws SocketException {
        this(new InetSocketAddress(addr, nPort));
    }

    public TcpDatagramSocket(SocketProvider provider) throws SocketException {
        this(new Impl(provider));
    }

    protected TcpDatagramSocket(Impl impl) {
        super(impl);
        this.m_impl = impl;
    }

    public SelectorProvider provider() {
        return this.m_impl.provider();
    }

    public void setSocketOptions(java.net.SocketOptions options) throws SocketException {
        this.m_impl.m_options.copyOptions(options);
    }

    public void setListenBacklog(int n) throws IOException {
        if (this.isBound()) {
            throw new IOException("already bound");
        }
        this.m_impl.m_nBacklog = n;
    }

    public void setPacketMagic(int nMagic, int nMask) throws IOException {
        if (this.isBound()) {
            throw new IOException("already bound");
        }
        this.m_impl.setPacketMagic(nMagic, nMask);
    }

    public void setAdvanceFrequency(int nAdvance) {
        this.m_impl.m_nAdvanceFrequency = Math.max(1, nAdvance);
    }

    @Override
    public void bind(SocketAddress addr) throws SocketException {
        this.m_impl.bind(addr);
    }

    @Override
    public boolean isBound() {
        return this.m_impl.m_socket.socket().isBound();
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        this.m_impl.send(p);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.m_impl.receive(p);
    }

    public String toString() {
        return this.m_impl.toString();
    }

    public static class Impl
    extends DatagramSocketImpl {
        final SocketProvider m_provider;
        final SocketOptions m_options = new SocketOptions();
        int m_nBacklog;
        final Map<SocketChannel, ConnectionStatus> m_mapRegScheduled = new ConcurrentHashMap<SocketChannel, ConnectionStatus>();
        Selector m_selector;
        Iterator<SelectionKey> m_iterKeysPending;
        SelectionKey m_keyCurrent;
        int m_cKeyUses;
        int m_nAdvanceFrequency = 32;
        ServerSocketChannel m_socket;
        ConcurrentMap<SocketAddress, Connection> m_mapConnectionsOut;
        Map<Integer, Object> m_mapOptions;
        long m_cMillisSoTimeout;
        long m_ldtLastWarn;
        int m_nPacketMagic;
        int m_nPacketMagicMask;
        public static final int HEADER_SIZE = 4;
        public static final int PROTOCOL_MAGIC = 232718554;

        public Impl() throws SocketException {
            this(SocketProviderFactory.DEFAULT_PROVIDER);
        }

        public Impl(SocketProvider provider) throws SocketException {
            this.m_provider = provider;
            this.m_mapConnectionsOut = new ConcurrentHashMap<SocketAddress, Connection>();
            this.m_mapOptions = new ConcurrentHashMap<Integer, Object>();
            try {
                SocketOptions options = this.m_options;
                options.setOption(1, true);
                options.setOption(128, 0);
                ServerSocketChannel socket = this.m_socket = provider.openServerSocketChannel();
                socket.configureBlocking(false);
                this.m_selector = socket.provider().openSelector();
            }
            catch (IOException e) {
                throw Impl.ensureSocketException(e);
            }
        }

        public SelectorProvider provider() {
            return this.m_selector.provider();
        }

        public void setPacketMagic(int nMagic, int nMask) {
            this.m_nPacketMagic = nMagic & nMask;
            this.m_nPacketMagicMask = nMask;
        }

        @Override
        protected void create() throws SocketException {
        }

        @Override
        protected void bind(int nPort, InetAddress addr) throws SocketException {
            this.bind(new InetSocketAddress(addr, nPort));
        }

        @Override
        protected int getLocalPort() {
            return this.m_socket == null ? 0 : this.m_socket.socket().getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void send(DatagramPacket packet) throws IOException {
            OutputStream out;
            Connection conn;
            int cb = packet.getLength();
            try {
                conn = this.ensureConnection(packet.getSocketAddress());
                out = conn.m_out;
            }
            catch (IOException e) {
                this.logException(packet.getSocketAddress(), e);
                return;
            }
            OutputStream outputStream = out;
            synchronized (outputStream) {
                try {
                    byte[] abPacket = packet.getData();
                    switch (this.m_nPacketMagicMask) {
                        case -65536: {
                            if (cb > 65535) {
                                throw new IOException("packet length exceeds 2^16");
                            }
                            abPacket[0] = (byte)(cb >>> 8);
                            abPacket[1] = (byte)cb;
                            break;
                        }
                        case -16: {
                            abPacket[3] = (byte)(conn.m_cTxPacket << 4 | abPacket[3] & 0xF);
                        }
                        case -256: {
                            if (cb > 0xFFFFFF) {
                                throw new IOException("packet length exceeds 2^24");
                            }
                            abPacket[0] = (byte)(cb >>> 16);
                            abPacket[1] = (byte)(cb >>> 8);
                            abPacket[2] = (byte)cb;
                            break;
                        }
                        case -1: {
                            abPacket[0] = (byte)(cb >>> 24);
                            abPacket[1] = (byte)(cb >>> 16);
                            abPacket[2] = (byte)(cb >>> 8);
                            abPacket[3] = (byte)cb;
                            break;
                        }
                        default: {
                            out.write(cb >>> 24);
                            out.write(cb >>> 16);
                            out.write(cb >>> 8);
                            out.write(cb);
                        }
                    }
                    out.write(packet.getData(), packet.getOffset(), cb);
                    out.flush();
                    ++conn.m_cTxPacket;
                }
                catch (IOException e) {
                    this.closeOutbound(packet.getSocketAddress());
                }
            }
        }

        @Override
        protected int peek(InetAddress addr) throws IOException {
            return 0;
        }

        @Override
        protected int peekData(DatagramPacket packet) throws IOException {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void receive(DatagramPacket packet) throws IOException {
            ByteBuffer buffPacket = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength());
            SelectionKey key = this.m_keyCurrent;
            if (key == null || this.m_cKeyUses++ > this.m_nAdvanceFrequency || !this.onRead(key, buffPacket)) {
                try {
                    key = null;
                    key = this.nextKey(buffPacket);
                }
                finally {
                    this.m_keyCurrent = key;
                    this.m_cKeyUses = 1;
                }
            }
            ConnectionStatus status = (ConnectionStatus)key.attachment();
            packet.setLength(status.m_cbBody);
            packet.setSocketAddress(status.m_addr);
            packet.setPort(status.m_addr.getPort());
        }

        protected SelectionKey nextKey(ByteBuffer buffPacket) throws IOException, SocketTimeoutException {
            Selector selector = this.m_selector;
            Map<SocketChannel, ConnectionStatus> mapSched = this.m_mapRegScheduled;
            long cMillisSoTimeout = this.m_cMillisSoTimeout;
            Selector selector2 = selector;
            synchronized (selector2) {
                Iterator<SelectionKey> iterPending = this.m_iterKeysPending;
                Set<SelectionKey> setPending = selector.isOpen() ? selector.selectedKeys() : null;
                while (true) {
                    try {
                        while (true) {
                            if (iterPending == null || !iterPending.hasNext()) {
                                try {
                                    selector.select(cMillisSoTimeout);
                                    if (!mapSched.isEmpty()) {
                                        this.processRegistrations();
                                        continue;
                                    }
                                    if (setPending.isEmpty()) {
                                        this.ensureBound();
                                        throw new SocketTimeoutException();
                                    }
                                    this.m_iterKeysPending = iterPending = selector.selectedKeys().iterator();
                                }
                                catch (ClosedChannelException e) {
                                    throw new SocketException("closed socket");
                                }
                            }
                            SelectionKey key = iterPending.next();
                            iterPending.remove();
                            if (key == null || !key.isValid()) continue;
                            if (key.isReadable()) {
                                if (!this.onRead(key, buffPacket)) continue;
                                return key;
                            }
                            if (key.isAcceptable()) {
                                this.onAccept(key);
                                continue;
                            }
                            if (key.readyOps() != 0) continue;
                            this.closeInbound((ConnectionStatus)key.attachment(), (SocketChannel)key.channel());
                        }
                    }
                    catch (ClosedSelectorException e) {
                        throw new SocketException("closed socket");
                    }
                    catch (CancelledKeyException e) {
                        continue;
                    }
                    break;
                }
            }
        }

        protected void onAccept(SelectionKey key) {
            SocketChannel chan = null;
            try {
                chan = ((ServerSocketChannel)key.channel()).accept();
                if (chan != null) {
                    chan.configureBlocking(false);
                    this.configureSocket(chan.socket());
                    chan.register(this.m_selector, 1, new ConnectionStatus());
                }
            }
            catch (IOException e) {
                this.logException(chan == null ? null : chan.socket().getRemoteSocketAddress(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean onRead(SelectionKey key, ByteBuffer buffPacket) {
            ConnectionStatus status;
            SocketChannel chan;
            try {
                chan = (SocketChannel)key.channel();
                status = (ConnectionStatus)key.attachment();
            }
            catch (CancelledKeyException e) {
                return false;
            }
            Socket socket = chan.socket();
            boolean fEOS = false;
            int nLimitRestore = -1;
            int nPosRestore = -1;
            int nPacketMagic = this.m_nPacketMagic;
            int nPacketMask = this.m_nPacketMagicMask;
            int nHead = 0;
            try {
                switch (status.m_state) {
                    case 0: 
                    case 3: {
                        fEOS = this.onConnectionHeader(status, chan);
                        if (status.m_state != 4) {
                            return false;
                        }
                    }
                    case 4: {
                        ByteBuffer buff = status.m_head;
                        boolean bl = fEOS = chan.read(buff) < 0;
                        if (buff.hasRemaining()) {
                            return false;
                        }
                        buff.flip();
                        nHead = buff.getInt();
                        switch (nPacketMask) {
                            case -65536: {
                                status.m_cbBody = nHead >>> 16;
                                break;
                            }
                            case -16: {
                                if ((status.m_cRxPacket & 0xF) != (nHead & 0xF0) >>> 4) {
                                    CacheFactory.log("Recovering corrupted packet stream from " + status.m_addr + " detected at packet " + status.m_cRxPacket + ", last packet" + " length " + status.m_cbBody, 5);
                                    throw new IOException();
                                }
                            }
                            case -256: {
                                status.m_cbBody = nHead >>> 8;
                                break;
                            }
                            default: {
                                status.m_cbBody = nHead;
                            }
                        }
                        ++status.m_cRxPacket;
                        buff.clear();
                        status.m_state = 5;
                    }
                    case 5: {
                        ByteBuffer buff;
                        if (status.m_body.position() == 0) {
                            if (buffPacket.remaining() >= status.m_cbBody) {
                                buff = buffPacket;
                                nPosRestore = buff.position();
                                nLimitRestore = buff.limit();
                                buff.limit(nPosRestore + status.m_cbBody);
                            } else if (status.m_body.remaining() >= status.m_cbBody) {
                                buff = status.m_body;
                                buff.limit(status.m_cbBody);
                            } else {
                                buff = status.m_body = ByteBuffer.allocate(status.m_cbBody);
                            }
                            switch (nPacketMask) {
                                case -65536: 
                                case -256: 
                                case -16: 
                                case -1: {
                                    if (status.m_cbBody < 4) {
                                        CacheFactory.log("Recovering corrupted packet stream from " + status.m_addr + " detected at" + " packet " + status.m_cRxPacket + ", with packet length " + status.m_cbBody + ", buffer " + "capacity " + status.m_body.capacity(), 5);
                                        throw new IOException();
                                    }
                                    buff.putInt(nPacketMagic | ~nPacketMask & nHead);
                                    break;
                                }
                            }
                        } else {
                            buff = status.m_body;
                        }
                        boolean bl = fEOS = chan.read(buff) < 0;
                        if (!buff.hasRemaining()) {
                            if (buff == status.m_body) {
                                buff.rewind();
                                status.m_cbBody = this.transferBytes(buff, buffPacket);
                                status.m_body.clear();
                            }
                            status.m_state = 4;
                            boolean bl2 = true;
                            return bl2;
                        }
                        if (buff != buffPacket) return false;
                        if (status.m_body.capacity() < status.m_cbBody) {
                            status.m_body = ByteBuffer.allocate(status.m_cbBody);
                        } else {
                            status.m_body.limit(status.m_cbBody);
                        }
                        buffPacket.limit(buffPacket.position());
                        buffPacket.position(nPosRestore);
                        this.transferBytes(buffPacket, status.m_body);
                        return false;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (IOException e) {
                this.logException(status.m_addr == null ? socket.getRemoteSocketAddress() : status.m_addr, e);
                this.closeInbound(status, chan);
                return false;
            }
            finally {
                if (nLimitRestore != -1) {
                    buffPacket.limit(nLimitRestore);
                    buffPacket.position(nPosRestore);
                }
                if (fEOS) {
                    this.closeInbound(status, chan);
                }
            }
        }

        protected boolean onConnectionHeader(ConnectionStatus status, SocketChannel chan) throws IOException {
            Socket socket = chan.socket();
            ByteBuffer buff = status.m_head;
            boolean fEOS = false;
            switch (status.m_state) {
                case 0: {
                    boolean bl = fEOS = chan.read(buff) < 0;
                    if (buff.hasRemaining()) break;
                    buff.flip();
                    int nMagic = buff.getInt();
                    buff.clear();
                    if (nMagic != 232718554) {
                        if (nMagic == 0) break;
                        fEOS = true;
                        this.logProtocolWarning(socket.getRemoteSocketAddress(), status, nMagic);
                        break;
                    }
                    status.m_state = 1;
                }
                case 1: {
                    boolean bl = fEOS = chan.read(buff) < 0;
                    if (buff.hasRemaining()) break;
                    buff.flip();
                    int nPacketMagic = buff.getInt();
                    buff.clear();
                    if (nPacketMagic != this.m_nPacketMagic) {
                        fEOS = true;
                        this.logProtocolWarning(socket.getRemoteSocketAddress(), status, nPacketMagic);
                        break;
                    }
                    status.m_state = 2;
                }
                case 2: {
                    boolean bl = fEOS = chan.read(buff) < 0;
                    if (buff.hasRemaining()) break;
                    buff.flip();
                    int nPacketMagicMask = buff.getInt();
                    buff.clear();
                    if (nPacketMagicMask != this.m_nPacketMagicMask) {
                        fEOS = true;
                        this.logProtocolWarning(socket.getRemoteSocketAddress(), status, nPacketMagicMask);
                        break;
                    }
                    status.m_state = 3;
                }
                case 3: {
                    boolean bl = fEOS = chan.read(buff) < 0;
                    if (buff.hasRemaining()) break;
                    buff.flip();
                    status.m_addr = new InetSocketAddress(chan.socket().getInetAddress(), buff.getInt());
                    buff.clear();
                    status.m_state = 4;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return fEOS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void close() {
            ConcurrentMap<SocketAddress, Connection> map;
            try {
                this.m_socket.close();
            }
            catch (IOException e) {
                this.logException(this.m_socket.socket().getLocalSocketAddress(), e);
            }
            ConcurrentMap<SocketAddress, Connection> concurrentMap = map = this.m_mapConnectionsOut;
            synchronized (concurrentMap) {
                for (Connection conn : map.values()) {
                    if (conn == null) continue;
                    try {
                        conn.m_socket.close();
                    }
                    catch (IOException e) {
                        this.logException(conn.m_socket.getRemoteSocketAddress(), e);
                    }
                }
            }
            Selector selector = this.m_selector;
            try {
                for (SelectionKey key : selector.keys()) {
                    if (key == null || !(key.channel() instanceof SocketChannel)) continue;
                    this.closeInbound((ConnectionStatus)key.attachment(), (SocketChannel)key.channel());
                }
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
            try {
                selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void setOption(int nId, Object oValue) throws SocketException {
            this.m_mapOptions.put(nId, oValue);
            if (nId == 4102) {
                this.m_cMillisSoTimeout = ((Number)oValue).longValue();
            }
        }

        @Override
        public Object getOption(int nId) throws SocketException {
            switch (nId) {
                case 15: {
                    return this.m_socket == null ? null : this.m_socket.socket().getInetAddress();
                }
            }
            return this.m_mapOptions.get(nId);
        }

        @Override
        protected void setTTL(byte ttl) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected byte getTTL() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setTimeToLive(int ttl) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int getTimeToLive() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void join(InetAddress inetaddr) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void leave(InetAddress inetaddr) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void bind(SocketAddress addr) throws SocketException {
            try {
                ServerSocketChannel socket = this.m_socket;
                this.m_options.apply(socket.socket());
                socket.socket().bind(addr, this.m_nBacklog);
                socket.register(this.m_selector, 16);
            }
            catch (IOException e) {
                throw Impl.ensureSocketException(e);
            }
        }

        void configureSocket(Socket socket) throws SocketException {
            this.m_options.apply(socket);
        }

        void ensureBound() throws SocketException {
            block3: {
                ServerSocketChannel socket = this.m_socket;
                if (!socket.socket().isBound()) {
                    try {
                        this.bind(null);
                    }
                    catch (IOException e) {
                        if (socket.socket().isBound()) break block3;
                        throw Impl.ensureSocketException(e);
                    }
                }
            }
        }

        protected static SocketException ensureSocketException(IOException e) {
            if (e instanceof SocketException) {
                return (SocketException)e;
            }
            SocketException es = new SocketException(e.getMessage());
            es.initCause(e);
            return es;
        }

        protected Connection makeConnection(SocketAddress addr) throws IOException {
            Connection conn = new Connection(addr, this.m_provider, this.m_options);
            OutputStream out = conn.m_out;
            int nMagic = 232718554;
            out.write(nMagic >>> 24);
            out.write(nMagic >>> 16);
            out.write(nMagic >>> 8);
            out.write(nMagic);
            int nPacketMagic = this.m_nPacketMagic;
            out.write(nPacketMagic >>> 24);
            out.write(nPacketMagic >>> 16);
            out.write(nPacketMagic >>> 8);
            out.write(nPacketMagic);
            int nPacketMagicMask = this.m_nPacketMagicMask;
            out.write(nPacketMagicMask >>> 24);
            out.write(nPacketMagicMask >>> 16);
            out.write(nPacketMagicMask >>> 8);
            out.write(nPacketMagicMask);
            int nPort = this.m_socket.socket().getLocalPort();
            out.write(nPort >>> 24);
            out.write(nPort >>> 16);
            out.write(nPort >>> 8);
            out.write(nPort);
            return conn;
        }

        protected Connection ensureConnection(SocketAddress addr) throws IOException {
            ConcurrentMap<SocketAddress, Connection> map = this.m_mapConnectionsOut;
            Connection conn = (Connection)map.get(addr);
            if (conn == null) {
                if (this.m_socket.socket().isClosed()) {
                    throw new SocketException("Socket is closed");
                }
                this.ensureBound();
                conn = this.makeConnection(addr);
                if (map.putIfAbsent(addr, conn) == null) {
                    return conn;
                }
                map.get(addr);
            }
            return conn;
        }

        protected void closeInbound(ConnectionStatus status, SocketChannel chan) {
            if (status.m_connection != null && status.m_addr != null) {
                this.m_mapConnectionsOut.remove(status.m_addr, status.m_connection);
            }
            try {
                chan.close();
            }
            catch (IOException e) {
                this.logException(status.m_addr == null ? chan.socket().getRemoteSocketAddress() : status.m_addr, e);
            }
        }

        protected void closeOutbound(SocketAddress addr) {
            Connection conn = (Connection)this.m_mapConnectionsOut.remove(addr);
            if (conn != null) {
                if (conn.m_out != null) {
                    try {
                        conn.m_out.flush();
                    }
                    catch (IOException e) {
                        this.logException(addr, e);
                    }
                }
                try {
                    SocketChannel chan = conn.m_socket.getChannel();
                    if (chan == null) {
                        conn.m_socket.close();
                    } else {
                        chan.close();
                    }
                }
                catch (IOException e) {
                    this.logException(addr, e);
                }
            }
        }

        protected void scheduleRegistration(SocketChannel chan, ConnectionStatus status) {
            this.m_mapRegScheduled.put(chan, status);
            this.m_selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processRegistrations() {
            Map<SocketChannel, ConnectionStatus> mapReg;
            Selector selector = this.m_selector;
            Map<SocketChannel, ConnectionStatus> map = mapReg = this.m_mapRegScheduled;
            synchronized (map) {
                Iterator<Map.Entry<SocketChannel, ConnectionStatus>> iter = this.m_mapRegScheduled.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<SocketChannel, ConnectionStatus> entry = iter.next();
                    if (entry == null) continue;
                    iter.remove();
                    SocketChannel chan = entry.getKey();
                    ConnectionStatus status = entry.getValue();
                    try {
                        chan.register(selector, 1, status);
                    }
                    catch (ClosedChannelException e) {
                        this.closeInbound(status, chan);
                    }
                }
            }
        }

        protected int transferBytes(ByteBuffer buffSrc, ByteBuffer buffDst) {
            int cbDst;
            int ofSrc = buffSrc.position();
            int cbSrc = buffSrc.remaining();
            if (cbSrc > (cbDst = buffDst.remaining())) {
                buffDst.put(buffSrc.array(), buffSrc.arrayOffset() + ofSrc, cbDst);
                buffSrc.position(ofSrc + cbDst);
                return cbDst;
            }
            buffDst.put(buffSrc);
            return cbSrc;
        }

        protected void logException(SocketAddress addr, IOException e) {
            int nLevel;
            int n = nLevel = e instanceof SSLException ? 2 : IO_EXCEPTIONS_LOG_LEVEL;
            if (nLevel >= 0 && CacheFactory.isLogEnabled(nLevel)) {
                CacheFactory.log(this + ", exception regarding peer " + addr + ", " + Base.getDeepMessage(e, "; "), nLevel);
                if (IO_EXCEPTIONS_LOG_LEVEL >= 0 && CacheFactory.isLogEnabled(IO_EXCEPTIONS_LOG_LEVEL)) {
                    CacheFactory.err(e);
                }
            }
        }

        protected void logProtocolWarning(SocketAddress addr, ConnectionStatus status, int nMagic) {
            long ldtNow = Base.getSafeTimeMillis();
            if (ldtNow - this.m_ldtLastWarn > 10000L) {
                CacheFactory.log("Unexpected protocol header " + nMagic + " in state " + status.m_state + " received from " + addr + " dropping connection", 2);
                this.m_ldtLastWarn = ldtNow;
            }
        }

        public String toString() {
            return "TcpDatagramSocket{bind=" + this.m_socket.socket() + "}";
        }

        static class ConnectionStatus {
            public Connection m_connection;
            public int m_state = 0;
            public InetSocketAddress m_addr;
            public ByteBuffer m_head = ByteBuffer.allocate(4);
            public ByteBuffer m_body = ByteBuffer.allocate(2048);
            public int m_cbBody;
            public int m_cRxPacket;
            public static final int WAIT_MAGIC = 0;
            public static final int WAIT_PACKET_MAGIC = 1;
            public static final int WAIT_PACKET_MAGIC_MASK = 2;
            public static final int WAIT_PORT = 3;
            public static final int WAIT_HEAD = 4;
            public static final int WAIT_BODY = 5;

            ConnectionStatus() {
            }
        }

        static class Connection {
            final Socket m_socket;
            final OutputStream m_out;
            int m_cTxPacket;

            public Connection(SocketAddress addr, SocketProvider provider, SocketOptions options) throws IOException {
                this.m_socket = provider.openSocket();
                options.apply(this.m_socket);
                this.m_socket.connect(addr);
                this.m_out = new BufferedOutputStream(this.m_socket.getOutputStream());
            }

            protected Connection(Socket socket) {
                this.m_out = null;
                this.m_socket = socket;
            }
        }
    }
}

