/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.dev.compiler.CompilerErrorInfo;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.ParsePosition;
import com.tangosol.dev.compiler.Script;
import com.tangosol.dev.compiler.Token;
import com.tangosol.dev.compiler.Tokenizer;
import com.tangosol.run.xml.XmlScript;
import com.tangosol.run.xml.XmlToken;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Dequeue;
import com.tangosol.util.ErrorList;
import com.tangosol.util.Resources;
import java.io.EOFException;
import java.io.IOException;
import java.util.NoSuchElementException;

public class XmlTokenizer
extends Base
implements Tokenizer,
ErrorList.Constants {
    public static final String ERR_INTERNAL = "XT-001";
    public static final String ERR_UNEXPECTED_EOF = "XT-002";
    public static final String ERR_UNEXPECTED_IO = "XT-003";
    public static final String ERR_XML_FORMAT = "XT-004";
    public static final String ERR_CHAR_EXPECTED = "XT-005";
    public static final Resources RESOURCES = ClassHelper.getPackageResources("com.tangosol.run.xml.");
    private static final int CTX_OUTSIDE = 0;
    private static final int CTX_XMLDECL = 1;
    private static final int CTX_DOCTYPE = 2;
    private static final int CTX_COMMENT = 3;
    private static final int CTX_PI = 4;
    private static final int CTX_ELEMENT = 5;
    private static final int CTX_CHARDATA = 6;
    private static final int CTX_DTD = 7;
    private static final int CTX_DTD_COMMENT = 8;
    private int m_nCtx;
    private Script m_script;
    private Dequeue m_dq;
    private ErrorList m_errlist;

    public XmlTokenizer() {
    }

    public XmlTokenizer(String s, ErrorList errlist) throws CompilerException {
        this(new XmlScript(s), errlist);
    }

    public XmlTokenizer(Script script, ErrorList errlist) throws CompilerException {
        this.setScript(script, errlist);
    }

    @Override
    public void setScript(Script script, ErrorList errlist) throws CompilerException {
        if (this.m_script != null) {
            throw new IllegalStateException();
        }
        this.m_errlist = errlist;
        this.m_script = script;
        this.m_dq = new Dequeue();
        this.eatFluff();
    }

    @Override
    public boolean hasMoreTokens() {
        if (this.m_dq.hasMoreElements()) {
            return true;
        }
        return this.m_script.hasMoreChars();
    }

    @Override
    public Token nextToken() throws CompilerException {
        Token tok;
        if (this.m_dq.hasMoreElements()) {
            tok = (Token)this.m_dq.nextElement();
        } else if (this.m_script.hasMoreChars()) {
            tok = this.eatToken();
            this.eatFluff();
        } else {
            throw new NoSuchElementException();
        }
        return tok;
    }

    @Override
    public void putBackToken(Token tok) {
        this.m_dq.putBackElement(tok);
    }

    @Override
    public ParsePosition savePosition() {
        Position pos = new Position();
        pos.toker = this;
        pos.dq = (Dequeue)this.m_dq.clone();
        pos.scriptpos = this.m_script.savePosition();
        return pos;
    }

    @Override
    public void restorePosition(ParsePosition parsepos) {
        Position pos = (Position)parsepos;
        if (pos.toker != this) {
            throw new IllegalArgumentException("Unknown ParsePosition object!");
        }
        this.m_script.restorePosition(pos.scriptpos);
        this.m_dq = pos.dq;
    }

    protected void eatFluff() throws CompilerException {
        Script script = this.m_script;
        try {
            block6: while (script.hasMoreChars()) {
                char ch = script.nextChar();
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block6;
                    }
                }
                script.putBackChar();
                return;
            }
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected Token eatToken() throws CompilerException {
        switch (this.m_nCtx) {
            case 0: {
                return this.eatOutside();
            }
            case 1: {
                return this.eatXmlDecl();
            }
            case 2: {
                return this.eatDocType();
            }
            case 3: 
            case 8: {
                return this.eatComment();
            }
            case 4: {
                return this.eatPi();
            }
            case 5: {
                return this.eatElement();
            }
            case 7: {
                return this.eatDtd();
            }
        }
        throw this.internalError();
    }

    protected Token eatOutside() throws CompilerException {
        Script script = this.m_script;
        int iLine = script.getLine();
        int ofInLine = script.getOffset();
        try {
            if (script.nextChar() == '<') {
                switch (script.nextChar()) {
                    case '/': {
                        this.m_nCtx = 5;
                        return new XmlToken(XmlToken.TOK_ENDTAG_START, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                    case '?': {
                        this.m_nCtx = 4;
                        return new XmlToken(XmlToken.TOK_PI_START, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                    case '!': {
                        switch (script.nextChar()) {
                            case '-': {
                                this.match('-');
                                this.m_nCtx = 3;
                                return new XmlToken(XmlToken.TOK_COMMENT_START, iLine, ofInLine, script.getOffset() - ofInLine);
                            }
                            case '[': {
                                this.match("CDATA[");
                                ParsePosition pos = script.savePosition();
                                this.scan("]]>");
                                String sData = ((Object)script.subScript(pos)).toString();
                                script.nextChar();
                                script.nextChar();
                                script.nextChar();
                                return new XmlToken(2, 4, 4, sData, sData, iLine, ofInLine, script.getOffset() - ofInLine);
                            }
                            case 'D': {
                                script.putBackChar();
                                this.match("DOCTYPE");
                                this.m_nCtx = 2;
                                return new XmlToken(XmlToken.TOK_DOCTYPE_START, iLine, ofInLine, script.getOffset() - ofInLine);
                            }
                        }
                        script.putBackChar();
                        this.match('-');
                        throw this.internalError();
                    }
                }
                script.putBackChar();
                this.m_nCtx = 5;
                return new XmlToken(XmlToken.TOK_ELEMENT_START, iLine, ofInLine, script.getOffset() - ofInLine);
            }
            script.putBackChar();
            ParsePosition pos = script.savePosition();
            while (script.nextChar() != '<') {
            }
            script.putBackChar();
            String sData = ((Object)script.subScript(pos)).toString();
            return new XmlToken(2, 4, 3, sData, sData, iLine, ofInLine, script.getOffset() - ofInLine);
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected Token eatXmlDecl() throws CompilerException {
        return this.eatElement();
    }

    protected Token eatDocType() throws CompilerException {
        Script script = this.m_script;
        int iLine = script.getLine();
        int ofInLine = script.getOffset();
        try {
            if (script.nextChar() == '[') {
                this.m_nCtx = 7;
                return new XmlToken(XmlToken.TOK_DTD_DECL_START, iLine, ofInLine, script.getOffset() - ofInLine);
            }
            script.putBackChar();
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        return this.eatElement();
    }

    protected Token eatDtd() throws CompilerException {
        Script script = this.m_script;
        int iLine = script.getLine();
        int ofInLine = script.getOffset();
        try {
            char ch = script.nextChar();
            switch (ch) {
                case '<': {
                    this.match('!');
                    if (this.peek('-')) {
                        this.match('-');
                        this.m_nCtx = 8;
                        return new XmlToken(XmlToken.TOK_COMMENT_START, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                    Token tokName = this.eatName();
                    String sName = tokName.getText();
                    this.scan('>');
                    this.match('>');
                    if (sName.equals("ELEMENT")) {
                        return new XmlToken(XmlToken.TOK_DTD_ELEMENT, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                    if (sName.equals("ATTLIST")) {
                        return new XmlToken(XmlToken.TOK_DTD_ATTLIST, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                    if (sName.equals("ENTITY")) {
                        return new XmlToken(XmlToken.TOK_DTD_ENTITY, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                    if (sName.equals("NOTATION")) {
                        return new XmlToken(XmlToken.TOK_DTD_NOTATION, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                    this.logError(3, ERR_XML_FORMAT, null, iLine, ofInLine, 0);
                    throw new CompilerException();
                }
                case '%': {
                    Token tokName = this.eatName();
                    String sName = tokName.getText();
                    this.match(';');
                    return new XmlToken(4, 0, 22, sName, sName, iLine, ofInLine, script.getOffset() - ofInLine);
                }
            }
            script.putBackChar();
            this.match(']');
            this.m_nCtx = 2;
            return new XmlToken(XmlToken.TOK_DTD_DECL_STOP, iLine, ofInLine, script.getOffset() - ofInLine);
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected Token eatComment() throws CompilerException {
        Script script = this.m_script;
        ParsePosition pos = script.savePosition();
        int iLine = script.getLine();
        int ofInLine = script.getOffset();
        boolean fFirst = true;
        try {
            while (true) {
                switch (script.nextChar()) {
                    case '-': {
                        if (script.nextChar() == '-' && script.nextChar() == '>') {
                            if (fFirst) {
                                this.m_nCtx = this.m_nCtx == 8 ? 7 : 0;
                                return new XmlToken(XmlToken.TOK_COMMENT_STOP, iLine, ofInLine, script.getOffset() - ofInLine);
                            }
                            script.putBackChar();
                            script.putBackChar();
                            script.putBackChar();
                            String sComment = ((Object)script.subScript(pos)).toString();
                            return new XmlToken(2, 2, 5, null, sComment, iLine, ofInLine, script.getOffset() - ofInLine);
                        }
                    }
                    case '\n': 
                    case '\r': {
                        script.putBackChar();
                        String sComment = ((Object)script.subScript(pos)).toString();
                        return new XmlToken(2, 2, 5, null, sComment, iLine, ofInLine, script.getOffset() - ofInLine);
                    }
                }
                fFirst = false;
            }
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected Token eatPi() throws CompilerException {
        Token tokName = this.eatName();
        if (tokName.getText().equals("xml")) {
            this.m_nCtx = 1;
        } else {
            this.eatFluff();
            Script script = this.m_script;
            ParsePosition pos = script.savePosition();
            int iLine = script.getLine();
            int ofInLine = script.getOffset();
            this.scan("?>");
            String sBody = ((Object)script.subScript(pos)).toString();
            if (sBody.length() > 0) {
                this.m_dq.addElement(new XmlToken(2, 4, 4, null, sBody, iLine, ofInLine, script.getOffset() - ofInLine));
            }
            iLine = script.getLine();
            ofInLine = script.getOffset();
            try {
                script.nextChar();
                script.nextChar();
            }
            catch (IOException e) {
                throw this.internalError();
            }
            this.m_dq.addElement(new XmlToken(XmlToken.TOK_PI_STOP, iLine, ofInLine, script.getOffset() - ofInLine));
            this.m_nCtx = 0;
        }
        return tokName;
    }

    protected Token eatElement() throws CompilerException {
        Script script = this.m_script;
        int iLine = script.getLine();
        int ofInLine = script.getOffset();
        try {
            char ch = script.nextChar();
            switch (ch) {
                case '?': {
                    this.match('>');
                    this.m_nCtx = 0;
                    return new XmlToken(XmlToken.TOK_PI_STOP, iLine, ofInLine, script.getOffset() - ofInLine);
                }
                case '=': {
                    return new XmlToken(XmlToken.TOK_EQUALS, iLine, ofInLine, script.getOffset() - ofInLine);
                }
                case '\"': 
                case '\'': {
                    ParsePosition pos = script.savePosition();
                    this.scan(ch);
                    String sLit = ((Object)script.subScript(pos)).toString();
                    this.match(ch);
                    return new XmlToken(2, 3, 2, null, sLit, iLine, ofInLine, script.getOffset() - ofInLine);
                }
                case '/': {
                    this.match('>');
                    this.m_nCtx = 0;
                    return new XmlToken(XmlToken.TOK_EMPTY_STOP, iLine, ofInLine, script.getOffset() - ofInLine);
                }
                case '>': {
                    this.m_nCtx = 0;
                    return new XmlToken(XmlToken.TOK_ELEMENT_STOP, iLine, ofInLine, script.getOffset() - ofInLine);
                }
            }
            script.putBackChar();
            return this.eatName();
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected Token eatName() throws CompilerException {
        Script script = this.m_script;
        int iLine = script.getLine();
        int ofInLine = script.getOffset();
        try {
            StringBuffer sb = new StringBuffer();
            char ch = script.nextChar();
            if (!XmlTokenizer.isNameStartChar(ch)) {
                int ofNext = script.getOffset();
                script.putBackChar();
                this.logError(3, ERR_XML_FORMAT, null, iLine, ofInLine, ofNext - ofInLine);
                throw new CompilerException();
            }
            sb.append(ch);
            while (XmlTokenizer.isNameChar(ch = script.nextChar())) {
                sb.append(ch);
            }
            script.putBackChar();
            String sName = sb.toString();
            return new XmlToken(1, 0, 1, null, sName, iLine, ofInLine, script.getOffset() - ofInLine);
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected static boolean isNameStartChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == ':' || Character.isUnicodeIdentifierStart(ch);
    }

    protected static boolean isNameChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == ':' || ch == '-' || ch == '.' || Character.isUnicodeIdentifierPart(ch);
    }

    protected boolean peek(char ch) throws CompilerException {
        Script script = this.m_script;
        try {
            char chActual = script.nextChar();
            if (ch == chActual) {
                return true;
            }
            script.putBackChar();
            return false;
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected void match(char ch) throws CompilerException {
        Script script = this.m_script;
        try {
            char chActual = script.nextChar();
            if (ch != chActual) {
                int ofNext = script.getOffset();
                script.putBackChar();
                this.logError(3, ERR_CHAR_EXPECTED, new String[]{XmlTokenizer.toCharEscape(ch), XmlTokenizer.toCharEscape(chActual)}, script.getLine(), script.getOffset(), ofNext - script.getOffset());
                script.nextChar();
                throw new CompilerException();
            }
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected void match(String s) throws CompilerException {
        char[] ach = s.toCharArray();
        int cch = ach.length;
        Script script = this.m_script;
        try {
            for (int of = 0; of < cch; ++of) {
                char chActual = script.nextChar();
                if (ach[of] == chActual) continue;
                int ofNext = script.getOffset();
                script.putBackChar();
                this.logError(3, ERR_CHAR_EXPECTED, new String[]{XmlTokenizer.toCharEscape(ach[of]), XmlTokenizer.toCharEscape(chActual)}, script.getLine(), script.getOffset(), ofNext - script.getOffset());
                script.nextChar();
                throw new CompilerException();
            }
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected void matchWhitespace() throws CompilerException {
        try {
            char ch = this.m_script.nextChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return;
                }
            }
            this.m_script.putBackChar();
            this.match(' ');
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, this.m_script.getLine(), this.m_script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, this.m_script.getLine(), this.m_script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected void scan(char ch) throws CompilerException {
        Script script = this.m_script;
        try {
            while (script.nextChar() != ch) {
            }
            script.putBackChar();
            return;
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected void scan(String s) throws CompilerException {
        char[] ach = s.toCharArray();
        int cch = ach.length;
        char chSentry = ach[0];
        Script script = this.m_script;
        try {
            while (true) {
                int c;
                if (script.nextChar() != chSentry) {
                    continue;
                }
                boolean fFound = true;
                int cTested = 1;
                for (int of = 1; of < cch; ++of) {
                    fFound = script.nextChar() == ach[of];
                    ++cTested;
                    if (!fFound) break;
                }
                int n = c = fFound ? cTested : cTested - 1;
                for (int i = 0; i < c; ++i) {
                    script.putBackChar();
                }
                if (fFound) break;
            }
        }
        catch (EOFException e) {
            this.logError(3, ERR_UNEXPECTED_EOF, null, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, ERR_UNEXPECTED_IO, new String[]{e.toString()}, script.getLine(), script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected CompilerException internalError() throws CompilerException {
        this.logError(4, ERR_INTERNAL, null, this.m_script.getLine(), this.m_script.getOffset(), 0);
        throw new CompilerException();
    }

    protected void logError(int nSeverity, String sCode, String[] asParams, int iLine, int ofInLine, int cchText) throws CompilerException {
        try {
            this.m_errlist.add(new CompilerErrorInfo(nSeverity, sCode, RESOURCES, asParams, iLine, ofInLine, cchText));
        }
        catch (ErrorList.OverflowException e) {
            throw new CompilerException();
        }
    }

    class Position
    implements ParsePosition {
        Tokenizer toker;
        Dequeue dq;
        ParsePosition scriptpos;

        Position() {
        }
    }
}

