/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterEnumerator;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.QueryMap;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public abstract class ConverterCollections
extends Base {
    public static Iterator getIterator(Iterator iter, Converter conv) {
        return new ConverterEnumerator(iter, conv);
    }

    public static ConverterCollection getCollection(Collection col, Converter convUp, Converter convDown) {
        return new ConverterCollection(col, convUp, convDown);
    }

    public static ConverterSet getSet(Set set, Converter convUp, Converter convDown) {
        return new ConverterSet(set, convUp, convDown);
    }

    public static ConverterSortedSet getSortedSet(SortedSet set, Converter convUp, Converter convDown) {
        return new ConverterSortedSet(set, convUp, convDown);
    }

    public static ConverterList getList(List list, Converter convUp, Converter convDown) {
        return new ConverterList(list, convUp, convDown);
    }

    public static ConverterListIterator getListIterator(ListIterator iter, Converter convUp, Converter convDown) {
        return new ConverterListIterator(iter, convUp, convDown);
    }

    public static ConverterMap getMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterSortedMap getSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterSortedMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterConcurrentMap getConcurrentMap(ConcurrentMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterConcurrentMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterInvocableMap getInvocableMap(InvocableMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterInvocableMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterObservableMap getObservableMap(ObservableMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterObservableMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterQueryMap getQueryMap(QueryMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterQueryMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterCacheMap getCacheMap(CacheMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterCacheMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterNamedCache getNamedCache(NamedCache cache, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterNamedCache(cache, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterEntrySet getEntrySet(Collection set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterEntrySet(set, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterEntry getEntry(Map.Entry entry, Converter convKeyUp, Converter convValUp, Converter convValDown) {
        return new ConverterEntry(entry, convKeyUp, convValUp, convValDown);
    }

    public static MapEvent getMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal) {
        return new ConverterMapEvent(map, event, convKey, convVal);
    }

    public static MapEvent getMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal, BackingMapManagerContext context) {
        return new ConverterMapEvent(map, event, convKey, convVal, context);
    }

    public static Object[] convertArray(Object[] ao, Converter conv) {
        int c = ao.length;
        for (int i = 0; i < c; ++i) {
            ao[i] = conv.convert(ao[i]);
        }
        return ao;
    }

    public static Object[] convertArray(Object[] aoSrc, Converter conv, Object[] aoDest) {
        int cSrc = aoSrc.length;
        int cDest = aoDest.length;
        if (cSrc > cDest) {
            cDest = cSrc;
            aoDest = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), cDest);
        }
        if (cDest > cSrc) {
            aoDest[cSrc] = null;
        }
        for (int i = 0; i < cSrc; ++i) {
            aoDest[i] = conv.convert(aoSrc[i]);
        }
        return aoDest;
    }

    public static class ConverterMapListener
    extends Base
    implements MapListener {
        protected ObservableMap m_map;
        protected MapListener m_listener;
        protected Converter m_convKey;
        protected Converter m_convVal;

        public ConverterMapListener(ObservableMap map, MapListener listener, Converter convKey, Converter convVal) {
            ConverterMapListener.azzert(listener != null && convKey != null && convVal != null, "Null listener or converter");
            this.m_map = map;
            this.m_listener = listener;
            this.m_convKey = convKey;
            this.m_convVal = convVal;
        }

        @Override
        public void entryInserted(MapEvent evt) {
            this.getMapListener().entryInserted(ConverterCollections.getMapEvent(this.getObservableMap(), evt, this.getConverterKeyUp(), this.getConverterValueUp()));
        }

        @Override
        public void entryUpdated(MapEvent evt) {
            this.getMapListener().entryUpdated(ConverterCollections.getMapEvent(this.getObservableMap(), evt, this.getConverterKeyUp(), this.getConverterValueUp()));
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            this.getMapListener().entryDeleted(ConverterCollections.getMapEvent(this.getObservableMap(), evt, this.getConverterKeyUp(), this.getConverterValueUp()));
        }

        public int hashCode() {
            return this.getMapListener().hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterMapListener) {
                ConverterMapListener that = (ConverterMapListener)o;
                return this.getMapListener().equals(that.getMapListener()) && this.getConverterKeyUp().equals(that.getConverterKeyUp()) && this.getConverterValueUp().equals(that.getConverterValueUp());
            }
            return false;
        }

        public ObservableMap getObservableMap() {
            return this.m_map;
        }

        public MapListener getMapListener() {
            return this.m_listener;
        }

        public Converter getConverterKeyUp() {
            return this.m_convKey;
        }

        public Converter getConverterValueUp() {
            return this.m_convVal;
        }
    }

    public static class ConverterCacheEvent
    extends ConverterMapEvent {
        public ConverterCacheEvent(ObservableMap map, CacheEvent event, Converter convKey, Converter convVal) {
            this(map, event, convKey, convVal, null);
        }

        public ConverterCacheEvent(ObservableMap map, CacheEvent event, Converter convKey, Converter convVal, BackingMapManagerContext context) {
            super(map, event, convKey, convVal, context);
        }

        public CacheEvent getCacheEvent() {
            return (CacheEvent)this.getMapEvent();
        }
    }

    public static class ConverterMapEvent
    extends CacheEvent {
        public static final Object NO_VALUE = new Object();
        protected MapEvent m_event;
        protected Converter m_convKey;
        protected Converter m_convVal;
        protected BackingMapManagerContext m_context;

        public ConverterMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal) {
            this(map, event, convKey, convVal, null);
        }

        public ConverterMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal, BackingMapManagerContext context) {
            super(map, event.getId(), NO_VALUE, NO_VALUE, NO_VALUE, event instanceof CacheEvent && ((CacheEvent)event).isSynthetic());
            this.m_event = event;
            this.m_convKey = convKey;
            this.m_convVal = convVal;
            this.m_context = context;
        }

        @Override
        public Object getKey() {
            Object oKey = this.m_oKey;
            if (oKey == NO_VALUE) {
                oKey = this.getConverterKeyUp().convert(this.getMapEvent().getKey());
                this.setKey(oKey);
            }
            return oKey;
        }

        @Override
        public Object getOldValue() {
            Object oValueOld = this.m_oValueOld;
            if (oValueOld == NO_VALUE) {
                oValueOld = this.getConverterValueUp().convert(this.getMapEvent().getOldValue());
                this.setOldValue(oValueOld);
            }
            return oValueOld;
        }

        @Override
        public Object getNewValue() {
            Object oValueNew = this.m_oValueNew;
            if (oValueNew == NO_VALUE) {
                oValueNew = this.getConverterValueUp().convert(this.getMapEvent().getNewValue());
                this.setNewValue(oValueNew);
            }
            return oValueNew;
        }

        @Override
        public Map.Entry getOldEntry() {
            return this.getContext() == null ? new ConverterMapEventEntry(false) : new ConverterMapEventBinaryEntry(false);
        }

        @Override
        public Map.Entry getNewEntry() {
            return this.getContext() == null ? new ConverterMapEventEntry(true) : new ConverterMapEventBinaryEntry(true);
        }

        public MapEvent getMapEvent() {
            return this.m_event;
        }

        public BackingMapManagerContext getContext() {
            return this.m_context;
        }

        public Converter getConverterKeyUp() {
            return this.m_convKey;
        }

        public Converter getConverterValueUp() {
            return this.m_convVal;
        }

        public void setKey(Object oKey) {
            this.m_oKey = oKey;
        }

        public void setOldValue(Object oValue) {
            this.m_oValueOld = oValue;
        }

        public void setNewValue(Object oValue) {
            this.m_oValueNew = oValue;
        }

        public boolean isKeyConverted() {
            return this.m_oKey != NO_VALUE;
        }

        public boolean isOldValueConverted() {
            return this.m_oValueOld != NO_VALUE;
        }

        public boolean isNewValueConverted() {
            return this.m_oValueNew != NO_VALUE;
        }

        public void clearConverted() {
            this.setKey(NO_VALUE);
            this.setOldValue(NO_VALUE);
            this.setNewValue(NO_VALUE);
        }

        protected class ConverterMapEventBinaryEntry
        extends ConverterMapEventEntry
        implements BinaryEntry {
            public ConverterMapEventBinaryEntry(boolean fNewValue) {
                super(fNewValue);
            }

            @Override
            public boolean isPresent() {
                return this.getBinaryValue() != null;
            }

            @Override
            public void remove(boolean fSynthetic) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setValue(Object oValue, boolean fSynthetic) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void update(ValueUpdater updater, Object oValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object extract(ValueExtractor extractor) {
                return InvocableMapHelper.extractFromEntry(extractor, this);
            }

            @Override
            public BackingMapManagerContext getContext() {
                return ConverterMapEvent.this.getContext();
            }

            @Override
            public Serializer getSerializer() {
                return this.getContext().getCacheService().getSerializer();
            }

            @Override
            public void updateBinaryValue(Binary binValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getOriginalValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Binary getOriginalBinaryValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ObservableMap getBackingMap() {
                return ConverterMapEvent.this.m_event.getMap();
            }

            @Override
            public BackingMapContext getBackingMapContext() {
                return null;
            }

            @Override
            public void expire(long cMillis) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        }

        protected class ConverterMapEventEntry
        implements Map.Entry {
            protected boolean m_fNewValue;

            public ConverterMapEventEntry(boolean fNewValue) {
                this.m_fNewValue = fNewValue;
            }

            public Binary getBinaryKey() {
                return (Binary)ConverterMapEvent.this.m_event.getKey();
            }

            public Binary getBinaryValue() {
                return this.m_fNewValue ? (Binary)ConverterMapEvent.this.m_event.getNewValue() : (Binary)ConverterMapEvent.this.m_event.getOldValue();
            }

            public Object getKey() {
                return ConverterMapEvent.this.getKey();
            }

            public Object getValue() {
                return this.m_fNewValue ? ConverterMapEvent.this.getNewValue() : ConverterMapEvent.this.getOldValue();
            }

            public Object setValue(Object oValue) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class ConverterEntry
    extends AbstractConverterEntry {
        protected Converter m_convKeyUp;
        protected Converter m_convValUp;
        protected Converter m_convValDown;

        public ConverterEntry(Map.Entry entry, Converter convKeyUp, Converter convValUp, Converter convValDown) {
            super(entry);
            this.m_convKeyUp = convKeyUp;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        protected Converter getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        @Override
        protected Converter getConverterValueUp() {
            return this.m_convValUp;
        }

        @Override
        protected Converter getConverterValueDown() {
            return this.m_convValDown;
        }
    }

    protected static abstract class AbstractConverterEntry
    extends Base
    implements Map.Entry,
    Serializable {
        protected Map.Entry m_entry;
        protected transient Object m_oKeyUp;
        protected transient Object m_oValueUp;

        protected AbstractConverterEntry(Map.Entry entry) {
            this.m_entry = entry;
        }

        protected abstract Converter getConverterKeyUp();

        protected abstract Converter getConverterValueUp();

        protected abstract Converter getConverterValueDown();

        public Object getKey() {
            Object oKeyUp = this.m_oKeyUp;
            if (oKeyUp == null) {
                this.m_oKeyUp = oKeyUp = this.getConverterKeyUp().convert(this.getEntry().getKey());
            }
            return oKeyUp;
        }

        public Object getValue() {
            Object oValueUp = this.m_oValueUp;
            if (oValueUp == null) {
                this.m_oValueUp = oValueUp = this.getConverterValueUp().convert(this.getEntry().getValue());
            }
            return oValueUp;
        }

        public Object setValue(Object value) {
            this.m_oValueUp = null;
            return this.getConverterValueUp().convert(this.getEntry().setValue(this.getConverterValueDown().convert(value)));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)o;
                return Base.equals(this.getKey(), that.getKey()) && Base.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object oKey = this.getKey();
            Object oValue = this.getValue();
            return (oKey == null ? 0 : oKey.hashCode()) ^ (oValue == null ? 0 : oValue.hashCode());
        }

        public String toString() {
            return "ConverterEntry{Key=\"" + this.getKey() + "\", Value=\"" + this.getValue() + "\"}";
        }

        public Map.Entry getEntry() {
            return this.m_entry;
        }
    }

    public static class ConverterEntrySet
    extends Base
    implements Set,
    Serializable {
        protected Collection m_set;
        protected Converter m_convKeyUp;
        protected Converter m_convKeyDown;
        protected Converter m_convValUp;
        protected Converter m_convValDown;

        public ConverterEntrySet(Collection set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            ConverterEntrySet.azzert(set != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_set = set;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        public int size() {
            return this.getEntrySet().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getEntrySet().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getEntrySet().contains(new com.tangosol.util.ConverterCollections$ConverterEntry((Map.Entry)o, this.getConverterKeyDown(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public Iterator iterator() {
            return this.wrapIterator(this.getEntrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            Object[] ao = this.getEntrySet().toArray();
            int c = ao.length;
            Object[] aEntry = new Map.Entry[c];
            for (int i = 0; i < c; ++i) {
                aEntry[i] = this.wrapEntry((Map.Entry)ao[i]);
            }
            return aEntry;
        }

        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoDest;
            int cDest;
            Object[] aoSrc = this.getEntrySet().toArray();
            int cSrc = aoSrc.length;
            if (cSrc > (cDest = (aoDest = ao).length)) {
                cDest = cSrc;
                aoDest = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), cDest);
            }
            if (cDest > cSrc) {
                aoDest[cSrc] = null;
            }
            for (int i = 0; i < cSrc; ++i) {
                aoDest[i] = this.wrapEntry((Map.Entry)aoSrc[i]);
            }
            return aoDest;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            return this.getEntrySet().remove(new SimpleMapEntry(this.getConverterKeyDown().convert(entry.getKey()), this.getConverterValueDown().convert(entry.getValue())));
        }

        @Override
        public boolean containsAll(Collection col) {
            return this.getEntrySet().containsAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection col) {
            return this.getEntrySet().removeAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public boolean retainAll(Collection col) {
            return this.getEntrySet().retainAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public void clear() {
            this.getEntrySet().clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterEntrySet) {
                ConverterEntrySet that = (ConverterEntrySet)o;
                return ((Object)this.getEntrySet()).equals(that.getEntrySet()) && this.getConverterKeyUp().equals(that.getConverterKeyUp()) && this.getConverterKeyDown().equals(that.getConverterKeyDown()) && this.getConverterValueUp().equals(that.getConverterValueUp()) && this.getConverterValueDown().equals(that.getConverterValueDown());
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return set.size() == this.size() && this.containsAll((Collection)set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            Iterator iter = this.getEntrySet().iterator();
            while (iter.hasNext()) {
                nHash += Base.hashCode(iter.next());
            }
            return nHash;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterEntrySet{");
            boolean fFirst = true;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iter.next());
            }
            sb.append('}');
            return sb.toString();
        }

        protected Set instantiateEntrySet(Collection col, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getEntrySet(col, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Map.Entry wrapEntry(Map.Entry entry) {
            return new ConverterEntry(entry);
        }

        protected Iterator wrapIterator(Iterator iter) {
            return new ConverterIterator(iter);
        }

        public Collection getEntrySet() {
            return this.m_set;
        }

        public Converter getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        public Converter getConverterKeyDown() {
            return this.m_convKeyDown;
        }

        public Converter getConverterValueUp() {
            return this.m_convValUp;
        }

        public Converter getConverterValueDown() {
            return this.m_convValDown;
        }

        protected class ConverterIterator
        extends Base
        implements Iterator {
            protected Iterator m_iter;

            public ConverterIterator(Iterator iter) {
                this.m_iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.getIterator().hasNext();
            }

            public Object next() {
                return ConverterEntrySet.this.wrapEntry((Map.Entry)this.getIterator().next());
            }

            @Override
            public void remove() {
                this.getIterator().remove();
            }

            public Iterator getIterator() {
                return this.m_iter;
            }
        }

        protected class ConverterEntry
        extends AbstractConverterEntry {
            public ConverterEntry(Map.Entry entry) {
                super(entry);
            }

            @Override
            protected Converter getConverterKeyUp() {
                return ConverterEntrySet.this.getConverterKeyUp();
            }

            @Override
            protected Converter getConverterValueUp() {
                return ConverterEntrySet.this.getConverterValueUp();
            }

            @Override
            protected Converter getConverterValueDown() {
                return ConverterEntrySet.this.getConverterValueDown();
            }
        }
    }

    public static class ConverterNamedCache
    extends ConverterCacheMap
    implements NamedCache,
    Serializable {
        protected ConverterConcurrentMap m_mapConcurrent;
        protected ConverterInvocableMap m_mapInvocable;
        protected ConverterQueryMap m_mapQuery;

        public ConverterNamedCache(NamedCache cache, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(cache, convKeyUp, convKeyDown, convValUp, convValDown);
            this.m_mapConcurrent = ConverterCollections.getConcurrentMap(cache, convKeyUp, convKeyDown, convValUp, convValDown);
            this.m_mapInvocable = ConverterCollections.getInvocableMap(cache, convKeyUp, convKeyDown, convValUp, convValDown);
            this.m_mapQuery = ConverterCollections.getQueryMap(cache, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public String getCacheName() {
            return this.getNamedCache().getCacheName();
        }

        @Override
        public CacheService getCacheService() {
            return this.getNamedCache().getCacheService();
        }

        @Override
        public boolean isActive() {
            return this.getNamedCache().isActive();
        }

        @Override
        public void release() {
            this.getNamedCache().release();
        }

        @Override
        public void destroy() {
            this.getNamedCache().destroy();
        }

        @Override
        public boolean lock(Object oKey, long cWait) {
            return this.m_mapConcurrent.lock(oKey, cWait);
        }

        @Override
        public boolean lock(Object oKey) {
            return this.m_mapConcurrent.lock(oKey);
        }

        @Override
        public boolean unlock(Object oKey) {
            return this.m_mapConcurrent.unlock(oKey);
        }

        @Override
        public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
            return this.m_mapInvocable.invoke(oKey, agent);
        }

        @Override
        public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
            return this.m_mapInvocable.invokeAll(collKeys, agent);
        }

        @Override
        public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
            return this.m_mapInvocable.invokeAll(filter, agent);
        }

        @Override
        public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
            return this.m_mapInvocable.aggregate(collKeys, agent);
        }

        @Override
        public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
            return this.m_mapInvocable.aggregate(filter, agent);
        }

        @Override
        public Set keySet(Filter filter) {
            return this.m_mapQuery.keySet(filter);
        }

        @Override
        public Set entrySet(Filter filter) {
            return this.m_mapQuery.entrySet(filter);
        }

        @Override
        public Set entrySet(Filter filter, Comparator comparator) {
            return this.m_mapQuery.entrySet(filter, comparator);
        }

        @Override
        public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
            this.m_mapQuery.addIndex(extractor, fOrdered, comparator);
        }

        @Override
        public void removeIndex(ValueExtractor extractor) {
            this.m_mapQuery.removeIndex(extractor);
        }

        public NamedCache getNamedCache() {
            return (NamedCache)this.getMap();
        }
    }

    public static class ConverterCacheMap
    extends ConverterObservableMap
    implements CacheMap,
    Serializable {
        public ConverterCacheMap(CacheMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public Map getAll(Collection colKeys) {
            Converter convKeyDown = this.getConverterKeyDown();
            Converter convKeyUp = this.getConverterKeyUp();
            Converter convValDown = this.getConverterValueDown();
            Converter convValUp = this.getConverterValueUp();
            Collection colKeysConv = colKeys instanceof Set ? this.instantiateSet((Set)colKeys, convKeyDown, convKeyUp) : this.instantiateCollection(colKeys, convKeyDown, convKeyUp);
            return this.instantiateMap(this.getCacheMap().getAll(colKeysConv), convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public Object put(Object oKey, Object oValue, long cMillis) {
            return this.getConverterValueUp().convert(this.getCacheMap().put(this.getConverterKeyDown().convert(oKey), this.getConverterValueDown().convert(oValue), cMillis));
        }

        public CacheMap getCacheMap() {
            return (CacheMap)this.getMap();
        }
    }

    public static class ConverterQueryMap
    extends ConverterMap
    implements QueryMap,
    Serializable {
        public ConverterQueryMap(QueryMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public Set keySet(Filter filter) {
            return this.instantiateSet(this.getQueryMap().keySet(filter), this.getConverterKeyUp(), this.getConverterKeyDown());
        }

        @Override
        public Set entrySet(Filter filter) {
            return this.instantiateEntrySet(this.getQueryMap().entrySet(filter), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public Set entrySet(Filter filter, Comparator comparator) {
            return this.instantiateEntrySet(this.getQueryMap().entrySet(filter, comparator), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
            this.getQueryMap().addIndex(extractor, fOrdered, comparator);
        }

        @Override
        public void removeIndex(ValueExtractor extractor) {
            this.getQueryMap().removeIndex(extractor);
        }

        public QueryMap getQueryMap() {
            return (QueryMap)this.getMap();
        }
    }

    public static class ConverterObservableMap
    extends ConverterMap
    implements ObservableMap,
    Serializable {
        public ConverterObservableMap(ObservableMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public void addMapListener(MapListener listener) {
            this.getObservableMap().addMapListener(this.getConverterListener(listener));
        }

        @Override
        public void removeMapListener(MapListener listener) {
            this.getObservableMap().removeMapListener(this.getConverterListener(listener));
        }

        @Override
        public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
            this.getObservableMap().addMapListener(this.getConverterListener(listener), this.getConverterKeyDown().convert(oKey), fLite);
        }

        @Override
        public void removeMapListener(MapListener listener, Object oKey) {
            this.getObservableMap().removeMapListener(this.getConverterListener(listener), this.getConverterKeyDown().convert(oKey));
        }

        @Override
        public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
            this.getObservableMap().addMapListener(this.getConverterListener(listener), filter, fLite);
        }

        @Override
        public void removeMapListener(MapListener listener, Filter filter) {
            this.getObservableMap().removeMapListener(this.getConverterListener(listener), filter);
        }

        protected MapListener getConverterListener(MapListener listener) {
            if (listener instanceof MapTriggerListener) {
                return listener;
            }
            Base listenerConv = new ConverterMapListener(this, listener, this.getConverterKeyUp(), this.getConverterValueUp());
            if (listener instanceof MapListenerSupport.SynchronousListener) {
                listenerConv = new MapListenerSupport.WrapperSynchronousListener((MapListener)((Object)listenerConv));
            }
            return listenerConv;
        }

        public ObservableMap getObservableMap() {
            return (ObservableMap)this.getMap();
        }
    }

    public static class ConverterInvocableMap
    extends ConverterMap
    implements InvocableMap,
    Serializable {
        public ConverterInvocableMap(InvocableMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
            Converter convKeyDown = this.getConverterKeyDown();
            Converter convKeyUp = this.getConverterKeyUp();
            Collection colKeysConv = collKeys instanceof Set ? this.instantiateSet((Set)collKeys, convKeyDown, convKeyUp) : this.instantiateCollection(collKeys, convKeyDown, convKeyUp);
            return this.getConverterValueUp().convert(this.getInvocableMap().aggregate(colKeysConv, agent));
        }

        @Override
        public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
            return this.getConverterValueUp().convert(this.getInvocableMap().aggregate(filter, agent));
        }

        @Override
        public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
            return this.getConverterValueUp().convert(this.getInvocableMap().invoke(this.getConverterKeyDown().convert(oKey), agent));
        }

        @Override
        public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
            Converter convKeyDown = this.getConverterKeyDown();
            Converter convKeyUp = this.getConverterKeyUp();
            Collection colKeysConv = collKeys instanceof Set ? this.instantiateSet((Set)collKeys, convKeyDown, convKeyUp) : this.instantiateCollection(collKeys, convKeyDown, convKeyUp);
            return this.instantiateMap(this.getInvocableMap().invokeAll(colKeysConv, agent), convKeyUp, convKeyDown, this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
            return this.instantiateMap(this.getInvocableMap().invokeAll(filter, agent), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        public InvocableMap getInvocableMap() {
            return (InvocableMap)this.getMap();
        }
    }

    public static class ConverterConcurrentMap
    extends ConverterMap
    implements ConcurrentMap,
    Serializable {
        public ConverterConcurrentMap(ConcurrentMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public boolean lock(Object oKey) {
            return this.getConcurrentMap().lock(this.getConverterKeyDown().convert(oKey));
        }

        @Override
        public boolean lock(Object oKey, long cWait) {
            return this.getConcurrentMap().lock(this.getConverterKeyDown().convert(oKey), cWait);
        }

        @Override
        public boolean unlock(Object oKey) {
            return this.getConcurrentMap().unlock(this.getConverterKeyDown().convert(oKey));
        }

        public ConcurrentMap getConcurrentMap() {
            return (ConcurrentMap)this.getMap();
        }
    }

    public static class ConverterSortedMap
    extends ConverterMap
    implements SortedMap,
    Serializable {
        public ConverterSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.instantiateSortedMap(this.getSortedMap().subMap(fromKey, toKey), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterKeyDown());
        }

        public SortedMap headMap(Object toKey) {
            return this.instantiateSortedMap(this.getSortedMap().headMap(toKey), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        public SortedMap tailMap(Object fromKey) {
            return this.instantiateSortedMap(this.getSortedMap().tailMap(fromKey), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        public Object firstKey() {
            return this.getConverterKeyUp().convert(this.getSortedMap().firstKey());
        }

        public Object lastKey() {
            return this.getConverterKeyUp().convert(this.getSortedMap().lastKey());
        }

        protected SortedMap instantiateSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getSortedMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public SortedMap getSortedMap() {
            return (SortedMap)this.getMap();
        }
    }

    public static class ConverterMap
    extends Base
    implements Map,
    Serializable {
        protected Map m_map;
        protected Converter m_convKeyUp;
        protected Converter m_convKeyDown;
        protected Converter m_convValUp;
        protected Converter m_convValDown;
        protected transient Set m_set;

        public ConverterMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            ConverterMap.azzert(map != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_map = map;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        public int size() {
            return this.getMap().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getMap().containsKey(this.getConverterKeyDown().convert(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.getMap().containsValue(this.getConverterValueDown().convert(value));
        }

        public Object get(Object key) {
            return this.getConverterValueUp().convert(this.getMap().get(this.getConverterKeyDown().convert(key)));
        }

        public Object put(Object key, Object value) {
            return this.getConverterValueUp().convert(this.getMap().put(this.getConverterKeyDown().convert(key), this.getConverterValueDown().convert(value)));
        }

        public Object remove(Object key) {
            return this.getConverterValueUp().convert(this.getMap().remove(this.getConverterKeyDown().convert(key)));
        }

        public void putAll(Map map) {
            this.getMap().putAll(this.instantiateMap(map, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        public Set keySet() {
            return this.instantiateSet(this.getMap().keySet(), this.getConverterKeyUp(), this.getConverterKeyDown());
        }

        public Collection values() {
            return this.instantiateCollection(this.getMap().values(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        public Set entrySet() {
            if (this.m_set == null) {
                Set set = this.getMap().entrySet();
                this.m_set = this.instantiateEntrySet(set, this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
            }
            return this.m_set;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterMap{");
            boolean fFirst = true;
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iter.next());
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map) {
                return ((Object)this.entrySet()).equals(((Map)o).entrySet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                nHash += Base.hashCode(iter.next());
            }
            return nHash;
        }

        protected Collection instantiateCollection(Collection col, Converter convUp, Converter convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected Set instantiateSet(Set set, Converter convUp, Converter convDown) {
            return ConverterCollections.getSet(set, convUp, convDown);
        }

        protected Map instantiateMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Set instantiateEntrySet(Set set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getEntrySet(set, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public Map getMap() {
            return this.m_map;
        }

        public Converter getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        public Converter getConverterKeyDown() {
            return this.m_convKeyDown;
        }

        public Converter getConverterValueUp() {
            return this.m_convValUp;
        }

        public Converter getConverterValueDown() {
            return this.m_convValDown;
        }
    }

    public static class ConverterListIterator
    extends Base
    implements ListIterator {
        protected ListIterator m_iter;
        protected Converter m_convUp;
        protected Converter m_convDown;

        public ConverterListIterator(ListIterator iter, Converter convUp, Converter convDown) {
            ConverterListIterator.azzert(iter != null && convUp != null && convDown != null);
            this.m_iter = iter;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        @Override
        public boolean hasNext() {
            return this.getListIterator().hasNext();
        }

        @Override
        public Object next() {
            return this.getConverterUp().convert(this.getListIterator().next());
        }

        @Override
        public boolean hasPrevious() {
            return this.getListIterator().hasPrevious();
        }

        public Object previous() {
            return this.getConverterUp().convert(this.getListIterator().previous());
        }

        @Override
        public int nextIndex() {
            return this.getListIterator().nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.getListIterator().previousIndex();
        }

        @Override
        public void remove() {
            this.getListIterator().remove();
        }

        public void set(Object o) {
            this.getListIterator().set(this.getConverterDown().convert(o));
        }

        public void add(Object o) {
            this.getListIterator().add(this.getConverterDown().convert(o));
        }

        public ListIterator getListIterator() {
            return this.m_iter;
        }

        public Converter getConverterUp() {
            return this.m_convUp;
        }

        public Converter getConverterDown() {
            return this.m_convDown;
        }
    }

    public static class ConverterList
    extends ConverterCollection
    implements List,
    Serializable {
        public ConverterList(List list, Converter convUp, Converter convDown) {
            super(list, convUp, convDown);
        }

        public Object get(int index) {
            return this.getConverterUp().convert(this.getList().get(index));
        }

        public Object set(int index, Object element) {
            return this.getConverterUp().convert(this.getList().set(index, this.getConverterDown().convert(element)));
        }

        public void add(int index, Object element) {
            this.getList().add(index, this.getConverterDown().convert(element));
        }

        public boolean addAll(int index, Collection col) {
            return this.getList().addAll(index, this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public Object remove(int index) {
            return this.getConverterUp().convert(this.getList().remove(index));
        }

        @Override
        public int indexOf(Object o) {
            return this.getList().indexOf(this.getConverterDown().convert(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.getList().lastIndexOf(this.getConverterDown().convert(o));
        }

        public ListIterator listIterator() {
            return this.instantiateListIterator(this.getList().listIterator(), this.getConverterUp(), this.getConverterDown());
        }

        public ListIterator listIterator(int index) {
            return this.instantiateListIterator(this.getList().listIterator(index), this.getConverterUp(), this.getConverterDown());
        }

        public List subList(int fromIndex, int toIndex) {
            return this.instantiateList(this.getList().subList(fromIndex, toIndex), this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return ((Object)this.getCollection()).equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            if (o instanceof List) {
                ListIterator iterThis = this.listIterator();
                ListIterator iterThat = ((List)o).listIterator();
                while (iterThis.hasNext() && iterThat.hasNext()) {
                    if (Base.equals(iterThis.next(), iterThat.next())) continue;
                    return false;
                }
                return !iterThis.hasNext() && !iterThat.hasNext();
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 1;
            ListIterator iter = this.listIterator();
            while (iter.hasNext()) {
                nHash = 31 * nHash + Base.hashCode(iter.next());
            }
            return nHash;
        }

        protected List instantiateList(List list, Converter convUp, Converter convDown) {
            return ConverterCollections.getList(list, convUp, convDown);
        }

        protected ListIterator instantiateListIterator(ListIterator iter, Converter convUp, Converter convDown) {
            return ConverterCollections.getListIterator(iter, convUp, convDown);
        }

        public List getList() {
            return (List)this.getCollection();
        }
    }

    public static class ConverterSortedSet
    extends ConverterSet
    implements SortedSet,
    Serializable {
        public ConverterSortedSet(SortedSet set, Converter convUp, Converter convDown) {
            super(set, convUp, convDown);
        }

        public Comparator comparator() {
            return this.getSortedSet().comparator();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            SortedSet<Object> subset = this.getSortedSet().subSet(this.getConverterDown().convert(fromElement), this.getConverterDown().convert(toElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        public SortedSet headSet(Object toElement) {
            SortedSet<Object> subset = this.getSortedSet().headSet(this.getConverterDown().convert(toElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        public SortedSet tailSet(Object fromElement) {
            SortedSet<Object> subset = this.getSortedSet().tailSet(this.getConverterDown().convert(fromElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        public Object first() {
            return this.getConverterUp().convert(this.getSortedSet().first());
        }

        public Object last() {
            return this.getConverterUp().convert(this.getSortedSet().last());
        }

        protected SortedSet instantiateSortedSet(SortedSet set, Converter convUp, Converter convDown) {
            return ConverterCollections.getSortedSet(set, convUp, convDown);
        }

        public SortedSet getSortedSet() {
            return (SortedSet)this.getCollection();
        }
    }

    public static class ConverterSet
    extends ConverterCollection
    implements Set,
    Serializable {
        public ConverterSet(Set set, Converter convUp, Converter convDown) {
            super(set, convUp, convDown);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return ((Object)this.getCollection()).equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return set.size() == this.size() && this.containsAll((Collection)set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            Iterator iter = this.getCollection().iterator();
            while (iter.hasNext()) {
                nHash += Base.hashCode(iter.next());
            }
            return nHash;
        }
    }

    public static class ConverterCollection
    extends Base
    implements Collection,
    Serializable {
        protected Collection m_col;
        protected Converter m_convUp;
        protected Converter m_convDown;

        public ConverterCollection(Collection col, Converter convUp, Converter convDown) {
            ConverterCollection.azzert(col != null && convUp != null && convDown != null);
            this.m_col = col;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        @Override
        public int size() {
            return this.getCollection().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getCollection().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getCollection().contains(this.getConverterDown().convert(o));
        }

        @Override
        public Iterator iterator() {
            return this.instantiateIterator(this.getCollection().iterator(), this.getConverterUp());
        }

        @Override
        public Object[] toArray() {
            return ConverterCollections.convertArray(this.getCollection().toArray(), this.getConverterUp());
        }

        public Object[] toArray(Object[] aoDest) {
            return ConverterCollections.convertArray(this.getCollection().toArray(), this.getConverterUp(), aoDest);
        }

        public boolean add(Object o) {
            return this.getCollection().add(this.getConverterDown().convert(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.getCollection().remove(this.getConverterDown().convert(o));
        }

        public boolean containsAll(Collection col) {
            return this.getCollection().containsAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public boolean addAll(Collection col) {
            return this.getCollection().addAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public boolean removeAll(Collection col) {
            return this.getCollection().removeAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public boolean retainAll(Collection col) {
            return this.getCollection().retainAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        @Override
        public void clear() {
            this.getCollection().clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return ((Object)this.getCollection()).equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterCollection{");
            boolean fFirst = true;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iter.next());
            }
            sb.append('}');
            return sb.toString();
        }

        public void invalidate() {
            this.m_col = null;
            this.m_convUp = null;
            this.m_convDown = null;
        }

        protected Collection instantiateCollection(Collection col, Converter convUp, Converter convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected Iterator instantiateIterator(Iterator iter, Converter conv) {
            return ConverterCollections.getIterator(iter, conv);
        }

        public Collection getCollection() {
            return this.m_col;
        }

        public Converter getConverterUp() {
            return this.m_convUp;
        }

        public Converter getConverterDown() {
            return this.m_convDown;
        }
    }
}

