/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractAggregator
extends ExternalizableHelper
implements InvocableMap.ParallelAwareAggregator,
ExternalizableLite,
PortableObject {
    protected boolean m_fParallel;
    private ValueExtractor m_extractor;

    public AbstractAggregator() {
    }

    public AbstractAggregator(ValueExtractor extractor) {
        AbstractAggregator.azzert(extractor != null);
        this.m_extractor = extractor;
    }

    public AbstractAggregator(String sMethod) {
        this.m_extractor = sMethod.indexOf(46) < 0 ? new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod);
    }

    @Override
    public Object aggregate(Set setEntries) {
        boolean fFinal = !this.m_fParallel;
        this.init(fFinal);
        Iterator iter = setEntries.iterator();
        while (iter.hasNext()) {
            this.processEntry((InvocableMap.Entry)iter.next());
        }
        return this.finalizeResult(fFinal);
    }

    protected void processEntry(InvocableMap.Entry entry) {
        this.process(entry.extract(this.getValueExtractor()), false);
    }

    @Override
    public InvocableMap.EntryAggregator getParallelAggregator() {
        this.m_fParallel = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object aggregateResults(Collection collResults) {
        this.init(true);
        Iterator iter = collResults.iterator();
        while (iter.hasNext()) {
            this.process(iter.next(), true);
        }
        try {
            Object object = this.finalizeResult(true);
            return object;
        }
        finally {
            this.m_fParallel = false;
        }
    }

    public ValueExtractor getValueExtractor() {
        return this.m_extractor;
    }

    protected abstract void init(boolean var1);

    protected abstract void process(Object var1, boolean var2);

    protected abstract Object finalizeResult(boolean var1);

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '(' + ((Object)this.getValueExtractor()).toString() + ')';
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ ((Object)this.getValueExtractor()).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractAggregator) {
            AbstractAggregator that = (AbstractAggregator)o;
            return this == that || this.getClass() == that.getClass() && this.m_fParallel == that.m_fParallel && AbstractAggregator.equals(this.m_extractor, that.m_extractor);
        }
        return false;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fParallel = in.readBoolean();
        this.m_extractor = (ValueExtractor)AbstractAggregator.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fParallel);
        AbstractAggregator.writeObject(out, this.m_extractor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fParallel = in.readBoolean(0);
        this.m_extractor = (ValueExtractor)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fParallel);
        out.writeObject(1, this.m_extractor);
    }
}

