/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CompositeAggregator
extends ExternalizableHelper
implements InvocableMap.EntryAggregator,
ExternalizableLite,
PortableObject {
    private static final InvocableMap.EntryAggregator[] EMPTY_AGGREGATOR_ARRAY = new InvocableMap.EntryAggregator[0];
    protected InvocableMap.EntryAggregator[] m_aAggregator;

    public CompositeAggregator() {
    }

    protected CompositeAggregator(InvocableMap.EntryAggregator[] aAggregator) {
        CompositeAggregator.azzert(aAggregator != null);
        this.m_aAggregator = aAggregator;
    }

    @Override
    public Object aggregate(Set setEntries) {
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int cAggregators = aAggregator.length;
        Object[] aoResult = new Object[cAggregators];
        for (int i = 0; i < cAggregators; ++i) {
            aoResult[i] = aAggregator[i].aggregate(setEntries);
        }
        return new ImmutableArrayList(aoResult);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cAggregators = CompositeAggregator.readInt(in);
        InvocableMap.EntryAggregator[] aAggregator = new InvocableMap.EntryAggregator[cAggregators];
        for (int i = 0; i < cAggregators; ++i) {
            aAggregator[i] = (InvocableMap.EntryAggregator)CompositeAggregator.readObject(in);
        }
        this.m_aAggregator = aAggregator;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int cAggregators = aAggregator.length;
        CompositeAggregator.writeInt(out, cAggregators);
        for (int i = 0; i < cAggregators; ++i) {
            CompositeAggregator.writeObject(out, aAggregator[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aAggregator = (InvocableMap.EntryAggregator[])in.readObjectArray(0, EMPTY_AGGREGATOR_ARRAY);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aAggregator);
    }

    public InvocableMap.EntryAggregator[] getAggregators() {
        return this.m_aAggregator;
    }

    public boolean equals(Object o) {
        if (o instanceof CompositeAggregator) {
            CompositeAggregator that = (CompositeAggregator)o;
            return CompositeAggregator.equalsDeep(this.m_aAggregator, that.m_aAggregator);
        }
        return false;
    }

    public int hashCode() {
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int iHash = 0;
        int c = aAggregator.length;
        for (int i = 0; i < c; ++i) {
            iHash += aAggregator[i].hashCode();
        }
        return iHash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassHelper.getSimpleName(this.getClass())).append('(');
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int c = aAggregator.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aAggregator[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static CompositeAggregator createInstance(InvocableMap.EntryAggregator[] aAggregator) {
        int cAggregators;
        int n = cAggregators = aAggregator == null ? 0 : aAggregator.length;
        if (cAggregators == 0) {
            throw new IllegalArgumentException("Empty aggregator array");
        }
        boolean fAllParallel = true;
        for (int i = 0; i < cAggregators; ++i) {
            if (aAggregator[i] instanceof InvocableMap.ParallelAwareAggregator) continue;
            fAllParallel = false;
            break;
        }
        if (fAllParallel) {
            InvocableMap.ParallelAwareAggregator[] aParallelAggregator;
            if (aAggregator instanceof InvocableMap.ParallelAwareAggregator[]) {
                aParallelAggregator = (InvocableMap.ParallelAwareAggregator[])aAggregator;
            } else {
                aParallelAggregator = new InvocableMap.ParallelAwareAggregator[cAggregators];
                System.arraycopy(aAggregator, 0, aParallelAggregator, 0, cAggregators);
            }
            return new Parallel(aParallelAggregator);
        }
        return new CompositeAggregator(aAggregator);
    }

    public static class Parallel
    extends CompositeAggregator
    implements InvocableMap.ParallelAwareAggregator {
        private static final InvocableMap.ParallelAwareAggregator[] EMPTY_AGGREGATOR_ARRAY = new InvocableMap.ParallelAwareAggregator[0];

        public Parallel() {
        }

        protected Parallel(InvocableMap.ParallelAwareAggregator[] aAggregator) {
            super(aAggregator);
        }

        @Override
        public InvocableMap.EntryAggregator getParallelAggregator() {
            InvocableMap.ParallelAwareAggregator[] aParallel = (InvocableMap.ParallelAwareAggregator[])this.m_aAggregator;
            int cAggregators = aParallel.length;
            InvocableMap.EntryAggregator[] aAggregator = new InvocableMap.EntryAggregator[cAggregators];
            for (int i = 0; i < cAggregators; ++i) {
                aAggregator[i] = aParallel[i].getParallelAggregator();
            }
            return new CompositeAggregator(aAggregator);
        }

        @Override
        public Object aggregateResults(Collection collResults) {
            InvocableMap.ParallelAwareAggregator[] aParallel = (InvocableMap.ParallelAwareAggregator[])this.m_aAggregator;
            int cAggregators = aParallel.length;
            int cResults = collResults.size();
            Object[][] aaoResults = new Object[cAggregators][];
            for (int iAggr = 0; iAggr < cAggregators; ++iAggr) {
                aaoResults[iAggr] = new Object[cResults];
            }
            Iterator iterResult = collResults.iterator();
            int iResult = 0;
            while (iterResult.hasNext()) {
                Object oResultPart = iterResult.next();
                if (!(oResultPart instanceof List)) {
                    throw new IllegalStateException("Expected result type: java.util.List; actual type: " + oResultPart.getClass().getName());
                }
                List listResultPart = (List)oResultPart;
                if (listResultPart.size() != cAggregators) {
                    throw new IllegalStateException("Expected result list size: " + cAggregators + "; actual size: " + listResultPart.size());
                }
                for (int iAggr = 0; iAggr < cAggregators; ++iAggr) {
                    aaoResults[iAggr][iResult] = listResultPart.get(iAggr);
                }
                ++iResult;
            }
            Object[] aoResult = new Object[cAggregators];
            for (int iAggr = 0; iAggr < cAggregators; ++iAggr) {
                aoResult[iAggr] = aParallel[iAggr].aggregateResults(new ImmutableArrayList(aaoResults[iAggr]));
            }
            return new ImmutableArrayList(aoResult);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            super.readExternal(in);
            InvocableMap.ParallelAwareAggregator[] aAggregator = new InvocableMap.ParallelAwareAggregator[this.m_aAggregator.length];
            for (int i = 0; i < aAggregator.length; ++i) {
                aAggregator[i] = (InvocableMap.ParallelAwareAggregator)this.m_aAggregator[i];
            }
            this.m_aAggregator = aAggregator;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_aAggregator = (InvocableMap.ParallelAwareAggregator[])in.readObjectArray(0, EMPTY_AGGREGATOR_ARRAY);
        }
    }
}

