/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SafeSortedMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class GreaterFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public GreaterFilter() {
    }

    public GreaterFilter(ValueExtractor extractor, Comparable oValue) {
        super(extractor, (Object)oValue);
    }

    public GreaterFilter(String sMethod, Comparable oValue) {
        super(sMethod, (Object)oValue);
    }

    public GreaterFilter(String sMethod, int iValue) {
        this(sMethod, (Comparable)GreaterFilter.makeInteger(iValue));
    }

    public GreaterFilter(String sMethod, long lValue) {
        this(sMethod, (Comparable)GreaterFilter.makeLong(lValue));
    }

    public GreaterFilter(String sMethod, float fValue) {
        this(sMethod, (Comparable)new Float(fValue));
    }

    public GreaterFilter(String sMethod, double dValue) {
        this(sMethod, (Comparable)new Double(dValue));
    }

    @Override
    protected boolean evaluateExtracted(Object oExtracted) {
        try {
            Comparable oLeft = (Comparable)oExtracted;
            Comparable oRight = (Comparable)this.getValue();
            return oLeft != null && oRight != null && oLeft.compareTo(oRight) > 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return this.calculateRangeEffectiveness(mapIndexes, setKeys);
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        block12: {
            MapIndex index;
            Object oValue;
            block10: {
                SortedMap mapLT;
                Set setEQ;
                block11: {
                    boolean fHeadHeavy;
                    SortedMap mapGE;
                    oValue = this.getValue();
                    if (oValue == null) {
                        setKeys.clear();
                        return null;
                    }
                    index = (MapIndex)mapIndexes.get(this.getValueExtractor());
                    if (index == null) {
                        return this;
                    }
                    if (!index.isOrdered()) break block10;
                    SortedMap mapContents = (SortedMap)index.getIndexContents();
                    setEQ = (Set)mapContents.get(oValue);
                    if (mapContents instanceof SafeSortedMap) {
                        SafeSortedMap.Split split = ((SafeSortedMap)mapContents).split(oValue);
                        mapLT = split.getHead();
                        mapGE = split.getTail();
                        fHeadHeavy = split.isHeadHeavy();
                    } else {
                        mapLT = mapContents.headMap(oValue);
                        mapGE = mapContents.tailMap(oValue);
                        boolean bl = fHeadHeavy = mapLT.size() > mapContents.size() / 2;
                    }
                    if (!fHeadHeavy && !index.isPartial()) break block11;
                    HashSet setGT = new HashSet();
                    for (Set set : mapGE.values()) {
                        if (set == setEQ) continue;
                        setGT.addAll(set);
                    }
                    setKeys.retainAll(setGT);
                    break block12;
                }
                for (Set set : mapLT.values()) {
                    setKeys.removeAll(set);
                }
                if (setEQ == null) break block12;
                setKeys.removeAll(setEQ);
                break block12;
            }
            Map mapContents = index.getIndexContents();
            if (index.isPartial()) {
                HashSet setGT = new HashSet();
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest == null || oTest.compareTo(oValue) <= 0) continue;
                    setGT.addAll((Set)entry.getValue());
                }
                setKeys.retainAll(setGT);
            } else {
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest != null && oTest.compareTo(oValue) > 0) continue;
                    setKeys.removeAll((Set)entry.getValue());
                }
            }
        }
        return null;
    }
}

