package org.gridvise
import scala.collection.JavaConversions._
import scala.collection.JavaConverters._
import org.gridvise.logical.ThreadDump
import org.gridvise.mgmtcache.coh.entity.config.ConfigCache
import org.gridvise.mgmtcache.coh.entity.launchable.LaunchableCache
import org.gridvise.mgmtcache.coh.entity.launchable.LaunchableKey
import org.gridvise.mgmtcache.coh.entity.launchable.RunningState
import org.gridvise.mgmtcache.coh.entity.logging.LoggingCache
import org.gridvise.mgmtcache.coh.invocation.tasks.RemoteReEvalTask
import org.gridvise.mgmtcache.coh.invocation.tasks.RemoteStartTask
import org.gridvise.mgmtcache.coh.invocation.tasks.RemoteStopTask
import org.gridvise.mgmtcache.coh.invocation.tasks.RemoteThreadDumpTask
import org.gridvise.mgmtcache.coh.invocation.ManagementInvocationService
import org.gridvise.mgmtcache.coh.invocation.ThreadDumpInvocationService
import logical.ClusterConfigParser
import java.util.ArrayList

object RemoteAPI {

  def start(launchableKeys: java.util.Collection[LaunchableKey]): String = {
    val startTask = new RemoteStartTask()
    startTask.setKeys(launchableKeys.toList)
    val launchableSet = ManagementInvocationService.queryOnAllMembers(startTask)
    launchableSet.toList.foreach(s => println(s))
    "started " + launchableSet.size() + " jvms"
  }

  def startJvmGroup(jvmGroup: String) {
    val startTask = new RemoteStartTask()
    val keys = LaunchableCache.getLaunchableKeysForNodeGroup(jvmGroup)
    if (keys.size == 0) println("no nodes associated with nodegroup " + jvmGroup)
    else {
      startTask.setKeys(keys)
      (ManagementInvocationService.queryOnAllMembers(startTask)).toList.foreach(s => println(s))
    }
  }

  def start() {
    val startTask = new RemoteStartTask()
    (ManagementInvocationService.queryOnAllMembers(startTask)).toList.foreach(s => println(s))
  }
  
  def start(jvmConfig: String): String = {
    start(LaunchableCache.getLaunchablesForJvmConfig(jvmConfig))
  }

  def getRunningState(launchableKeys: java.util.Collection[LaunchableKey]): RunningState.Value = {
    LaunchableCache.getRunningState(launchableKeys.toList)
  }

  def stop() {
    ManagementInvocationService.queryOnAllMembers(new RemoteStopTask()).toList.foreach(s => println(s))
  }

  def stop(jvmConfig: String): String = {
    stop(LaunchableCache.getLaunchablesForJvmConfig(jvmConfig))
  }

  def stop(launchableKeys: java.util.Collection[LaunchableKey]): String = {
    val stopTask = new RemoteStopTask()
    val launchableSet = ManagementInvocationService.queryOnAllMembers(stopTask)
    stopTask.setKeys(launchableKeys.toList)
    launchableSet.toList.foreach(s => println(s))
    "stopped "+launchableSet.size() + " jvms"
  }

  def threadDump(launchableKeys: java.util.Collection[LaunchableKey]): List[ThreadDump] = {
    val threadDumpTask = new RemoteThreadDumpTask()
    threadDumpTask.setKeys(launchableKeys.toList)
    val dumpList = ThreadDumpInvocationService.queryOnAllMembers(threadDumpTask)
    var returnList: List[ThreadDump] = Nil
    dumpList.foreach(l => l.foreach(t => returnList ::= t))
    returnList
  }

  def threadDumpForJvmGroup(jvmGroup: String) {
    val keys = LaunchableCache.getLaunchableKeysForNodeGroup(jvmGroup)
    if (keys.size == 0)
      println("no nodes associated with nodegroup " + jvmGroup)
    else
      threadDump(keys)
  }

  def threadDumpForJvmConfig(jvmConfig: String) : List[ThreadDump] = {
    val keys = LaunchableCache.getLaunchableKeysForJvmConfig(jvmConfig)
    if (keys.size == 0){
      println("no nodes associated with nodegroup " + jvmConfig)
      Nil
    }
    else{
      threadDump(keys)
    }
  }

  def getDumpForJvmConfig(jvmConfig: String) {
    val keys = LaunchableCache.getLaunchableKeysForJvmConfig(jvmConfig)
    if (keys.size == 0)
      println("no nodes associated with nodegroup " + jvmConfig)
    else
      threadDump(keys)
  }

  def getLogsForJvmConfig(jvmConfig: String): String = {
    getLogs(LaunchableCache.getLaunchableKeysForJvmConfig(jvmConfig))
  }

  def getLogs(launchableKeys: java.util.Collection[LaunchableKey]): String = {
    getLogs(launchableKeys.asScala)
  }

//  def getLogs(launchableKeys: Collection[LaunchableKey]): String = {
//    var result = ""
//    launchableKeys.foreach(a => result += getLogs(a))
//    result
//  }

  def getLogs(launchableKey: LaunchableKey): String = {
    LoggingCache.getLog(launchableKey)
  }

  def getLaunchables() = {
    LaunchableCache.values()
  }

  def getLaunchable(key: LaunchableKey) = {
    LaunchableCache.get(key)
  }

  def getConfig(): String = {
    ConfigCache.getConfig()
  }

  def saveConfig(config: String) = {
    stop()
    LaunchableCache.clear()
    ClusterConfigParser.initialize(config)
    ConfigCache.putConfig(config)
  }

  def getLaunchableKeys() = {
    LaunchableCache.keySet(null);
  }

  def reEvaluateLaunchables() = {
    val task = new RemoteReEvalTask()
    ManagementInvocationService.queryOnAllMembers(task).toList.foreach(s => println(s))
  }

}