/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.event.streams.oschecks;

import java.util.Date;
import org.gridvise.event.os.HighCPUEvent;
import org.gridvise.event.os.HighCPULaunchableEvent;
import org.gridvise.event.streams.Check;
import org.gridvise.event.streams.CheckResult;
import org.gridvise.logical.Launchable;
import org.gridvise.logical.ThreadDump;
import org.gridvise.logical.os.OSOperations$;
import org.gridvise.logical.os.ProcInfo;
import org.gridvise.mgmtcache.coh.ManagementCacheServer$;
import org.gridvise.mgmtcache.coh.entity.config.ConfigCache$;
import org.gridvise.mgmtcache.coh.entity.events.EventCache$;
import org.gridvise.mgmtcache.coh.entity.launchable.LaunchableCache$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u001b\tY1\t\u0015)V\u0007\",7m[3s\u0015\t\u0019A!\u0001\u0005pg\u000eDWmY6t\u0015\t)a!A\u0004tiJ,\u0017-\\:\u000b\u0005\u001dA\u0011!B3wK:$(BA\u0005\u000b\u0003!9'/\u001b3wSN,'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005!\u0011BA\t\u0005\u0005\u0015\u0019\u0005.Z2l\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\u0004qKJ4wN]7\u0015\u0003i\u0001\"aD\u000e\n\u0005q!!aC\"iK\u000e\\'+Z:vYRDQA\b\u0001\u0005\u0002}\taCZ5sK2\u000bWO\\2iC\ndWm\u0011)V\u000bZ,g\u000e\u001e\u000b\u0004A\u0019b\u0004CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDQaJ\u000fA\u0002!\n\u0001\u0002\u001d:pG2\u000bWO\u001c\t\u0004SE\"dB\u0001\u00160\u001d\tYc&D\u0001-\u0015\tiC\"\u0001\u0004=e>|GOP\u0005\u0002G%\u0011\u0001GI\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114G\u0001\u0003MSN$(B\u0001\u0019#!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0002pg*\u0011\u0011\bC\u0001\bY><\u0017nY1m\u0013\tYdG\u0001\u0005Qe>\u001c\u0017J\u001c4p\u0011\u0015iT\u00041\u0001?\u0003\u0015!W/\u001c9t!\u0011y$)\u0012%\u000f\u0005\u0005\u0002\u0015BA!#\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0004\u001b\u0006\u0004(BA!#!\tyd)\u0003\u0002H\t\n11\u000b\u001e:j]\u001e\u0004\"!\u0013&\u000e\u0003aJ!a\u0013\u001d\u0003\u0015QC'/Z1e\tVl\u0007\u000fC\u0003N\u0001\u0011\u0005a*\u0001\nde\u0016\fG/\u001a%jO\"\u001c\u0005+V#wK:$Hc\u0001\u0011P#\")\u0001\u000b\u0014a\u0001i\u0005\t\u0001\u000fC\u0003S\u0019\u0002\u0007\u0001*\u0001\u0003ek6\u0004\b\"\u0002+\u0001\t\u0003)\u0016\u0001\u00054je\u0016lu-\u001c;D!V+e/\u001a8u)\t\u0001c\u000bC\u0003('\u0002\u0007\u0001\u0006C\u0003Y\u0001\u0011\u0005\u0011,A\tgSJ,w\n\u001e5fe\u000e\u0003V+\u0012<f]R$\"\u0001\t.\t\u000b\u001d:\u0006\u0019\u0001\u0015")
public class CPPUChecker
extends Check {
    @Override
    public CheckResult perform() {
        CheckResult checkResult;
        List<ProcInfo> cpuInfo = OSOperations$.MODULE$.getCPUUsageHigherThen(ConfigCache$.MODULE$.getCPUCheckThreashold());
        if (cpuInfo.size() == 0) {
            checkResult = this.createCheckResult("all good", true);
        } else {
            List<Launchable> launchables = LaunchableCache$.MODULE$.getLaunchablesOnThisMachine();
            List pidListlaunchable = (List)launchables.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Launchable l) {
                    return l.processIdentifier();
                }
            }, List$.MODULE$.canBuildFrom());
            List pidListCPU = (List)cpuInfo.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ProcInfo p) {
                    return p.id();
                }
            }, List$.MODULE$.canBuildFrom());
            List highLaunchables = (List)launchables.filter((Function1)new Serializable(this, pidListCPU){
                public static final long serialVersionUID = 0L;
                private final List pidListCPU$1;

                public final boolean apply(Launchable l) {
                    return this.pidListCPU$1.contains((Object)l.processIdentifier());
                }
                {
                    this.pidListCPU$1 = pidListCPU$1;
                }
            });
            Date dumpDate = new Date();
            Map launchableDumpsByPID = ((TraversableOnce)highLaunchables.map((Function1)new Serializable(this, dumpDate){
                public static final long serialVersionUID = 0L;
                private final Date dumpDate$1;

                public final Tuple2<String, ThreadDump> apply(Launchable l) {
                    return new Tuple2((Object)l.processIdentifier(), (Object)l.threadDump(this.dumpDate$1));
                }
                {
                    this.dumpDate$1 = dumpDate$1;
                }
            }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
            List procLaun = (List)cpuInfo.filter((Function1)new Serializable(this, pidListlaunchable){
                public static final long serialVersionUID = 0L;
                private final List pidListlaunchable$1;

                public final boolean apply(ProcInfo p) {
                    return this.pidListlaunchable$1.contains((Object)p.id());
                }
                {
                    this.pidListlaunchable$1 = pidListlaunchable$1;
                }
            });
            List procMgmt = (List)cpuInfo.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ProcInfo p) {
                    return p.cmd().indexOf(ManagementCacheServer$.MODULE$.getClass().getName()) != -1;
                }
            });
            List procOther = (List)cpuInfo.filterNot((Function1)new Serializable(this, procLaun, procMgmt){
                public static final long serialVersionUID = 0L;
                private final List procLaun$1;
                private final List procMgmt$1;

                public final boolean apply(ProcInfo p) {
                    return this.procLaun$1.contains((Object)p) || this.procMgmt$1.contains((Object)p);
                }
                {
                    this.procLaun$1 = procLaun$1;
                    this.procMgmt$1 = procMgmt$1;
                }
            });
            this.fireLaunchableCPUEvent((List<ProcInfo>)procLaun, (Map<String, ThreadDump>)launchableDumpsByPID);
            this.fireMgmtCPUEvent((List<ProcInfo>)procMgmt);
            this.fireOtherCPUEvent((List<ProcInfo>)procOther);
            checkResult = this.createCheckResult("cpu threashold exceeded", false);
        }
        return checkResult;
    }

    public void fireLaunchableCPUEvent(List<ProcInfo> procLaun, Map<String, ThreadDump> dumps) {
        procLaun.foreach((Function1)new Serializable(this, dumps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CPPUChecker $outer;
            private final Map dumps$1;

            public final void apply(ProcInfo p) {
                this.$outer.createHighCPUEvent(p, (ThreadDump)this.dumps$1.get((Object)p.id()).get());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dumps$1 = dumps$1;
            }
        });
    }

    public void createHighCPUEvent(ProcInfo p, ThreadDump dump) {
        Launchable l = LaunchableCache$.MODULE$.getLaunchableForPid(p.id());
        EventCache$.MODULE$.store(new HighCPULaunchableEvent(p, l, dump));
    }

    public void fireMgmtCPUEvent(List<ProcInfo> procLaun) {
        procLaun.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ProcInfo p) {
                EventCache$.MODULE$.store(new HighCPUEvent(p, "ups, mgmt server taking high cpu"));
            }
        });
    }

    public void fireOtherCPUEvent(List<ProcInfo> procLaun) {
        procLaun.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ProcInfo p) {
                EventCache$.MODULE$.store(new HighCPUEvent(p, new StringBuilder().append((Object)"The following command is taking ").append((Object)BoxesRunTime.boxToDouble((double)p.cpu())).append((Object)"% CPU: ").append((Object)p.cmd()).toString()));
            }
        });
    }
}

