/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.logical;

import java.util.Map;
import org.gridvise.logical.ClusterConfigParser$;
import org.gridvise.logical.ClusterConfigParser$$anonfun$getLaunchables$1$;
import org.gridvise.logical.Launchable;
import org.gridvise.logical.os.MachineInfo$;
import org.gridvise.mgmtcache.coh.entity.launchable.LaunchableCache$;
import org.gridvise.util.IdGenerator$;
import org.gridvise.xmlbindings.Classpath;
import org.gridvise.xmlbindings.ClusterConfig;
import org.gridvise.xmlbindings.Dir;
import org.gridvise.xmlbindings.Jvm;
import org.gridvise.xmlbindings.JvmConfig;
import org.gridvise.xmlbindings.JvmGroup;
import org.gridvise.xmlbindings.NodeGroupRef;
import org.gridvise.xmlbindings.OptionType;
import org.gridvise.xmlbindings.OverrideVar2;
import org.gridvise.xmlbindings.Server;
import org.gridvise.xmlbindings.SystemVar2;
import org.gridvise.xmlbindings.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class ClusterConfigParser$ {
    public static final ClusterConfigParser$ MODULE$;
    private final String hostnameVarName;
    private final String uniqueNameVarName;
    private final String hostname;
    private String clusterName;
    private String clusterMode;
    private ClusterConfig clusterconfig;
    private Server server;
    private final HashMap<String, JvmConfig> jvmConfigs;
    private final HashMap<String, JvmGroup> jvmGroups;
    private final HashMap<String, String> sysVars;
    private final HashMap<String, String> overrideVars;

    static {
        new ClusterConfigParser$();
    }

    public Logger logger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public String hostnameVarName() {
        return this.hostnameVarName;
    }

    public String uniqueNameVarName() {
        return this.uniqueNameVarName;
    }

    public String hostname() {
        return this.hostname;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void clusterName_$eq(String x$1) {
        this.clusterName = x$1;
    }

    public String clusterMode() {
        return this.clusterMode;
    }

    public void clusterMode_$eq(String x$1) {
        this.clusterMode = x$1;
    }

    public ClusterConfig clusterconfig() {
        return this.clusterconfig;
    }

    public void clusterconfig_$eq(ClusterConfig x$1) {
        this.clusterconfig = x$1;
    }

    public Server server() {
        return this.server;
    }

    public void server_$eq(Server x$1) {
        this.server = x$1;
    }

    public HashMap<String, JvmConfig> jvmConfigs() {
        return this.jvmConfigs;
    }

    public HashMap<String, JvmGroup> jvmGroups() {
        return this.jvmGroups;
    }

    public HashMap<String, String> sysVars() {
        return this.sysVars;
    }

    public HashMap<String, String> overrideVars() {
        return this.overrideVars;
    }

    public void initialize(String xmlIncoming) {
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Initializing on hostname=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname()})));
        String xmlString = this.replaceSysVarRefs(xmlIncoming);
        Elem xml = (Elem)XML$.MODULE$.loadString(xmlString);
        this.clusterconfig_$eq(scalaxb.package$.MODULE$.fromXML((NodeSeq)xml, scalaxb.package$.MODULE$.fromXML$default$2(), package$.MODULE$.XmlbindingsClusterConfigFormat()));
        this.clusterName_$eq(this.clusterconfig().name());
        this.clusterMode_$eq(this.clusterconfig().mode());
        this.assignServer();
        this.indexJvmConfigs();
        this.indexJvmGroups();
        this.setOverideVariables();
        this.indexSystemVariables();
        this.insertLaunchables();
    }

    private HashSet<Launchable> getLaunchables() {
        Object object;
        ObjectRef launchables = new ObjectRef((Object)new HashSet());
        if (this.server() == null) {
            this.logger().info("No launchables configured for this host");
            object = BoxedUnit.UNIT;
        } else {
            object = this.server().NodeGroupRef().map((Function1)new Serializable(launchables){
                public static final long serialVersionUID = 0L;
                public final ObjectRef launchables$1;

                public final Seq<BoxedUnit> apply(NodeGroupRef n) {
                    JvmGroup g = (JvmGroup)ClusterConfigParser$.MODULE$.jvmGroups().get((Object)n.name()).get();
                    return (Seq)g.Jvm().map((Function1)new Serializable(this, n){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getLaunchables.1 $outer;
                        public final NodeGroupRef n$1;

                        public final void apply(Jvm j) {
                            IntRef c = new IntRef(0);
                            ClusterConfigParser$.MODULE$.org$gridvise$logical$ClusterConfigParser$$times(j.count(), (Function0<BoxedUnit>)new Serializable(this, j, c){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$getLaunchables$1$$anonfun$apply$2 $outer;
                                private final Jvm j$1;
                                private final IntRef c$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    ClusterConfigParser$.MODULE$.logger().info(new StringOps(Predef$.MODULE$.augmentString("%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ClusterConfigParser$.MODULE$.jvmConfigs().get((Object)this.j$1.configRef()).get()})));
                                    JvmConfig jvmConfig = (JvmConfig)ClusterConfigParser$.MODULE$.jvmConfigs().get((Object)this.j$1.configRef()).get();
                                    Launchable l = ClusterConfigParser$.MODULE$.org$gridvise$logical$ClusterConfigParser$$createLaunchable(jvmConfig, this.$outer.n$1.name().toString(), Predef$.MODULE$.int2Integer(this.c$1.elem + 1));
                                    if (!this.j$1.delay().isEmpty()) {
                                        l.delay_$eq(BoxesRunTime.unboxToInt((Object)this.j$1.delay().get()));
                                    }
                                    ((HashSet)this.$outer.org$gridvise$logical$ClusterConfigParser$$anonfun$$anonfun$$$outer().launchables$1.elem).add((Object)l);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.j$1 = j$1;
                                    this.c$1 = c$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.getLaunchables.1 org$gridvise$logical$ClusterConfigParser$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.n$1 = n$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                {
                    this.launchables$1 = launchables$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return (HashSet)launchables.elem;
    }

    private void insertLaunchables() {
        this.getLaunchables().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Launchable l) {
                return LaunchableCache$.MODULE$.putLaunchable(l);
            }
        });
    }

    private void indexJvmConfigs() {
        this.clusterconfig().JvmConfigs().JvmConfig().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<JvmConfig> apply(JvmConfig c) {
                ClusterConfigParser$.MODULE$.sysVars().put((Object)ClusterConfigParser$.MODULE$.uniqueNameVarName(), (Object)c.uniqueName());
                return ClusterConfigParser$.MODULE$.jvmConfigs().put((Object)c.uniqueName(), (Object)c);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void indexSystemVariables() {
        ObjectRef p = new ObjectRef(System.getenv());
        this.logger().info(new StringBuilder().append((Object)"handling EnvironmentVariables ").append((Object)((Map)p.elem)).toString());
        this.clusterconfig().RequiredSystemVars().SystemVar().map((Function1)new Serializable(p){
            public static final long serialVersionUID = 0L;
            private final ObjectRef p$1;

            public final Object apply(SystemVar2 c) {
                Option option;
                String v = ClusterConfigParser$.MODULE$.org$gridvise$logical$ClusterConfigParser$$getOverrideOption(c.name());
                if (v == null) {
                    String v2 = (String)((Map)this.p$1.elem).get(c.name());
                    if (v2 == null) {
                        ClusterConfigParser$.MODULE$.logger().warn(new StringOps(Predef$.MODULE$.augmentString("WARNING: %s not provided as environment variable.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.name()})));
                        if (c.description() == null) {
                            option = BoxedUnit.UNIT;
                        } else {
                            ClusterConfigParser$.MODULE$.logger().info(new StringOps(Predef$.MODULE$.augmentString("%s is expected as: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.name(), c.description()})));
                            option = BoxedUnit.UNIT;
                        }
                    } else {
                        option = ClusterConfigParser$.MODULE$.sysVars().put((Object)c.name(), (Object)v2.toString().replace("workspace-jvms", "workspace"));
                    }
                } else {
                    option = ClusterConfigParser$.MODULE$.sysVars().put((Object)c.name(), (Object)v);
                }
                return option;
            }
            {
                this.p$1 = p$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.sysVars().put((Object)this.hostnameVarName(), (Object)this.hostname());
    }

    public String org$gridvise$logical$ClusterConfigParser$$getOverrideOption(String name) {
        Option overrideOption = this.overrideVars().get((Object)name);
        return overrideOption.isEmpty() ? null : (String)overrideOption.get();
    }

    private void setOverideVariables() {
        this.clusterconfig().OverrideSystemVars().OverrideVar().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(OverrideVar2 c) {
                return ClusterConfigParser$.MODULE$.overrideVars().put((Object)c.name(), (Object)c.dir());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void indexJvmGroups() {
        this.clusterconfig().JvmGroups().JvmGroup().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<JvmGroup> apply(JvmGroup c) {
                return ClusterConfigParser$.MODULE$.jvmGroups().put((Object)c.name(), (Object)c);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<BoxedUnit> assignServer() {
        return (Seq)this.clusterconfig().Servers().Server().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Server s) {
                if (ClusterConfigParser$.MODULE$.hostname().startsWith(s.hostname())) {
                    ClusterConfigParser$.MODULE$.server_$eq(s);
                }
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Launchable org$gridvise$logical$ClusterConfigParser$$createLaunchable(JvmConfig jvmConfig, String nodeGroupName, Integer ordinal) {
        Launchable l = new Launchable(IdGenerator$.MODULE$.next(), ordinal);
        this.setProperties(jvmConfig, l);
        l.nodeGroupName_$eq(nodeGroupName);
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Created launchable %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l})));
        return l;
    }

    private void setProperties(JvmConfig jvmConfig, Launchable l) {
        String parentJvmConfigName;
        if (!jvmConfig.parent().isEmpty() && (parentJvmConfigName = (String)jvmConfig.parent().get()) != null) {
            Option parentJvmConfig = this.jvmConfigs().get((Object)parentJvmConfigName);
            if (parentJvmConfig == null) {
                this.logger().warn(new StringOps(Predef$.MODULE$.augmentString("WARNING: reference to parent %s not found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jvmConfig.parent().get()})));
            } else {
                this.setProperties((JvmConfig)parentJvmConfig.get(), l);
            }
        }
        l.configName_$eq(jvmConfig.uniqueName());
        if (!jvmConfig.mainClass().isEmpty()) {
            l.mainClass_$eq(jvmConfig.mainClass());
        }
        if (!jvmConfig.jvmArgs().isEmpty()) {
            l.jvmArgs_$eq((String)jvmConfig.jvmArgs().get());
        }
        jvmConfig.JavaOptions().Option().foreach((Function1)new Serializable(l){
            public static final long serialVersionUID = 0L;
            private final Launchable l$1;

            public final Option<String> apply(OptionType x) {
                return this.l$1.jvmOptions().put((Object)x.name(), (Object)x.valueAttribute());
            }
            {
                this.l$1 = l$1;
            }
        });
        jvmConfig.Classpath().foreach((Function1)new Serializable(l){
            public static final long serialVersionUID = 0L;
            public final Launchable l$1;

            public final void apply(Classpath x) {
                x.Dir().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.setProperties.2 $outer;

                    public final boolean apply(Dir d) {
                        return this.$outer.l$1.classPathEntries().add((Object)new StringBuilder().append((Object)((String)ClusterConfigParser$.MODULE$.sysVars().get(d.systemVar().get()).get())).append((Object)"/").append(d.relativePath().get()).toString());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.l$1 = l$1;
            }
        });
    }

    private String replaceSysVarRefs(String xmlString) {
        Elem xml = (Elem)XML$.MODULE$.loadString(xmlString);
        this.clusterconfig_$eq(scalaxb.package$.MODULE$.fromXML((NodeSeq)xml, scalaxb.package$.MODULE$.fromXML$default$2(), package$.MODULE$.XmlbindingsClusterConfigFormat()));
        this.setOverideVariables();
        this.indexSystemVariables();
        ObjectRef returnString = new ObjectRef((Object)xmlString);
        this.sysVars().foreach((Function1)new Serializable(returnString){
            public static final long serialVersionUID = 0L;
            private final ObjectRef returnString$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String varName = (String)tuple2._1();
                    String varValue = (String)tuple2._2();
                    this.returnString$1.elem = ((String)this.returnString$1.elem).replaceAll(new StringBuilder().append((Object)"\\$\\{").append((Object)varName).append((Object)"\\}").toString(), varValue);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.returnString$1 = returnString$1;
            }
        });
        return (String)returnString.elem;
    }

    public void org$gridvise$logical$ClusterConfigParser$$times(int n, Function0<BoxedUnit> code) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).foreach$mVc$sp((Function1)new Serializable(code){
            public static final long serialVersionUID = 0L;
            private final Function0 code$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.code$1.apply$mcV$sp();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    private ClusterConfigParser$() {
        MODULE$ = this;
        this.hostnameVarName = "HOSTNAME";
        this.uniqueNameVarName = "uniqueName";
        this.hostname = MachineInfo$.MODULE$.getMachineName();
        this.clusterName = "";
        this.clusterMode = "";
        this.jvmConfigs = new HashMap();
        this.jvmGroups = new HashMap();
        this.sysVars = new HashMap();
        this.overrideVars = new HashMap();
    }
}

