/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ArraySet<E>
extends AbstractSet<E> {
    private final ArrayList<E> m_list;

    public ArraySet(int initialCapacity) {
        this.m_list = new ArrayList(initialCapacity);
    }

    public ArraySet() {
        this(10);
    }

    public ArraySet(Collection<? extends E> collection) {
        if (collection instanceof Set) {
            this.m_list = new ArrayList<E>(collection);
        } else {
            this.m_list = new ArrayList(collection.size());
            for (E e : collection) {
                this.add(e);
            }
        }
    }

    public ArrayList<E> getArrayList() {
        return this.m_list;
    }

    @Override
    public boolean add(E e) {
        return !this.contains(e) && this.m_list.add(e);
    }

    @Override
    public void clear() {
        this.m_list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.m_list.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.m_list.remove(o);
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_list.toArray(a);
    }
}

