/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.io;

import com.oracle.common.io.BufferManager;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckedBufferManager
implements BufferManager {
    protected final Logger LOGGER = Logger.getLogger(CheckedBufferManager.class.getName());
    protected final BufferManager m_delegate;
    protected final Set<ByteBuffer> m_setAllocated = Collections.newSetFromMap(Collections.synchronizedMap(new IdentityHashMap()));

    public CheckedBufferManager(BufferManager mgr) {
        this.m_delegate = mgr;
    }

    @Override
    public ByteBuffer acquire(int cbMin) {
        ByteBuffer buff;
        int cAttempts = 0;
        do {
            buff = this.m_delegate.acquire(cbMin);
            ++cAttempts;
        } while (!this.m_setAllocated.add(buff));
        if (cAttempts > 1) {
            this.LOGGER.log(Level.WARNING, "Compensating for unaccounted for ByteBuffer re-use of " + (cAttempts - 1) + " buffers for request size of " + cbMin + " from " + this.m_delegate);
        }
        return buff;
    }

    @Override
    public ByteBuffer acquirePref(int cbPref) {
        ByteBuffer buff;
        int cAttempts = 0;
        do {
            buff = this.m_delegate.acquirePref(cbPref);
            ++cAttempts;
        } while (!this.m_setAllocated.add(buff));
        if (cAttempts > 1) {
            this.LOGGER.log(Level.WARNING, "Compensating for unaccounted for ByteBuffer re-use of " + (cAttempts - 1) + " buffers for prefered size of " + cbPref + " from " + this.m_delegate);
        }
        return buff;
    }

    @Override
    public ByteBuffer acquireSum(int cbSum) {
        ByteBuffer buff;
        int cAttempts = 0;
        do {
            buff = this.m_delegate.acquireSum(cbSum);
            ++cAttempts;
        } while (!this.m_setAllocated.add(buff));
        if (cAttempts > 1) {
            this.LOGGER.log(Level.WARNING, "Compensating for unaccounted for ByteBuffer re-use of " + (cAttempts - 1) + " buffers for accumulated size of " + cbSum + " from " + this.m_delegate);
        }
        return buff;
    }

    @Override
    public ByteBuffer truncate(ByteBuffer buff) {
        RuntimeException e;
        Set<ByteBuffer> setAllocated = this.m_setAllocated;
        if (setAllocated.remove(buff)) {
            if (setAllocated.add(buff = this.m_delegate.truncate(buff))) {
                return buff;
            }
            e = new IllegalStateException("Unable to safely compensate for unaccounted  ByteBuffer re-use of truncated buffer size of " + buff.limit() + " to " + this.m_delegate);
        } else {
            e = new IllegalArgumentException("Rejecting attempt to truncate unknown buffer of size " + buff.capacity() + " from " + this.m_delegate);
        }
        this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
        throw e;
    }

    @Override
    public void release(ByteBuffer buff) {
        if (!this.m_setAllocated.remove(buff)) {
            IllegalArgumentException e = new IllegalArgumentException("Rejecting attempt to release unknown buffer of size " + buff.capacity() + " to " + this.m_delegate);
            this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public void dispose() {
        this.m_delegate.dispose();
    }
}

