/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.io;

import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.io.Buffers;
import com.oracle.common.io.MultiBufferSequence;
import com.oracle.common.io.SingleBufferSequence;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class BufferSequenceOutputStream
extends OutputStream
implements DataOutput {
    protected BufferManager m_manager;
    protected ByteBuffer m_buffer;
    private ByteBuffer m_buffTmp;
    protected long m_cb;
    protected List<ByteBuffer> m_listBuffers;

    public BufferSequenceOutputStream(BufferManager manager) {
        this(manager, 0);
    }

    public BufferSequenceOutputStream(BufferManager manager, int cb) {
        if (manager == null) {
            throw new IllegalArgumentException("manager cannot be null");
        }
        this.m_manager = manager;
        if (cb > 0) {
            this.m_buffer = (ByteBuffer)manager.acquirePref(cb).clear();
        }
    }

    public BufferSequence toBufferSequence() throws IOException {
        BufferManager manager = this.m_manager;
        List<ByteBuffer> listBuffers = this.m_listBuffers;
        ByteBuffer bufLast = this.m_buffer;
        this.close();
        if (listBuffers == null) {
            if (bufLast == null || bufLast.position() == 0) {
                if (bufLast != null) {
                    manager.release(bufLast);
                }
                return Buffers.getEmptyBufferSequence();
            }
            bufLast.flip();
            return new SingleBufferSequence(manager, manager.truncate(bufLast));
        }
        bufLast.flip();
        long cb = this.m_cb + (long)bufLast.remaining();
        listBuffers.add(manager.truncate(bufLast));
        int cBuffer = listBuffers.size();
        return new MultiBufferSequence(manager, listBuffers.toArray(new ByteBuffer[cBuffer]), 0, cBuffer, cb);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        int cb = 2;
        ByteBuffer buff = this.getBuffer();
        if (buff.remaining() >= cb && buff.order() == ByteOrder.BIG_ENDIAN) {
            buff.putShort((short)v);
        } else {
            this.write(this.getBufferTemp().putShort((short)v).array(), 0, cb);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        int cb = 2;
        ByteBuffer buff = this.getBuffer();
        if (buff.remaining() >= cb && buff.order() == ByteOrder.BIG_ENDIAN) {
            buff.putChar((char)v);
        } else {
            this.write(this.getBufferTemp().putChar((char)v).array(), 0, cb);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        int cb = 4;
        ByteBuffer buff = this.getBuffer();
        if (buff.remaining() >= cb && buff.order() == ByteOrder.BIG_ENDIAN) {
            buff.putInt(v);
        } else {
            ByteBuffer buffTmp = this.m_buffTmp;
            buffTmp.clear();
            buff.putInt(v);
            this.write(buffTmp.array(), 0, cb);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        int cb = 8;
        ByteBuffer buff = this.getBuffer();
        if (buff.remaining() >= cb && buff.order() == ByteOrder.BIG_ENDIAN) {
            buff.putLong(v);
        } else {
            this.write(this.getBufferTemp().putLong(v).array(), 0, cb);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int cb = 4;
        ByteBuffer buff = this.getBuffer();
        if (buff.remaining() >= cb && buff.order() == ByteOrder.BIG_ENDIAN) {
            buff.putFloat(v);
        } else {
            this.write(this.getBufferTemp().putFloat(v).array(), 0, cb);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        int cb = 8;
        ByteBuffer buff = this.getBuffer();
        if (buff.remaining() >= cb && buff.order() == ByteOrder.BIG_ENDIAN) {
            buff.putDouble(v);
        } else {
            this.write(this.getBufferTemp().putDouble(v).array(), 0, cb);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int c = s.length();
        for (int i = 0; i < c; ++i) {
            this.writeByte(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int c = s.length();
        for (int i = 0; i < c; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.write(bytearr, 0, utflen + 2);
    }

    @Override
    public void write(int b) throws IOException {
        this.getBuffer().put((byte)b);
    }

    @Override
    public void write(byte[] ab, int of, int cb) throws IOException {
        if (ab == null || of < 0 || cb < 0 || of + cb > ab.length) {
            if (ab == null) {
                throw new IllegalArgumentException("null byte array");
            }
            throw new IllegalArgumentException("ab.length=" + ab.length + ", of=" + of + ", cb=" + cb);
        }
        ByteBuffer buff = this.getBuffer();
        while (cb > 0) {
            int cbCopy = Math.min(buff.remaining(), cb);
            buff.put(ab, of, cbCopy);
            cb -= cbCopy;
            of += cbCopy;
            buff = this.getBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.m_manager == null) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_listBuffers = null;
        this.m_buffer = null;
        this.m_manager = null;
    }

    protected ByteBuffer getBuffer() throws IOException {
        BufferManager manager = this.m_manager;
        if (manager == null) {
            throw new IOException("stream closed");
        }
        ByteBuffer buffer = this.m_buffer;
        if (buffer != null && !buffer.hasRemaining()) {
            buffer.flip();
            this.m_cb += (long)buffer.remaining();
            this.ensureBufferList().add(buffer);
            buffer = null;
        }
        if (buffer == null) {
            this.m_buffer = buffer = manager.acquireSum((int)Math.min(Integer.MAX_VALUE, this.m_cb));
        }
        return buffer;
    }

    protected final ByteBuffer getBufferTemp() {
        ByteBuffer buffTmp = this.m_buffTmp;
        if (buffTmp == null) {
            this.m_buffTmp = buffTmp = ByteBuffer.allocate(8);
        }
        buffTmp.clear();
        return buffTmp;
    }

    protected List<ByteBuffer> ensureBufferList() {
        List<ByteBuffer> listBuffers = this.m_listBuffers;
        if (listBuffers == null) {
            this.m_listBuffers = listBuffers = new ArrayList<ByteBuffer>();
        }
        return listBuffers;
    }
}

