/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$OwnershipRequest$Poll;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class PartitionedService$OwnershipRequest
extends RequestMessage {
    public static final int REQUEST_COUNT_THRESHOLD = 4;
    private int[][] __m_RequestAssignments;
    private transient int __m_RequestCount;
    private boolean __m_Restore;

    public PartitionedService$OwnershipRequest() {
        this(null, null, true);
    }

    public PartitionedService$OwnershipRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(33);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new PartitionedService$OwnershipRequest$Poll("Poll", this, true), "Poll");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int[][] getRequestAssignments() {
        return this.__m_RequestAssignments;
    }

    public int getRequestCount() {
        return this.__m_RequestCount;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$OwnershipRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$OwnershipRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isRestore() {
        return this.__m_Restore;
    }

    public void onReceived() {
        super.onReceived();
        ((PartitionedService)this.getService()).onOwnershipRequest(this);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        boolean fRestore = input.readBoolean();
        this.setRestore(fRestore);
        if (fRestore ^ true) {
            int cAttempt = ExternalizableHelper.readInt(input);
            this.setRequestCount(cAttempt);
            if (cAttempt > REQUEST_COUNT_THRESHOLD) {
                PartitionedService service = (PartitionedService)this.getService();
                int cPartitions = service.getPartitionCount();
                int cBackups = service.getBackupCount();
                int[][] aaiOwners = new int[cPartitions][cBackups + 1];
                int iPartition = 0;
                while (iPartition < cPartitions) {
                    int iStore = 0;
                    while (iStore <= cBackups) {
                        aaiOwners[iPartition][iStore] = ExternalizableHelper.readInt(input);
                        ++iStore;
                    }
                    ++iPartition;
                }
                this.setRequestAssignments(aaiOwners);
            }
        }
    }

    public void setRequestAssignments(int[][] aai) {
        this.__m_RequestAssignments = aai;
    }

    public void setRequestCount(int c) {
        this.__m_RequestCount = c;
    }

    public void setRestore(boolean fRestore) {
        this.__m_Restore = fRestore;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        PartitionedService service = (PartitionedService)this.getService();
        boolean fRestore = this.isRestore();
        output.writeBoolean(fRestore);
        if (fRestore ^ true) {
            int cAttempt = service.getOwnershipInProgress();
            ExternalizableHelper.writeInt(output, cAttempt);
            if (cAttempt > REQUEST_COUNT_THRESHOLD) {
                int[][] aaiOwner = service.getPartitionAssignments();
                int cPartitions = service.getPartitionCount();
                int cBackups = service.getBackupCount();
                int iPartition = 0;
                while (iPartition < cPartitions) {
                    int iStore = 0;
                    while (iStore <= cBackups) {
                        ExternalizableHelper.writeInt(output, aaiOwner[iPartition][iStore]);
                        ++iStore;
                    }
                    ++iPartition;
                }
            }
        }
    }
}

