/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$MessageFactory;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class HttpAcceptor
extends Acceptor {
    private Object __m_HttpServer;
    private String __m_LocalAddress;
    private int __m_LocalPort;
    private Object __m_ResourceConfig;
    private static ListMap __mapChildren;

    static {
        HttpAcceptor.__initStatic();
    }

    public HttpAcceptor() {
        this(null, null, true);
    }

    public HttpAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLocalAddress("localhost");
            this.setLocalPort(8080);
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Peer$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Acceptor$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml == null) {
            return;
        }
        XmlElement xmlAcceptor = xml.getSafeElement("http-acceptor");
        if (XmlHelper.isInstanceConfigEmpty(xmlAcceptor)) {
            XmlElement xmlClass = xmlAcceptor.ensureElement("class-name");
            xmlClass.setString("com.tangosol.coherence.rest.server.DefaultHttpServer");
        }
        try {
            this.setHttpServer(XmlHelper.createInstance(xmlAcceptor, this.getContextClassLoader(), null, Class.forName("com.tangosol.coherence.rest.server.HttpServer")));
        }
        catch (ClassNotFoundException e) {
            throw Base.ensureRuntimeException(e);
        }
        XmlElement xmlLocal = xmlAcceptor.getSafeElement("local-address");
        String sAddr = xmlLocal.getSafeElement("address").getString(this.getLocalAddress());
        if (sAddr.length() == 0) {
            sAddr = this.getLocalAddress();
        }
        this.setLocalAddress(sAddr);
        int nPort = xmlLocal.getSafeElement("port").getInt(this.getLocalPort());
        if (nPort <= 0 ? true : nPort > 65535) {
            throw new IllegalArgumentException(String.valueOf("invalid port in local-address:\n") + xmlLocal);
        }
        this.setLocalPort(nPort);
        XmlElement xmlConfig = xmlAcceptor.ensureElement("resource-config");
        if (XmlHelper.isInstanceConfigEmpty(xmlConfig)) {
            XmlElement xmlInstance = xmlConfig.ensureElement("instance");
            XmlElement xmlClass = xmlInstance.ensureElement("class-name");
            xmlClass.setString("com.tangosol.coherence.rest.server.DefaultResourceConfig");
        }
        try {
            this.setResourceConfig(XmlHelper.createInstance(xmlConfig, this.getContextClassLoader(), null, Class.forName("com.sun.jersey.api.core.ResourceConfig")));
        }
        catch (ClassNotFoundException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public String getDescription() {
        Object oServer = this.getHttpServer();
        Object oConfig = this.getResourceConfig();
        return String.valueOf("HttpServer=") + (oServer == null ? "null" : oServer.getClass().getName()) + ", LocalAddress=" + this.getLocalAddress() + ", LocalPort=" + this.getLocalPort() + ", ResourceConfig=" + (oConfig == null ? "null" : oConfig.getClass().getName());
    }

    public Object getHttpServer() {
        return this.__m_HttpServer;
    }

    public String getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public int getLocalPort() {
        return this.__m_LocalPort;
    }

    public Object getResourceConfig() {
        return this.__m_ResourceConfig;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/HttpAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new HttpAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        throw new UnsupportedOperationException();
    }

    protected void onServiceStarting() {
        super.onServiceStarting();
        Object oServer = this.getHttpServer();
        Component._assert(oServer != null);
        Object oConfig = this.getResourceConfig();
        Component._assert(oConfig != null);
        try {
            ClassHelper.invoke(oServer, "setLocalAddress", new Object[]{this.getLocalAddress()});
            ClassHelper.invoke(oServer, "setLocalPort", new Object[]{this.getLocalPort()});
            ClassHelper.invoke(oServer, "setResourceConfig", new Object[]{oConfig});
            ClassHelper.invoke(oServer, "start", ClassHelper.VOID);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
        Component._trace(String.valueOf("HttpAcceptor now listening for connections on ") + this.getLocalAddress() + ':' + this.getLocalPort(), 3);
    }

    protected void onServiceStopped() {
        super.onServiceStopped();
        try {
            Object oServer = this.getHttpServer();
            if (oServer != null) {
                ClassHelper.invoke(oServer, "stop", ClassHelper.VOID);
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void onServiceStopping() {
        super.onServiceStopping();
        try {
            Object oServer = this.getHttpServer();
            if (oServer != null) {
                ClassHelper.invoke(oServer, "stop", ClassHelper.VOID);
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void setHttpServer(Object pHttpServer) {
        this.__m_HttpServer = pHttpServer;
    }

    protected void setLocalAddress(String sAddress) {
        this.__m_LocalAddress = sAddress;
    }

    protected void setLocalPort(int nPort) {
        this.__m_LocalPort = nPort;
    }

    protected void setResourceConfig(Object config) {
        this.__m_ResourceConfig = config;
    }
}

