/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.BatchView;
import com.tangosol.coherence.reporter.ColumnView;
import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.DateView;
import com.tangosol.coherence.reporter.JMXQueryHandler;
import com.tangosol.coherence.reporter.NodeView;
import com.tangosol.coherence.reporter.QueryHandler;
import com.tangosol.coherence.reporter.ReportColumnView;
import com.tangosol.net.CacheFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Reporter
extends Base
implements Constants {
    protected List m_listDisplay = null;
    protected DateFormat m_dateFormat;
    protected List m_listXmlCol = null;
    protected Map m_mapColumns = new HashMap();
    protected String m_sDescTemplate;
    protected String m_sQueryTemp;
    public long m_lBatch;
    protected XmlElement m_xml;
    protected char m_cDelim;
    protected XmlElement m_xmlFilter;
    protected boolean m_fHeaders;
    protected String m_sFileTempl;
    protected QueryHandler m_queryHandler;
    protected boolean m_fGroupBy;
    public static Map m_mapColumnClass = new HashMap();

    public static void main(String[] asArg) {
        int cArgs = asArg.length;
        if (cArgs == 0) {
            Reporter.showUsage();
            return;
        }
        String sConfigFile = asArg[0];
        String sOutputPath = cArgs > 1 ? asArg[1] : "";
        long lBatchId = cArgs > 2 ? Long.parseLong(asArg[2]) : 1L;
        CacheFactory.ensureCluster();
        new Reporter().run(sConfigFile, sOutputPath, lBatchId, null, null);
    }

    public void run(String sConfigFile, String sPathTemplate, long lBatch, XmlElement xmlParams) {
        this.run(sConfigFile, sPathTemplate, lBatch, xmlParams, null);
    }

    public void run(String sConfigFile, String sPathTemplate, long lBatch, XmlElement xmlParams, ClassLoader loader) {
        this.setBatch(lBatch);
        XmlElement xmlReports = XmlHelper.loadFileOrResource(sConfigFile, "Reporter configuration", loader);
        xmlReports = this.replaceParams(xmlReports, xmlParams);
        XmlElement xmlConfig = xmlReports.getElement("report");
        if (xmlConfig == null) {
            return;
        }
        this.setConfig(xmlConfig);
        XmlElement xmlQuery = xmlConfig.getElement("query");
        char cDelim = this.getDelim();
        String sDesc = this.getDescTemplate();
        boolean fHeaders = this.m_fHeaders;
        QueryHandler handler = this.ensureQueryHandler(xmlConfig, xmlQuery, lBatch);
        handler.execute();
        Set setBeans = (Set)handler.getKeys();
        if (setBeans.size() > 0) {
            this.initDisplayColumns();
            List listDisplay = this.ensureDisplayList();
            boolean fDetail = false;
            for (ReportColumnView columnView : listDisplay) {
                if (columnView == null) continue;
                fDetail |= columnView.isRowDetail() && columnView.isVisible();
            }
            File fileOut = this.getFile(sPathTemplate);
            PrintStream streamOut = this.getPrintStream(fileOut);
            if (fHeaders && fileOut.length() == 0L && setBeans.size() > 0) {
                if ((sDesc = this.replaceMacros(sDesc, null)).length() > 0) {
                    this.writeDescription(streamOut, sDesc);
                }
                this.writeHeader(streamOut, listDisplay, cDelim);
            }
            if (fDetail) {
                Set setKeys = handler.getGroupKeys();
                Iterator iter = setKeys.iterator();
                while (iter.hasNext()) {
                    this.writeDetail(streamOut, listDisplay, iter.next(), cDelim);
                }
            } else {
                Iterator iter = handler.getGroupKeys().iterator();
                Object oFirstKey = iter.hasNext() ? iter.next() : null;
                this.writeDetail(streamOut, listDisplay, oFirstKey, cDelim);
            }
            streamOut.close();
        }
        handler.postProcess();
    }

    public XmlElement replaceParams(XmlElement xmlReports, XmlElement xmlParams) {
        XmlHelper.replaceSystemProperties(xmlReports, "system-property");
        SimpleElement xmlParseParams = new SimpleElement();
        if (xmlParams != null) {
            XmlHelper.transformInitParams(xmlParseParams, xmlParams);
        }
        Reporter.replaceInitParams(xmlReports, xmlParseParams);
        return xmlReports;
    }

    protected void initDisplayColumns() {
        List listXmlCol = this.m_listXmlCol;
        Map mapColumns = this.ensureColumnMap();
        List listDisplay = this.ensureDisplayList();
        if (mapColumns.isEmpty()) {
            ColumnView view;
            for (XmlElement xmlColumn : listXmlCol) {
                ReportColumnView columnView = this.ensureDisplayColumn(xmlColumn);
                this.m_fGroupBy |= xmlColumn.getSafeElement("group-by").getBoolean(false);
                listDisplay.add(columnView);
                mapColumns.put(columnView.getId(), columnView);
            }
            if (mapColumns.get("batch") == null) {
                view = new BatchView();
                view.setQueryHandler(this.m_queryHandler);
                mapColumns.put("batch", view);
            }
            if (mapColumns.get("date") == null) {
                view = new DateView();
                view.setQueryHandler(this.m_queryHandler);
                mapColumns.put("date", view);
            }
            if (mapColumns.get("node") == null) {
                mapColumns.put("node", new NodeView());
            }
        }
    }

    public ReportColumnView ensureDisplayColumn(XmlElement xmlColumn) {
        XmlValue xmlId = xmlColumn.getAttribute("id");
        XmlElement xmlColDef = xmlColumn;
        if (xmlId != null) {
            String sId = xmlId.getString();
            xmlColDef = this.getColumnById(xmlColumn, sId);
        }
        ColumnView columnView = new ColumnView();
        columnView.configure(xmlColDef);
        columnView.setQueryHandler(this.m_queryHandler);
        columnView.configure(xmlColDef);
        columnView.setDateFormat(this.m_dateFormat);
        return columnView;
    }

    protected XmlElement getColumnById(XmlElement xmlColumn, String sId) {
        XmlElement xmlRow = Reporter.getRowXml(xmlColumn);
        List listXml = xmlRow.getElementList();
        for (XmlElement xmlSub : listXml) {
            String sTemp = xmlSub.getSafeAttribute("id").getString();
            if (!sTemp.equals(sId)) continue;
            return xmlSub;
        }
        return null;
    }

    protected static XmlElement getRowXml(XmlElement xml) {
        XmlElement xmlTemp = xml;
        while (xmlTemp.getElement("row") == null) {
            if ((xmlTemp = xmlTemp.getParent()) != null) continue;
            return null;
        }
        return xmlTemp.getElement("row");
    }

    protected void writeDescription(PrintStream wps, String sDesc) {
        wps.println(sDesc);
        wps.flush();
    }

    protected void writeDetail(PrintStream wps, List listColumn, Object oSource, char cDelim) {
        int c = 0;
        for (ReportColumnView columnView : listColumn) {
            if (columnView == null || !columnView.isVisible()) continue;
            if (c != 0) {
                wps.print(cDelim);
            }
            ++c;
            wps.print(columnView.getOutputString(oSource));
        }
        wps.println();
        wps.flush();
    }

    protected void writeHeader(PrintStream wps, List listColumn, char cDelim) {
        int c = 0;
        for (ReportColumnView columnView : listColumn) {
            if (columnView == null || !columnView.isVisible()) continue;
            if (c != 0) {
                wps.print(cDelim);
            }
            ++c;
            String oResult = columnView.getHeader();
            String sData = oResult == null ? "" : oResult.toString();
            wps.print(sData);
        }
        wps.println();
        wps.flush();
    }

    public String currentKey(String sKey) {
        if (sKey.length() == 0) {
            return "";
        }
        String[] arKey = Base.parseDelimitedString(sKey, '/');
        return arKey[0];
    }

    protected char getDelim() {
        int cDelim = this.m_cDelim;
        if (cDelim == 0) {
            String sDelim = this.m_xml.getSafeElement("delim").getString("{tab}");
            cDelim = sDelim.equals("{tab}") ? 9 : (sDelim.equals("{space}") ? 32 : (int)sDelim.charAt(0));
        }
        this.m_cDelim = cDelim;
        return (char)cDelim;
    }

    public String getDescTemplate() {
        return this.m_sDescTemplate;
    }

    public Map ensureColumnMap() {
        HashMap mapColumns = this.m_mapColumns;
        if (mapColumns == null) {
            this.m_mapColumns = mapColumns = new HashMap();
        }
        return mapColumns;
    }

    public long getBatch() {
        return this.m_lBatch;
    }

    public void setBatch(long lBatch) {
        this.m_lBatch = lBatch;
    }

    protected List ensureDisplayList() {
        if (this.m_listDisplay == null) {
            this.m_listDisplay = new LinkedList();
        }
        return this.m_listDisplay;
    }

    protected File getFile(String sPathTempl) {
        try {
            String sFileTempl = this.m_sFileTempl;
            String sFilename = this.replaceMacros(this.getFileTemplate(sFileTempl, sPathTempl), null);
            if (sFilename.length() == 0) {
                Reporter.log("Report writer:No output file specified. Report terminated");
                return null;
            }
            File fOut = new File(sFilename);
            if (!fOut.exists()) {
                fOut.createNewFile();
            }
            return fOut;
        }
        catch (IOException e) {
            throw Reporter.ensureRuntimeException(e, "Invalid or unable to create output file.");
        }
    }

    protected PrintStream getPrintStream(File fOut) {
        try {
            FileOutputStream os = new FileOutputStream(fOut, true);
            return new PrintStream(new BufferedOutputStream(os));
        }
        catch (FileNotFoundException e) {
            throw Reporter.ensureRuntimeException(e);
        }
    }

    protected String getFileTemplate(String sTemplate, String sPath) {
        String sFileName = sTemplate;
        if (sFileName.length() == 0) {
            Reporter.log("Report writer:No output file specified. Report terminated");
            return null;
        }
        sFileName = sPath + sFileName;
        return sFileName;
    }

    protected void setDateFormat(DateFormat df) {
        this.m_dateFormat = df;
    }

    public static void showUsage() {
        Reporter.out();
        Reporter.out("java com.tangosol.coherence.reporter.Reporter <report-config> [[<output-directory> [<batchId>]]");
        Reporter.out();
        Reporter.out("command option descriptions:");
        Reporter.out("\t<report-config> the file containing the report configuration XML");
        Reporter.out();
        Reporter.out("\t<output-directory> (optional) the path where the output files are created.");
        Reporter.out("\t(default is the current directory)");
        Reporter.out();
        Reporter.out("\t<batchId> (optional) a long indentifier for the report execution.");
        Reporter.out("\tThe batchId is useful when differientiating data from different");
        Reporter.out("\texecutions contained in a single file");
        Reporter.out("\t (default is 1)");
        Reporter.out();
    }

    protected String replaceMacros(String sTemplate, Object source) {
        String sRet = sTemplate;
        Set setMacros = Reporter.getMacros(sTemplate);
        for (String sId : setMacros) {
            ReportColumnView columnView = (ReportColumnView)this.ensureColumnMap().get(sId);
            String oValue = columnView.getOutputString(source);
            if (columnView == null || oValue == null) continue;
            sRet = sRet.replaceAll("\\{" + sId + "\\}", oValue.toString());
        }
        return sRet;
    }

    public static Set getMacros(String sTemplate) {
        HashSet<String> listRet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(sTemplate, "{}", true);
        while (st.hasMoreTokens()) {
            String sToken = st.nextToken();
            if (!sToken.equals("{")) continue;
            String sAttrib = st.nextToken();
            listRet.add(sAttrib);
            sToken = st.nextToken();
            if (sToken.equals("}")) continue;
            Base.log("Error processing string \"" + sTemplate + "\". Unmatched brace {.");
            return null;
        }
        return listRet;
    }

    public static Set getMacroDefaults(String sTemplate) {
        HashMap<String, String> mapResults = new HashMap<String, String>();
        int ofStart = sTemplate.indexOf(123);
        int ofEnd = -1;
        while (ofStart >= 0) {
            ofEnd = sTemplate.indexOf(125, ofStart);
            if (ofEnd < 0) {
                CacheFactory.log("Invalid attribute format: " + sTemplate, 1);
                break;
            }
            String sAttrName = sTemplate.substring(ofStart + 1, ofEnd);
            String sDefault = null;
            int ofDefault = sAttrName.indexOf(32);
            if (ofDefault > 0) {
                sDefault = sAttrName.substring(ofDefault + 1).trim();
                sAttrName = sAttrName.substring(0, ofDefault);
            }
            mapResults.put(sAttrName, sDefault);
            ofStart = sTemplate.indexOf(123, ofEnd);
        }
        return mapResults.entrySet();
    }

    protected static int columnFromString(String sType) {
        if (sType.equals("global")) {
            return 4;
        }
        if (sType.equals("function")) {
            return 1;
        }
        if (sType.equals("method")) {
            return 2;
        }
        if (sType.equals("key")) {
            return 3;
        }
        if (sType.equals("")) {
            return 0;
        }
        if (sType.equals("attribute")) {
            return 0;
        }
        return -1;
    }

    public void setConfig(XmlElement xmlReportCfg) {
        if (this.m_xml == null) {
            this.m_xml = xmlReportCfg;
            XmlElement xmlQuery = xmlReportCfg.getSafeElement("query");
            XmlElement xmlRow = xmlReportCfg.getElement("row");
            this.m_sDescTemplate = xmlReportCfg.getSafeElement("description").getString();
            this.m_sQueryTemp = xmlQuery.getSafeElement("pattern").getString();
            this.m_xmlFilter = xmlQuery.getSafeElement("filter-ref");
            this.m_fHeaders = !xmlReportCfg.getSafeElement("hide-headers").getBoolean(false);
            this.m_listXmlCol = xmlRow.getElementList();
            this.m_sFileTempl = xmlReportCfg.getSafeElement("file-name").getString();
            List listXmlCol = this.m_listXmlCol;
            for (XmlElement xmlColumn : listXmlCol) {
                this.m_fGroupBy |= xmlColumn.getSafeElement("group-by").getBoolean(false);
            }
        }
    }

    public static void replaceInitParams(XmlElement xml, XmlElement xmlParams) {
        String sTemplate = xml.getString();
        if (sTemplate != null && sTemplate.length() > 0) {
            String sRet = sTemplate;
            Set setMacros = Reporter.getMacroDefaults(sTemplate);
            for (Map.Entry entry : setMacros) {
                String sId;
                String sMacro = (String)entry.getKey();
                Object oDefault = entry.getValue();
                String sDefault = oDefault == null ? null : oDefault.toString();
                String sValue = xmlParams == null ? null : xmlParams.getSafeElement(sMacro).getString();
                String string = sId = sDefault == null ? sMacro : sMacro + " " + sDefault;
                if (sValue != null && sValue.length() > 0) {
                    sRet = sRet.replaceAll("\\{" + sId + "\\}", sValue);
                    continue;
                }
                if (sDefault == null) continue;
                sRet = sRet.replaceAll("\\{" + sId + "\\}", sDefault);
            }
            if (!sRet.equals(sTemplate)) {
                xml.setString(sRet);
            }
        }
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            Reporter.replaceInitParams((XmlElement)iter.next(), xmlParams);
        }
    }

    public XmlElement getConfig() {
        return this.m_xml;
    }

    public QueryHandler ensureQueryHandler(XmlElement xmlConfig, XmlElement xmlQuery, long lBatch) {
        QueryHandler qh = this.m_queryHandler;
        if (qh == null) {
            qh = new JMXQueryHandler();
            qh.setContext(xmlQuery, xmlConfig);
            this.m_queryHandler = qh;
        }
        ((JMXQueryHandler)qh).setBatch(lBatch);
        return qh;
    }

    protected static Object getColumnKey(XmlElement xmlColumn) {
        XmlValue xmlTemp = xmlColumn.getAttribute("id");
        if (xmlTemp == null) {
            return xmlColumn;
        }
        return xmlTemp.getString();
    }

    public static int compare(Object o1, Object o2) {
        return o1 instanceof Comparable && o2 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : String.valueOf(o1).compareTo(String.valueOf(o2));
    }

    static {
        String sBase = "com.tangosol.coherence.reporter.";
        m_mapColumnClass.put("attribute", sBase + "AttributeColumn");
        m_mapColumnClass.put("subquery", sBase + "SubQueryColumn");
        m_mapColumnClass.put("constant", sBase + "ConstantColumn");
        m_mapColumnClass.put("property", sBase + "PropertyColumn");
        m_mapColumnClass.put("global,{batch-counter}", sBase + "BatchColumn");
        m_mapColumnClass.put("global,{report-time}", sBase + "DateTimeColumn");
        m_mapColumnClass.put("key", sBase + "KeyColumn");
        m_mapColumnClass.put("function,sum", sBase + "SumColumn");
        m_mapColumnClass.put("function,count", sBase + "CountColumn");
        m_mapColumnClass.put("function,avg", sBase + "AverageColumn");
        m_mapColumnClass.put("function,min", sBase + "MinColumn");
        m_mapColumnClass.put("function,max", sBase + "MaxColumn");
        m_mapColumnClass.put("function,delta", sBase + "DeltaColumn");
        m_mapColumnClass.put("function,divide", sBase + "DivideSource");
        m_mapColumnClass.put("function,add", sBase + "AddSource");
        m_mapColumnClass.put("function,subtract", sBase + "SubtractSource");
        m_mapColumnClass.put("function,multiply", sBase + "MultiplySource");
    }
}

