/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.OptimisticNamedCache;
import com.tangosol.coherence.transaction.internal.MapEventValue;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;

public class MapListenerWrapper
implements MapListener {
    private MapListener m_listener;
    private OptimisticNamedCache m_cache;

    public MapListenerWrapper(MapListener listener, OptimisticNamedCache cache) {
        this.m_listener = listener;
        this.m_cache = cache;
    }

    @Override
    public void entryInserted(MapEvent evt) {
        MapEventValue eventValue = (MapEventValue)evt.getNewValue();
        Object oKey = evt.getKey();
        int nId = eventValue.getId();
        Object oVal = eventValue.getValue();
        Object oOldVal = evt.getOldValue();
        MapEvent event = new MapEvent(this.m_cache, nId, oKey, oOldVal, oVal);
        switch (nId) {
            case 1: {
                this.m_listener.entryInserted(event);
                break;
            }
            case 2: {
                this.m_listener.entryUpdated(event);
                break;
            }
            case 3: {
                this.m_listener.entryDeleted(event);
                break;
            }
            default: {
                throw new RuntimeException("Unknown map event id: " + evt.getId());
            }
        }
    }

    @Override
    public void entryUpdated(MapEvent evt) {
    }

    @Override
    public void entryDeleted(MapEvent evt) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapListenerWrapper)) {
            return false;
        }
        MapListenerWrapper that = (MapListenerWrapper)o;
        return this.m_listener.equals(that.m_listener) && this.m_cache.equals(that.m_cache);
    }

    public int hashCode() {
        return 7 + this.m_listener.hashCode() + this.m_cache.hashCode();
    }
}

