/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.util;

import com.tangosol.coherence.transaction.internal.FilterWrapper;
import com.tangosol.coherence.transaction.internal.OptimisticNamedCacheImpl;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.operation.EntrySetOperation;
import com.tangosol.coherence.transaction.internal.operation.InvokeFilterOperation;
import com.tangosol.coherence.transaction.internal.operation.QueryOperation;
import com.tangosol.coherence.transaction.internal.util.PartitionedIteratorWrapper;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.processor.UpdaterProcessor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class PartitionedSetWrapper
implements Set {
    protected final QueryOperation m_operation;
    private final OptimisticNamedCacheImpl m_cache;

    public PartitionedSetWrapper(QueryOperation operation, OptimisticNamedCacheImpl cache) {
        this.m_operation = operation;
        this.m_cache = cache;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator iterator() {
        return new PartitionedIteratorWrapper(this);
    }

    @Override
    public boolean isEmpty() {
        return this.m_cache.isEmpty();
    }

    @Override
    public int size() {
        return this.m_cache.size();
    }

    @Override
    public void clear() {
        this.getCache().clear();
    }

    @Override
    public Object[] toArray() {
        return this.getCompleteSet().toArray();
    }

    @Override
    public Object[] toArray(Object[] ao) {
        return this.getCompleteSet().toArray(ao);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PartitionedSetWrapper)) {
            return false;
        }
        PartitionedSetWrapper that = (PartitionedSetWrapper)o;
        return this.m_cache.equals(that.m_cache);
    }

    @Override
    public int hashCode() {
        return this.m_cache.hashCode();
    }

    protected OptimisticNamedCacheImpl getCache() {
        return this.m_cache;
    }

    protected QueryOperation getOperation() {
        return this.m_operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getPartitionedSet(int nPartition) {
        QueryOperation queryOperation = this.m_operation;
        synchronized (queryOperation) {
            Set set;
            QueryOperation op = this.getOperation();
            PartitionSet parts = op.getPartitionSet();
            parts.add(nPartition);
            try {
                set = this.getSet(this.getCache().invoke(op).getResults());
                parts.remove(nPartition);
            }
            catch (Throwable throwable) {
                parts.remove(nPartition);
                throw throwable;
            }
            return set;
        }
    }

    protected boolean updateAll(Filter filter, Object oValue) {
        InvokeFilterOperation op = new InvokeFilterOperation(this.m_operation.getServiceName());
        OptimisticNamedCacheImpl cache = this.getCache();
        filter = new FilterWrapper(filter, cache.getServiceContext(), cache.getCacheName());
        op.setPredicate(filter);
        op.setEntryProcessor(new UpdaterProcessor((ValueUpdater)null, oValue));
        Results results = cache.invoke(op).getResults();
        return results != null && results.size() > 0;
    }

    protected Set getCompleteSet() {
        EntrySetOperation op = new EntrySetOperation(this.m_operation.getServiceName());
        OptimisticNamedCacheImpl cache = this.getCache();
        op.setPredicate(new FilterWrapper(AlwaysFilter.INSTANCE, cache.getServiceContext(), cache.getCacheName()));
        Results results = cache.invoke(op).getResults();
        return this.getSet(results);
    }

    protected abstract Set getSet(Map var1);
}

