/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Annotation;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AnnotationDefaultAttribute
extends Attribute
implements Constants {
    private Annotation.AbstractElementValue m_elementValue;
    private boolean m_fModified;

    protected AnnotationDefaultAttribute(VMStructure context) {
        super(context, "AnnotationDefault");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_elementValue = Annotation.AbstractElementValue.loadElementValue(stream, pool);
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        this.m_elementValue.preassemble(pool);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(this.m_elementValue.getSize());
        this.m_elementValue.assemble(stream, pool);
    }

    @Override
    public String toString() {
        return super.getName() + '=' + this.m_elementValue;
    }

    public Annotation.AbstractElementValue getElementValue() {
        return this.m_elementValue;
    }

    public void setElementValue(Annotation.AbstractElementValue elementValue) {
        this.m_elementValue = elementValue;
        this.m_fModified = true;
    }

    @Override
    public boolean isModified() {
        return this.m_fModified || this.m_elementValue.isModified();
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
    }
}

