/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.Case;
import com.tangosol.dev.assembler.Catch;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.GuardedSection;
import com.tangosol.dev.assembler.Jsr;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.LineNumberTableAttribute;
import com.tangosol.dev.assembler.LocalVariableTableAttribute;
import com.tangosol.dev.assembler.LocalVariableTypeTableAttribute;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpBranch;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpStore;
import com.tangosol.dev.assembler.OpSwitch;
import com.tangosol.dev.assembler.OpVariable;
import com.tangosol.dev.assembler.Ret;
import com.tangosol.dev.assembler.Switch;
import com.tangosol.dev.assembler.Try;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.util.StringTable;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CodeAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "CodeAttribute";
    private static final byte[] NO_BYTES = new byte[0];
    private static final Label[] LABEL_ARRAY = new Label[0];
    private static final int CLEAR = 0;
    private static final int ADDED = 1;
    private static final int LOADED = 2;
    private static final int DISASSEMBLED = 3;
    private static final int ASSEMBLED = 4;
    private static final UtfConstant CONST_LINENUMBERS = new UtfConstant("LineNumberTable");
    private static final UtfConstant CONST_VARIABLES = new UtfConstant("LocalVariableTable");
    private int m_nState;
    private ConstantPool m_pool;
    private boolean m_fModified;
    private int m_cVars;
    private int m_cwStack;
    private byte[] m_abCode;
    private Op m_opFirst;
    private Op m_opLast;
    private int m_iLine;
    private Vector m_vectCatch = new Vector();
    private StringTable m_tblAttribute = new StringTable();

    protected CodeAttribute(VMStructure context) {
        super(context, "Code");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_cwStack = stream.readUnsignedShort();
        this.m_cVars = stream.readUnsignedShort();
        int cbCode = stream.readInt();
        this.m_abCode = new byte[cbCode];
        stream.readFully(this.m_abCode);
        this.m_pool = pool;
        this.m_vectCatch.clear();
        int cExcept = stream.readUnsignedShort();
        for (int i = 0; i < cExcept; ++i) {
            GuardedSection section = new GuardedSection();
            section.disassemble(stream, pool);
            this.m_vectCatch.add(section);
        }
        this.m_tblAttribute.clear();
        int cAttr = stream.readUnsignedShort();
        for (int i = 0; i < cAttr; ++i) {
            Attribute attribute = Attribute.loadAttribute(this, stream, pool);
            this.m_tblAttribute.put(attribute.getIdentity(), attribute);
        }
        this.m_nState = 2;
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        this.ensureOps();
        this.preassembleOps(pool);
        Enumeration enmr = this.m_vectCatch.elements();
        while (enmr.hasMoreElements()) {
            ((GuardedSection)enmr.nextElement()).preassemble(pool);
        }
        enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            ((Attribute)enmr.nextElement()).preassemble(pool);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        this.assembleOps(pool);
        byte[] abAttr = NO_BYTES;
        int cAttrs = this.m_tblAttribute.getSize();
        if (cAttrs > 0) {
            ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
            DataOutputStream streamAttr = new DataOutputStream(streamRaw);
            Enumeration enmr = this.m_tblAttribute.elements();
            while (enmr.hasMoreElements()) {
                ((Attribute)enmr.nextElement()).assemble(streamAttr, pool);
            }
            abAttr = streamRaw.toByteArray();
        }
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(8 + this.m_abCode.length + 2 + 8 * this.m_vectCatch.size() + 2 + abAttr.length);
        stream.writeShort(this.m_cwStack);
        stream.writeShort(this.m_cVars);
        stream.writeInt(this.m_abCode.length);
        stream.write(this.m_abCode);
        stream.writeShort(this.m_vectCatch.size());
        Enumeration enmr = this.m_vectCatch.elements();
        while (enmr.hasMoreElements()) {
            ((GuardedSection)enmr.nextElement()).assemble(stream, pool);
        }
        stream.writeShort(cAttrs);
        stream.write(abAttr);
    }

    @Override
    public boolean isModified() {
        if (this.m_fModified) {
            return true;
        }
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            if (!attr.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            ((Attribute)enmr.nextElement()).resetModified();
        }
    }

    @Override
    public String toString() {
        return "Code attribute for " + this.getContext().toString();
    }

    protected void ensureOps() {
        if (this.m_nState == 2 || this.m_nState == 4) {
            this.disassembleOps();
        }
    }

    protected void disassembleOps() {
        if (this.m_abCode == null || this.m_opFirst != null) {
            throw new IllegalStateException("CodeAttribute.disassembleOps:  No code exists or ops already exist!");
        }
        try {
            Method method = (Method)this.getContext();
            String[] asTypes = method.getTypes();
            if (method.isStatic()) {
                int cNew = asTypes.length - 1;
                String[] asNew = new String[cNew];
                System.arraycopy(asTypes, 1, asNew, 0, cNew);
                asTypes = asNew;
            } else {
                asTypes[0] = 'L' + method.getClassName() + ';';
            }
            Op[] aopBounds = new Op[2];
            Op.disassembleOps(this.m_abCode, this.m_cVars, asTypes, this.m_vectCatch, (LineNumberTableAttribute)this.m_tblAttribute.get("LineNumberTable"), (LocalVariableTableAttribute)this.m_tblAttribute.get("LocalVariableTable"), (LocalVariableTypeTableAttribute)this.m_tblAttribute.get("LocalVariableTypeTable"), this.m_pool, aopBounds);
            this.m_opFirst = aopBounds[0];
            this.m_opLast = aopBounds[1];
        }
        catch (IOException e) {
            throw CodeAttribute.ensureRuntimeException(e);
        }
        this.m_abCode = null;
        this.m_nState = 3;
    }

    protected void preassembleOps(ConstantPool pool) {
        Enumeration enmr;
        if (this.m_nState != 1 && this.m_nState != 3 || this.m_opFirst == null) {
            throw new IllegalStateException("CodeAttribute.preassembleOps:  Illegal state (" + this.m_nState + ") or no ops to assemble!");
        }
        if (!(this.m_opFirst instanceof Label)) {
            Label label = new Label();
            label.setNext(this.m_opFirst);
            this.m_opFirst = label;
        }
        Label labelMain = (Label)this.m_opFirst;
        HashSet<Label> setContexts = new HashSet<Label>();
        setContexts.add(labelMain);
        int cwStack = this.checkStack(labelMain, 0, 0, labelMain, setContexts, 0);
        int cContexts = 0;
        Iterator iter = setContexts.iterator();
        while (iter.hasNext()) {
            ((Label)iter.next()).setContextIndex(cContexts++);
        }
        LineNumberTableAttribute attrLines = new LineNumberTableAttribute(this);
        LocalVariableTableAttribute attrVars = null;
        if (this.m_nState == 3) {
            attrVars = (LocalVariableTableAttribute)this.m_tblAttribute.get("LocalVariableTable");
        }
        if (attrVars == null) {
            attrVars = new LocalVariableTableAttribute(this);
        }
        Begin begin = null;
        HashSet<OpDeclare> setVars = new HashSet<OpDeclare>();
        boolean fDebugInfo = false;
        Vector<OpDeclare> vectVar = new Vector<OpDeclare>();
        int[] aiVar = new int[cContexts];
        int cMaxSlots = 0;
        int iPrevLine = 0;
        Vector<GuardedSection> vectCatch = new Vector<GuardedSection>();
        Op op = this.m_opFirst;
        Op opPrev = null;
        block16: while (op != null) {
            if (op.isDiscardable()) {
                do {
                    if ((op = op.getNext()) != null) continue;
                    opPrev.setNext(null);
                    break block16;
                } while (op.isDiscardable());
                opPrev.setNext(op);
            }
            int iOp = op.getValue();
            switch (iOp) {
                case 234: {
                    Begin beginNew = (Begin)op;
                    beginNew.setVariablePool((int[])aiVar.clone());
                    beginNew.setOuterScope(begin);
                    begin = beginNew;
                    break;
                }
                case 235: {
                    End end = (End)op;
                    if (begin == null) {
                        throw new IllegalStateException("CodeAttribute.preassembleOps:  END without BEGIN!");
                    }
                    begin.setEnd(end);
                    enmr = begin.getDeclarations();
                    while (enmr.hasMoreElements()) {
                        OpDeclare decl = (OpDeclare)enmr.nextElement();
                        setVars.remove(decl);
                    }
                    aiVar = begin.getVariablePool();
                    begin = begin.getOuterScope();
                    break;
                }
                case 236: 
                case 237: 
                case 238: 
                case 239: 
                case 240: 
                case 241: {
                    int iVar;
                    OpDeclare decl = (OpDeclare)op;
                    if (begin == null) {
                        throw new IllegalStateException("CodeAttribute.preassembleOps:  Declaration (?VAR) without BEGIN!");
                    }
                    vectVar.addElement(decl);
                    begin.addDeclaration(decl);
                    decl.setBegin(begin);
                    if (decl.hasDebugInfo()) {
                        fDebugInfo = true;
                        setVars.add(decl);
                    }
                    if ((iVar = decl.getSlot()) == Integer.MIN_VALUE) {
                        int iCtx = decl.getContext().getContextIndex();
                        iVar = aiVar[iCtx];
                        decl.setSlot(iVar);
                        aiVar[iCtx] = iVar + decl.getWidth();
                        break;
                    }
                    int cSlots = iVar + decl.getWidth();
                    if (cSlots <= cMaxSlots) break;
                    cMaxSlots = cSlots;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 132: 
                case 169: 
                case 242: {
                    OpDeclare decl = ((OpVariable)((Object)op)).getVariable();
                    if (decl.getBegin() != null && decl.getEnd() == null) break;
                    throw new IllegalStateException("CodeAttribute.preassembleOps:  Variable used out of scope! " + op);
                }
                case 168: {
                    Jsr jsr = (Jsr)op;
                    int iCtx = jsr.getContext().getContextIndex();
                    jsr.setFirstSlot(aiVar[iCtx]);
                    break;
                }
                case 251: {
                    Label label = (Label)op;
                    label.setVariables((HashSet)setVars.clone());
                    break;
                }
                case 255: {
                    Catch opCatch = (Catch)op;
                    Try opTry = opCatch.getTry();
                    ClassConstant clz = opCatch.getExceptionClass();
                    Label label = opCatch.getLabel();
                    GuardedSection section = new GuardedSection(opTry, opCatch, clz, label);
                    vectCatch.addElement(section);
                }
            }
            int iCurLine = op.getLine();
            if (iCurLine != iPrevLine && iCurLine > 0 && op.hasSize()) {
                attrLines.add(op);
                iPrevLine = iCurLine;
            }
            op.preassemble(pool);
            opPrev = op;
            op = opPrev.getNext();
        }
        if (begin != null) {
            throw new IllegalStateException("CodeAttribute.preassembleOps:  BEGIN without END!");
        }
        if (cMaxSlots == 0) {
            Object[] alabelContext = setContexts.toArray(LABEL_ARRAY);
            Arrays.sort(alabelContext);
            if (alabelContext.length != cContexts) {
                throw new IllegalStateException("CodeAttribute.preassembleOps:  Unexpected number of contexts!");
            }
            if (((Label)alabelContext[0]).getDepth() != 0 || cContexts > 1 && ((Label)alabelContext[1]).getDepth() != 1) {
                throw new IllegalStateException("CodeAttribute.preassembleOps:  Unexpected depths of contexts!");
            }
            for (int i = 0; i < cContexts; ++i) {
                Object labelContext = alabelContext[i];
                int iFirstSlot = 0;
                enmr = ((Label)labelContext).getCallers();
                while (enmr.hasMoreElements()) {
                    Jsr jsr = (Jsr)enmr.nextElement();
                    int iSlot = jsr.getContext().getFirstSlot() + jsr.getFirstSlot();
                    if (iSlot <= iFirstSlot) continue;
                    iFirstSlot = iSlot;
                }
                ((Label)labelContext).setFirstSlot(iFirstSlot);
            }
            Enumeration enmr2 = vectVar.elements();
            while (enmr2.hasMoreElements()) {
                OpDeclare decl = (OpDeclare)enmr2.nextElement();
                int iSlotOffset = decl.getSlot();
                Label labelContext = decl.getContext();
                int iSlot = labelContext.getFirstSlot() + iSlotOffset;
                int cSlots = iSlot + decl.getWidth();
                decl.setSlot(iSlot);
                if (cSlots <= cMaxSlots) continue;
                cMaxSlots = cSlots;
            }
            if (fDebugInfo) {
                Method method = (Method)this.getContext();
                String[] asType = method.getTypes();
                int cTypes = asType.length;
                int cwParams = method.isStatic() ? 0 : 1;
                for (int i = 0; i < cTypes; ++i) {
                    char chType = asType[i].charAt(0);
                    cwParams += OpDeclare.getJavaWidth(chType);
                }
                this.checkAssignment(labelMain, setVars, cwParams);
                HashMap<OpDeclare, Op> mapVars = new HashMap<OpDeclare, Op>();
                block23: for (Op op2 = this.m_opFirst; op2 != null; op2 = op2.getNext()) {
                    switch (op2.getValue()) {
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: {
                            OpDeclare decl = (OpDeclare)op2;
                            if (!decl.hasDebugInfo() || decl.getSlot() >= cwParams || mapVars.containsKey(decl)) continue block23;
                            mapVars.put(decl, decl);
                            continue block23;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 242: {
                            OpStore stor = (OpStore)op2;
                            OpDeclare decl = stor.getVariable();
                            if (!decl.hasDebugInfo() || mapVars.containsKey(decl)) continue block23;
                            mapVars.put(decl, stor);
                            continue block23;
                        }
                        case 251: {
                            Label label = (Label)op2;
                            HashSet setLabelVars = label.getVariables();
                            Iterator iterator = mapVars.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                OpDeclare decl = (OpDeclare)entry.getKey();
                                if (setLabelVars.contains(decl)) continue;
                                Op opInit = (Op)entry.getValue();
                                attrVars.add(decl, opInit, label);
                                iterator.remove();
                            }
                            if (setLabelVars.size() == mapVars.size()) continue block23;
                            for (OpDeclare decl : setLabelVars) {
                                if (mapVars.containsKey(decl)) continue;
                                mapVars.put(decl, label);
                            }
                            continue block23;
                        }
                        case 235: {
                            End end = (End)op2;
                            Iterator iterator = mapVars.entrySet().iterator();
                            while (iterator.hasNext()) {
                                OpDeclare decl;
                                Map.Entry entry = iterator.next();
                                decl = (OpDeclare)entry.getKey();
                                if (decl.getEnd() != end) continue;
                                Op opInit = (Op)entry.getValue();
                                attrVars.add(decl, opInit, end);
                                iterator.remove();
                            }
                            continue block23;
                        }
                    }
                }
            }
        }
        this.m_cVars = cMaxSlots;
        this.m_cwStack = cwStack;
        this.m_vectCatch = vectCatch;
        if (attrLines.isEmpty()) {
            this.m_tblAttribute.remove(attrLines.getIdentity());
        } else {
            this.m_tblAttribute.put(attrLines.getIdentity(), attrLines);
        }
        if (attrLines.isEmpty() || attrVars.isEmpty()) {
            this.m_tblAttribute.remove(attrVars.getIdentity());
        } else {
            this.m_tblAttribute.put(attrVars.getIdentity(), attrVars);
        }
    }

    protected void assembleOps(ConstantPool pool) throws IOException {
        if (this.m_nState != 1 && this.m_nState != 3 || this.m_opFirst == null) {
            throw new IllegalStateException("CodeAttribute.assembleOps:  Illegal state (" + this.m_nState + ") or no ops to assemble!");
        }
        int of = 0;
        for (Op op = this.m_opFirst; op != null; op = op.getNext()) {
            op.setOffset(of);
            op.calculateSize(pool);
            of += op.getSize();
        }
        ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(streamRaw);
        for (Op op = this.m_opFirst; op != null; op = op.getNext()) {
            op.assemble(stream, pool);
        }
        this.m_abCode = streamRaw.toByteArray();
        this.m_nState = 4;
    }

    protected int checkStack(Label labelFirst, int cwCurStack, int cwMaxStack, Label labelContext, Set setContexts, int iSubDepth) {
        if (cwCurStack > cwMaxStack) {
            cwMaxStack = cwCurStack;
        }
        if (labelFirst != labelContext && labelFirst.isSubroutine()) {
            throw new IllegalStateException("CodeAttribute.checkStack:  Label reachable both by subroutine invocation and otherwise!");
        }
        block10: for (Op op = labelFirst; op != null; op = op.getNext()) {
            boolean fVisited = op.isReachable();
            op.setStackHeight(cwCurStack);
            int iOp = op.getValue();
            if (iOp == 168) {
                Jsr jsr = (Jsr)op;
                Label label = jsr.getLabel();
                boolean fSub = label.isSubroutine();
                boolean fPrev = label.isReachable();
                jsr.setContext(labelContext);
                label.addCaller(jsr);
                if (!fSub) {
                    if (fPrev) {
                        throw new IllegalStateException("CodeAttribute.checkStack:  Label reachable both by subroutine invocation and otherwise!");
                    }
                    setContexts.add(label);
                    cwMaxStack = this.checkStack(label, cwCurStack + 1, cwMaxStack, label, setContexts, iSubDepth + 1);
                }
                if (label.getRet() == null) {
                    return cwMaxStack;
                }
            }
            if ((cwCurStack += op.getStackChange()) > cwMaxStack) {
                cwMaxStack = cwCurStack;
            } else if (cwCurStack < 0) {
                throw new IllegalStateException("CodeAttribute.checkStack:  Stack underflow on " + op.toString() + " (#" + op.getValue() + " @" + op.getOffset() + ")!");
            }
            switch (iOp) {
                case 251: {
                    Label label = op;
                    if (fVisited) {
                        if (labelContext != label.getContext()) {
                            throw new IllegalStateException("CodeAttribute.checkStack:  Label " + label + " is reachable within two " + "different code contexts!");
                        }
                        return cwMaxStack;
                    }
                    label.setContext(labelContext);
                    continue block10;
                }
                case 169: {
                    if (iSubDepth > 0) {
                        labelContext.setRet((Ret)op);
                        labelContext.setRetHeight(cwCurStack);
                        return cwMaxStack;
                    }
                    throw new IllegalStateException("CodeAttribute.checkStack:  RET without JSR!");
                }
                case 167: {
                    return this.checkStack(((Goto)op).getLabel(), cwCurStack, cwMaxStack, labelContext, setContexts, iSubDepth);
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    cwMaxStack = this.checkStack(((OpBranch)op).getLabel(), cwCurStack, cwMaxStack, labelContext, setContexts, iSubDepth);
                    continue block10;
                }
                case 170: 
                case 171: 
                case 252: {
                    int i;
                    OpSwitch opswitch = (OpSwitch)op;
                    cwMaxStack = this.checkStack(opswitch.getLabel(), cwCurStack, cwMaxStack, labelContext, setContexts, iSubDepth);
                    Case[] aopCase = opswitch.getCases();
                    int cCases = aopCase.length;
                    for (i = 0; i < cCases; ++i) {
                        cwMaxStack = this.checkStack(aopCase[i].getLabel(), cwCurStack, cwMaxStack, labelContext, setContexts, iSubDepth);
                    }
                    return cwMaxStack;
                }
                case 254: {
                    int i;
                    Try optry = (Try)op;
                    Catch[] aopCatch = optry.getCatches();
                    int cCatches = aopCatch.length;
                    for (i = 0; i < cCatches; ++i) {
                        cwMaxStack = this.checkStack(aopCatch[i].getLabel(), 1, cwMaxStack, labelContext, setContexts, iSubDepth);
                    }
                    continue block10;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return cwMaxStack;
                }
                case 236: 
                case 237: 
                case 238: 
                case 239: 
                case 240: 
                case 241: {
                    OpDeclare decl = (OpDeclare)op;
                    decl.setContext(labelContext);
                }
            }
        }
        throw new IllegalStateException("CodeAttribute.checkStack:  Code not terminated properly!  (e.g. no return)");
    }

    protected void checkAssignment(Label labelFirst, HashSet setVars, int cwParams) {
        block12: for (Op op = labelFirst; op != null; op = op.getNext()) {
            int iOp = op.getValue();
            switch (iOp) {
                case 236: 
                case 237: 
                case 238: 
                case 239: 
                case 240: 
                case 241: {
                    OpDeclare decl = (OpDeclare)op;
                    if (decl.getSlot() >= cwParams) continue block12;
                    setVars.add(decl);
                    continue block12;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 242: {
                    OpStore stor = (OpStore)op;
                    OpDeclare decl = stor.getVariable();
                    setVars.add(decl);
                    continue block12;
                }
                case 251: {
                    Label label = op;
                    HashSet setLabelVars = label.getVariables();
                    if (!setLabelVars.retainAll(setVars) && label.isVisited()) {
                        return;
                    }
                    if (setVars.size() != setLabelVars.size()) {
                        setVars = (HashSet)setLabelVars.clone();
                    }
                    label.setVisited(true);
                    continue block12;
                }
                case 168: {
                    Jsr jsr = (Jsr)op;
                    Label label = jsr.getLabel();
                    Ret ret = label.getRet();
                    this.checkAssignment(label, (HashSet)setVars.clone(), cwParams);
                    if (ret == null) {
                        return;
                    }
                    setVars.addAll(ret.getVariables());
                    continue block12;
                }
                case 169: {
                    Ret ret = (Ret)op;
                    HashSet setRetVars = ret.getVariables();
                    if (setRetVars == null) {
                        ret.setVariables(setVars);
                    } else {
                        setRetVars.retainAll(setVars);
                    }
                    return;
                }
                case 167: {
                    this.checkAssignment(((Goto)op).getLabel(), setVars, cwParams);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.checkAssignment(((OpBranch)op).getLabel(), (HashSet)setVars.clone(), cwParams);
                    continue block12;
                }
                case 170: 
                case 171: 
                case 252: {
                    int i;
                    OpSwitch opswitch = (OpSwitch)op;
                    Case[] aopCase = opswitch.getCases();
                    int cCases = aopCase.length;
                    for (i = 0; i < cCases; ++i) {
                        this.checkAssignment(aopCase[i].getLabel(), (HashSet)setVars.clone(), cwParams);
                    }
                    this.checkAssignment(opswitch.getLabel(), setVars, cwParams);
                    return;
                }
                case 254: {
                    int i;
                    Try optry = (Try)op;
                    Catch[] aopCatch = optry.getCatches();
                    int cCatches = aopCatch.length;
                    for (i = 0; i < cCatches; ++i) {
                        this.checkAssignment(aopCatch[i].getLabel(), (HashSet)setVars.clone(), cwParams);
                    }
                    continue block12;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
        }
        throw new IllegalStateException("CodeAttribute.checkAssignment:  Code not terminated properly!  (e.g. no return)");
    }

    public void clear() {
        this.m_abCode = null;
        this.m_opFirst = null;
        this.m_opLast = null;
        this.m_iLine = 0;
        this.m_vectCatch.clear();
        this.m_nState = 0;
        this.m_fModified = true;
    }

    public Op add(Op op) {
        if (this.m_nState > 1) {
            throw new IllegalStateException("CodeAttribute.add:  Illegal state (" + this.m_nState + ")");
        }
        if (op == null) {
            throw new IllegalArgumentException("CodeAttribute.add:  Op is required!");
        }
        if (op instanceof Case && !(this.m_opLast instanceof Switch) && !(this.m_opLast instanceof Case)) {
            throw new IllegalArgumentException("CodeAttribute.add:  A Case Op can only follow a Switch or a Case op!");
        }
        op.setLine(this.m_iLine);
        if (this.m_opFirst == null) {
            this.m_opFirst = op;
            this.m_opLast = op;
        } else {
            this.m_opLast.setNext(op);
            this.m_opLast = op;
        }
        this.m_nState = 1;
        this.m_fModified = true;
        return op;
    }

    public int getLine() {
        return this.m_iLine;
    }

    public void setLine(int iLine) {
        this.m_iLine = iLine;
    }

    public void nextLine() {
        ++this.m_iLine;
    }

    public Op getFirstOp() {
        this.ensureOps();
        return this.m_opFirst;
    }

    public void print() {
        CodeAttribute.out("Code Listing:");
        for (Op op = this.m_opFirst; op != null; op = op.getNext()) {
            op.print();
        }
        LocalVariableTableAttribute attr = (LocalVariableTableAttribute)this.m_tblAttribute.get("LocalVariableTable");
        if (attr != null) {
            CodeAttribute.out("Local variable table:");
            CodeAttribute.out(attr);
        }
    }

    public String toJasm() {
        StringBuffer sb = new StringBuffer(8192);
        switch (this.m_nState) {
            case 2: {
                this.ensureOps();
            }
            case 3: {
                if (this.m_opFirst != null) {
                    int cDigits = CodeAttribute.getMaxDecDigits(this.m_opLast.getOffset());
                    int nLine = 0;
                    for (Op op = this.m_opFirst; op != null; op = op.getNext()) {
                        String s;
                        int nOpLine = op.getLine();
                        if (nOpLine != nLine) {
                            nLine = nOpLine;
                            sb.append('\n').append(CodeAttribute.toDecString(op.getOffset(), cDigits)).append(": // line ").append(nLine);
                        }
                        if ((s = op.toJasm()) == null) continue;
                        sb.append('\n').append(CodeAttribute.toDecString(op.getOffset(), cDigits)).append(": ").append(s);
                    }
                    break;
                }
            }
            default: {
                for (Op op = this.m_opFirst; op != null; op = op.getNext()) {
                    sb.append("\n[").append(op.getOffset()).append("] (").append(op.getLine()).append(") ").append(op.toString());
                }
            }
        }
        return sb.substring(1);
    }

    public Attribute getAttribute(String sName) {
        return (Attribute)this.m_tblAttribute.get(sName);
    }

    public Attribute addAttribute(String sName) {
        Attribute attribute = sName.equals("LineNumberTable") ? new LineNumberTableAttribute(this) : (sName.equals("LocalVariableTable") ? new LocalVariableTableAttribute(this) : new Attribute((VMStructure)this, sName));
        this.m_tblAttribute.put(attribute.getIdentity(), attribute);
        this.m_fModified = true;
        return attribute;
    }

    public void removeAttribute(String sName) {
        if (this.m_tblAttribute.remove(sName) != null) {
            this.m_fModified = true;
        }
    }
}

