/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

class LHBuffer {
    int group;
    boolean overflow;
    int frame;
    int index;
    byte[] buffer;
    static final int PRIMARY_HEADER_SIZE = 13;
    static final int VER1_GROUP0_HEADER_SIZE = 22;
    static final int GROUP0_HEADER_SIZE = 26;
    static final int OVERFLOW_HEADER_SIZE = 14;
    static final int FREELIST_HEADER_SIZE = 7;
    static final int FREELIST_ELEMENT_SIZE = 4;
    static final int END_OF_GROUP = 128;
    static final int RECORD_MARK = 255;

    LHBuffer(int framesize) {
        this.buffer = new byte[framesize];
    }

    int getType() {
        return this.getInt(0, 1);
    }

    void putType(int i) {
        this.putInt(0, 1, i);
    }

    int getDataForward() {
        return this.getInt(1, 4);
    }

    void putDataForward(int i) {
        this.putInt(1, 4, i);
    }

    int getDataForwardSkip() {
        return this.getInt(5, 4);
    }

    void putDataForwardSkip(int i) {
        this.putInt(5, 4, i);
    }

    int getPrimaryModulo() {
        return this.getInt(9, 4);
    }

    void putPrimaryModulo(int i) {
        this.putInt(9, 4, i);
    }

    int getGroup0FrameSize() {
        return this.getInt(13, 2);
    }

    void putGroup0FrameSize(int i) {
        this.putInt(13, 2, i);
    }

    int getGroup0Alpha() {
        return this.getInt(15, 4);
    }

    void putGroup0Alpha(int i) {
        this.putInt(15, 4, i);
    }

    int getGroup0Threshold() {
        return this.getInt(19, 1);
    }

    void putGroup0Threshold(int i) {
        this.putInt(19, 1, i);
    }

    int getGroup0SizeLock() {
        return this.getInt(20, 2);
    }

    void putGroup0SizeLock(int i) {
        this.putInt(20, 2, i);
    }

    int getGroup0RecordCount() {
        return this.getInt(22, 4);
    }

    void putGroup0RecordCount(int i) {
        this.putInt(22, 4, i);
    }

    int getOverflowGroup() {
        return this.getInt(9, 4);
    }

    void putOverflowGroup(int i) {
        this.putInt(9, 4, i);
    }

    int getFreeListSize() {
        return this.getInt(1, 2);
    }

    void putFreeListSize(int i) {
        this.putInt(1, 2, i);
    }

    int getFreeListNextList() {
        return this.getInt(3, 4);
    }

    void putFreeListNextList(int i) {
        this.putInt(3, 4, i);
    }

    int getFreeListElement(int i) {
        return this.getInt(7 + i * 4, 4);
    }

    void putFreeListElement(int i, int j) {
        this.putInt(7 + i * 4, 4, j);
    }

    boolean EndOfGroup() {
        return this.getInt(this.index, 1) == 128;
    }

    int GetNextByte() {
        return this.getInt(this.index++, 1);
    }

    void PutNextByte(int b) {
        this.putInt(this.index++, 1, b);
    }

    int getInt(int offset, int length) {
        int i = 0;
        offset += length;
        while (length > 0) {
            i = i << 8 | this.buffer[--offset] & 0xFF;
            --length;
        }
        return i;
    }

    void putInt(int offset, int length, int i) {
        while (length > 0) {
            this.buffer[offset] = (byte)i;
            i >>= 8;
            --length;
            ++offset;
        }
    }

    void fill(int offset, int length, int ch) {
        while (length > 0) {
            this.buffer[offset] = (byte)ch;
            --length;
            ++offset;
        }
    }
}

