/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.nio.AbstractBufferManager;
import java.nio.ByteBuffer;

public class DirectBufferManager
extends AbstractBufferManager {
    public static final int CLEANUP_NONE = 0;
    public static final int CLEANUP_FINALIZERS = 1;
    public static final int CLEANUP_GC = 2;
    protected static final boolean MODE_DEBUG = false;
    protected static volatile long s_cbUncollected;
    private static volatile long s_lTotalAllocationTime;
    private static volatile int s_cAllocations;
    private static int s_nCleanupMethod;
    private static float s_fCleanupThreshold;

    public DirectBufferManager(int cbInitial, int cbMaximum) {
        super(cbInitial, cbMaximum);
        this.allocateBuffer();
    }

    @Override
    protected void allocateBuffer() {
        long lStart = System.currentTimeMillis();
        ByteBuffer bufOld = this.getBuffer();
        ByteBuffer bufNew = ByteBuffer.allocateDirect(this.getCapacity());
        int cbOld = 0;
        int cbNew = bufNew.capacity();
        if (bufOld != null) {
            int ofOld = bufOld.position();
            cbOld = bufOld.capacity();
            bufOld.position(0);
            if (cbOld > cbNew) {
                int cbChunk;
                int cbCopy;
                int cbBuf = Math.max(cbCopy, 16384);
                byte[] abBuf = new byte[cbBuf];
                for (cbCopy = Math.min(cbOld, cbNew); cbCopy > 0; cbCopy -= cbChunk) {
                    cbChunk = Math.min(cbBuf, cbCopy);
                    bufOld.get(abBuf, 0, cbChunk);
                    bufNew.put(abBuf, 0, cbChunk);
                }
            } else {
                bufNew.put(bufOld);
            }
            if (ofOld < cbNew) {
                bufNew.position(ofOld);
            }
        }
        s_cbUncollected += (long)cbOld;
        ++s_cAllocations;
        this.setBuffer(bufNew);
        this.cleanupBuffers();
        long cMillis = System.currentTimeMillis() - lStart;
        if (cMillis > 100L) {
            DirectBufferManager.log("Buffer [" + s_cAllocations + "] allocated grew from " + cbOld + " to " + cbNew + " bytes, took " + cMillis + " ms.");
        }
        s_lTotalAllocationTime += cMillis;
    }

    protected void cleanupBuffers() {
        Runtime runtime = Runtime.getRuntime();
        if ((float)s_cbUncollected > (float)runtime.maxMemory() * DirectBufferManager.getCleanupThreshold()) {
            switch (DirectBufferManager.getCleanupMethod()) {
                case 1: {
                    runtime.runFinalization();
                    break;
                }
                case 2: {
                    runtime.gc();
                    break;
                }
            }
            s_cbUncollected = 0L;
        }
    }

    public static long getTotalAllocationTime() {
        return s_lTotalAllocationTime;
    }

    public static int getAllocations() {
        return s_cAllocations;
    }

    public static int getCleanupMethod() {
        return s_nCleanupMethod;
    }

    protected static void setCleanupMethod(int nCleanupMethod) {
        if (nCleanupMethod < 0 || nCleanupMethod > 2) {
            throw new IllegalArgumentException("Invalid cleanup method: " + nCleanupMethod);
        }
        s_nCleanupMethod = nCleanupMethod;
    }

    public static float getCleanupThreshold() {
        return s_fCleanupThreshold;
    }

    protected static void setCleanupThreshold(float flCleanupThreshold) {
        if ((double)flCleanupThreshold < 0.0 || (double)flCleanupThreshold > 1.0) {
            throw new IllegalArgumentException("Invalid cleanup threshold: " + flCleanupThreshold);
        }
        s_fCleanupThreshold = flCleanupThreshold;
    }

    static {
        DirectBufferManager.setCleanupThreshold(Float.parseFloat(System.getProperty("tangosol.coherence.nio.cleanup.frequency", "0.10F")));
        String sCleanupMethod = System.getProperty("tangosol.coherence.nio.cleanup.method", "FINALIZERS");
        if (sCleanupMethod.equalsIgnoreCase("FINALIZERS")) {
            DirectBufferManager.setCleanupMethod(1);
        } else if (sCleanupMethod.equalsIgnoreCase("GC")) {
            DirectBufferManager.setCleanupMethod(2);
        } else {
            DirectBufferManager.setCleanupMethod(0);
        }
    }
}

