/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;

public class EnumPofSerializer
implements PofSerializer {
    @Override
    public void serialize(PofWriter writer, Object o) throws IOException {
        if (!o.getClass().isEnum()) {
            throw new IllegalArgumentException("EnumPofSerializer can only be used to serialize enum types.");
        }
        writer.writeString(0, ((Enum)o).name());
        writer.writeRemainder(null);
    }

    @Override
    public Object deserialize(PofReader reader) throws IOException {
        PofContext ctx = reader.getPofContext();
        Class clz = ctx.getClass(reader.getUserTypeId());
        if (!clz.isEnum()) {
            throw new IllegalArgumentException("EnumPofSerializer can only be used to deserialize enum types.");
        }
        Object enumValue = Enum.valueOf(clz, reader.readString(0));
        reader.registerIdentity(enumValue);
        reader.readRemainder();
        return enumValue;
    }
}

