/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.events.PartitionedServiceDispatcher;
import com.tangosol.net.events.internal.AbstractEvent;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Continuation;
import java.util.HashSet;
import java.util.Set;

public class ServiceDispatcher
extends AbstractEventDispatcher
implements PartitionedServiceDispatcher {
    protected static final Set<Enum> EVENT_TYPES = new HashSet<Enum>();
    protected PartitionedService m_service;

    public ServiceDispatcher(PartitionedService service) {
        super(EVENT_TYPES);
        this.m_service = service;
    }

    @Override
    public PartitionedService getService() {
        return this.m_service;
    }

    public Continuation getTransferEventContinuation(PartitionedServiceDispatcher.TransferEvent.Type eventType, PartitionedService service, String sCacheName, int nPartition, Member memberLocal, Member memberRemote, Set<BinaryEntry> setBinEntry, Continuation continuation) {
        TransferEvent event = new TransferEvent(eventType, service, sCacheName, nPartition, memberLocal, memberRemote, setBinEntry);
        return this.getDispatchContinuation(event, continuation);
    }

    static {
        EVENT_TYPES.add(PartitionedServiceDispatcher.TransferEvent.Type.ARRIVED);
        EVENT_TYPES.add(PartitionedServiceDispatcher.TransferEvent.Type.DEPARTING);
    }

    protected static class TransferEvent
    extends AbstractEvent
    implements PartitionedServiceDispatcher.TransferEvent {
        protected String m_sCacheName;
        protected Member m_memberLocal;
        protected Member m_memberRemote;
        protected int m_nPartition;
        protected PartitionedService m_service;
        protected Set<BinaryEntry> m_setBinEntry;

        protected TransferEvent(Enum eventType, PartitionedService service, String sCacheName, int nPartition, Member memberLocal, Member memberRemote, Set<BinaryEntry> setBinEntry) {
            super(eventType);
            this.m_service = service;
            this.m_sCacheName = sCacheName;
            this.m_nPartition = nPartition;
            this.m_setBinEntry = setBinEntry;
            this.m_memberRemote = memberRemote;
            this.m_memberLocal = memberLocal;
        }

        @Override
        protected boolean isMutableEvent() {
            return false;
        }

        @Override
        public int getPartitionId() {
            return this.m_nPartition;
        }

        @Override
        public PartitionedService getPartitionService() {
            return this.m_service;
        }

        @Override
        public Member getLocalMember() {
            return this.m_memberLocal;
        }

        @Override
        public Member getRemoteMember() {
            return this.m_memberRemote;
        }

        @Override
        public String getCacheName() {
            return this.m_sCacheName;
        }

        @Override
        public Set<BinaryEntry> getEntrySet() {
            return this.m_setBinEntry;
        }
    }
}

