/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.CopyOnWriteLongArray;
import com.tangosol.util.LongArray;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class StorageVersion {
    protected final AtomicLong m_atomicSubmittedVersion;
    protected final AtomicLong m_atomicCommittedVersion;
    protected final LongArray m_laPartitionVersion = new CopyOnWriteLongArray();
    protected final Queue<Thread> m_queueParkedThreads = new ConcurrentLinkedQueue<Thread>();

    public StorageVersion() {
        this.m_atomicCommittedVersion = new AtomicLong(0L);
        this.m_atomicSubmittedVersion = new AtomicLong(0L);
    }

    public long getCommittedVersion() {
        return this.m_atomicCommittedVersion.get();
    }

    public String toString() {
        StringBuilder sbMap = new StringBuilder();
        LongArray.Iterator iter = this.m_laPartitionVersion.iterator();
        while (iter.hasNext()) {
            PartitionVersion version = (PartitionVersion)iter.next();
            if (version.submissionCounter.get() <= 0L) continue;
            sbMap.append("\n{Partition ").append(iter.getIndex()).append(' ').append(version).append('}');
        }
        return "StorageVersion{SubmittedVersion=" + this.m_atomicSubmittedVersion.get() + ", CommittedVersion=" + this.m_atomicCommittedVersion.get() + ", ParkedThreadCount=" + this.m_queueParkedThreads.size() + ", PartitionVersions={" + sbMap + "\n}}";
    }

    public long getSubmittedVersion() {
        return this.m_atomicSubmittedVersion.get();
    }

    public PartitionSet getModifiedPartitions(long lCommittedVersion, PartitionSet partsCheck) {
        LongArray laPartitionVersion = this.m_laPartitionVersion;
        PartitionSet partsSuspect = new PartitionSet(partsCheck.getPartitionCount());
        int nPart = partsCheck.next(0);
        while (nPart >= 0) {
            PartitionVersion version = (PartitionVersion)laPartitionVersion.get(nPart);
            if (version != null && (version.submissionCounter.get() > 0L || version.committedVersion.get() > lCommittedVersion)) {
                partsSuspect.add(nPart);
            }
            nPart = partsCheck.next(nPart + 1);
        }
        return partsSuspect;
    }

    public void submit(int nPartition) {
        LongArray laPartitionVersion = this.m_laPartitionVersion;
        PartitionVersion version = (PartitionVersion)laPartitionVersion.get(nPartition);
        if (version == null) {
            version = new PartitionVersion();
            laPartitionVersion.set(nPartition, version);
        }
        version.submissionCounter.incrementAndGet();
        this.m_atomicSubmittedVersion.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int nPartition) {
        boolean fUnpark;
        PartitionVersion version = (PartitionVersion)this.m_laPartitionVersion.get(nPartition);
        Queue<Thread> queue = this.m_queueParkedThreads;
        PartitionVersion partitionVersion = version;
        synchronized (partitionVersion) {
            long lVersion = this.m_atomicCommittedVersion.incrementAndGet();
            version.committedVersion.set(lVersion);
            long cPendingUpdates = version.submissionCounter.decrementAndGet();
            assert (cPendingUpdates >= 0L);
            fUnpark = cPendingUpdates == 0L && !queue.isEmpty();
        }
        if (fUnpark) {
            Thread thread;
            while ((thread = queue.poll()) != null) {
                LockSupport.unpark(thread);
            }
        }
    }

    public void dropCommittedVersion(int nPartition) {
        this.m_laPartitionVersion.remove(nPartition);
    }

    public void waitForPendingUpdates() {
        this.m_queueParkedThreads.add(Thread.currentThread());
        LockSupport.park();
    }

    private static class PartitionVersion {
        public final AtomicLong committedVersion = new AtomicLong(0L);
        public final AtomicLong submissionCounter = new AtomicLong(0L);

        private PartitionVersion() {
        }

        public String toString() {
            return "PartitionVersion{CommittedVersion=" + this.committedVersion.get() + ", SubmissionCounter=" + this.submissionCounter.get() + "}";
        }
    }
}

