/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.tangosol.net.management.annotation.Description;
import com.tangosol.util.ClassHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class AnnotatedStandardMBean
extends StandardMBean {
    private static final Map<String, Class> s_mapPrimitiveClasses;

    public <T> AnnotatedStandardMBean(T impl, Class<T> clzMBeanIfc) throws NotCompliantMBeanException {
        super(impl, clzMBeanIfc);
    }

    protected AnnotatedStandardMBean(Class clzMBeanIfc) throws NotCompliantMBeanException {
        super(clzMBeanIfc);
    }

    private static Class classForName(String sName, ClassLoader loader) throws ClassNotFoundException {
        Class<?> c = s_mapPrimitiveClasses.get(sName);
        if (c == null) {
            c = Class.forName(sName, false, loader);
        }
        return c;
    }

    private static Method methodFor(Class clzMBeanIfc, MBeanOperationInfo op) {
        MBeanParameterInfo[] aParams = op.getSignature();
        int cParams = aParams.length;
        String[] asParamTypes = new String[cParams];
        for (int i = 0; i < cParams; ++i) {
            asParamTypes[i] = aParams[i].getType();
        }
        return AnnotatedStandardMBean.findMethod(clzMBeanIfc, op.getName(), asParamTypes);
    }

    private static Method findMethod(Class clzMBeanIfc, String sName, String ... asParamTypes) {
        ClassLoader loader = clzMBeanIfc.getClassLoader();
        int cParams = asParamTypes.length;
        Class[] aParamClasses = new Class[cParams];
        try {
            for (int i = 0; i < cParams; ++i) {
                aParamClasses[i] = AnnotatedStandardMBean.classForName(asParamTypes[i], loader);
            }
            return ClassHelper.findMethod(clzMBeanIfc, sName, aParamClasses, false);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <A extends Annotation> A getParameterAnnotation(Method meth, int iParam, Class<A> clzAnnot) {
        for (Annotation a : meth.getParameterAnnotations()[iParam]) {
            if (!clzAnnot.isInstance(a)) continue;
            return (A)((Annotation)clzAnnot.cast(a));
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op) {
        Description desc;
        String sDesc = op.getDescription();
        Method meth = AnnotatedStandardMBean.methodFor(this.getMBeanInterface(), op);
        if (meth != null && (desc = meth.getAnnotation(Description.class)) != null) {
            sDesc = desc.value();
        }
        return sDesc;
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String sDesc = info.getDescription();
        String sMethName = info.getName();
        sMethName = info.isIs() ? "is" + sMethName : "get" + sMethName;
        Method methGetter = AnnotatedStandardMBean.findMethod(this.getMBeanInterface(), sMethName, new String[0]);
        if (methGetter != null) {
            Description descGetter = methGetter.getAnnotation(Description.class);
            if (descGetter != null) {
                sDesc = descGetter.value();
            } else {
                Description descSetter;
                sMethName = "set" + info.getName();
                Method methSetter = AnnotatedStandardMBean.findMethod(this.getMBeanInterface(), sMethName, new String[0]);
                if (methSetter != null && (descSetter = methSetter.getAnnotation(Description.class)) != null) {
                    sDesc = descSetter.value();
                }
            }
        }
        return sDesc;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        Description desc;
        String sDesc = info.getDescription();
        Class<?> clzMBeanIfc = this.getMBeanInterface();
        if (clzMBeanIfc != null && (desc = clzMBeanIfc.getAnnotation(Description.class)) != null) {
            sDesc = desc.value();
        }
        return sDesc;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int iParam) {
        Description desc;
        String sName = param.getName();
        Method meth = AnnotatedStandardMBean.methodFor(this.getMBeanInterface(), op);
        if (meth != null && (desc = AnnotatedStandardMBean.getParameterAnnotation(meth, iParam, Description.class)) != null) {
            sName = desc.value();
        }
        return sName;
    }

    static {
        Class[] aclzPrims;
        s_mapPrimitiveClasses = new HashMap<String, Class>();
        for (Class clz : aclzPrims = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE}) {
            s_mapPrimitiveClasses.put(clz.getName(), clz);
        }
    }
}

