/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.IterableAdapter;
import com.tangosol.run.xml.SimpleAdapter;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Binary;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public abstract class PrimitiveArrayAdapter
extends IterableAdapter {
    public PrimitiveArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
    }

    public boolean isStringable() {
        return false;
    }

    @Override
    public abstract int hash(Object var1);

    @Override
    public abstract boolean equalsValue(Object var1, Object var2);

    @Override
    public abstract Object clone(Object var1);

    @Override
    public Object fromXml(XmlElement xml) {
        if (this.isStringable() && !this.isNested()) {
            return xml == null ? null : this.fromXmlString(xml);
        }
        return super.fromXml(xml);
    }

    @Override
    public XmlElement toXml(Object o) {
        if (this.isStringable() && !this.isNested()) {
            return o == null ? null : this.toXmlString(o);
        }
        return super.toXml(o);
    }

    @Override
    public Object readXml(XmlElement xml) {
        if (this.isStringable() && !this.isNested()) {
            return this.fromXml(this.findElement(xml));
        }
        return super.readXml(xml);
    }

    @Override
    public void writeXml(XmlElement xml, Object o) {
        if (this.isStringable() && !this.isNested()) {
            XmlElement xmlValue = this.toXml(o);
            if (xmlValue != null) {
                xml.getElementList().add(xmlValue);
            }
        } else {
            super.writeXml(xml, o);
        }
    }

    @Override
    protected Object readElements(XmlElement xml) {
        String sElement = this.getElementName();
        if (sElement == null) {
            sElement = this.getLocalXmlName();
        }
        Iterator iter = XmlHelper.getElements(xml, sElement, this.getNamespaceUri());
        if (this.isSparse()) {
            int c = xml.getSafeAttribute("length").getInt();
            if (c < 0) {
                throw new IllegalArgumentException("Illegal length: " + c);
            }
            return this.readSparseArray(iter, c);
        }
        boolean fNested = this.isNested();
        if (!fNested && !iter.hasNext()) {
            return null;
        }
        return this.readArray(iter, xml, fNested);
    }

    @Override
    protected void writeElements(XmlElement xml, Object o) {
        String sElement = XmlHelper.getUniversalName(this.getElementName(), this.getNamespacePrefix());
        if (sElement == null) {
            sElement = this.getXmlName();
        }
        if (this.isSparse()) {
            this.writeSparseArray(xml, o, sElement);
        } else {
            this.writeArray(xml, o, sElement);
        }
    }

    public Object fromXmlString(XmlElement xml) {
        throw new UnsupportedOperationException();
    }

    public XmlElement toXmlString(Object o) {
        throw new UnsupportedOperationException();
    }

    public abstract Object readSparseArray(Iterator var1, int var2);

    public abstract Object readArray(Iterator var1, XmlElement var2, boolean var3);

    public abstract void writeSparseArray(XmlElement var1, Object var2, String var3);

    public abstract void writeArray(XmlElement var1, Object var2, String var3);

    public static class DoubleArrayAdapter
    extends PrimitiveArrayAdapter {
        public DoubleArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            DoubleArrayAdapter.azzert(clzType == double[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            double[] adfl = (double[])o;
            int c = adfl.length;
            for (int i = 0; i < c; ++i) {
                long l = Double.doubleToLongBits(adfl[i]);
                n ^= (int)(l ^ l >>> 32);
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            double[] adfl1 = (double[])o1;
            double[] adfl2 = (double[])o2;
            if (adfl1.length != adfl2.length) {
                return false;
            }
            int c = adfl1.length;
            for (int i = 0; i < c; ++i) {
                if (adfl1[i] == adfl2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (double[])((double[])o).clone();
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((double[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            double[] adfl = new double[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                adfl[attr.getInt((int)-1)] = elem.getDouble();
            }
            return adfl;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            if (!iter.hasNext()) {
                return new double[0];
            }
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            double[] adfl = new double[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    double[] adflNew = new double[cNew];
                    System.arraycopy(adfl, 0, adflNew, 0, cMax);
                    adfl = adflNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                adfl[c++] = xmlValue.getDouble();
            }
            if (c == cMax) {
                return adfl;
            }
            double[] adflNew = new double[c];
            System.arraycopy(adfl, 0, adflNew, 0, c);
            return adflNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            double[] adfl = (double[])o;
            int c = adfl.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                double dfl = adfl[i];
                if (dfl == 0.0) continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setDouble(dfl);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            double[] adfl = (double[])o;
            int c = adfl.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setDouble(adfl[i]);
            }
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            return DoubleArrayAdapter.readDoubleArray(in);
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            DoubleArrayAdapter.writeDoubleArray(out, (double[])o);
        }
    }

    public static class FloatArrayAdapter
    extends PrimitiveArrayAdapter {
        public FloatArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            FloatArrayAdapter.azzert(clzType == float[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            float[] afl = (float[])o;
            int c = afl.length;
            for (int i = 0; i < c; ++i) {
                n ^= Float.floatToIntBits(afl[i]);
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            float[] afl1 = (float[])o1;
            float[] afl2 = (float[])o2;
            if (afl1.length != afl2.length) {
                return false;
            }
            int c = afl1.length;
            for (int i = 0; i < c; ++i) {
                if (afl1[i] == afl2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (float[])((float[])o).clone();
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((float[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            float[] afl = new float[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                afl[attr.getInt((int)-1)] = (float)elem.getDouble();
            }
            return afl;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            if (!iter.hasNext()) {
                return new float[0];
            }
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            float[] afl = new float[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    float[] aflNew = new float[cNew];
                    System.arraycopy(afl, 0, aflNew, 0, cMax);
                    afl = aflNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                afl[c++] = (float)xmlValue.getDouble();
            }
            if (c == cMax) {
                return afl;
            }
            float[] aflNew = new float[c];
            System.arraycopy(afl, 0, aflNew, 0, c);
            return aflNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            float[] afl = (float[])o;
            int c = afl.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                double dfl = afl[i];
                if (dfl == 0.0) continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setDouble(dfl);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            float[] afl = (float[])o;
            int c = afl.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setDouble(afl[i]);
            }
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            return FloatArrayAdapter.readFloatArray(in);
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            FloatArrayAdapter.writeFloatArray(out, (float[])o);
        }
    }

    public static class LongArrayAdapter
    extends PrimitiveArrayAdapter {
        public LongArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            LongArrayAdapter.azzert(clzType == long[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            for (long l : (long[])o) {
                n ^= (int)(l ^ l >>> 32);
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            long[] al1 = (long[])o1;
            long[] al2 = (long[])o2;
            if (al1.length != al2.length) {
                return false;
            }
            int c = al1.length;
            for (int i = 0; i < c; ++i) {
                if (al1[i] == al2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (long[])((long[])o).clone();
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((long[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            long[] al = new long[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                al[attr.getInt((int)-1)] = elem.getLong();
            }
            return al;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            long[] al = new long[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    long[] alNew = new long[cNew];
                    System.arraycopy(al, 0, alNew, 0, cMax);
                    al = alNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                al[c++] = xmlValue.getLong();
            }
            if (c == cMax) {
                return al;
            }
            long[] alNew = new long[c];
            System.arraycopy(al, 0, alNew, 0, c);
            return alNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            long[] al = (long[])o;
            int c = al.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                long l = al[i];
                if (l == 0L) continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setLong(l);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            long[] al = (long[])o;
            int c = al.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setLong(al[i]);
            }
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            int c = LongArrayAdapter.readInt(in);
            long[] an = new long[c];
            for (int i = 0; i < c; ++i) {
                an[i] = LongArrayAdapter.readLong(in);
            }
            return an;
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            long[] an = (long[])o;
            int c = an.length;
            LongArrayAdapter.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                LongArrayAdapter.writeLong(out, an[i]);
            }
        }
    }

    public static class IntArrayAdapter
    extends PrimitiveArrayAdapter {
        public IntArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            IntArrayAdapter.azzert(clzType == int[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            int[] an = (int[])o;
            int c = an.length;
            for (int i = 0; i < c; ++i) {
                n ^= an[i];
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            int[] an1 = (int[])o1;
            int[] an2 = (int[])o2;
            if (an1.length != an2.length) {
                return false;
            }
            int c = an1.length;
            for (int i = 0; i < c; ++i) {
                if (an1[i] == an2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (int[])((int[])o).clone();
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((int[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            int[] an = new int[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                an[attr.getInt((int)-1)] = elem.getInt();
            }
            return an;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            if (!iter.hasNext()) {
                return new int[0];
            }
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            int[] an = new int[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    int[] anNew = new int[cNew];
                    System.arraycopy(an, 0, anNew, 0, cMax);
                    an = anNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                an[c++] = xmlValue.getInt();
            }
            if (c == cMax) {
                return an;
            }
            int[] anNew = new int[c];
            System.arraycopy(an, 0, anNew, 0, c);
            return anNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            int[] an = (int[])o;
            int c = an.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                int n = an[i];
                if (n == 0) continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setInt(n);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            int[] an = (int[])o;
            int c = an.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setInt(an[i]);
            }
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            int c = IntArrayAdapter.readInt(in);
            int[] an = new int[c];
            for (int i = 0; i < c; ++i) {
                an[i] = IntArrayAdapter.readInt(in);
            }
            return an;
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            int[] an = (int[])o;
            int c = an.length;
            IntArrayAdapter.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                IntArrayAdapter.writeInt(out, an[i]);
            }
        }
    }

    public static class ShortArrayAdapter
    extends PrimitiveArrayAdapter {
        public ShortArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            ShortArrayAdapter.azzert(clzType == short[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            short[] an = (short[])o;
            int c = an.length;
            for (int i = 0; i < c; ++i) {
                n ^= an[i];
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            short[] an1 = (short[])o1;
            short[] an2 = (short[])o2;
            if (an1.length != an2.length) {
                return false;
            }
            int c = an1.length;
            for (int i = 0; i < c; ++i) {
                if (an1[i] == an2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (short[])((short[])o).clone();
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((short[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            short[] an = new short[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                an[attr.getInt((int)-1)] = (short)elem.getInt();
            }
            return an;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            short[] an = new short[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    short[] anNew = new short[cNew];
                    System.arraycopy(an, 0, anNew, 0, cMax);
                    an = anNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                an[c++] = (short)xmlValue.getInt();
            }
            if (c == cMax) {
                return an;
            }
            short[] anNew = new short[c];
            System.arraycopy(an, 0, anNew, 0, c);
            return anNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            short[] an = (short[])o;
            int c = an.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                short n = an[i];
                if (n == 0) continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setInt(n);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            short[] an = (short[])o;
            int c = an.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setInt(an[i]);
            }
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            int c = ShortArrayAdapter.readInt(in);
            short[] an = new short[c];
            for (int i = 0; i < c; ++i) {
                an[i] = (short)ShortArrayAdapter.readInt(in);
            }
            return an;
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            short[] an = (short[])o;
            int c = an.length;
            ShortArrayAdapter.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                ShortArrayAdapter.writeInt(out, an[i]);
            }
        }
    }

    public static class CharArrayAdapter
    extends PrimitiveArrayAdapter {
        public CharArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            CharArrayAdapter.azzert(clzType == char[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            char[] an = (char[])o;
            int c = an.length;
            for (int i = 0; i < c; ++i) {
                n ^= an[i];
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            char[] ach1 = (char[])o1;
            char[] ach2 = (char[])o2;
            if (ach1.length != ach2.length) {
                return false;
            }
            int c = ach1.length;
            for (int i = 0; i < c; ++i) {
                if (ach1[i] == ach2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (char[])((char[])o).clone();
        }

        @Override
        public Object fromXmlString(XmlElement xml) {
            return xml.getString().toCharArray();
        }

        @Override
        public XmlElement toXmlString(Object o) {
            return new SimpleElement(this.getXmlName(), new String((char[])o));
        }

        @Override
        public boolean isStringable() {
            return true;
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((char[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            char[] ach = new char[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                ach[attr.getInt((int)-1)] = (char)elem.getInt();
            }
            return ach;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            char[] ach = new char[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    char[] achNew = new char[cNew];
                    System.arraycopy(ach, 0, achNew, 0, cMax);
                    ach = achNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                ach[c++] = (char)xmlValue.getInt();
            }
            if (c == cMax) {
                return ach;
            }
            char[] achNew = new char[c];
            System.arraycopy(ach, 0, achNew, 0, c);
            return achNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            char[] ach = (char[])o;
            int c = ach.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                char n = ach[i];
                if (n == '\u0000') continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setInt(n);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            char[] ach = (char[])o;
            int c = ach.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setInt(ach[i]);
            }
        }

        @Override
        public Object fromUri(String sUri) {
            return SimpleAdapter.decodeString(sUri).toCharArray();
        }

        @Override
        public String toUri(Object o) {
            return SimpleAdapter.encodeString(new String((char[])o));
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            return CharArrayAdapter.readUTF(in).toCharArray();
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            CharArrayAdapter.writeUTF(out, new String((char[])o));
        }
    }

    public static class ByteArrayAdapter
    extends PrimitiveArrayAdapter {
        public ByteArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            ByteArrayAdapter.azzert(clzType == byte[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            byte[] an = (byte[])o;
            int c = an.length;
            for (int i = 0; i < c; ++i) {
                n ^= an[i];
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            byte[] ab1 = (byte[])o1;
            byte[] ab2 = (byte[])o2;
            if (ab1.length != ab2.length) {
                return false;
            }
            int c = ab1.length;
            for (int i = 0; i < c; ++i) {
                if (ab1[i] == ab2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (byte[])((byte[])o).clone();
        }

        @Override
        public Object fromXmlString(XmlElement xml) {
            return xml.getBinary().toByteArray();
        }

        @Override
        public XmlElement toXmlString(Object o) {
            return new SimpleElement(this.getXmlName(), new Binary((byte[])o));
        }

        @Override
        public boolean isStringable() {
            return true;
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((byte[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            byte[] ab = new byte[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                ab[attr.getInt((int)-1)] = (byte)elem.getInt();
            }
            return ab;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            byte[] ab = new byte[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    byte[] abNew = new byte[cNew];
                    System.arraycopy(ab, 0, abNew, 0, cMax);
                    ab = abNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                ab[c++] = (byte)xmlValue.getInt();
            }
            if (c == cMax) {
                return ab;
            }
            byte[] abNew = new byte[c];
            System.arraycopy(ab, 0, abNew, 0, c);
            return abNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            byte[] an = (byte[])o;
            int c = an.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                byte n = an[i];
                if (n == 0) continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setInt(n);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            byte[] ab = (byte[])o;
            int c = ab.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setInt(ab[i]);
            }
        }

        @Override
        public Object fromUri(String sUri) {
            return ByteArrayAdapter.parseHex(sUri);
        }

        @Override
        public String toUri(Object o) {
            return ByteArrayAdapter.toHex((byte[])o);
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            return ByteArrayAdapter.readByteArray(in);
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            ByteArrayAdapter.writeByteArray(out, (byte[])o);
        }
    }

    public static class BooleanArrayAdapter
    extends PrimitiveArrayAdapter {
        public BooleanArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            BooleanArrayAdapter.azzert(clzType == boolean[].class);
        }

        @Override
        public int hash(Object o) {
            if (o == null) {
                return 0;
            }
            int n = 0;
            boolean[] af = (boolean[])o;
            int c = af.length;
            for (int i = 0; i < c; ++i) {
                n ^= af[i] ? 1231 : 1237;
            }
            return n;
        }

        @Override
        public boolean equalsValue(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            boolean[] af1 = (boolean[])o1;
            boolean[] af2 = (boolean[])o2;
            if (af1.length != af2.length) {
                return false;
            }
            int c = af1.length;
            for (int i = 0; i < c; ++i) {
                if (af1[i] == af2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object clone(Object o) {
            return o == null ? null : (boolean[])((boolean[])o).clone();
        }

        @Override
        public Object fromXmlString(XmlElement xml) {
            return BooleanArrayAdapter.toBooleanArray(xml.getString());
        }

        @Override
        public XmlElement toXmlString(Object o) {
            return new SimpleElement(this.getXmlName(), BooleanArrayAdapter.toString((boolean[])o));
        }

        @Override
        public boolean isStringable() {
            return true;
        }

        @Override
        public boolean isEmpty(Object o) {
            return o == null || this.isEmptyIsNull() && ((boolean[])o).length == 0;
        }

        @Override
        public Object readSparseArray(Iterator iter, int c) {
            boolean[] af = new boolean[c];
            while (iter.hasNext()) {
                XmlElement elem = (XmlElement)iter.next();
                XmlValue attr = elem.getAttribute("id");
                if (attr == null) {
                    throw new IllegalArgumentException("Element " + elem.getName() + " is missing the required \"id\" attribute");
                }
                af[attr.getInt((int)-1)] = elem.getBoolean();
            }
            return af;
        }

        @Override
        public Object readArray(Iterator iter, XmlElement xml, boolean fNested) {
            int cXml = xml.getElementList().size();
            int cMax = fNested ? cXml : Math.min(cXml, 32);
            boolean[] af = new boolean[cMax];
            int c = 0;
            while (iter.hasNext()) {
                if (c >= cMax) {
                    int cNew = cMax * 2;
                    boolean[] afNew = new boolean[cNew];
                    System.arraycopy(af, 0, afNew, 0, cMax);
                    af = afNew;
                    cMax = cNew;
                }
                XmlElement xmlValue = (XmlElement)iter.next();
                af[c++] = xmlValue.getBoolean();
            }
            if (c == cMax) {
                return af;
            }
            boolean[] afNew = new boolean[c];
            System.arraycopy(af, 0, afNew, 0, c);
            return afNew;
        }

        @Override
        public void writeSparseArray(XmlElement xml, Object o, String sElement) {
            boolean[] af = (boolean[])o;
            int c = af.length;
            xml.addAttribute("length").setInt(c);
            for (int i = 0; i < c; ++i) {
                boolean f = af[i];
                if (!f) continue;
                XmlElement element = xml.addElement(sElement);
                element.addAttribute("id").setInt(i);
                element.setBoolean(f);
            }
        }

        @Override
        public void writeArray(XmlElement xml, Object o, String sElement) {
            boolean[] af = (boolean[])o;
            int c = af.length;
            for (int i = 0; i < c; ++i) {
                xml.addElement(sElement).setBoolean(af[i]);
            }
        }

        @Override
        public Object fromUri(String sUri) {
            return BooleanArrayAdapter.toBooleanArray(sUri);
        }

        @Override
        public String toUri(Object o) {
            return BooleanArrayAdapter.toString((boolean[])o);
        }

        @Override
        public Object readExternal(DataInput in) throws IOException {
            return BooleanArrayAdapter.readBooleanArray(in);
        }

        @Override
        public void writeExternal(DataOutput out, Object o) throws IOException {
            BooleanArrayAdapter.writeBooleanArray(out, (boolean[])o);
        }

        public static boolean[] toBooleanArray(String s) {
            char[] ach = s.toCharArray();
            boolean[] af = new boolean[ach.length];
            int c = ach.length;
            for (int i = 0; i < c; ++i) {
                af[i] = ach[i] == '1';
            }
            return af;
        }

        public static String toString(boolean[] af) {
            char[] ach = new char[af.length];
            int c = af.length;
            for (int i = 0; i < c; ++i) {
                ach[i] = af[i] ? 49 : 48;
            }
            return new String(ach);
        }
    }
}

