/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SimpleEnumerator
extends Base
implements Enumeration,
Iterator {
    private static final Object[] NO_OBJECTS = new Object[0];
    protected Object[] m_aoItem;
    protected int m_iItem;
    protected int m_ofLimit;
    protected boolean m_fForward;

    public SimpleEnumerator(Object[] aoItem) {
        this(aoItem, 0, aoItem.length, true, false);
    }

    public SimpleEnumerator(Object[] aoItem, int ofStart, int cItems) {
        this(aoItem, ofStart, cItems, true, false);
    }

    public SimpleEnumerator(Object[] aoItem, int ofStart, int cItems, boolean fForward, boolean fCopy) {
        if (cItems < 0) {
            throw new IllegalArgumentException("Negative count");
        }
        if (fForward ? ofStart < 0 || ofStart + cItems > aoItem.length : ofStart >= aoItem.length || ofStart - cItems < 0) {
            throw new IllegalArgumentException("Off limits");
        }
        if (fCopy && cItems > 1) {
            aoItem = (Object[])aoItem.clone();
        }
        this.m_aoItem = aoItem;
        this.m_fForward = fForward;
        this.m_iItem = ofStart;
        this.m_ofLimit = fForward ? ofStart + cItems : ofStart - cItems;
    }

    public SimpleEnumerator(Enumeration enmr) {
        this(SimpleEnumerator.toArray(enmr));
    }

    public SimpleEnumerator(Iterator iter) {
        this(SimpleEnumerator.toArray(iter));
    }

    public SimpleEnumerator(Collection col) {
        this(col.toArray());
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }

    @Override
    public boolean hasNext() {
        return this.m_fForward ? this.m_iItem < this.m_ofLimit : this.m_iItem > this.m_ofLimit;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Object o = this.m_aoItem[this.m_iItem];
            this.m_iItem = this.m_fForward ? ++this.m_iItem : --this.m_iItem;
            return o;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("iterator is immutable");
    }

    public static Object[] toArray(Enumeration enmr) {
        if (!enmr.hasMoreElements()) {
            return NO_OBJECTS;
        }
        if (enmr instanceof SimpleEnumerator) {
            return ((SimpleEnumerator)enmr).toArray();
        }
        ArrayList list = new ArrayList();
        do {
            list.add(enmr.nextElement());
        } while (enmr.hasMoreElements());
        return list.toArray();
    }

    public static Object[] toArray(Enumeration enmr, Object[] ao) {
        if (!enmr.hasMoreElements()) {
            if (ao.length > 0) {
                ao[0] = null;
            }
            return ao;
        }
        if (enmr instanceof SimpleEnumerator) {
            return ((SimpleEnumerator)enmr).toArray(ao);
        }
        ArrayList list = new ArrayList();
        do {
            list.add(enmr.nextElement());
        } while (enmr.hasMoreElements());
        return list.toArray(ao);
    }

    public static Object[] toArray(Iterator iter) {
        if (!iter.hasNext()) {
            return NO_OBJECTS;
        }
        if (iter instanceof SimpleEnumerator) {
            return ((SimpleEnumerator)iter).toArray();
        }
        ArrayList list = new ArrayList();
        do {
            list.add(iter.next());
        } while (iter.hasNext());
        return list.toArray();
    }

    public static Object[] toArray(Iterator iter, Object[] ao) {
        if (!iter.hasNext()) {
            if (ao == null) {
                ao = NO_OBJECTS;
            } else if (ao.length > 0) {
                ao[0] = null;
            }
            return ao;
        }
        if (iter instanceof SimpleEnumerator) {
            return ((SimpleEnumerator)iter).toArray(ao);
        }
        ArrayList list = new ArrayList();
        do {
            list.add(iter.next());
        } while (iter.hasNext());
        return ao == null ? list.toArray() : list.toArray(ao);
    }

    public Object[] toArray() {
        return this.toArray(null);
    }

    public Object[] toArray(Object[] ao) {
        int co;
        Object[] aoItem = this.m_aoItem;
        int iNext = this.m_iItem;
        int iLast = this.m_ofLimit;
        boolean fForward = this.m_fForward;
        int n = co = fForward ? iLast - iNext : iNext - iLast;
        if (ao == null) {
            ao = new Object[co];
        } else if (ao.length < co) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), co);
        } else if (ao.length > co) {
            ao[co] = null;
        }
        if (fForward) {
            System.arraycopy(aoItem, iNext, ao, 0, co);
        } else {
            int i = 0;
            while (iNext > iLast) {
                ao[i++] = aoItem[iNext--];
            }
        }
        this.m_iItem = iLast;
        return ao;
    }
}

