/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.SimpleQueryRecordReporter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.QueryRecorder;
import com.tangosol.util.filter.ExtractorFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleQueryRecord
implements QueryRecord,
ExternalizableLite,
PortableObject {
    private QueryRecorder.RecordType m_type;
    private List<PartialResult> m_listResults = new LinkedList<PartialResult>();

    public SimpleQueryRecord() {
    }

    public SimpleQueryRecord(QueryRecorder.RecordType type, Collection colResults) {
        this.m_type = type;
        this.mergeResults(colResults);
    }

    @Override
    public QueryRecorder.RecordType getType() {
        return this.m_type;
    }

    @Override
    public List<? extends QueryRecord.PartialResult> getResults() {
        return this.m_listResults;
    }

    protected void mergeResults(Collection colResults) {
        List<PartialResult> listResults = this.m_listResults;
        for (QueryRecord.PartialResult resultThat : colResults) {
            for (PartialResult resultThis : listResults) {
                if (!resultThis.isMatching(resultThat)) continue;
                resultThis.merge(resultThat);
                resultThat = null;
                break;
            }
            if (resultThat == null) continue;
            listResults.add(new PartialResult(resultThat));
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_type = QueryRecorder.RecordType.fromInt(in.readInt());
        ExternalizableHelper.readCollection(in, this.m_listResults, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_type.toInt());
        ExternalizableHelper.writeCollection(out, this.m_listResults);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_type = QueryRecorder.RecordType.fromInt(in.readInt(0));
        in.readCollection(1, this.m_listResults);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_type.toInt());
        out.writeCollection(1, this.m_listResults);
    }

    public String toString() {
        return SimpleQueryRecordReporter.report(this);
    }

    public static class PartialResult
    implements QueryRecord.PartialResult,
    ExternalizableLite,
    PortableObject {
        protected List<Step> m_listSteps = new LinkedList<Step>();
        private PartitionSet m_partMask;
        private transient QueryContext m_ctx;

        public PartialResult() {
        }

        public PartialResult(PartitionSet partMask) {
            this.m_partMask = partMask;
        }

        public PartialResult(QueryContext ctx, PartitionSet partMask) {
            this(partMask);
            this.m_ctx = ctx;
        }

        public PartialResult(QueryRecord.PartialResult result) {
            this(result.getPartitions());
            List<Step> listSteps = this.m_listSteps;
            for (QueryRecord.PartialResult.Step step : result.getSteps()) {
                listSteps.add(new Step(step));
            }
        }

        @Override
        public List<? extends QueryRecord.PartialResult.Step> getSteps() {
            return this.m_listSteps;
        }

        @Override
        public PartitionSet getPartitions() {
            return this.m_partMask;
        }

        public QueryRecord.PartialResult.ExplainStep instantiateExplainStep(Filter filter) {
            ExplainStep step = new ExplainStep(filter);
            this.m_listSteps.add(step);
            return step;
        }

        public QueryRecord.PartialResult.TraceStep instantiateTraceStep(Filter filter) {
            TraceStep step = new TraceStep(filter);
            this.m_listSteps.add(step);
            return step;
        }

        protected void merge(QueryRecord.PartialResult result) {
            this.getPartitions().add(result.getPartitions());
            List<Step> listStepsThis = this.m_listSteps;
            List<? extends QueryRecord.PartialResult.Step> listStepsThat = result.getSteps();
            for (int i = 0; i < listStepsThat.size(); ++i) {
                QueryRecord.PartialResult.Step step = listStepsThat.get(i);
                Step mergeStep = listStepsThis.get(i);
                mergeStep.merge(step);
            }
        }

        protected boolean isMatching(QueryRecord.PartialResult result) {
            List<Step> listStepsThis = this.m_listSteps;
            List<? extends QueryRecord.PartialResult.Step> listStepsThat = result.getSteps();
            if (listStepsThat.size() != listStepsThat.size()) {
                return false;
            }
            for (int i = 0; i < listStepsThis.size(); ++i) {
                if (listStepsThis.get(i).isMatching(listStepsThat.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_partMask = (PartitionSet)ExternalizableHelper.readObject(in);
            ExternalizableHelper.readCollection(in, this.m_listSteps, null);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_partMask);
            LinkedList<Step> listSteps = new LinkedList<Step>();
            for (Step step : this.m_listSteps) {
                listSteps.add(new Step(step));
            }
            ExternalizableHelper.writeCollection(out, listSteps);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_partMask = (PartitionSet)in.readObject(0);
            in.readCollection(1, this.m_listSteps);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_partMask);
            LinkedList<Step> listSteps = new LinkedList<Step>();
            for (Step step : this.m_listSteps) {
                listSteps.add(new Step(step));
            }
            out.writeCollection(1, listSteps);
        }

        public static class IndexLookupRecord
        implements QueryRecord.PartialResult.IndexLookupRecord,
        ExternalizableLite,
        PortableObject {
            private String m_sExtractor;
            private String m_sIndex;
            private boolean m_fOrdered;

            public IndexLookupRecord() {
            }

            public IndexLookupRecord(ValueExtractor extractor, MapIndex index) {
                this(((Object)extractor).toString(), index == null ? null : index.toString(), index != null && index.isOrdered());
            }

            public IndexLookupRecord(QueryRecord.PartialResult.IndexLookupRecord record) {
                this(record.getExtractorDescription(), record.getIndexDescription(), record.isOrdered());
            }

            protected IndexLookupRecord(String sExtractor, String sIndex, boolean fOrdered) {
                this.m_sExtractor = sExtractor;
                this.m_sIndex = sIndex;
                this.m_fOrdered = fOrdered;
            }

            @Override
            public String getExtractorDescription() {
                return this.m_sExtractor;
            }

            @Override
            public String getIndexDescription() {
                return this.m_sIndex;
            }

            @Override
            public boolean isOrdered() {
                return this.m_fOrdered;
            }

            public int hashCode() {
                return (this.m_fOrdered ? 1 : 0) + Base.hashCode(this.m_sIndex) + this.m_sExtractor.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof IndexLookupRecord) {
                    IndexLookupRecord that = (IndexLookupRecord)o;
                    return this.m_fOrdered == that.m_fOrdered && this.m_sExtractor.equals(that.m_sExtractor) && Base.equals(this.m_sIndex, that.m_sIndex);
                }
                return false;
            }

            @Override
            public void readExternal(DataInput in) throws IOException {
                this.m_sExtractor = (String)ExternalizableHelper.readObject(in);
                this.m_sIndex = (String)ExternalizableHelper.readObject(in);
                this.m_fOrdered = in.readBoolean();
            }

            @Override
            public void writeExternal(DataOutput out) throws IOException {
                ExternalizableHelper.writeObject(out, this.m_sExtractor);
                ExternalizableHelper.writeObject(out, this.m_sIndex);
                out.writeBoolean(this.m_fOrdered);
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                this.m_sExtractor = (String)in.readObject(0);
                this.m_sIndex = (String)in.readObject(1);
                this.m_fOrdered = in.readBoolean(2);
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                out.writeObject(0, this.m_sExtractor);
                out.writeObject(1, this.m_sIndex);
                out.writeBoolean(2, this.m_fOrdered);
            }
        }

        public class TraceStep
        extends AbstractRecordableStep
        implements QueryRecord.PartialResult.TraceStep {
            public TraceStep(Filter filter) {
                super(filter);
            }

            @Override
            public void recordPostFilterKeys(int nSizeOut) {
                this.m_nSizeOut += nSizeOut;
            }

            @Override
            public void recordDuration(long cMillisElapsed) {
                this.m_cMillis += cMillisElapsed;
            }

            @Override
            public QueryRecord.PartialResult.TraceStep ensureStep(Filter filter) {
                TraceStep subStep = (TraceStep)this.m_mapSteps.get(filter);
                if (subStep == null) {
                    subStep = new TraceStep(filter);
                    this.m_mapSteps.put(filter, subStep);
                    this.m_listSubSteps.add(subStep);
                }
                return subStep;
            }
        }

        public class ExplainStep
        extends AbstractRecordableStep
        implements QueryRecord.PartialResult.ExplainStep {
            public ExplainStep(Filter filter) {
                super(filter);
            }

            @Override
            public void recordEfficiency(int nEfficiency) {
                this.m_nEfficiency = nEfficiency;
            }

            @Override
            public QueryRecord.PartialResult.ExplainStep ensureStep(Filter filter) {
                ExplainStep subStep = (ExplainStep)this.m_mapSteps.get(filter);
                if (subStep == null) {
                    subStep = new ExplainStep(filter);
                    this.m_mapSteps.put(filter, subStep);
                    this.m_listSubSteps.add(subStep);
                }
                return subStep;
            }
        }

        public abstract class AbstractRecordableStep
        extends Step
        implements QueryRecord.PartialResult.RecordableStep {
            protected Map<Filter, Step> m_mapSteps;

            public AbstractRecordableStep(Filter filter) {
                super(filter);
                this.m_mapSteps = new IdentityHashMap<Filter, Step>();
            }

            @Override
            public void recordPreFilterKeys(int nSizeIn) {
                this.m_nSizeIn += nSizeIn;
            }

            @Override
            public void recordExtractor(ValueExtractor extractor) {
                MapIndex index = PartialResult.this.m_ctx.getBackingMapContext().getIndexMap().get(extractor);
                this.m_setIndexLookupRecords.add(new IndexLookupRecord(extractor, index));
            }
        }

        public static class Step
        implements QueryRecord.PartialResult.Step,
        ExternalizableLite,
        PortableObject {
            protected String m_sFilter;
            protected int m_nEfficiency;
            protected int m_nSizeIn = 0;
            protected int m_nSizeOut = 0;
            protected long m_cMillis = 0L;
            protected Set<IndexLookupRecord> m_setIndexLookupRecords = new HashSet<IndexLookupRecord>();
            protected List<Step> m_listSubSteps = new LinkedList<Step>();

            public Step() {
            }

            public Step(Filter filter) {
                this.m_sFilter = filter instanceof ExtractorFilter ? filter.toString() : filter.getClass().getName();
            }

            public Step(QueryRecord.PartialResult.Step step) {
                this.m_sFilter = step.getFilterDescription();
                this.m_nSizeIn = step.getPreFilterKeySetSize();
                this.m_nSizeOut = step.getPostFilterKeySetSize();
                this.m_nEfficiency = step.getEfficiency();
                this.m_cMillis = step.getDuration();
                for (QueryRecord.PartialResult.IndexLookupRecord indexLookupRecord : step.getIndexLookupRecords()) {
                    this.m_setIndexLookupRecords.add(new IndexLookupRecord(indexLookupRecord));
                }
                for (QueryRecord.PartialResult.Step step2 : step.getSteps()) {
                    this.m_listSubSteps.add(new Step(step2));
                }
            }

            @Override
            public List<? extends QueryRecord.PartialResult.Step> getSteps() {
                return this.m_listSubSteps;
            }

            @Override
            public String getFilterDescription() {
                return this.m_sFilter;
            }

            @Override
            public Set<? extends QueryRecord.PartialResult.IndexLookupRecord> getIndexLookupRecords() {
                return this.m_setIndexLookupRecords;
            }

            @Override
            public int getEfficiency() {
                return this.m_nEfficiency;
            }

            @Override
            public int getPreFilterKeySetSize() {
                return this.m_nSizeIn;
            }

            @Override
            public int getPostFilterKeySetSize() {
                return this.m_nSizeOut;
            }

            @Override
            public long getDuration() {
                return this.m_cMillis;
            }

            protected boolean isMatching(QueryRecord.PartialResult.Step step) {
                if (this.getFilterDescription().equals(step.getFilterDescription()) && ((Object)this.getIndexLookupRecords()).equals(step.getIndexLookupRecords())) {
                    List<? extends QueryRecord.PartialResult.Step> listSteps = step.getSteps();
                    if (this.m_listSubSteps.size() == listSteps.size()) {
                        int i = 0;
                        for (Step subStep : this.m_listSubSteps) {
                            if (subStep.isMatching(listSteps.get(i++))) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }

            protected void merge(QueryRecord.PartialResult.Step step) {
                this.m_nSizeIn += step.getPreFilterKeySetSize();
                this.m_nSizeOut += step.getPostFilterKeySetSize();
                this.m_nEfficiency += step.getEfficiency();
                this.m_cMillis += step.getDuration();
                List<? extends QueryRecord.PartialResult.Step> listSteps = step.getSteps();
                int i = 0;
                for (Step subStep : this.m_listSubSteps) {
                    subStep.merge(listSteps.get(i++));
                }
            }

            @Override
            public void readExternal(DataInput in) throws IOException {
                this.m_sFilter = (String)ExternalizableHelper.readObject(in);
                this.m_nEfficiency = in.readInt();
                this.m_nSizeIn = in.readInt();
                this.m_nSizeOut = in.readInt();
                this.m_cMillis = in.readLong();
                ExternalizableHelper.readCollection(in, this.m_setIndexLookupRecords, null);
                ExternalizableHelper.readCollection(in, this.m_listSubSteps, null);
            }

            @Override
            public void writeExternal(DataOutput out) throws IOException {
                ExternalizableHelper.writeObject(out, this.m_sFilter);
                out.writeInt(this.m_nEfficiency);
                out.writeInt(this.m_nSizeIn);
                out.writeInt(this.m_nSizeOut);
                out.writeLong(this.m_cMillis);
                ExternalizableHelper.writeCollection(out, this.m_setIndexLookupRecords);
                LinkedList<Step> listSteps = new LinkedList<Step>();
                for (Step step : this.m_listSubSteps) {
                    listSteps.add(new Step(step));
                }
                ExternalizableHelper.writeCollection(out, listSteps);
            }

            @Override
            public void readExternal(PofReader in) throws IOException {
                this.m_sFilter = (String)in.readObject(0);
                this.m_nEfficiency = in.readInt(1);
                this.m_nSizeIn = in.readInt(2);
                this.m_nSizeOut = in.readInt(3);
                this.m_cMillis = in.readLong(4);
                in.readCollection(5, this.m_setIndexLookupRecords);
                in.readCollection(6, this.m_listSubSteps);
            }

            @Override
            public void writeExternal(PofWriter out) throws IOException {
                out.writeObject(0, this.m_sFilter);
                out.writeInt(1, this.m_nEfficiency);
                out.writeInt(2, this.m_nSizeIn);
                out.writeInt(3, this.m_nSizeOut);
                out.writeLong(4, this.m_cMillis);
                out.writeCollection(5, this.m_setIndexLookupRecords);
                LinkedList<Step> listSteps = new LinkedList<Step>();
                for (Step step : this.m_listSubSteps) {
                    listSteps.add(new Step(step));
                }
                out.writeCollection(6, listSteps);
            }
        }
    }
}

