/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.QueryRecord;
import com.tangosol.util.aggregator.QueryRecorder;
import java.util.LinkedList;
import java.util.List;

public class SimpleQueryRecordReporter {
    private static final String REPORT_DIVIDER = "======================================================================================%n";
    private static final String REPORT_NA = "----";
    private static final String REPORT_NO_INDEX = "No index found";
    private static final String REPORT_PARTITION_FORMAT = "%s%n%n";
    private static final String REPORT_TRACE_HEADER_FORMAT = "%nTrace%n%-35.35s   %-10.10s   %-20.20s   %-10.10s%n";
    private static final String REPORT_EXPLAIN_HEADER_FORMAT = "%nExplain Plan%n%-35.35s   %-10.10s   %-10.10s%n";
    private static final String REPORT_INDEX_HEADER_FORMAT = "%nIndex Lookups%n%-5.5s  %-40.40s  %-20.20s  %-10.10s%n";
    private static final String REPORT_TRACE_STEP_FORMAT = "%-35.35s | %-10.10s | %-20.20s | %-10.10s";
    private static final String REPORT_EXPLAIN_STEP_FORMAT = "%-35.35s | %-10.10s | %-10.10s";
    private static final String REPORT_INDEX_LOOKUP_FORMAT = "%-5.5s  %-40.40s  %-20.20s  %b";

    public static String report(QueryRecord record) {
        StringBuilder sb = new StringBuilder();
        LinkedList<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups = new LinkedList<QueryRecord.PartialResult.IndexLookupRecord>();
        List<? extends QueryRecord.PartialResult> listRecords = record.getResults();
        boolean fReportPartition = listRecords.size() > 1;
        for (QueryRecord.PartialResult partialResult : listRecords) {
            sb.append(SimpleQueryRecordReporter.reportResult(partialResult, record.getType(), listIndexLookups, fReportPartition));
        }
        sb.append(SimpleQueryRecordReporter.reportIndexLookUps(listIndexLookups));
        return sb.toString();
    }

    protected static String reportResult(QueryRecord.PartialResult result, QueryRecorder.RecordType type, List<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups, boolean fReportPartition) {
        StringBuilder sb = new StringBuilder();
        if (type == QueryRecorder.RecordType.TRACE) {
            sb.append(String.format(REPORT_TRACE_HEADER_FORMAT, "Name", "Index", "Effectiveness", "Duration"));
        } else {
            sb.append(String.format(REPORT_EXPLAIN_HEADER_FORMAT, "Name", "Index", "Cost"));
        }
        sb.append(String.format(REPORT_DIVIDER, new Object[0]));
        for (QueryRecord.PartialResult.Step step : result.getSteps()) {
            sb.append(SimpleQueryRecordReporter.reportStep(step, type, listIndexLookups, 0));
            sb.append(String.format("%n", new Object[0]));
        }
        sb.append(String.format("%n", new Object[0]));
        if (fReportPartition) {
            sb.append(String.format(REPORT_PARTITION_FORMAT, result.getPartitions().toString()));
        }
        return sb.toString();
    }

    protected static String reportIndexLookUps(List<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(REPORT_INDEX_HEADER_FORMAT, "Index", "Description", "Extractor", "Ordered"));
        sb.append(String.format(REPORT_DIVIDER, new Object[0]));
        for (int i = 0; i < listIndexLookups.size(); ++i) {
            sb.append(SimpleQueryRecordReporter.reportIndexLookupRecord(i, listIndexLookups.get(i)));
            sb.append(String.format("%n", new Object[0]));
        }
        sb.append(String.format("%n", new Object[0]));
        return sb.toString();
    }

    protected static String reportStep(QueryRecord.PartialResult.Step step, QueryRecorder.RecordType type, List<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups, int nLevel) {
        StringBuilder sbName = new StringBuilder();
        for (int i = 0; i < nLevel; ++i) {
            sbName.append("  ");
        }
        sbName.append(step.getFilterDescription());
        String sCost = step.getEfficiency() >= 0 ? Integer.toString(step.getEfficiency()) : REPORT_NA;
        String sSizeIn = step.getPreFilterKeySetSize() >= 0 ? Integer.toString(step.getPreFilterKeySetSize()) : REPORT_NA;
        String sSizeOut = step.getPostFilterKeySetSize() >= 0 ? Integer.toString(step.getPostFilterKeySetSize()) : REPORT_NA;
        String sDuration = step.getDuration() >= 0L ? Long.toString(step.getDuration()) : REPORT_NA;
        StringBuilder sbIndex = new StringBuilder();
        for (QueryRecord.PartialResult.IndexLookupRecord indexLookupRecord : step.getIndexLookupRecords()) {
            int n = listIndexLookups.indexOf(indexLookupRecord);
            if (n == -1) {
                n = listIndexLookups.size();
                listIndexLookups.add(indexLookupRecord);
            }
            sbIndex.append(sbIndex.length() > 0 ? "," : "" + n);
        }
        StringBuilder sbStep = new StringBuilder();
        if (type == QueryRecorder.RecordType.TRACE) {
            int n = step.getPreFilterKeySetSize() == 0 ? 0 : (step.getPreFilterKeySetSize() - step.getPostFilterKeySetSize()) * 100 / step.getPreFilterKeySetSize();
            String string = sSizeIn + "|" + sSizeOut + "(" + n + "%)";
            sbStep.append(String.format(REPORT_TRACE_STEP_FORMAT, sbName, sbIndex.length() > 0 ? sbIndex : REPORT_NA, string, sDuration));
        } else {
            sbStep.append(String.format(REPORT_EXPLAIN_STEP_FORMAT, sbName, sbIndex.length() > 0 ? sbIndex : REPORT_NA, sCost));
        }
        for (QueryRecord.PartialResult.Step step2 : step.getSteps()) {
            sbStep.append(String.format("%n", new Object[0])).append(SimpleQueryRecordReporter.reportStep(step2, type, listIndexLookups, nLevel + 1));
        }
        return sbStep.toString();
    }

    protected static String reportIndexLookupRecord(int nIndexLookupId, QueryRecord.PartialResult.IndexLookupRecord record) {
        String sIndexDesc = record.getIndexDescription();
        return String.format(REPORT_INDEX_LOOKUP_FORMAT, Integer.toString(nIndexLookupId), sIndexDesc == null ? REPORT_NO_INDEX : sIndexDesc, record.getExtractorDescription(), record.isOrdered());
    }
}

