/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigParseable;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FromMapMode;
import com.typesafe.config.impl.Parseable;
import com.typesafe.config.impl.PropertiesParser;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigImpl {
    private static final ConfigOrigin defaultValueOrigin = SimpleConfigOrigin.newSimple("hardcoded value");
    private static final ConfigBoolean defaultTrueValue = new ConfigBoolean(defaultValueOrigin, true);
    private static final ConfigBoolean defaultFalseValue = new ConfigBoolean(defaultValueOrigin, false);
    private static final ConfigNull defaultNullValue = new ConfigNull(defaultValueOrigin);
    private static final SimpleConfigList defaultEmptyList = new SimpleConfigList(defaultValueOrigin, Collections.<AbstractConfigValue>emptyList());
    private static final SimpleConfigObject defaultEmptyObject = SimpleConfigObject.empty(defaultValueOrigin);

    private static ConfigObject fromBasename(NameSource nameSource, String string, ConfigParseOptions configParseOptions) {
        ConfigObject configObject;
        if (string.endsWith(".conf") || string.endsWith(".json") || string.endsWith(".properties")) {
            ConfigParseable configParseable = nameSource.nameToParseable(string);
            configObject = configParseable.parse(configParseable.options().setAllowMissing(configParseOptions.getAllowMissing()));
        } else {
            Object object;
            ConfigParseable configParseable = nameSource.nameToParseable(string + ".conf");
            ConfigParseable configParseable2 = nameSource.nameToParseable(string + ".json");
            ConfigParseable configParseable3 = nameSource.nameToParseable(string + ".properties");
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            ConfigSyntax configSyntax = configParseOptions.getSyntax();
            configObject = SimpleConfigObject.empty(SimpleConfigOrigin.newSimple(string));
            if (configSyntax == null || configSyntax == ConfigSyntax.CONF) {
                try {
                    configObject = configParseable.parse(configParseable.options().setAllowMissing(false).setSyntax(ConfigSyntax.CONF));
                    bl = true;
                }
                catch (ConfigException.IO iO) {
                    arrayList.add(iO.getMessage());
                }
            }
            if (configSyntax == null || configSyntax == ConfigSyntax.JSON) {
                try {
                    object = configParseable2.parse(configParseable2.options().setAllowMissing(false).setSyntax(ConfigSyntax.JSON));
                    configObject = configObject.withFallback((ConfigMergeable)object);
                    bl = true;
                }
                catch (ConfigException.IO iO) {
                    arrayList.add(iO.getMessage());
                }
            }
            if (configSyntax == null || configSyntax == ConfigSyntax.PROPERTIES) {
                try {
                    object = configParseable3.parse(configParseable3.options().setAllowMissing(false).setSyntax(ConfigSyntax.PROPERTIES));
                    configObject = configObject.withFallback((ConfigMergeable)object);
                    bl = true;
                }
                catch (ConfigException.IO iO) {
                    arrayList.add(iO.getMessage());
                }
            }
            if (!configParseOptions.getAllowMissing() && !bl) {
                if (arrayList.isEmpty()) {
                    throw new ConfigException.BugOrBroken("should not be reached: nothing found but no exceptions thrown");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : arrayList) {
                    stringBuilder.append(string2);
                    stringBuilder.append(", ");
                }
                stringBuilder.setLength(stringBuilder.length() - 2);
                object = stringBuilder.toString();
                throw new ConfigException.IO(SimpleConfigOrigin.newSimple(string), (String)object);
            }
        }
        return configObject;
    }

    public static ConfigObject parseResourcesAnySyntax(final Class<?> clazz, String string, final ConfigParseOptions configParseOptions) {
        NameSource nameSource = new NameSource(){

            @Override
            public ConfigParseable nameToParseable(String string) {
                return Parseable.newResources(clazz, string, configParseOptions);
            }
        };
        return ConfigImpl.fromBasename(nameSource, string, configParseOptions);
    }

    public static ConfigObject parseResourcesAnySyntax(final ClassLoader classLoader, String string, final ConfigParseOptions configParseOptions) {
        NameSource nameSource = new NameSource(){

            @Override
            public ConfigParseable nameToParseable(String string) {
                return Parseable.newResources(classLoader, string, configParseOptions);
            }
        };
        return ConfigImpl.fromBasename(nameSource, string, configParseOptions);
    }

    public static ConfigObject parseFileAnySyntax(File file, final ConfigParseOptions configParseOptions) {
        NameSource nameSource = new NameSource(){

            @Override
            public ConfigParseable nameToParseable(String string) {
                return Parseable.newFile(new File(string), configParseOptions);
            }
        };
        return ConfigImpl.fromBasename(nameSource, file.getPath(), configParseOptions);
    }

    static AbstractConfigObject emptyObject(String string) {
        SimpleConfigOrigin simpleConfigOrigin = string != null ? SimpleConfigOrigin.newSimple(string) : null;
        return ConfigImpl.emptyObject(simpleConfigOrigin);
    }

    public static Config emptyConfig(String string) {
        return ConfigImpl.emptyObject(string).toConfig();
    }

    static AbstractConfigObject empty(ConfigOrigin configOrigin) {
        return ConfigImpl.emptyObject(configOrigin);
    }

    private static SimpleConfigList emptyList(ConfigOrigin configOrigin) {
        if (configOrigin == null || configOrigin == defaultValueOrigin) {
            return defaultEmptyList;
        }
        return new SimpleConfigList(configOrigin, Collections.<AbstractConfigValue>emptyList());
    }

    private static AbstractConfigObject emptyObject(ConfigOrigin configOrigin) {
        if (configOrigin == defaultValueOrigin) {
            return defaultEmptyObject;
        }
        return SimpleConfigObject.empty(configOrigin);
    }

    private static ConfigOrigin valueOrigin(String string) {
        if (string == null) {
            return defaultValueOrigin;
        }
        return SimpleConfigOrigin.newSimple(string);
    }

    public static ConfigValue fromAnyRef(Object object, String string) {
        ConfigOrigin configOrigin = ConfigImpl.valueOrigin(string);
        return ConfigImpl.fromAnyRef(object, configOrigin, FromMapMode.KEYS_ARE_KEYS);
    }

    public static ConfigObject fromPathMap(Map<String, ? extends Object> map2, String string) {
        ConfigOrigin configOrigin = ConfigImpl.valueOrigin(string);
        return (ConfigObject)((Object)ConfigImpl.fromAnyRef(map2, configOrigin, FromMapMode.KEYS_ARE_PATHS));
    }

    static AbstractConfigValue fromAnyRef(Object object, ConfigOrigin configOrigin, FromMapMode fromMapMode) {
        if (configOrigin == null) {
            throw new ConfigException.BugOrBroken("origin not supposed to be null");
        }
        if (object == null) {
            if (configOrigin != defaultValueOrigin) {
                return new ConfigNull(configOrigin);
            }
            return defaultNullValue;
        }
        if (object instanceof Boolean) {
            if (configOrigin != defaultValueOrigin) {
                return new ConfigBoolean(configOrigin, (Boolean)object);
            }
            if (((Boolean)object).booleanValue()) {
                return defaultTrueValue;
            }
            return defaultFalseValue;
        }
        if (object instanceof String) {
            return new ConfigString(configOrigin, (String)object);
        }
        if (object instanceof Number) {
            if (object instanceof Double) {
                return new ConfigDouble(configOrigin, (Double)object, null);
            }
            if (object instanceof Integer) {
                return new ConfigInt(configOrigin, (Integer)object, null);
            }
            if (object instanceof Long) {
                return new ConfigLong(configOrigin, (Long)object, null);
            }
            return ConfigNumber.newNumber(configOrigin, ((Number)object).doubleValue(), null);
        }
        if (object instanceof Map) {
            if (((Map)object).isEmpty()) {
                return ConfigImpl.emptyObject(configOrigin);
            }
            if (fromMapMode == FromMapMode.KEYS_ARE_KEYS) {
                HashMap<String, AbstractConfigValue> hashMap = new HashMap<String, AbstractConfigValue>();
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    Object k = entry.getKey();
                    if (!(k instanceof String)) {
                        throw new ConfigException.BugOrBroken("bug in method caller: not valid to create ConfigObject from map with non-String key: " + k);
                    }
                    AbstractConfigValue abstractConfigValue = ConfigImpl.fromAnyRef(entry.getValue(), configOrigin, fromMapMode);
                    hashMap.put((String)k, abstractConfigValue);
                }
                return new SimpleConfigObject(configOrigin, hashMap);
            }
            return PropertiesParser.fromPathMap(configOrigin, (Map)object);
        }
        if (object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            if (!iterator.hasNext()) {
                return ConfigImpl.emptyList(configOrigin);
            }
            ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
            while (iterator.hasNext()) {
                AbstractConfigValue abstractConfigValue = ConfigImpl.fromAnyRef(iterator.next(), configOrigin, fromMapMode);
                arrayList.add(abstractConfigValue);
            }
            return new SimpleConfigList(configOrigin, arrayList);
        }
        throw new ConfigException.BugOrBroken("bug in method caller: not valid to create ConfigValue from: " + object);
    }

    static ConfigIncluder defaultIncluder() {
        try {
            return DefaultIncluderHolder.defaultIncluder;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    private static AbstractConfigObject loadSystemProperties() {
        return (AbstractConfigObject)Parseable.newProperties(System.getProperties(), ConfigParseOptions.defaults().setOriginDescription("system properties")).parse();
    }

    static AbstractConfigObject systemPropertiesAsConfigObject() {
        try {
            return SystemPropertiesHolder.systemProperties;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    public static Config systemPropertiesAsConfig() {
        return ConfigImpl.systemPropertiesAsConfigObject().toConfig();
    }

    static void reloadSystemPropertiesConfig() {
        SystemPropertiesHolder.systemProperties = ConfigImpl.loadSystemProperties();
    }

    private static AbstractConfigObject loadEnvVariables() {
        Map<String, String> map2 = System.getenv();
        HashMap<String, AbstractConfigValue> hashMap = new HashMap<String, AbstractConfigValue>();
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            String string = entry.getKey();
            hashMap.put(string, new ConfigString(SimpleConfigOrigin.newSimple("env var " + string), entry.getValue()));
        }
        return new SimpleConfigObject(SimpleConfigOrigin.newSimple("env variables"), hashMap, ResolveStatus.RESOLVED, false);
    }

    static AbstractConfigObject envVariablesAsConfigObject() {
        try {
            return EnvVariablesHolder.envVariables;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    public static Config envVariablesAsConfig() {
        return ConfigImpl.envVariablesAsConfigObject().toConfig();
    }

    public static Config defaultReference(ClassLoader classLoader) {
        Config config = Parseable.newResources(classLoader, "reference.conf", ConfigParseOptions.defaults()).parse().toConfig();
        return ConfigImpl.systemPropertiesAsConfig().withFallback(config).resolve();
    }

    static /* synthetic */ AbstractConfigObject access$100() {
        return ConfigImpl.loadSystemProperties();
    }

    static /* synthetic */ AbstractConfigObject access$200() {
        return ConfigImpl.loadEnvVariables();
    }

    private static class EnvVariablesHolder {
        static final AbstractConfigObject envVariables = ConfigImpl.access$200();

        private EnvVariablesHolder() {
        }
    }

    private static class SystemPropertiesHolder {
        static AbstractConfigObject systemProperties = ConfigImpl.access$100();

        private SystemPropertiesHolder() {
        }
    }

    private static class DefaultIncluderHolder {
        static final ConfigIncluder defaultIncluder = new SimpleIncluder(null);

        private DefaultIncluderHolder() {
        }
    }

    private static class SimpleIncluder
    implements ConfigIncluder {
        private ConfigIncluder fallback;

        SimpleIncluder(ConfigIncluder configIncluder) {
            this.fallback = configIncluder;
        }

        @Override
        public ConfigObject include(final ConfigIncludeContext configIncludeContext, String string) {
            NameSource nameSource = new NameSource(){

                @Override
                public ConfigParseable nameToParseable(String string) {
                    ConfigParseable configParseable = configIncludeContext.relativeTo(string);
                    if (configParseable == null) {
                        return Parseable.newNotFound(string, "include was not found: '" + string + "'", ConfigParseOptions.defaults());
                    }
                    return configParseable;
                }
            };
            ConfigObject configObject = ConfigImpl.fromBasename(nameSource, string, ConfigParseOptions.defaults().setAllowMissing(true));
            if (this.fallback != null) {
                return configObject.withFallback(this.fallback.include(configIncludeContext, string));
            }
            return configObject;
        }

        @Override
        public ConfigIncluder withFallback(ConfigIncluder configIncluder) {
            if (this == configIncluder) {
                throw new ConfigException.BugOrBroken("trying to create includer cycle");
            }
            if (this.fallback == configIncluder) {
                return this;
            }
            if (this.fallback != null) {
                return new SimpleIncluder(this.fallback.withFallback(configIncluder));
            }
            return new SimpleIncluder(configIncluder);
        }
    }

    private static interface NameSource {
        public ConfigParseable nameToParseable(String var1);
    }
}

