/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class FileHelper
extends Util {
    public FileHelper(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static void copyFile(File fileFrom, File fileTo) throws IOException {
        FileInputStream streamIn = new FileInputStream(fileFrom);
        FileOutputStream streamOut = new FileOutputStream(fileTo);
        try {
            int cb;
            int cbBlock = 8092;
            byte[] ab = new byte[cbBlock];
            while (!((cb = streamIn.read(ab, 0, cbBlock)) <= 0)) {
                streamOut.write(ab, 0, cb);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            streamIn.close();
            streamOut.close();
            throw throwable;
        }
        streamIn.close();
        streamOut.close();
        fileTo.setLastModified(fileFrom.lastModified());
    }

    public static String getRelativePath(String sPath, String sRoot) {
        char SEP = File.separatorChar;
        try {
            String sRootAbs = new File(sRoot).getCanonicalPath();
            String sPathAbs = new File(sPath).getCanonicalPath();
            if (sPathAbs.equals(sRootAbs)) {
                return "./";
            }
            if (sPathAbs.startsWith(String.valueOf(sRootAbs) + SEP)) {
                return String.valueOf("./") + sPathAbs.substring(sRootAbs.length() + 1).replace(SEP, '/');
            }
            char[] achRoot = sRootAbs.toCharArray();
            char[] achPath = sPathAbs.toCharArray();
            int cMin = Math.min(achRoot.length, achPath.length);
            int ofRoot = -1;
            int ofDiff = cMin;
            int of = 0;
            while (of < cMin) {
                char ch = achPath[of];
                if (ch == achRoot[of]) {
                    if (ch == SEP) {
                        ofRoot = of;
                    }
                } else {
                    ofDiff = of;
                    break;
                }
                ++of;
            }
            if (ofRoot > 0) {
                StringBuffer sbPath = new StringBuffer();
                int of2 = achRoot.length - 1;
                while (of2 >= ofRoot) {
                    if (achRoot[of2] == SEP) {
                        sbPath.append("../");
                    }
                    --of2;
                }
                sbPath.append(sPathAbs.substring(ofRoot + 1).replace(SEP, '/'));
                Component._assert(new File(new File(sRoot), sbPath.toString()).getCanonicalPath().equals(sPathAbs));
                return sbPath.toString();
            }
        }
        catch (IOException iOException) {}
        return sPath.replace('\\', '/');
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/FileHelper".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public static boolean isFullyAccessible(File file) {
        try {
            file = file.getCanonicalFile();
            if (file.exists()) {
                if (file.canRead() ^ true ? true : file.canWrite() ^ true) {
                    return false;
                }
                File fileTmp = File.createTempFile("tmp", ".tmp", file.getParentFile());
                fileTmp.delete();
                if (file.renameTo(fileTmp) ^ true) {
                    return false;
                }
                if (fileTmp.renameTo(file) ^ true) {
                    throw new IllegalStateException(String.valueOf("File: ") + file + " was temporarily renamed to: " + fileTmp + " but could not be renamed back. The operation should be performed manually.");
                }
                return true;
            }
            if (file.createNewFile()) {
                file.delete();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

