/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$SocketManager$MulticastUdpSocket;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberHeartbeat;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounce;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceWait;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberInduct;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestId;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdReject;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdWait;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberTimestampRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberTimestampResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberWelcomeAnnounce;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyIpTimeout;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyTcmpTimeout;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$QuorumControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$QuorumRollCall;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberHeartbeat;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberKill;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberPanic;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoinRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceRegister;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceRegisterRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceSecureRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceUpdateResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$TcpRing;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.net.management.Registry;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Continuation;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ClusterService
extends Grid {
    public static final int REJECT_AUTHORIZE = 1;
    public static final int REJECT_CLUSTER_NAME = 7;
    public static final int REJECT_EDITION = 8;
    public static final int REJECT_LICENSE_EXPIRED = 4;
    public static final int REJECT_LICENSE_TYPE = 9;
    public static final int REJECT_PACKET_MAX = 3;
    public static final int REJECT_SENIOR = 5;
    public static final int REJECT_SIZE = 0;
    public static final int REJECT_VERSION = 2;
    public static final int REJECT_WKA = 6;
    public static final int STATE_ANNOUNCE = 0;
    public static final int STATE_JOINED = 2;
    public static final int STATE_JOINING = 1;
    public static final int STATE_LEAVING = 3;
    public static final int STATE_LEFT = 4;
    private Member __m_AnnounceMember;
    private transient Set __m_BroadcastAddresses;
    private int __m_BroadcastCounter;
    private int __m_BroadcastLimit;
    private int __m_BroadcastMode;
    private long __m_BroadcastNextMillis;
    private int __m_BroadcastRepeatMillis;
    private int __m_BroadcastTimeoutMillis;
    private Binary __m_BroadcastTimestamp;
    private transient int __m_DeliveryTimeoutMillis;
    private int __m_HeartbeatDelay;
    private transient MemberSet __m_HeartbeatMemberSet;
    private transient long __m_LastInterminableWarningMillis;
    private UUID __m_LastPanicUid;
    private transient int __m_MaximumPacketLength;
    private long __m_MembershipReopen;
    private transient LongArray __m_PendingServiceJoining;
    private ClusterService$QuorumControl __m_QuorumControl;
    private Member __m_RequestMember;
    private Grid[] __m_Service;
    private ServiceInfo[] __m_ServiceInfo;
    private int __m_State;
    private transient long __m_StatsMembersDepartureCount;
    private transient ClusterService$TcpRing __m_TcpRing;
    private transient long __m_TimestampAdjustment;
    private transient int __m_TimestampMaxVariance;
    private Set __m_WellKnownAddresses;
    private Map __m_WkaMap;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        ClusterService.__initStatic();
    }

    public ClusterService() {
        this(null, null, true);
    }

    public ClusterService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(true);
            this.setBroadcastRepeatMillis(256);
            this.setBroadcastTimeoutMillis(32768);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setSerializerMap(new WeakHashMap());
            this.setServiceId(0);
            this.setServiceName("Cluster");
            this.setTimestampMaxVariance(10);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid$Guard("Guard", this, true), "Guard");
        this._addChild(new ClusterService$InQueue("InQueue", this, true), "InQueue");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new ClusterService$QuorumControl("QuorumControl", this, true), "QuorumControl");
        this._addChild(new Grid$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this._addChild(new ClusterService$TcpRing("TcpRing", this, true), "TcpRing");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_PendingServiceJoining = new SparseArray();
            this.__m_WkaMap = new SafeHashMap();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz6 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz8 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz9 = __mapChildren.put("MemberHeartbeat", ClusterService$MemberHeartbeat.get_CLASS());
        Class clazz10 = __mapChildren.put("MemberJoined", ClusterService$MemberJoined.get_CLASS());
        Class clazz11 = __mapChildren.put("MemberLeaving", ClusterService$MemberLeaving.get_CLASS());
        Class clazz12 = __mapChildren.put("MemberLeft", ClusterService$MemberLeft.get_CLASS());
        Class clazz13 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz14 = __mapChildren.put("MemberWelcomeRequest", ClusterService$MemberWelcomeRequest.get_CLASS());
        Class clazz15 = __mapChildren.put("NewMemberAnnounce", ClusterService$NewMemberAnnounce.get_CLASS());
        Class clazz16 = __mapChildren.put("NewMemberAnnounceReply", ClusterService$NewMemberAnnounceReply.get_CLASS());
        Class clazz17 = __mapChildren.put("NewMemberAnnounceWait", ClusterService$NewMemberAnnounceWait.get_CLASS());
        Class clazz18 = __mapChildren.put("NewMemberInduct", ClusterService$NewMemberInduct.get_CLASS());
        Class clazz19 = __mapChildren.put("NewMemberRequestId", ClusterService$NewMemberRequestId.get_CLASS());
        Class clazz20 = __mapChildren.put("NewMemberRequestIdReject", ClusterService$NewMemberRequestIdReject.get_CLASS());
        Class clazz21 = __mapChildren.put("NewMemberRequestIdReply", ClusterService$NewMemberRequestIdReply.get_CLASS());
        Class clazz22 = __mapChildren.put("NewMemberRequestIdWait", ClusterService$NewMemberRequestIdWait.get_CLASS());
        Class clazz23 = __mapChildren.put("NewMemberTimestampRequest", ClusterService$NewMemberTimestampRequest.get_CLASS());
        Class clazz24 = __mapChildren.put("NewMemberTimestampResponse", ClusterService$NewMemberTimestampResponse.get_CLASS());
        Class clazz25 = __mapChildren.put("NewMemberWelcome", ClusterService$NewMemberWelcome.get_CLASS());
        Class clazz26 = __mapChildren.put("NewMemberWelcomeAnnounce", ClusterService$NewMemberWelcomeAnnounce.get_CLASS());
        Class clazz27 = __mapChildren.put("NewMemberWelcomeRequest", ClusterService$NewMemberWelcomeRequest.get_CLASS());
        Class clazz28 = __mapChildren.put("NotifyIpTimeout", ClusterService$NotifyIpTimeout.get_CLASS());
        Class clazz29 = __mapChildren.put("NotifyMemberJoined", ClusterService$NotifyMemberJoined.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz31 = __mapChildren.put("NotifyMemberLeft", ClusterService$NotifyMemberLeft.get_CLASS());
        Class clazz32 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz33 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz34 = __mapChildren.put("NotifyResponse", ClusterService$NotifyResponse.get_CLASS());
        Class clazz35 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz36 = __mapChildren.put("NotifyServiceJoined", Grid$NotifyServiceJoined.get_CLASS());
        Class clazz37 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz38 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz39 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz40 = __mapChildren.put("NotifyShutdown", ClusterService$NotifyShutdown.get_CLASS());
        Class clazz41 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz42 = __mapChildren.put("NotifyTcmpTimeout", ClusterService$NotifyTcmpTimeout.get_CLASS());
        Class clazz43 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz44 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz45 = __mapChildren.put("QuorumRollCall", ClusterService$QuorumRollCall.get_CLASS());
        Class clazz46 = __mapChildren.put("ReceiveQueue", Grid$ReceiveQueue.get_CLASS());
        Class clazz47 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz48 = __mapChildren.put("SeniorMemberHeartbeat", ClusterService$SeniorMemberHeartbeat.get_CLASS());
        Class clazz49 = __mapChildren.put("SeniorMemberKill", ClusterService$SeniorMemberKill.get_CLASS());
        Class clazz50 = __mapChildren.put("SeniorMemberPanic", ClusterService$SeniorMemberPanic.get_CLASS());
        Class clazz51 = __mapChildren.put("ServiceJoined", ClusterService$ServiceJoined.get_CLASS());
        Class clazz52 = __mapChildren.put("ServiceJoining", ClusterService$ServiceJoining.get_CLASS());
        Class clazz53 = __mapChildren.put("ServiceJoinRequest", ClusterService$ServiceJoinRequest.get_CLASS());
        Class clazz54 = __mapChildren.put("ServiceLeaving", ClusterService$ServiceLeaving.get_CLASS());
        Class clazz55 = __mapChildren.put("ServiceLeft", ClusterService$ServiceLeft.get_CLASS());
        Class clazz56 = __mapChildren.put("ServiceRegister", ClusterService$ServiceRegister.get_CLASS());
        Class clazz57 = __mapChildren.put("ServiceRegisterRequest", ClusterService$ServiceRegisterRequest.get_CLASS());
        Class clazz58 = __mapChildren.put("ServiceSecureRequest", ClusterService$ServiceSecureRequest.get_CLASS());
        Class clazz59 = __mapChildren.put("ServiceUpdateResponse", ClusterService$ServiceUpdateResponse.get_CLASS());
        Class clazz60 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.util.Base");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicBroadcast(Member member) {
        Set setBroadcast;
        if ((!(member != null) ? false : this.isWellKnown(member) ^ true) && (setBroadcast = this.getBroadcastAddresses()) != null) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.add(member.getSocketAddress());
            }
        }
    }

    public static int calcMachines(Set setMembers) {
        HashSet<Integer> setMachines = new HashSet<Integer>();
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            setMachines.add(Base.makeInteger(member.getMachineId()));
        }
        return setMachines.size();
    }

    public long calcTimestamp(long lLocalhostMillis) {
        if (lLocalhostMillis != (long)0) {
            lLocalhostMillis += this.getTimestampAdjustment();
        }
        return lLocalhostMillis;
    }

    protected void checkGuardables() {
        long cLateMillis;
        if (this.isGuardian() && (cLateMillis = this.getGuardSupport().check()) > 0L) {
            Component._trace(String.valueOf("Service guardian is ") + cLateMillis + "ms late, indicating that this JVM may be " + "running slowly or experienced a long GC", 5);
        }
    }

    protected void checkPendingJoinPolls() {
        block13: {
            Component._assert(Thread.currentThread() == this.getThread());
            LongArray laPending = this.getPendingServiceJoining();
            if (!(laPending.isEmpty() ^ true)) break block13;
            long ldtNow = Base.getSafeTimeMillis();
            long cTimeout = this.getDeliveryTimeoutMillis();
            long ldtCutoff = ldtNow - (cTimeout - (cTimeout >> 2));
            long ldtOldest = laPending.getFirstIndex();
            if (ldtOldest < ldtCutoff) {
                ClusterService$ServiceJoining msg = (ClusterService$ServiceJoining)laPending.get(ldtOldest);
                String sMsg = "ServiceJoining";
                try {
                    sMsg = String.valueOf(msg);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Poll poll = msg.getRequestPoll();
                if (poll == null) {
                    laPending.remove(ldtOldest);
                    Component._trace(String.valueOf("validatePolls: ") + "This senior encountered a null pending poll for message: " + sMsg, 1);
                    return;
                }
                MemberSet setRemain = poll.getRemainingMemberSet();
                if (setRemain.isEmpty()) {
                    boolean fWasClosed = poll.isClosed();
                    poll.close();
                    laPending.remove(ldtOldest);
                    Component._trace(String.valueOf("validatePolls: ") + "This senior encountered an empty " + (fWasClosed ? "closed " : "") + "pending poll for message: " + sMsg, 1);
                    return;
                }
                String sPoll = "Poll";
                try {
                    sPoll = poll.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Component._trace(String.valueOf("validatePolls: ") + "This senior encountered an overdue poll, indicating a dead " + "member, a significant network issue or an Operating " + "System threading library bug (e.g. Linux NPTL): " + sPoll + "\nfor message: " + sMsg, 2);
                try {
                    ArrayList<Member> listOverdue = new ArrayList<Member>();
                    HashSet<Integer> setMachines = new HashSet<Integer>();
                    MasterMemberSet setAll = this.getClusterMemberSet();
                    Member[] aMember = (Member[])((MemberSet)setAll).toArray(new Member[((MemberSet)setAll).size()]);
                    int i = 0;
                    int c = aMember.length;
                    while (i < c) {
                        Member member = aMember[i];
                        if (!(member != null) ? false : setRemain.contains(member)) {
                            listOverdue.add(member);
                            setMachines.add(new Integer(member.getMachineId()));
                        }
                        ++i;
                    }
                    long ldtGiveUp = ldtOldest + (cTimeout + (cTimeout >> 2));
                    if (!(setMachines.size() <= 1 ? true : ldtNow > ldtGiveUp)) break block13;
                    Iterator iter = listOverdue.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        Component._trace(String.valueOf("Removing unresponsive member: ") + member, 2);
                        this.doMemberLeft(member);
                    }
                    poll.close();
                    if (listOverdue.isEmpty()) {
                        Component._trace(String.valueOf("validatePolls: ") + "This senior encountered and closed an overdue poll " + "that did not contain any known members, indicating " + "a likely JVM or Operating System threading library " + "(e.g. Linux NPTL) bug: " + sPoll, 1);
                    }
                }
                catch (Throwable e) {
                    Component._trace(String.valueOf("validatePolls: ") + "Non-fatal exception detected during processing:", 1);
                    Component._trace(e);
                    Component._trace(String.valueOf("validatePolls: ") + "Exception has been logged; continuing processing.", 1);
                }
            }
        }
    }

    public int compareImportance(Member memberThat) {
        Member memberThis = this.getThisMember();
        int nThisWeight = memberThis.getPriority();
        if (this.isWellKnown(memberThis)) {
            ++nThisWeight;
        }
        int nThatWeight = memberThat.getPriority();
        if (this.isWellKnown(memberThat)) {
            ++nThatWeight;
        }
        int iResult = nThisWeight - nThatWeight;
        int i = 1;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                iResult += service.compareImportance(memberThat);
            }
            ++i;
        }
        return iResult;
    }

    public void doMemberInduct(Member memberNew) {
        Component._assert(Thread.currentThread() == this.getThread());
        ClusterService$NewMemberInduct msg = (ClusterService$NewMemberInduct)this.instantiateMessage("NewMemberInduct");
        msg.addToMember(memberNew);
        MasterMemberSet setMember = this.getClusterMemberSet();
        Object[] aoMember = setMember.toArray();
        int cMembers = aoMember.length;
        msg.setMemberCount(cMembers);
        int i = 0;
        while (i < cMembers) {
            Member member = (Member)aoMember[i];
            msg.setMember(i, member);
            msg.setServiceVersion(i, setMember.getServiceVersion(member.getId()));
            ++i;
        }
        int cServices = this.getServiceInfoCount();
        msg.setServiceCount(cServices);
        int i2 = 0;
        while (i2 < cServices) {
            ServiceInfo info = this.getServiceInfo(i2);
            msg.setServiceId(i2, info.getServiceId());
            msg.setServiceName(i2, info.getServiceName());
            msg.setServiceType(i2, info.getServiceType());
            ++i2;
        }
        this.send(msg);
    }

    public void doMemberLeaving() {
        this.setState(STATE_LEAVING);
        Member memberThis = this.getThisMember();
        if (memberThis != null) {
            ClusterService$MemberLeaving msg = (ClusterService$MemberLeaving)this.instantiateMessage("MemberLeaving");
            msg.setToMemberSet(this.getOthersMemberSet());
            msg.setMemberId(memberThis.getId());
            msg.setMemberUid(memberThis.getUid32());
            this.send(msg);
        }
    }

    public void doMemberLeft() {
        Member memberThis;
        if (this.getTcpRing().isEnabled() ^ true && (memberThis = this.getThisMember()) != null) {
            this.doMemberLeft(memberThis);
            Daemon.sleep(((Cluster)this.getCluster()).getDependencies().getPublisherAckDelayMillis());
        }
        this.setState(STATE_LEFT);
    }

    public void doMemberLeft(Member member) {
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member memberThis = setMember.getThisMember();
        if (setMember.contains(member)) {
            MemberSet setTo;
            this.removeMember(member);
            Member memberSenior = setMember.getOldestMember();
            MemberSet memberSet = setTo = memberThis == memberSenior ? this.getOthersMemberSet() : SingleMemberSet.instantiate(memberSenior);
            if (setTo.isEmpty() ^ true) {
                ClusterService$MemberLeft msg = (ClusterService$MemberLeft)this.instantiateMessage("MemberLeft");
                msg.setToMemberSet(setTo);
                msg.setMemberId(member.getId());
                msg.setMemberUID(member.getUid32());
                this.send(msg);
            }
        } else {
            Component._trace(String.valueOf("ClusterService.doMemberLeft: ") + "Unknown " + member, 4);
        }
    }

    public void doNotifyIpTimeout(InetAddress address) {
        ClusterService$NotifyIpTimeout msg = (ClusterService$NotifyIpTimeout)this.instantiateMessage("NotifyIpTimeout");
        msg.addToMember(this.getThisMember());
        msg.setTimedOutAddress(address);
        this.send(msg);
    }

    public void doNotifyTcmpTimeout(MessagePacket packet, MemberSet setTimedOut) {
        ClusterService$NotifyTcmpTimeout msg = (ClusterService$NotifyTcmpTimeout)this.instantiateMessage("NotifyTcmpTimeout");
        msg.addToMember(this.getThisMember());
        msg.setUndeliverablePacket(packet);
        msg.setTimedOutMembers(setTimedOut);
        this.send(msg);
    }

    public void doServiceJoined(Grid service) {
        int nId = service.getServiceId();
        if (nId > 0) {
            ServiceMemberSet setMember = this.getServiceInfo(nId).getMemberSet();
            Member memberThis = this.getThisMember();
            int nMemberId = memberThis.getId();
            long ldtJoined = setMember.getServiceJoinTime(nMemberId);
            MemberSet setJoined = new MemberSet();
            setMember.setServiceJoined(nMemberId);
            MasterMemberSet setClusterMember = this.getClusterMemberSet();
            Iterator iter = setClusterMember.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(!setClusterMember.isServiceJoined(member.getId()) ? false : member != memberThis)) continue;
                setJoined.add(member);
            }
            ClusterService$ServiceJoined msg = (ClusterService$ServiceJoined)this.instantiateMessage("ServiceJoined");
            msg.setToMemberSet(setJoined);
            msg.setServiceId(nId);
            msg.setServiceJoinTime(ldtJoined);
            this.send(msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doServiceJoining(Grid service) {
        int nServiceId = service.getServiceId();
        if (!(nServiceId > 0) ? false : this.getService(nServiceId) == null) {
            this.getServiceInfo(nServiceId).setServiceJoinTime(this.getThisMember().getId(), 0L);
            this.setService(nServiceId, service);
            do {
                ClusterService$ServiceJoinRequest msg = (ClusterService$ServiceJoinRequest)this.instantiateMessage("ServiceJoinRequest");
                msg.addToMember(this.getClusterOldestMember());
                msg.setServiceId(nServiceId);
                msg.setServiceVersion(service.getServiceVersion());
                msg.setServiceEndPointName(service.getEndPointName());
                msg.setMemberConfigMap(new HashMap(service.getThisMemberConfigMap()));
                try {
                    this.poll(msg);
                }
                catch (RuntimeException e) {
                    this.setService(nServiceId, null);
                    throw e;
                }
                if (service.getServiceMemberSet() != null) {
                    return;
                }
                boolean bl = true;
                if (!bl) return;
            } while (!(nServiceId != this.ensureService(service.getServiceName(), service.getServiceType())));
            this.setService(nServiceId, null);
            throw new RuntimeException("Service info mismatch; service has to be restarted");
        }
        if (this.getService(nServiceId) == service) {
            return;
        }
        boolean bl = true;
        if (!bl) return;
        throw new IllegalStateException(String.valueOf("Attempt to replace existing service: ") + this.getService(nServiceId) + "\nwith a different instance: " + service);
    }

    public void doServiceLeaving(Grid service) {
        int nId = service.getServiceId();
        if (nId > 0) {
            if (this.getService(nId) == service) {
                ServiceMemberSet setMember = this.getServiceInfo(nId).getMemberSet();
                Member memberThis = this.getThisMember();
                int nMemberId = memberThis.getId();
                long ldtJoined = setMember.getServiceJoinTime(nMemberId);
                setMember.setServiceLeaving(nMemberId);
                ClusterService$ServiceLeaving msg = (ClusterService$ServiceLeaving)this.instantiateMessage("ServiceLeaving");
                msg.setToMemberSet(this.getOthersMemberSet());
                msg.setServiceId(nId);
                msg.setServiceJoinTime(ldtJoined);
                this.send(msg);
            } else {
                Component._trace(String.valueOf("ClusterService.doServiceLeaving: ") + "Unknown Service " + service, 1);
            }
        }
    }

    public void doServiceLeft(Grid service) {
        int nId = service.getServiceId();
        if (nId > 0) {
            if (this.getService(nId) == service) {
                ServiceMemberSet setMember = this.getServiceInfo(nId).getMemberSet();
                Member memberThis = this.getThisMember();
                long ldtJoined = setMember.getServiceJoinTime(memberThis.getId());
                setMember.remove(memberThis);
                this.setService(nId, null);
                ClusterService$ServiceLeft msg = (ClusterService$ServiceLeft)this.instantiateMessage("ServiceLeft");
                msg.setToMemberSet(this.getOthersMemberSet());
                msg.setServiceId(nId);
                msg.setServiceJoinTime(ldtJoined);
                this.send(msg);
            } else {
                Component._trace(String.valueOf("ClusterService.doServiceLeft: ") + "Unknown Service " + service, 1);
            }
        }
    }

    public Member ensureMember(Member memberNew, String sVersion) {
        int nId;
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member member = setMember.getMember(nId = memberNew.getId());
        if (member == null) {
            member = memberNew;
            setMember.add(member);
            setMember.setServiceVersion(nId, sVersion);
            setMember.setServiceJoinTime(nId, member.getTimestamp());
            setMember.setServiceEndPointName(nId, "");
            setMember.ensureMemberConfigMap(nId).clear();
            setMember.setServiceJoining(nId);
            this.onMemberJoined(member);
        }
        return member;
    }

    /*
     * Unable to fully structure code
     */
    public int ensureService(String sName, String sType) {
        do {
            msg = (ClusterService$ServiceRegisterRequest)this.instantiateMessage("ServiceRegisterRequest");
            msg.addToMember(this.getClusterOldestMember());
            msg.setServiceName(sName);
            msg.setServiceType(sType);
        } while ((oResult = this.poll(msg)) == null);
        nId = (Integer)oResult;
        info = this.getServiceInfo(nId);
        sTypeReg = info.getServiceType();
        if (!(sType.equals(sTypeReg) ^ true)) ** GOTO lbl17
        throw new IllegalArgumentException(String.valueOf("Invalid service type: requested=") + sType + ", registered=" + sTypeReg);
        while (!((memberSenior = (Member)info.getOldestMember()) == null != false ? true : memberSenior.equals(this.getThisMember()))) {
            oResponse = this.pollSecure(memberSenior, null);
            if (!(oResponse == null)) {
                if (!(oResponse instanceof Exception)) break;
                throw new WrapperException((Exception)oResponse);
            }
lbl17:
            // 3 sources

            if (Security.getInstance() == null) continue;
        }
        return nId;
    }

    public ServiceInfo ensureServiceInfo(int nService, String sName, String sType) {
        ServiceInfo[] ainfo = this.getServiceInfo();
        int i = 0;
        int c = ainfo == null ? 0 : ainfo.length;
        while (i < c) {
            ServiceInfo info = ainfo[i];
            if (info != null) {
                boolean fObsolete = false;
                fObsolete = i == nService ? (info.getServiceName().equals(sName) ^ true ? true : (!(sType != null) ? false : sType.equals(info.getServiceType()) ^ true)) : info.getServiceName().equals(sName);
                if (fObsolete) {
                    Component._trace(String.valueOf("Removing the obsolete service info: ") + info, 3);
                    ainfo[i] = null;
                }
            }
            ++i;
        }
        ServiceInfo info = this.getServiceInfo(nService);
        if (info == null) {
            info = new ServiceInfo();
            info.setMemberSet(nService == 0 ? this.getServiceMemberSet() : new ServiceMemberSet());
            info.setServiceId(nService);
            info.setServiceName(sName);
            info.setServiceType(sType);
            this.setServiceInfo(nService, info);
            this.onServiceAnnounced(info);
        } else {
            Component._assert(sName.equals(info.getServiceName()));
            Component._assert(sType == null ? true : sType.equals(info.getServiceType()));
        }
        return info;
    }

    public int ensureWkaMember(Member memberNew) {
        int[] acMax = new int[4];
        int nType = memberNew.getEdition();
        Iterator iter = this.getWkaMap().values().iterator();
        while (iter.hasNext()) {
            int[] an = (int[])iter.next();
            if (!(!(an[0] == nType) ? false : an[1] < 4)) continue;
            acMax[an[1]] = acMax[an[1]] + Math.max(an[2], 1);
        }
        if (acMax[0] > 0) {
            return 0;
        }
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        map.put(new Integer(memberNew.getMachineId()), memberNew.getStatsCount());
        Iterator iter2 = this.getClusterMemberSet().iterator();
        while (iter2.hasNext()) {
            int[] anNew;
            Integer IKey;
            int[] anOld;
            Member member = (Member)iter2.next();
            if (!(member.getEdition() == nType) || !((anOld = map.put(IKey = new Integer(member.getMachineId()), anNew = member.getStatsCount())) != null)) continue;
            int i = 0;
            int c = anNew.length;
            while (i < c) {
                anNew[i] = Math.max(anOld[i], anNew[i]);
                ++i;
            }
        }
        int[] acCur = new int[4];
        Iterator iter3 = map.values().iterator();
        while (iter3.hasNext()) {
            int[] an = (int[])iter3.next();
            acCur[1] = acCur[1] + 1;
            acCur[2] = acCur[2] + an[1];
            acCur[3] = acCur[3] + an[0];
        }
        int i = 1;
        int c = acMax.length;
        while (i < c) {
            int cMax = acMax[i];
            if (cMax > 0) {
                int nResult = acCur[i] - cMax;
                return nResult <= 0 ? nResult : i << 29 | cMax << 12 | nResult;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public String formatClusterString() {
        String sClusterName = this.getClusterName();
        StringBuffer sb = new StringBuffer("cluster");
        if (!(sClusterName != null) ? false : sClusterName.length() > 0) {
            sb.append(" \"").append(sClusterName).append('\"');
        }
        return sb.toString();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "STATE_ANNOUNCE";
            }
            case 1: {
                return "STATE_JOINING";
            }
            case 2: {
                return "STATE_JOINED";
            }
            case 3: {
                return "STATE_LEAVING";
            }
            case 4: {
                return "STATE_LEFT";
            }
        }
        return "<unknown>";
    }

    public int fromString(String s) {
        if (!(s != null) ? false : s.length() >= 2) {
            String[] a;
            char ch1 = s.charAt(0);
            int ch2 = s.charAt(1);
            if (s.indexOf(32) > 0 && (!(!(!(!((a = Base.parseDelimitedString(s, ' ')).length > 3) ? false : a[0].length() > 5) ? false : a[1].length() > 5) ? false : a[2].length() > 3) ? false : a[3].length() > 3)) {
                int n = 0;
                int i = 1;
                while (i < 4) {
                    n = n << 8 | a[i].charAt(i);
                    ++i;
                }
                switch (n) {
                    case 7103333: 
                    case 7304293: {
                        return 0;
                    }
                    case 7299429: 
                    case 7302501: {
                        return 1;
                    }
                    case 7299956: {
                        if (a[2].charAt(0) == 'L') {
                            return 0;
                        }
                    }
                    case 7299444: 
                    case 7304564: {
                        return 3;
                    }
                    case 7303284: 
                    case 7304308: {
                        if (a[2].charAt(0) != 'D') {
                            return 4;
                        }
                    }
                    case 7301492: {
                        return 5;
                    }
                }
            }
            if (!(!(s.length() >= 30) ? false : s.charAt(13) == 'l') ? false : s.charAt(28) == 'c') {
                ch2 = s.length();
                ch1 = s.charAt(ch2 - 1);
                switch (ch1) {
                    case 'e': {
                        return 5 - (ch2 < 33 ? 2 : 1);
                    }
                    case 'l': 
                    case 's': {
                        return 0;
                    }
                }
                ch2 = s.charAt(ch2 - (ch1 == 'n' ? 1 : 0) - 6);
                ch1 = s.charAt(30);
            }
            switch (ch1) {
                case 'G': {
                    return 5;
                }
                case 'E': 
                case 'e': {
                    return ch2 == ch1 ? 4 : 0;
                }
                case 'S': {
                    return 3;
                }
                case 'P': 
                case 'p': {
                    return 2;
                }
                case 'C': 
                case 'R': {
                    return 1;
                }
                case 'D': 
                case 'd': {
                    return ch2 == 101 ? 1 : 0;
                }
            }
        }
        return -1;
    }

    public Member getAnnounceMember() {
        return this.__m_AnnounceMember;
    }

    public Set getBroadcastAddresses() {
        return this.__m_BroadcastAddresses;
    }

    public int getBroadcastCounter() {
        return this.__m_BroadcastCounter;
    }

    public int getBroadcastLimit() {
        return this.__m_BroadcastLimit;
    }

    private int getBroadcastMode() {
        return this.__m_BroadcastMode;
    }

    public long getBroadcastNextMillis() {
        return this.__m_BroadcastNextMillis;
    }

    public int getBroadcastRepeatMillis() {
        return this.__m_BroadcastRepeatMillis;
    }

    public int getBroadcastTimeoutMillis() {
        return this.__m_BroadcastTimeoutMillis;
    }

    public Binary getBroadcastTimestamp() {
        return this.__m_BroadcastTimestamp;
    }

    public int getBroadcastVariance() {
        return 212343923;
    }

    public int getClusterId() {
        return this.isWkaEnabled() ? this.getWkaHashCode() : ((Cluster)this.getCluster()).getSocketManager().getMulticastUdpSocket().hashCode();
    }

    public String getClusterName() {
        return ((Cluster)this.getCluster()).getClusterName();
    }

    public String getDecoratedThreadName() {
        int nState = this.getState();
        String sState = nState == STATE_JOINED ? "" : String.valueOf(Logger.THREAD_NAME_DELIM) + ClusterService.formatStateName(nState);
        Member member = this.getThisMember();
        if (member == null && (member = this.getRequestMember()) == null) {
            member = this.getAnnounceMember();
        }
        String sMember = member == null ? "" : String.valueOf(Logger.THREAD_NAME_DELIM) + member.toString();
        return String.valueOf(super.getDecoratedThreadName()) + sState + sMember;
    }

    public int getDeliveryTimeoutMillis() {
        return this.__m_DeliveryTimeoutMillis;
    }

    public int getHeartbeatDelay() {
        return this.__m_HeartbeatDelay;
    }

    public MemberSet getHeartbeatMemberSet() {
        MemberSet setTo = this.__m_HeartbeatMemberSet;
        if (setTo == null) {
            setTo = new ActualMemberSet();
            this.setHeartbeatMemberSet(setTo);
        }
        setTo.clear();
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = setMembers.size();
        if (cMembers > 1) {
            Cluster cluster = (Cluster)this.getCluster();
            Member memberThis = setMembers.getThisMember();
            int cDelay = this.getHeartbeatDelay();
            int cTimeout = this.getHeuristicTimeoutMillis() - cDelay;
            int cDesired = Math.max(cMembers * cDelay / cTimeout, 1);
            long ldtNow = Base.getSafeTimeMillis();
            long ldtEligible = ldtNow - (long)(cTimeout >> 2);
            long ldtDanger = ldtEligible - (long)(cTimeout >> 1);
            Member[] aMember = (Member[])setMembers.toArray(new Member[cMembers]);
            cMembers = aMember.length;
            int iFirst = (int)(Math.random() * (double)cMembers);
            int iLast = iFirst + cMembers;
            int i = iFirst;
            while (i < iLast) {
                Member member = aMember[i >= cMembers ? i - cMembers : i];
                if (!(!(member != null) ? false : member != memberThis) ? false : member.isDeaf() ^ true) {
                    boolean fDanger;
                    long ldtLastIn;
                    boolean fAckPending;
                    long ldtLastOut = member.getLastOutgoingMillis();
                    boolean bl = fAckPending = ldtLastOut > (ldtLastIn = member.getLastIncomingMillis());
                    boolean bl2 = !(fAckPending ^ true) ? false : (fDanger = ldtLastIn < ldtDanger);
                    boolean fEligible = !(fAckPending ^ true) ? false : ldtLastIn < ldtEligible;
                    boolean fTrintDanger = cluster.isCommEndangered(member);
                    if (((!fEligible ? false : cDesired > 0) ? true : fDanger) ? true : fTrintDanger) {
                        setTo.add(member);
                    }
                    --cDesired;
                }
                ++i;
            }
        }
        return setTo;
    }

    public int getHeuristicTimeoutMillis() {
        return this.getDeliveryTimeoutMillis() >> 1;
    }

    public long getLastInterminableWarningMillis() {
        return this.__m_LastInterminableWarningMillis;
    }

    public UUID getLastPanicUid() {
        return this.__m_LastPanicUid;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public long getMembershipReopen() {
        return this.__m_MembershipReopen;
    }

    public int getMulticastTimeToLive() {
        Cluster$SocketManager$MulticastUdpSocket socket = ((Cluster)this.getCluster()).getSocketManager().getMulticastUdpSocket();
        return socket == null ? 0 : socket.getTimeToLive();
    }

    public LongArray getPendingServiceJoining() {
        return this.__m_PendingServiceJoining;
    }

    public ClusterService$QuorumControl getQuorumControl() {
        ClusterService$QuorumControl control = this.__m_QuorumControl;
        if (control == null) {
            control = (ClusterService$QuorumControl)this._findChild("QuorumControl");
            this.setQuorumControl(control);
        }
        return control;
    }

    public Member getRequestMember() {
        return this.__m_RequestMember;
    }

    public long getRequestTimeout() {
        return this.getDeliveryTimeoutMillis();
    }

    protected Grid[] getService() {
        return this.__m_Service;
    }

    public Grid getService(int i) {
        Grid[] aService = this.getService();
        return (aService == null ? true : i >= aService.length) ? null : aService[i];
    }

    public Grid getService(String sName) {
        int cServices = this.getServiceCount();
        int i = 0;
        while (i < cServices) {
            Grid service = this.getService(i);
            if (!(service != null) ? false : sName.equals(service.getServiceName())) {
                return service;
            }
            ++i;
        }
        return null;
    }

    public int getServiceCount() {
        Grid[] aService = this.getService();
        return aService == null ? 0 : aService.length;
    }

    protected ServiceInfo[] getServiceInfo() {
        return this.__m_ServiceInfo;
    }

    public ServiceInfo getServiceInfo(int i) {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return (ainfo == null ? true : i >= ainfo.length) ? null : ainfo[i];
    }

    public ServiceInfo getServiceInfo(String sName) {
        int cInfo = this.getServiceInfoCount();
        int i = 0;
        while (i < cInfo) {
            ServiceInfo info = this.getServiceInfo(i);
            if (!(info != null) ? false : sName.equals(info.getServiceName())) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public int getServiceInfoCount() {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return ainfo == null ? 0 : ainfo.length;
    }

    public Member getServiceOldestMember() {
        return this.getClusterOldestMember();
    }

    public String getServiceStateName() {
        return String.valueOf(super.getServiceStateName()) + ", " + ClusterService.formatStateName(this.getState());
    }

    public String getServiceType() {
        return "Cluster";
    }

    public String getServiceVersion() {
        return "3.7.1";
    }

    public Set getSlowMembers() {
        HashSet<Member> setMembers = null;
        Iterator iter = this.getClusterMemberSet().iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!this.isSlow(member)) continue;
            if (setMembers == null) {
                setMembers = new HashSet<Member>();
            }
            setMembers.add(member);
        }
        return setMembers;
    }

    public long getStartupTimeout() {
        return this.getDeliveryTimeoutMillis();
    }

    public int getState() {
        return this.__m_State;
    }

    public long getStatsMembersDepartureCount() {
        return this.__m_StatsMembersDepartureCount;
    }

    public ClusterService$TcpRing getTcpRing() {
        ClusterService$TcpRing ring = this.__m_TcpRing;
        if (ring == null) {
            ring = (ClusterService$TcpRing)this._findChild("TcpRing");
            this.setTcpRing(ring);
        }
        return ring;
    }

    public long getTimestamp() {
        return this.calcTimestamp(Base.getSafeTimeMillis());
    }

    public long getTimestampAdjustment() {
        return this.__m_TimestampAdjustment;
    }

    public int getTimestampMaxVariance() {
        return this.__m_TimestampMaxVariance;
    }

    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long cWait2 = Math.max(1L, this.getBroadcastNextMillis() - Base.getSafeTimeMillis());
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public Set getWellKnownAddresses() {
        return this.__m_WellKnownAddresses;
    }

    protected MemberSet getWitnessMemberSet(Member memberSuspect) {
        ArrayList listMembers = new ArrayList(new ImmutableArrayList(this.getClusterMemberSet().toArray()));
        Collections.shuffle(listMembers, Base.getRandom());
        Member memberThis = this.getThisMember();
        int nMachineThis = memberThis.getMachineId();
        int nMachineSuspect = memberSuspect.getMachineId();
        LinkedList[] aListWitness = new LinkedList[4];
        int i = 0;
        int c = aListWitness.length;
        while (i < c) {
            aListWitness[i] = new LinkedList();
            ++i;
        }
        int GREATER = 0;
        int EQUAL = 1;
        int LESSER = 2;
        int WEAK = 3;
        Iterator iter = listMembers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(!(!(member != memberThis) ? false : member != memberSuspect) ? false : member.isDeaf() ^ true)) continue;
            int nMachineThat = member.getMachineId();
            int iComp = this.compareImportance(member);
            int iCategory = ((nMachineThat == nMachineThis ? true : nMachineThat == nMachineSuspect) ? true : this.isSlow(member)) ? WEAK : (iComp > 0 ? LESSER : (iComp == 0 ? EQUAL : GREATER));
            aListWitness[iCategory].add(member);
        }
        ActualMemberSet setWitness = new ActualMemberSet();
        int iPass = 0;
        while (iPass < 3) {
            int i2 = 0;
            int iMaxCategory = iPass == 0 ? LESSER : WEAK;
            while (i2 <= iMaxCategory) {
                LinkedList listWitness = aListWitness[i2];
                if (!(!(listWitness.isEmpty() ^ true) ? false : setWitness.add((Member)listWitness.remove(0))) ? false : setWitness.size() == 2) {
                    return setWitness;
                }
                ++i2;
            }
            ++iPass;
        }
        return setWitness.isEmpty() ? null : setWitness;
    }

    public int getWkaHashCode() {
        return this.isWkaEnabled() ? this.getWellKnownAddresses().hashCode() : 0;
    }

    public Map getWkaMap() {
        return this.__m_WkaMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ClusterService();
    }

    private final Component get_Module() {
        return this;
    }

    public int indexOfService(String sName) {
        Component._assert(sName != null);
        ServiceInfo[] ainfo = this.getServiceInfo();
        int i = 0;
        int c = ainfo.length;
        while (i < c) {
            ServiceInfo info = ainfo[i];
            if (!(info != null) ? false : info.getServiceName().equals(sName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Member instantiateMember() {
        return new Member();
    }

    protected Queue instantiateQueue() {
        return (Queue)this._findChild("InQueue");
    }

    public boolean isHeuristicallyDead(Member member) {
        if (member == null ? true : member.isDeaf()) {
            return true;
        }
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lCutoffMillis = lCurrentMillis - (long)this.getHeuristicTimeoutMillis();
        long lLastInMillis = member.getLastIncomingMillis();
        return lLastInMillis < lCutoffMillis;
    }

    public boolean isMembershipSuspended() {
        return Base.getSafeTimeMillis() <= this.getMembershipReopen() ? true : this.getQuorumControl().isClusterSuspended();
    }

    public boolean isNotification() {
        if (this.getBroadcastNextMillis() <= Base.getSafeTimeMillis()) {
            return true;
        }
        return super.isNotification();
    }

    public boolean isSlow(Member member) {
        int cTimeoutMillis;
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lLastSlowMillis = member.getLastSlowMillis();
        return lLastSlowMillis > lCurrentMillis - (long)(cTimeoutMillis = this.getDeliveryTimeoutMillis());
    }

    public boolean isWellKnown(Member member) {
        return this.isWkaEnabled() ^ true ? true : this.getWellKnownAddresses().contains(member.getSocketAddress());
    }

    public boolean isWkaEnabled() {
        return this.getWellKnownAddresses() != null;
    }

    protected void notifyServiceJoined() {
    }

    protected void onEnter() {
        int n;
        if (this.isWkaEnabled() && (!((n = ((Cluster)this.getCluster()).getDependencies().getEdition()) < 4) ? false : n != 1)) {
            throw Base.ensureRuntimeException(null, this.toString("HT^\u007fw*16<>,+r013&v\u007f<3*,+:-618\u007f6,\u007f10+\u007f>)>63>=3:q"));
        }
        this.setBroadcastLimit(this.getBroadcastTimeoutMillis() / this.getBroadcastRepeatMillis() + 1);
        this.setBroadcastNextMillis(Base.getSafeTimeMillis());
        super.onEnter();
    }

    public void onException(Throwable e) {
        switch (this.getState()) {
            default: {
                super.onException(e);
                break;
            }
            case 1: {
                if (e instanceof ClusterJoinException) {
                    this.setStartException(e);
                } else {
                    Component._trace(String.valueOf("StopJoining ") + this.toString() + " due to unhandled exception: ", 1);
                    Component._trace(e);
                }
                this.onStopJoining();
                break;
            }
            case 2: {
                Component._trace(String.valueOf("StopRunning ") + this.toString() + " due to unhandled exception: ", 1);
                Component._trace(e);
                this.onStopRunning();
                break;
            }
        }
    }

    protected void onExit() {
        this.getTcpRing().close();
        super.onExit();
    }

    public void onInit() {
        MasterMemberSet setMember = new MasterMemberSet();
        this.setClusterMemberSet(setMember);
        this.setServiceMemberSet(setMember);
        this.ensureServiceInfo(0, this.getServiceName(), this.getServiceType());
        this.setService(0, this);
        super.onInit();
    }

    public void onMemberJoined(Member member) {
        Member memberThis = this.getThisMember();
        if (!(memberThis != null) ? false : member != memberThis) {
            Component._trace(String.valueOf(member) + " joined Cluster with senior member " + this.getClusterOldestMember().getId(), 5);
            Cluster cluster = (Cluster)this.getCluster();
            cluster.onMemberJoined(member);
            if (this.getClusterMemberSet().isServiceJoined(memberThis.getId())) {
                this.getTcpRing().onMemberJoined(member);
            }
            int i = 0;
            int c = this.getServiceCount();
            while (i < c) {
                Grid service = this.getService(i);
                if (service != null) {
                    Grid$NotifyMemberJoined msg = (Grid$NotifyMemberJoined)service.instantiateMessage("NotifyMemberJoined");
                    msg.setNotifyMember(member);
                    service.send(msg);
                }
                ++i;
            }
            this.getQuorumControl().onMemberJoined(member);
        }
        if (this.isAcceptingClients()) {
            this.dispatchMemberEvent(member, MemberEvent.MEMBER_JOINED);
            this.dispatchNotification(Registry.CLUSTER_TYPE, "member.joined", String.valueOf("Member ") + member.getId() + " joined", member.toString());
        }
    }

    public void onMemberLeaving(Member member) {
        int i = 0;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                Grid$NotifyMemberLeaving msg = (Grid$NotifyMemberLeaving)service.instantiateMessage("NotifyMemberLeaving");
                msg.setNotifyMember(member);
                service.send(msg);
            }
            ++i;
        }
        this.dispatchMemberEvent(member, MemberEvent.MEMBER_LEAVING);
    }

    protected void onMemberLeft(Member member) {
        Member memberSenior = this.getClusterOldestMember();
        Component._trace(String.valueOf(member) + " left Cluster with senior member " + memberSenior.getId(), 5);
        this.getQuorumControl().onMemberLeft(member);
        this.removeDynamicBroadcast(member);
        Cluster cluster = (Cluster)this.getCluster();
        cluster.onMemberLeft(member);
        this.getTcpRing().onMemberLeft(member);
        int i = 0;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                Grid$NotifyMemberLeft msg = (Grid$NotifyMemberLeft)service.instantiateMessage("NotifyMemberLeft");
                msg.setNotifyMember(member);
                service.send(msg);
            }
            ++i;
        }
        this.dispatchMemberEvent(member, MemberEvent.MEMBER_LEFT);
        this.dispatchNotification(Registry.CLUSTER_TYPE, "member.left", String.valueOf("Member ") + member.getId() + " left", member.toString());
        this.setStatsMembersDepartureCount(this.getStatsMembersDepartureCount() + (long)1);
    }

    public void onMemberRejected(int nReason, Member rejecter) {
        nReason = nReason < 0 ? -nReason : (nReason -= MasterMemberSet.MAX_MEMBERS);
        String sError = null;
        switch (nReason) {
            case 0: {
                int cbMax = this.getMaximumPacketLength();
                sError = String.valueOf("The cluster has exceeded its maximum size.  This limit is ") + "based on the configured maximum packet length, with the " + "current value of " + cbMax + " bytes the cluster size limit " + "is approximately " + MessagePacket.calcMaxMembers(cbMax) + " members.";
                break;
            }
            case 1: {
                sError = "This member is not authorized to join the cluster.";
                break;
            }
            case 2: {
                sError = String.valueOf("This member could not join the cluster because of ") + "an incompatibility between the cluster protocol used by this " + "member and the one being used by the rest of the cluster.  This " + "is most likely caused by a Coherence version mismatch, or by " + "mismatched protocol filters (e.g. compression, or encryption).";
                break;
            }
            case 3: {
                sError = String.valueOf("This member could not join the cluster because of ") + "a configuration mismatch between this member " + "and the configuration being used by the rest of the cluster. " + "The maximum packet size (" + this.getMaximumPacketLength() + ") for this member does not match the maximum packet size that " + "the running cluster is using.";
                break;
            }
            case 4: {
                sError = String.valueOf("This member could not join the cluster because the ") + "senior member's license has expired.";
                break;
            }
            case 5: {
                sError = String.valueOf("This member will not join the cluster because the ") + "senior member's IP address is not an authorized host.";
                break;
            }
            case 6: {
                boolean fWka = this.isWkaEnabled();
                sError = String.valueOf("This member could not join the cluster because of ") + "a configuration mismatch between this member " + "and the configuration being used by the rest of the cluster. " + "This member is" + (fWka ? " " : " not ") + "configured to use WKA, but the running cluster is" + (fWka ? String.valueOf(" not. This is caused by one of the addresses on this ") + "member's WKA list being in use on a non-WKA cluster." : String.valueOf(". This is caused by this member's address being ") + "a part of the running cluster's WKA list.");
                break;
            }
            case 7: {
                sError = String.valueOf("This member could not join the cluster because of ") + "a configuration mismatch between this member " + "and the configuration being used by the rest of the cluster. " + "This member specified a cluster name of \"" + this.getClusterName() + "\" " + "which did not match the name of the running cluster. This indicates that " + "there are multiple clusters on this network attempting to use overlapping " + "network configurations.";
                break;
            }
            case 8: {
                ClusterDependencies cfg = ((Cluster)this.getCluster()).getDependencies();
                String sEditionName = Coherence.EDITION_NAMES[cfg.getEdition()];
                sError = String.valueOf("This member could not join the cluster because of ") + "a mismatch between Coherence product editions. This " + "member was attempting to run as a " + Coherence.TITLE + " " + sEditionName + " edition cluster.";
                break;
            }
            case 9: {
                ClusterDependencies cfg = ((Cluster)this.getCluster()).getDependencies();
                String modeName = Coherence.MODE_NAMES[cfg.getMode()];
                sError = String.valueOf("This member could not join the cluster because of ") + "a mismatch between Coherence license types. This " + "member was attempting to run in " + modeName + " mode.";
                break;
            }
            default: {
                if ((nReason += MasterMemberSet.MAX_MEMBERS) == Integer.MAX_VALUE) {
                    sError = "No cluster edition available.";
                    break;
                }
                String sLimiter = (new String[]{"site", "server", "socket", "CPU"})[nReason << 1 >>> 30];
                sError = String.valueOf("This member could not join the cluster because the ") + sLimiter + " license limit of " + (nReason << 4 >>> 16) + " would be exceeded by " + (nReason & 0xFFF) + ".";
                break;
            }
        }
        if (sError != null) {
            if (rejecter != null) {
                sError = String.valueOf(sError) + (String.valueOf(" Rejected by ") + rejecter + ".");
            }
            Component._trace(sError, 1);
        }
        this.onStopJoining();
    }

    public void onMembersTimedOut(Set setTimedOut) {
        this.getQuorumControl().onMembersTimedOut(setTimedOut);
    }

    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (msg instanceof DiscoveryMessage) {
            if (e instanceof SecurityException) {
                Component._trace(String.valueOf("SecurityException received while reading message ") + msg.get_Name() + "\n" + e, 2);
            }
            ((DiscoveryMessage)msg).setReadError(true);
            return true;
        }
        return super.onMessageReadException(e, msg);
    }

    protected void onNotify() {
        super.onNotify();
        long lTime = Base.getSafeTimeMillis();
        if (lTime >= this.getBroadcastNextMillis()) {
            switch (this.getState()) {
                case 0: {
                    this.onTimerAnnouncing();
                    break;
                }
                case 1: {
                    this.onTimerJoining();
                    break;
                }
                case 2: {
                    this.onTimerRunning();
                    break;
                }
            }
            this.setBroadcastNextMillis(lTime + (long)this.getBroadcastRepeatMillis());
        }
    }

    public void onNotifyIpTimeout(InetAddress address) {
        HashSet<Member> setTimedOut = new HashSet<Member>();
        Iterator iter = this.getClusterMemberSet().iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!address.equals(member.getAddress())) continue;
            setTimedOut.add(member);
        }
        if (setTimedOut.isEmpty() ^ true) {
            iter = setTimedOut.iterator();
            while (iter.hasNext()) {
                if (!(((Member)iter.next()).isTimedOut() ^ true)) continue;
                Component._trace(String.valueOf("Failed to reach address ") + address + " within the " + "IpMonitor timeout. Members " + setTimedOut + " are suspect.", 2);
                break;
            }
            this.onMembersTimedOut(setTimedOut);
        }
    }

    public void onNotifyMemberLeft(Member member) {
        this.closePolls(member);
    }

    public void onNotifyTcmpTimeout(MessagePacket packet, MemberSet setLate) {
        HashSet<Member> setTimedOut = new HashSet<Member>();
        Member memberThis = this.getThisMember();
        Iterator iter = setLate.iterator();
        while (iter.hasNext()) {
            Member memberLate = (Member)iter.next();
            if (!((memberLate.isTimedOut() ? true : memberThis.isTimedOut()) ? true : this.verifyMemberLeft(memberLate, packet))) continue;
            setTimedOut.add(memberLate);
        }
        if (setTimedOut.isEmpty() ^ true) {
            this.onMembersTimedOut(setTimedOut);
        }
    }

    public void onNotifyTcpDeparture(Member member) {
        if (this.getClusterMemberSet().contains(member)) {
            this.doMemberLeft(member);
        }
    }

    public void onServiceAnnounced(ServiceInfo info) {
        String sServiceName = info.getServiceName();
        int i = 1;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                Grid$NotifyServiceAnnounced msg = (Grid$NotifyServiceAnnounced)service.instantiateMessage("NotifyServiceAnnounced");
                msg.setNotifyServiceName(sServiceName);
                service.send(msg);
            }
            ++i;
        }
    }

    public void onServiceJoined(ServiceInfo info, Member member) {
        Component._assert(!(info != null) ? false : member != null);
        if (member != this.getThisMember()) {
            ServiceMemberSet setMember = info.getMemberSet();
            int nServiceId = info.getServiceId();
            Component._assert(setMember.contains(member));
            if (nServiceId > 0) {
                Member memberOldest = setMember.getOldestMember();
                Component._trace(String.valueOf("Member ") + member.getId() + " joined Service " + info.getServiceName() + " with senior member " + (memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId())), 5);
                Grid service = this.getService(nServiceId);
                if (service != null) {
                    Grid$NotifyServiceJoined msg = (Grid$NotifyServiceJoined)service.instantiateMessage("NotifyServiceJoined");
                    msg.setNotifyMember(member);
                    service.send(msg);
                }
            }
        }
    }

    public void onServiceJoining(ServiceInfo info, Member member, boolean fNew) {
        Component._assert(!(info != null) ? false : member != null);
        if (member != this.getThisMember() && fNew ^ true) {
            Member memberOldest = info.getMemberSet().getOldestMember();
            Component._trace(String.valueOf("Member ") + member.getId() + " already registered as running Service " + info.getServiceName() + " with senior member " + memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId()), 3);
        }
    }

    public void onServiceLeaving(ServiceInfo info, Member member) {
        int nMember;
        ServiceMemberSet setMember;
        Component._assert(!(info != null) ? false : member != null);
        Component._assert(info.getMemberSet().contains(member));
        if (member != this.getThisMember() && (setMember = info.getMemberSet()).isServiceLeaving(nMember = member.getId()) ^ true) {
            Grid service;
            setMember.setServiceLeaving(nMember);
            int nServiceId = info.getServiceId();
            if (nServiceId > 0 && (service = this.getService(nServiceId)) != null) {
                Grid$NotifyServiceLeaving msg = (Grid$NotifyServiceLeaving)service.instantiateMessage("NotifyServiceLeaving");
                msg.setNotifyMember(member);
                service.send(msg);
            }
        }
    }

    public void onServiceLeft(ServiceInfo info, Member member) {
        Component._assert(!(info != null) ? false : member != null);
        if (member != this.getThisMember()) {
            int nServiceId = info.getServiceId();
            Component._assert(nServiceId > 0);
            Member memberOldest = info.getMemberSet().getOldestMember();
            Component._trace(String.valueOf("Member ") + member.getId() + " left service " + info.getServiceName() + " with senior member " + (memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId())), 5);
            Grid service = this.getService(nServiceId);
            if (service != null) {
                Grid$NotifyServiceLeft msg = (Grid$NotifyServiceLeft)service.instantiateMessage("NotifyServiceLeft");
                msg.setNotifyMember(member);
                service.send(msg);
            }
        }
    }

    public void onServiceStarted() {
    }

    public void onStopJoining() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.stop();
        }
    }

    public void onStopRunning() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.getTcpRing().onLeft();
            this.stop();
        }
    }

    public void onTimerAnnouncing() {
        int cLimit;
        Member memberThis = this.getAnnounceMember();
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            if (this.isWellKnown(memberThis)) {
                Cluster cluster = (Cluster)this.getCluster();
                MasterMemberSet setMember = this.getClusterMemberSet();
                memberThis.setId(1);
                memberThis.setPreferredPacketLength(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPacketLength());
                memberThis.setPreferredPort(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPort());
                setMember.add(memberThis);
                setMember.setThisMember(memberThis);
                UID uid = cLimit > 0 ? memberThis.getUid() : new UID((int)UID.toLong(memberThis.getAddress()), System.currentTimeMillis() | (long)3338, cLimit);
                cLimit = setMember.induct(memberThis, this);
                if (cLimit > 0) {
                    Component._trace(String.valueOf(memberThis.toString(Member.SHOW_LICENSE)) + " UID=" + uid + " is unable to join the cluster.", 1);
                    this.onMemberRejected(cLimit, null);
                } else {
                    Component._trace(String.valueOf("Created a new ") + this.formatClusterString() + " with " + memberThis.toString(Member.SHOW_LICENSE) + " UID=" + uid, 3);
                    this.setState(STATE_JOINED);
                    setMember.setServiceJoined(memberThis.getId());
                    this.setAcceptingClients(true);
                }
            } else {
                this.resetBroadcastCounter("waiting for well-known nodes to respond", null);
            }
        } else {
            ClusterService$NewMemberAnnounce msg = (ClusterService$NewMemberAnnounce)this.instantiateMessage("NewMemberAnnounce");
            msg.setFromMember(memberThis);
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onTimerJoining() {
        int cLimit;
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            if (!(this.getThisMember() == null)) throw new ClusterJoinException();
            this.resetBroadcastCounter("AnnounceReply was not followed by RequestIdReply", null);
            this.setTimestampAdjustment(0);
            this.setRequestMember(null);
            this.setState(STATE_ANNOUNCE);
            return;
        } else {
            ClusterService$NewMemberRequestId msg = (ClusterService$NewMemberRequestId)this.instantiateMessage("NewMemberRequestId");
            msg.setFromMember(this.getRequestMember());
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            msg.setServiceVersion(this.getServiceVersion());
            msg.setMaxPacketSize(this.getMaximumPacketLength());
            msg.setWkaEnabled(this.isWkaEnabled());
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    public void onTimerRunning() {
        DiscoveryMessage msg;
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member memberThis = setMember.getThisMember();
        Member memberOldest = setMember.getOldestMember();
        long ldtLastRecv = this.calcTimestamp(memberThis.getLastIncomingMillis());
        MemberSet setTo = this.getHeartbeatMemberSet();
        if (!(setTo != null) ? false : setTo.isEmpty() ^ true) {
            Iterator iter = setTo.iterator();
            while (iter.hasNext()) {
                ClusterService$MemberHeartbeat msg2 = (ClusterService$MemberHeartbeat)this.instantiateMessage("MemberHeartbeat");
                msg2.setToMemberSet(SingleMemberSet.instantiate((Member)iter.next()));
                msg2.setLastReceivedMillis(ldtLastRecv);
                this.post(msg2);
            }
        }
        if (this.isAcceptingClients()) {
            if (memberThis == memberOldest) {
                msg = (ClusterService$SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
                ((ClusterService$SeniorMemberHeartbeat)msg).setLastReceivedMillis(ldtLastRecv);
                ((ClusterService$SeniorMemberHeartbeat)msg).setMemberSet(setMember);
                ((ClusterService$SeniorMemberHeartbeat)msg).setWkaEnabled(this.isWkaEnabled());
                this.send(msg);
                this.checkPendingJoinPolls();
            }
        } else if (memberThis == memberOldest) {
            this.setAcceptingClients(true);
        } else {
            msg = (ClusterService$NewMemberWelcomeAnnounce)this.instantiateMessage("NewMemberWelcomeAnnounce");
            ((ClusterService$NewMemberWelcomeAnnounce)msg).setSeniorMember(memberOldest);
            ((ClusterService$NewMemberWelcomeAnnounce)msg).setServiceVersion(this.getServiceVersion());
            this.send(msg);
        }
        this.getTcpRing().heartbeatBuddies();
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        this.heartbeat();
        this.getTcpRing().select(this.getWaitMillis());
    }

    public Object pollSecure(Member memberSenior, Object oRequestInfo) {
        ClusterService$ServiceSecureRequest msgRequest = (ClusterService$ServiceSecureRequest)this.instantiateMessage("ServiceSecureRequest");
        msgRequest.setRequestInfo(oRequestInfo);
        msgRequest.addToMember(memberSenior);
        return this.poll(msgRequest);
    }

    public void populateWelcomeMessage(ClusterService$NewMemberWelcome msg) {
        Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        msg.setFromMemberUid(memberThis.getUid32());
        msg.setPreferredPacketLength(memberThis.getPreferredPacketLength());
        msg.setPreferredPort(memberThis.getPreferredPort());
        Grid[] aService = this.getService();
        int cServices = aService.length;
        ServiceInfo[] aInfo = new ServiceInfo[cServices];
        int cInfo = 0;
        int iService = 0;
        while (iService < cServices) {
            ServiceInfo info;
            Grid service = aService[iService];
            if (service != null && (info = this.getServiceInfo(iService)).getMemberSet().getServiceJoinTime(nMemberThis) > 0L) {
                aInfo[cInfo++] = info;
            }
            ++iService;
        }
        msg.setServiceCount(cInfo);
        int i = 0;
        while (i < cInfo) {
            ServiceInfo info = aInfo[i];
            ServiceMemberSet setMember = info.getMemberSet();
            msg.setServiceId(i, info.getServiceId());
            msg.setServiceName(i, info.getServiceName());
            msg.setServiceType(i, info.getServiceType());
            msg.setServiceVersion(i, setMember.getServiceVersion(nMemberThis));
            msg.setServiceEndPointName(i, setMember.getServiceEndPointName(nMemberThis));
            msg.setServiceJoinTime(i, setMember.getServiceJoinTime(nMemberThis));
            msg.setServiceState(i, setMember.getState(nMemberThis));
            ++i;
        }
    }

    protected void register() {
    }

    public void registerServiceJoining(ClusterService$ServiceJoining msg) {
        Component._assert(Thread.currentThread() == this.getThread());
        LongArray laPending = this.getPendingServiceJoining();
        long lIndex = Base.getSafeTimeMillis();
        while (true) {
            if (laPending.get(lIndex) == null) {
                laPending.set(lIndex, msg);
                return;
            }
            ++lIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicBroadcast(Member member) {
        Set setBroadcast;
        if ((!(member != null) ? false : this.isWellKnown(member) ^ true) && (setBroadcast = this.getBroadcastAddresses()) != null) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.remove(member.getSocketAddress());
            }
        }
    }

    public void removeMember(Member member) {
        int nMember = member.getId();
        int i = 1;
        int c = this.getServiceInfoCount();
        while (i < c) {
            ServiceInfo info = this.getServiceInfo(i);
            if (!(info != null) ? false : info.getMemberSet().remove(member)) {
                this.onServiceLeft(info, member);
            }
            ++i;
        }
        if (this.getClusterMemberSet().remove(member)) {
            this.onMemberLeft(member);
        }
    }

    public void resetBroadcastCounter(DataInput stream, boolean fSelf) throws IOException {
        Coherence app = (Coherence)Coherence.get_Instance();
        XmlElement xmlAll = Coherence.getServiceConfig(this.toString("{S6<:1,:"));
        MasterMemberSet setMember = this.getClusterMemberSet();
        boolean fValid = fSelf ? true : (!(!(this.getState() == STATE_JOINED) ? false : setMember.getThisMember() == setMember.getOldestMember()) ? false : this.isMembershipSuspended() ^ true);
        int nEThis = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString(":;6+601r1>2:")).getString()));
        int nMThis = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString("36<:1,:r20;:")).getString()));
        Map map = this.getWkaMap();
        int nEThat = ExternalizableHelper.readInt(stream);
        int nMThat = ExternalizableHelper.readInt(stream);
        if ((nEThis == nEThat ? true : ((!(nEThis == 1) ? false : nEThat == 5) ? true : (!(nEThis == 5) ? false : nEThat == 1))) ^ true) {
            fValid = false;
        }
        if (nMThis != nMThat) {
            fValid = false;
        }
        int[] anType = new int[6];
        int i = 0;
        int c = anType.length;
        while (i < c) {
            anType[i] = -1;
            ++i;
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            int[] an = (int[])iter.next();
            anType[an[0]] = an[1];
        }
        while (stream.readBoolean()) {
            int[] anOld;
            UID id = new UID(stream);
            int[] an = new int[3];
            int i2 = 0;
            while (i2 < 3) {
                an[i2] = ExternalizableHelper.readInt(stream);
                ++i2;
            }
            if (!fValid) continue;
            if (!(anType[an[0]] >= 0) ? false : an[1] != anType[an[0]]) {
                if (an[2] >= 0) continue;
                Iterator iter2 = map.values().iterator();
                while (iter2.hasNext()) {
                    if (!(((int[])iter2.next())[0] == an[0])) continue;
                    iter2.remove();
                }
            }
            if ((anOld = map.put(id, an)) != null && (!(anOld[0] == an[0]) ? false : anOld[1] == an[1])) {
                an[2] = Math.max(an[2], anOld[2]);
            }
            anType[an[0]] = an[1];
        }
    }

    public void resetBroadcastCounter(String sReason, DiscoveryMessage msg) {
        this.setBroadcastCounter(0);
        Member memberThis = this.getAnnounceMember();
        long ldtNow = Base.getSafeTimeMillis();
        long cMillisDelay = ldtNow - memberThis.getTimestamp();
        long cMillisMax = this.getStartupTimeout();
        long cMillisJoin = this.getBroadcastTimeoutMillis();
        long cMillisWarn = Math.min(30000L, (cMillisMax + cMillisJoin) / (long)2);
        if (!(sReason != null) ? false : cMillisDelay > cMillisWarn) {
            long ldtLastWarning = this.getLastInterminableWarningMillis();
            if (ldtLastWarning == 0L) {
                Set setWka = this.getBroadcastAddresses();
                if (setWka == null ? true : setWka.size() == 0) {
                    ClusterDependencies config = ((Cluster)this.getCluster()).getDependencies();
                    Component._trace(String.valueOf("This ") + memberThis + " has been attempting to join the cluster at address " + config.getGroupAddress().toString() + ":" + config.getGroupPort() + " with TTL " + config.getGroupTimeToLive() + " for " + cMillisDelay / (long)1000 + " seconds without success;" + " this could indicate a mis-configured TTL value, or it may" + " simply be the result of a busy cluster or active failover.", 2);
                } else {
                    Component._trace(String.valueOf("This ") + memberThis + " has been attempting to join the cluster using WKA list " + setWka + " for " + cMillisDelay / (long)1000 + " seconds without success;" + " this could indicate a mis-configured WKA, or it may" + " simply be the result of a busy cluster or active failover.", 2);
                }
            }
            int iLevel = 6;
            if (ldtNow > ldtLastWarning + 5000L) {
                iLevel = 2;
                this.setLastInterminableWarningMillis(ldtNow);
            }
            String sMsg = msg == null ? String.valueOf("Delaying formation of a new cluster; ") + sReason : String.valueOf("Received a discovery message that indicates ") + sReason + ":\n" + msg;
            Component._trace(sMsg, iLevel);
            if (cMillisDelay > cMillisMax) {
                Component._trace(String.valueOf("Failure to join a cluster for ") + cMillisDelay / (long)1000 + " seconds" + "; stopping cluster service.", 1);
                this.onStopJoining();
            }
        }
    }

    public synchronized void setAcceptingClients(boolean fAccepting) {
        boolean fPrev = this.isAcceptingClients();
        super.setAcceptingClients(fAccepting);
        if (!fAccepting ? false : fPrev ^ true) {
            int cMillis = this.getHeartbeatDelay();
            if (cMillis == 0) {
                cMillis = Math.max(this.getBroadcastRepeatMillis(), this.getBroadcastTimeoutMillis() >>> 3);
            }
            this.setBroadcastRepeatMillis(cMillis);
        }
    }

    public void setActionPolicy(ActionPolicy policy) {
        super.setActionPolicy(policy);
    }

    public void setAnnounceMember(Member member) {
        this.__m_AnnounceMember = member;
    }

    public void setBroadcastAddresses(Set setAddresses) {
        this.__m_BroadcastAddresses = setAddresses;
    }

    public void setBroadcastCounter(int c) {
        this.__m_BroadcastCounter = c;
    }

    /*
     * Unable to fully structure code
     */
    public void setBroadcastLimit(int c) {
        block47: {
            block48: {
                if (!(c > 0)) break block47;
                n = this.getBroadcastMode();
                iInv = -2147483648;
                if (!(n < 1)) break block48;
                app = (Coherence)Coherence.get_Instance();
                n = this.getBroadcastVariance();
                cl = ClusterService.__sm0().getClassLoader();
                if (cl == null) {
                    cl = Base.getContextClassLoader();
                }
                asName = new String[]{"<02p+>180,03p36<:1,:pS6<:1,:;P=5:<+q<3>,,", "<02p+>180,03p36<:1,:pS6<:1,:;P=5:<+{S6<:1,:[>+>q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:[>+>X-6;Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:^//36<>+601Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:\\><7618Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:\\02/*+:\\36:1+q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:M:>3K62:\\36:1+q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:[>+>\\36:1+q<3>,,", "+>180,03q;>+", "+>180,03q<:-"};
                sa = new SparseArray();
                ab = null;
                if (cl != null) {
                    i = 0;
                    cNames = asName.length;
                    while (i < cNames) {
                        try {
                            in = cl.getResourceAsStream(this.toString(asName[i]));
                            if (in != null) {
                                ab = Base.read(in);
                                n ^= Base.toCrc(ab);
                                if (i == 8) {
                                    bufin = new Binary(ab).getBufferInput();
                                    while (bufin.available() > 0) {
                                        sa.set(bufin.readPackedInt(), new UID(bufin));
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            n -= this.getBroadcastRepeatMillis();
                            iInv |= 1;
                        }
                        ++i;
                    }
                }
                xmlAll = Coherence.getServiceConfig(this.toString("{S6<:1,:"));
                nEN = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString(":;6+601r1>2:")).getString()));
                nLM = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString("36<:1,:r20;:")).getString()));
                buf = new BinaryWriteBuffer(100);
                try {
                    block44: {
                        try {
                            out = buf.getBufferOutput();
                            out.writePackedInt(nEN);
                            out.writePackedInt(nLM);
                            if (!(nEN >= 2 == false ? false : xmlAll != null)) break block44;
                            cfc = Class.forName(this.toString("5>)>q,:<*-6+&q<:-+q\\:-+696<>+:Y><+0-&"));
                            cf = ClassHelper.invokeStatic(cfc, this.toString("8:+V1,+>1<:"), new Object[]{this.toString("Gqjof")});
                            ct = ClassHelper.invoke(cf, this.toString("8:1:->+:\\:-+696<>+:"), new Object[]{new Binary(ab).getInputStream()});
                            pb = ClassHelper.invoke(ct, this.toString("8:+O*=36<T:&"), ClassHelper.VOID);
                            sg = null;
                            try {
                                aSgClass = new String[]{",*1q,:<*-6+&q/-0)6;:-q[L^{LW^n(6+7[L^", ",*1q,:<*-6+&q/-0)6;:-q[L^", "<02q6=2q<-&/+0q/-0)6;:-qLW^n(6+7[L^"};
                                i = 0;
                                cc = aSgClass.length;
                                while (i < cc) {
                                    try {
                                        dsc = Class.forName(this.toString(aSgClass[i]));
                                        classDsc = dsc.getDeclaredConstructor(null);
                                        if (classDsc.isAccessible()) {
                                            sg = classDsc.newInstance(null);
                                            break;
                                        }
                                        classDsc.setAccessible(true);
                                        sg = classDsc.newInstance(null);
                                        break;
                                    }
                                    catch (ClassNotFoundException e) {
                                        if (i == cc) {
                                            throw e;
                                        }
                                        ++i;
                                    }
                                }
                                sgpc = Class.forName(this.toString("5>)>q,:<*-6+&qL681>+*-:L/6"));
                                mIt = sgpc.getDeclaredMethod(this.toString(":1861:V16+I:-69&"), new Class[]{Class.forName(this.toString("5>)>q,:<*-6+&qO*=36<T:&"))});
                                mIt.setAccessible(true);
                                mUp = sgpc.getDeclaredMethod(this.toString(":1861:J/;>+:"), new Class[]{ClusterService.__sm1(), Integer.TYPE, Integer.TYPE});
                                mUp.setAccessible(true);
                                mVf = sgpc.getDeclaredMethod(this.toString(":1861:I:-69&"), new Class[]{ClusterService.__sm1()});
                                mVf.setAccessible(true);
                                mIt.invoke(sg, new Object[]{pb});
                            }
                            catch (Throwable e) {
                                sgc = Class.forName(this.toString("5>)>q,:<*-6+&qL681>+*-:"));
                                sg = ClassHelper.invokeStatic(sgc, this.toString("8:+V1,+>1<:"), new String[]{this.toString("LW^n(6+7[L^")});
                                mUp = sgc.getMethod(this.toString("*/;>+:"), new Class[]{ClusterService.__sm1(), Integer.TYPE, Integer.TYPE});
                                mVf = sgc.getMethod(this.toString("):-69&"), new Class[]{ClusterService.__sm1()});
                                ClassHelper.invoke(sg, this.toString("616+I:-69&"), new Object[]{pb});
                            }
                            iLc = 15;
                            iter = xmlAll.getSafeElement(this.toString("36<:1,:r36,+")).getElements(this.toString("36<:1,:"));
                            while (iter.hasNext()) {
                                block46: {
                                    block52: {
                                        block55: {
                                            block54: {
                                                block53: {
                                                    block45: {
                                                        block51: {
                                                            block50: {
                                                                block49: {
                                                                    xml = (XmlElement)iter.next();
                                                                    id = null;
                                                                    nId = 0;
                                                                    nType = 0;
                                                                    cStop = 0;
                                                                    sP = xml.getSafeElement(this.toString(",09+(>-:")).getString();
                                                                    sL = xml.getSafeElement(this.toString("36<:1,::")).getString();
                                                                    sA = xml.getSafeElement(this.toString(">8-::2:1+")).getString();
                                                                    sM = xml.getSafeElement(this.toString("+&/:")).getString();
                                                                    sF = xml.getSafeElement(this.toString("9-02r;>+:")).getString();
                                                                    sT = xml.getSafeElement(this.toString("+0r;>+:")).getString();
                                                                    sR = xml.getSafeElement(this.toString("2>61+:1>1<:r-:1:(>3r;>+:")).getString();
                                                                    cI = xml.getSafeElement(this.toString("2>'r,:>+,")).getInt();
                                                                    cU = xml.getSafeElement(this.toString("2>'r*,:-,")).getInt();
                                                                    sS = xml.getSafeElement(this.toString(",6+:")).getString();
                                                                    cS = xml.getSafeElement(this.toString("2>'r,:-):-,")).getInt();
                                                                    cP = xml.getSafeElement(this.toString("2>'r,0<4:+,")).getInt();
                                                                    cC = xml.getSafeElement(this.toString("2>'r</*,")).getInt();
                                                                    sI = xml.getSafeElement(this.toString("6;")).getString();
                                                                    sK = xml.getSafeElement(this.toString("4:&")).getString();
                                                                    sE = xml.getSafeElement(this.toString(",681>+*-:")).getString();
                                                                    iInv |= 1 << iLc;
                                                                    if (!(((sP.length() == 0 != false ? true : sL.length() == 0) != false ? true : sM.length() == 0) != false ? true : sI.length() == 0)) break block49;
                                                                    iInv |= 2;
                                                                    break block46;
                                                                }
                                                                nP = this.fromString(sP);
                                                                nM = this.fromString(sM);
                                                                if (!(nP < 1)) break block50;
                                                                iInv |= 4;
                                                                break block46;
                                                            }
                                                            if (!((nP == nEN != false ? true : ((nEN == 1 != false ? true : nEN == 5) == false ? false : (nP == 1 != false ? true : nP == 5))) ^ true)) break block51;
                                                            iInv |= 8;
                                                            break block46;
                                                        }
                                                        if (!(sT.length() > 0)) ** GOTO lbl-1000
                                                        ldt = 0L;
                                                        if (sT.length() >= 8 == false ? false : sT.length() <= 10) {
                                                            ldt = Coherence.parseDate(sT) + (long)(Base.UNIT_D << 2);
                                                        }
                                                        if (this.getTimestamp() > ldt) {
                                                            iInv |= 16;
                                                        } else lbl-1000:
                                                        // 2 sources

                                                        {
                                                            if (sI.length() == 32 != false ? true : sI.length() == 34) {
                                                                try {
                                                                    id = new UID(sI);
                                                                    break block45;
                                                                }
                                                                catch (Throwable e) {
                                                                    iInv |= 32;
                                                                    break block46;
                                                                }
                                                            }
                                                            iInv |= 64;
                                                        }
                                                        break block46;
                                                    }
                                                    if (!(sE.length() == 0)) break block52;
                                                    if (!(sK.length() == 0)) break block53;
                                                    iInv |= 128;
                                                    break block46;
                                                }
                                                try {
                                                    nC = (int)Long.parseLong(sK.substring(1, 9), 16);
                                                    sC = new Binary(Base.parseHex(sK.substring(9, sK.length() - 1))).getBufferInput().readUTF();
                                                }
                                                catch (Exception e) {
                                                    iInv |= 256;
                                                    break block46;
                                                }
                                                nId = this.fromString(sC);
                                                if (!(nP != nId)) break block54;
                                                iInv |= 512;
                                                break block46;
                                            }
                                            sb = new StringBuffer();
                                            sb.append(sP.length() == 0 != false ? null : sP).append(sL.length() == 0 != false ? null : sL).append(nM).append(sC.length() == 0 != false ? null : sC).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(cU).append("00").append(sS.length() == 0 != false ? null : sS).append(cS).append('0').append(cC).append(id);
                                            bufTemp = new BinaryWriteBuffer(sb.length() + 10);
                                            bufTemp.getBufferOutput().writeUTF(sb.toString());
                                            if (!(nC != Base.toCrc(bufTemp.toByteArray()))) break block55;
                                            iInv |= 1024;
                                            break block46;
                                        }
                                        if (!(Base.equals(sa.get(nC), id) ^ true)) ** GOTO lbl-1000
                                        iInv |= 2048;
                                        break block46;
                                    }
                                    nId = this.fromString(sP);
                                    sb = new StringBuffer();
                                    sb.append(sP.length() == 0 != false ? null : sP).append(sL.length() == 0 != false ? null : sL).append(sA).append(nM).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(Coherence.parseDate(sR)).append(cI).append(cU).append(sS.length() == 0 != false ? null : sS).append(cS).append(cP).append(cC).append(id);
                                    streamRaw = new ByteArrayOutputStream();
                                    stream = new DataOutputStream(streamRaw);
                                    stream.writeUTF(sb.toString());
                                    abRaw = streamRaw.toByteArray();
                                    abSg = Base.parseHex(sE);
                                    mUp.invoke(sg, new Object[]{abRaw, Base.makeInteger(0), Base.makeInteger(abRaw.length)});
                                    if ((Boolean)mVf.invoke(sg, new Object[]{abSg}) ^ true) {
                                        iInv |= 4096;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        if (cS > 0) {
                                            nType = 1;
                                            cStop = cS;
                                        } else if (cP > 0) {
                                            nType = 2;
                                            cStop = cP;
                                        } else if (cC > 0) {
                                            nType = 3;
                                            cStop = cC;
                                        } else if (cI > 0) {
                                            nType = 4;
                                            cStop = cI;
                                        } else if (cU > 0) {
                                            nType = 5;
                                            cStop = cU;
                                        }
                                        out.writeBoolean(true);
                                        out.write(id.toByteArray());
                                        ExternalizableHelper.writeInt(out, nId);
                                        ExternalizableHelper.writeInt(out, nType);
                                        ExternalizableHelper.writeInt(out, cStop);
                                        iInv &= ~(1 << iLc);
                                    }
                                }
                                ++iLc;
                            }
                        }
                        catch (Throwable e) {
                            if (buf.length() > 2) {
                                buf.retain(0, 2);
                            }
                            iInv |= 8192;
                        }
                    }
                    var14_19 = null;
                }
                catch (Throwable var13_18) {
                    var14_20 = null;
                    try {
                        buf.getAppendingBufferOutput().writeBoolean(false);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw var13_18;
                }
                try {
                    buf.getAppendingBufferOutput().writeBoolean(false);
                }
                catch (Throwable e) {}
                this.setBroadcastTimestamp(buf.toBinary());
                n = n == 2 != false ? --n : 2;
                this.setBroadcastMode(n);
            }
            if (n > 1) {
                var3_3 = iInv | 16384;
            }
        }
        this.__m_BroadcastLimit = c;
    }

    private void setBroadcastMode(int n) {
        this.__m_BroadcastMode = n;
        try {
            this.resetBroadcastCounter(this.getBroadcastTimestamp().getBufferInput(), true);
        }
        catch (Throwable throwable) {}
    }

    public void setBroadcastNextMillis(long cMillis) {
        this.__m_BroadcastNextMillis = cMillis;
    }

    public void setBroadcastRepeatMillis(int cMillis) {
        this.__m_BroadcastRepeatMillis = cMillis;
    }

    public void setBroadcastTimeoutMillis(int cMillis) {
        this.__m_BroadcastTimeoutMillis = cMillis;
    }

    private void setBroadcastTimestamp(Binary bin) {
        this.__m_BroadcastTimestamp = bin;
    }

    public void setDeliveryTimeoutMillis(int cMillis) {
        this.__m_DeliveryTimeoutMillis = cMillis;
    }

    public void setHeartbeatDelay(int cMillis) {
        this.__m_HeartbeatDelay = cMillis;
    }

    protected void setHeartbeatMemberSet(MemberSet setMember) {
        this.__m_HeartbeatMemberSet = setMember;
    }

    protected void setLastInterminableWarningMillis(long cMillis) {
        this.__m_LastInterminableWarningMillis = cMillis;
    }

    protected void setLastPanicUid(UUID uid) {
        this.__m_LastPanicUid = uid;
    }

    public void setMaximumPacketLength(int cbPacket) {
        this.__m_MaximumPacketLength = cbPacket;
    }

    protected void setMembershipReopen(long ldtMillis) {
        this.__m_MembershipReopen = ldtMillis;
    }

    public void setNotification(boolean fNotify) {
        super.setNotification(fNotify);
        if (fNotify) {
            this.getTcpRing().wakeup();
        }
    }

    private void setPendingServiceJoining(LongArray la) {
        this.__m_PendingServiceJoining = la;
    }

    protected void setQuorumControl(ClusterService$QuorumControl control) {
        this.__m_QuorumControl = control;
    }

    public void setRequestMember(Member member) {
        this.__m_RequestMember = member;
    }

    protected synchronized void setService(int i, Grid service) {
        boolean fBeyondBounds;
        Grid[] aService = this.getService();
        boolean bl = aService == null ? true : (fBeyondBounds = i >= aService.length);
        if (!fBeyondBounds ? false : service != null) {
            int cNew = i + 1;
            Grid[] aServiceNew = new Grid[cNew];
            if (aService != null) {
                System.arraycopy(aService, 0, aServiceNew, 0, aService.length);
            }
            aService = aServiceNew;
            this.setService(aServiceNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aService[i] = service;
        }
    }

    protected void setService(Grid[] aService) {
        this.__m_Service = aService;
    }

    public synchronized void setServiceInfo(int i, ServiceInfo info) {
        boolean fBeyondBounds;
        ServiceInfo[] ainfo = this.getServiceInfo();
        boolean bl = ainfo == null ? true : (fBeyondBounds = i >= ainfo.length);
        if (!fBeyondBounds ? false : info != null) {
            int cNew = i + 1;
            ServiceInfo[] ainfoNew = new ServiceInfo[cNew];
            if (ainfo != null) {
                System.arraycopy(ainfo, 0, ainfoNew, 0, ainfo.length);
            }
            ainfo = ainfoNew;
            this.setServiceInfo(ainfoNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            ainfo[i] = info;
        }
    }

    protected void setServiceInfo(ServiceInfo[] aInfo) {
        this.__m_ServiceInfo = aInfo;
    }

    public synchronized void setState(int nState) {
        if (nState != this.getState()) {
            switch (nState) {
                case 2: {
                    int nMemberId = this.getThisMember().getId();
                    MasterMemberSet setMember = this.getClusterMemberSet();
                    setMember.setServiceVersion(nMemberId, this.getServiceVersion());
                    setMember.setServiceJoinTime(nMemberId, this.getTimestamp());
                    setMember.setServiceEndPointName(nMemberId, "");
                    ObservableMap mapMemberConfig = setMember.ensureMemberConfigMap(nMemberId);
                    mapMemberConfig.addMapListener((Grid$MemberConfigListener)this._findChild("MemberConfigListener"));
                    ClusterService$MemberWelcomeRequest msg = (ClusterService$MemberWelcomeRequest)this.instantiateMessage("MemberWelcomeRequest");
                    msg.setToMemberSet(this.getOthersMemberSet());
                    this.send(msg);
                    this.initializeSUID();
                    break;
                }
            }
            this.__m_State = nState;
            this.updateServiceThreadName();
        }
        this.notifyAll();
    }

    protected void setStatsMembersDepartureCount(long c) {
        this.__m_StatsMembersDepartureCount = c;
    }

    protected void setTcpRing(ClusterService$TcpRing ring) {
        this.__m_TcpRing = ring;
    }

    public void setTimestampAdjustment(long cMillis) {
        this.__m_TimestampAdjustment = cMillis;
    }

    public void setTimestampMaxVariance(int cMillis) {
        this.__m_TimestampMaxVariance = cMillis;
    }

    public void setWellKnownAddresses(Set setWka) {
        this.__m_WellKnownAddresses = setWka;
    }

    private void setWkaMap(Map map) {
        this.__m_WkaMap = map;
    }

    public void shutdown() {
        Cluster cluster = (Cluster)this.getCluster();
        if (cluster.getState() < Cluster.STATE_LEAVING) {
            throw new IllegalStateException(String.valueOf("Cannot shutdown ClusterService") + " without shutting down the Cluster");
        }
        super.shutdown();
    }

    public void stop() {
        Cluster cluster = (Cluster)this.getCluster();
        if (!this.isAcceptingClients() ? false : cluster.getState() < Cluster.STATE_LEAVING) {
            Component._trace("Requested to stop cluster service.", 1);
            cluster.stop();
        } else {
            super.stop();
        }
    }

    public void unregisterServiceJoining(ClusterService$ServiceJoining msg) {
        Component._assert(Thread.currentThread() == this.getThread());
        boolean fRemoved = false;
        LongArray laPending = this.getPendingServiceJoining();
        LongArray.Iterator iter = laPending.iterator();
        while (iter.hasNext()) {
            if (!msg.equals(iter.next())) continue;
            iter.remove();
            fRemoved = true;
            break;
        }
        Component._assert(fRemoved);
    }

    public boolean validateNewMember(Member memberNew) {
        InetAddress addrNew = memberNew.getAddress();
        int nPortNew = memberNew.getPort();
        MasterMemberSet setMember = this.getClusterMemberSet();
        Iterator iter = setMember.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(!(!(member.getPort() == nPortNew) ? false : member.getAddress().equals(addrNew)) ? false : member.getUid32().equals(memberNew.getUid32()) ^ true)) continue;
            Component._trace(String.valueOf("New member uses existing address/port; ") + "killing the old member: " + member, 4);
            this.doMemberLeft(member);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateNewService(ServiceInfo info, Member member, Continuation continuation) {
        Component._assert(!(info != null) ? false : member != null);
        int nServiceId = info.getServiceId();
        Component._assert(nServiceId > 0);
        Member memberThis = this.getThisMember();
        if (!(member == memberThis)) {
            Grid serviceJoining;
            ClusterService clusterService = this;
            synchronized (clusterService) {
                serviceJoining = this.getService(nServiceId);
            }
            ServiceMemberSet setMember = info.getMemberSet();
            if (serviceJoining != null) {
                Member memberOldest = setMember.getOldestMember();
                Security security = Security.getInstance();
                if (!(security != null) ? false : memberThis == memberOldest) {
                    String sServiceName = info.getServiceName();
                    try {
                        security.verifySecureContext(this, sServiceName, member);
                    }
                    catch (RuntimeException e) {
                        Component._trace(String.valueOf("Member ") + member + " attempted to join Service " + sServiceName + " bypassing the security checkpoint; evicting the node", 1);
                        this.doMemberLeft(member);
                        return;
                    }
                }
                if (serviceJoining.getServiceMemberSet() != null) {
                    int nMember = member.getId();
                    Grid$NotifyServiceJoining msg = (Grid$NotifyServiceJoining)serviceJoining.instantiateMessage("NotifyServiceJoining");
                    msg.setNotifyMember(member);
                    msg.setNotifyServiceVersion(setMember.getServiceVersion(nMember));
                    msg.setNotifyServiceJoinTime(setMember.getServiceJoinTime(nMember));
                    msg.setNotifyServiceEndPointName(setMember.getServiceEndPointName(nMember));
                    msg.setNotifyMemberConfigMap(setMember.getMemberConfigMap(nMember));
                    msg.addToMember(memberThis);
                    if (continuation != null) {
                        ClusterService$NotifyResponse msgContinue = (ClusterService$NotifyResponse)this.instantiateMessage("NotifyResponse");
                        msgContinue.setService(this);
                        msgContinue.setContinuation(continuation);
                        continuation = null;
                        msg.setContinuationMessage(msgContinue);
                    }
                    serviceJoining.send(msg);
                }
            }
        }
        if (continuation != null) {
            continuation.proceed(null);
        }
    }

    public boolean validateSeniorBroadcast(DiscoveryMessage message, MemberSet setFrom) {
        if (this.isRunning() ^ true) {
            return false;
        }
        Member memberFrom = message.getFromMember();
        if (message.isReadError()) {
            if (this.getClusterMemberSet().size() <= 1) {
                this.onMemberRejected(-REJECT_VERSION, memberFrom);
                throw new EventDeathException("Version mismatch");
            }
            Component._trace(String.valueOf("Detected another cluster senior, running on an incompatible ") + "protocol at " + message.getSourceAddress() + " manual intervention may be required", 1);
            return false;
        }
        if (!(!(message instanceof ClusterService$SeniorMemberHeartbeat) ? false : ((ClusterService$SeniorMemberHeartbeat)message).isWkaEnabled()) ? false : Base.equals(this.getClusterName(), message.getClusterName()) ^ true) {
            return false;
        }
        switch (this.getState()) {
            case 0: 
            case 1: {
                if (!(message instanceof ClusterService$SeniorMemberHeartbeat) ? false : this.isWkaEnabled() ^ ((ClusterService$SeniorMemberHeartbeat)message).isWkaEnabled()) {
                    this.onMemberRejected(-REJECT_WKA, memberFrom);
                    throw new EventDeathException("WKA mismatch");
                }
                this.resetBroadcastCounter(String.valueOf("the presence of an existing cluster") + " that does not respond to join requests;" + " this is usually caused by a network layer failure", message);
                this.addDynamicBroadcast(memberFrom);
            }
            default: {
                return false;
            }
            case 2: 
        }
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member memberThis = setMember.getThisMember();
        Member memberOldest = setMember.getOldestMember();
        if (memberThis == null ? true : memberOldest == null) {
            return false;
        }
        if (memberFrom.equals(memberOldest)) {
            return true;
        }
        UUID uidFrom = memberFrom.getUid32();
        UUID uidThis = memberThis.getUid32();
        Component._assert(uidFrom.equals(uidThis) ^ true);
        if (!(memberThis == memberOldest) ? false : (this.isWellKnown(memberFrom) ^ true ? true : (!(message instanceof ClusterService$SeniorMemberHeartbeat) ? false : ((ClusterService$SeniorMemberHeartbeat)message).isWkaEnabled()))) {
            ClusterService$SeniorMemberHeartbeat msg = (ClusterService$SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
            msg.setToMember(memberFrom);
            msg.setLastReceivedMillis(this.calcTimestamp(memberThis.getLastIncomingMillis()));
            msg.setMemberSet(setMember);
            msg.setWkaEnabled(this.isWkaEnabled());
            this.send(msg);
        }
        long ldtCurrent = Base.getSafeTimeMillis();
        long cTimeout = this.getDeliveryTimeoutMillis();
        long cHeartbeat = this.getHeartbeatDelay();
        Member memberDead = setMember.findDeadMember(memberFrom);
        if (memberDead != null) {
            Component._assert(memberDead.isDead());
            this.setMembershipReopen(ldtCurrent + cTimeout / (long)4);
            if (memberDead.isZombie() ^ true) {
                Component._trace(String.valueOf("The member formerly known as ") + memberDead + " has been forcefully evicted from the cluster, but continues" + " to emit a cluster heartbeat; henceforth, the member will be" + " shunned and its messages will be ignored.", 2);
                memberDead.declareZombie();
                return false;
            }
            if (!(ldtCurrent > memberDead.getTimestamp() + cTimeout) ? false : (memberThis == memberOldest ? true : this.isWellKnown(memberDead) ^ true)) {
                memberDead.declareZombie();
                this.setLastPanicUid(null);
            } else {
                return false;
            }
        }
        boolean fPanicActivated = uidFrom.equals(this.getLastPanicUid());
        if (memberThis == memberOldest) {
            if (setFrom == null) {
                return false;
            }
            int cSizeThis = setMember.size();
            int cSizeFrom = setFrom.size();
            if (!(!(setMember.getMember(uidFrom) != null) ? false : cSizeThis - cSizeFrom < cSizeFrom) ? false : setMember.containsAll((Collection)setFrom)) {
                Component._trace(String.valueOf("This senior ") + memberThis + " appears to have been disconnected from other nodes due to a long" + " period of inactivity and the seniority has been assumed by the " + memberFrom + "; stopping cluster service.", 1);
                GuardSupport.logStackTraces();
                this.onStopRunning();
                return false;
            }
            if (fPanicActivated ^ true) {
                this.setMembershipReopen(ldtCurrent + (long)4 * cHeartbeat);
            }
            if (cSizeThis == 1 ? true : cSizeFrom == 1) {
                boolean fStop;
                if (cSizeThis > 1) {
                    fStop = false;
                } else if (cSizeFrom > 1) {
                    fStop = true;
                } else {
                    boolean bl = fStop = uidThis.compareTo(uidFrom) > 0;
                }
                if (fStop) {
                    Component._trace(String.valueOf("This senior ") + memberThis + " appears to have been disconnected from another senior " + memberFrom + "; stopping cluster service.", 1);
                    GuardSupport.logStackTraces();
                    this.onStopRunning();
                } else {
                    long ldtWarning = this.getLastInterminableWarningMillis();
                    if (ldtCurrent > ldtWarning + cTimeout) {
                        if (ldtWarning > 0L) {
                            String sCause = cSizeThis == 1 ? "younger that this member" : "the only member of its cluster";
                            Component._trace(String.valueOf("This senior ") + memberThis + " appears to have been disconnected from another senior " + memberFrom + ", which is " + sCause + ", but did not respond to any of the termination requests" + "; manual intervention may be necessary to stop that process.", 2);
                            this.setLastPanicUid(uidFrom);
                        }
                        this.setLastInterminableWarningMillis(ldtCurrent);
                    }
                }
                return false;
            }
            if (cSizeThis < cSizeFrom ? true : (!(cSizeThis == cSizeFrom) ? false : uidThis.compareTo(uidFrom) > 0)) {
                return false;
            }
            if (fPanicActivated ^ true) {
                Component._trace(String.valueOf("An existence of a cluster island with senior ") + memberFrom + " containing " + cSizeFrom + " nodes have been detected." + " Since this " + memberThis + " is the senior of " + (cSizeThis > cSizeFrom ? "a larger" : "an older") + " cluster island, the panic protocol is being activated to stop the" + " other island's senior and all junior nodes that belong to it.", 2);
                this.setLastPanicUid(uidFrom);
                ClusterService$SeniorMemberPanic msg = (ClusterService$SeniorMemberPanic)this.instantiateMessage("SeniorMemberPanic");
                MemberSet setTo = new MemberSet();
                setTo.addAll((Collection)setMember);
                setTo.remove(memberThis);
                msg.setCulpritMember(memberFrom);
                msg.setToMemberSet(setTo);
                this.send(msg);
            }
        } else if (fPanicActivated ^ true) {
            this.setLastPanicUid(uidFrom);
            Component._trace(String.valueOf("Notifying the senior ") + memberOldest + " of an unexpected cluster" + " heartbeat from " + (memberDead == null ? "" : "departed ") + memberFrom, 2);
            ClusterService$SeniorMemberPanic msg = (ClusterService$SeniorMemberPanic)this.instantiateMessage("SeniorMemberPanic");
            msg.setCulpritMember(memberFrom);
            msg.addToMember(memberOldest);
            this.send(msg);
        }
        return false;
    }

    protected boolean verifyMemberLeft(Member memberSuspect, MessagePacket packet) {
        MemberSet setWitness;
        if (this.isRunning() ^ true) {
            return false;
        }
        if (memberSuspect == null) {
            return true;
        }
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = ((MemberSet)setMembers).size();
        if (this.isHeuristicallyDead(memberSuspect) ^ true) {
            Set setSlow = this.getSlowMembers();
            if (setSlow == null ? true : setSlow.contains(memberSuspect) ^ true) {
                this.verifyMemberSlow(memberSuspect, packet);
                Component._trace(String.valueOf("This member is running extremely slowly and may endanger ") + "the rest of the cluster. Marking this member as suspect.", 1);
                this.onMembersTimedOut(Collections.singleton(this.getThisMember()));
                return false;
            }
            int cSlow = setSlow.size();
            int iVote = this.compareImportance(memberSuspect);
            if (iVote > 0 ? true : (!(iVote == 0) ? false : cSlow == 1)) {
                String sReason = cSlow == 1 ? String.valueOf("; the member appears to be alive, ") + "but exhibits long periods of unresponsiveness; " : " to a lower priority member; ";
                if (memberSuspect.isTimedOut() ^ true) {
                    Component._trace(String.valueOf("Timeout while delivering a packet") + sReason + "to " + memberSuspect + ". Marking Member " + memberSuspect.getId() + " as suspect.", 2);
                }
                return true;
            }
        }
        if ((setWitness = this.getWitnessMemberSet(memberSuspect)) == null) {
            if (this.getThisMember().isTimedOut() ^ true) {
                StringBuffer sb = new StringBuffer();
                sb.append("This node appears to have become disconnected from the rest of the cluster containing ").append(cMembers - 1).append(" nodes. All departure confirmation requests went unanswered.");
                Component._trace(sb.toString(), 1);
            }
            this.onMembersTimedOut(Collections.singleton(this.getThisMember()));
            return false;
        }
        if (!memberSuspect.isDeaf()) {
            if (memberSuspect.isDead()) {
                return true;
            }
            memberSuspect.setDeaf(true);
            StringBuffer sb = new StringBuffer();
            sb.append("Timeout while delivering a packet");
            if (Component._isTraceEnabled(6)) {
                sb.append(' ').append(packet);
            }
            sb.append("; requesting time-out confirmation for ").append(memberSuspect.toString(Member.SHOW_STATS)).append("\nby ").append(setWitness);
            Component._trace(sb.toString(), 2);
            ClusterService$MemberLeft msg = (ClusterService$MemberLeft)this.instantiateMessage("MemberLeft");
            msg.setToMemberSet(setWitness);
            msg.setMemberId(memberSuspect.getId());
            msg.setMemberUID(memberSuspect.getUid32());
            msg.setRequest(true);
            this.send(msg);
        }
        return false;
    }

    public void verifyMemberSlow(Member memberSlow, MessagePacket packet) {
        block4: {
            int cTimeoutMillis;
            long lLastInMillis;
            if (this.isRunning() ^ true ? true : memberSlow == null) {
                return;
            }
            long lCurrentMillis = Base.getSafeTimeMillis();
            if (!(lCurrentMillis - (lLastInMillis = memberSlow.getLastIncomingMillis()) < (long)((cTimeoutMillis = this.getDeliveryTimeoutMillis()) >> 1))) break block4;
            if (this.isSlow(memberSlow) ^ true) {
                long lFirstSentMillis = packet.getResendTimeout() - (long)cTimeoutMillis;
                long lFailedAckMillis = lCurrentMillis - lFirstSentMillis;
                long cRecentMillis = lCurrentMillis - lLastInMillis;
                int cApproxPacketLength = packet.getLength();
                StringBuffer sb = new StringBuffer();
                sb.append("A potential communication problem has been detected. ").append("A packet has failed to be delivered (or acknowledged) after ").append(lFailedAckMillis / (long)1000).append(" seconds, although other packets were acknowledged by").append(" the same cluster member (").append(memberSlow).append(") to this member (").append(this.getThisMember()).append(") as recently as ").append(cRecentMillis / (long)1000).append(" seconds ago. ");
                if (cApproxPacketLength > 1400) {
                    sb.append("It is possible that the packet size greater than ").append(cApproxPacketLength).append(" is responsible; for example, some network ").append("equipment cannot handle packets larger than 1472 bytes (IPv4) or ").append("1468 bytes (IPv6). ").append("Use the 'ping' command with the <size> option to verify successful").append(" delivery of specifically sized packets. Other possible causes include ");
                } else {
                    sb.append("Possible causes include ");
                }
                sb.append("network failure, poor thread scheduling (see FAQ if running on Windows), ").append("an extremely overloaded server, a server that is attempting to run its ").append("processes using swap space, and unreasonably lengthy GC times.");
                Component._trace(sb.toString(), 2);
            }
            memberSlow.setLastSlowMillis(lCurrentMillis);
        }
    }
}

