/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$BufferPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$MessageBuffer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.SSLException;

public class TcpAcceptor$TcpProcessor
extends Daemon {
    private transient TcpAcceptor __m_Acceptor;
    private Selector __m_Selector;
    private ServerSocket __m_ServerSocket;
    private ServerSocketChannel __m_ServerSocketChannel;
    private SelectionKey __m_ServerSocketKey;

    public TcpAcceptor$TcpProcessor() {
        this(null, null, true);
    }

    public TcpAcceptor$TcpProcessor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void flushConnections() {
        Queue queue = this.getAcceptor().getConnectionFlushQueue();
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        while (connection != null) {
            SelectionKey key = connection.getSelectionKey();
            if (key != null) {
                try {
                    key.interestOps(key.interestOps() | SelectionKey.OP_WRITE);
                }
                catch (CancelledKeyException e) {
                    // empty catch block
                }
            }
            connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        }
    }

    public TcpAcceptor getAcceptor() {
        TcpAcceptor acceptor = this.__m_Acceptor;
        if (acceptor == null) {
            acceptor = (TcpAcceptor)this.get_Module();
            this.setAcceptor(acceptor);
        }
        return acceptor;
    }

    public Selector getSelector() {
        return this.__m_Selector;
    }

    public ServerSocket getServerSocket() {
        return this.__m_ServerSocket;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.__m_ServerSocketChannel;
    }

    public SelectionKey getServerSocketKey() {
        return this.__m_ServerSocketKey;
    }

    public String getThreadName() {
        return String.valueOf(((TcpAcceptor)this.get_Module()).getServiceName()) + ':' + super.getThreadName();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$TcpProcessor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new TcpAcceptor$TcpProcessor();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected void onAccept(SelectionKey key) {
        TcpAcceptor$TcpConnection connection;
        SelectionKey keyConnection;
        SocketChannel channel;
        if (key.isValid() ^ true) {
            return;
        }
        TcpAcceptor acceptor = this.getAcceptor();
        try {
            ServerSocketChannel channelServer = (ServerSocketChannel)key.channel();
            channel = channelServer.accept();
            if (channel == null) {
                return;
            }
        }
        catch (ClosedChannelException e) {
            if (this.isExiting() ^ true) {
                Component._trace(e, "Caught an exception while accepting a Socket connection");
            }
            return;
        }
        catch (SSLException e) {
            Component._trace(String.valueOf("Could not accept a Socket connection due to: ") + e, 2);
            return;
        }
        catch (IOException e) {
            Component._trace(e, "Error accepting a Socket connection");
            return;
        }
        TcpUtil.setBlockingMode(channel, false);
        Socket socket = channel.socket();
        if (acceptor.isAuthorizedHost(socket.getInetAddress()) ^ true) {
            TcpUtil.close(socket);
            TcpUtil.close(channel);
            return;
        }
        try {
            acceptor.configureSocket(socket);
        }
        catch (RuntimeException e) {
            Component._trace(e, String.valueOf("Error accepting a connection for \"") + socket + '\"');
            TcpUtil.close(socket);
            TcpUtil.close(channel);
            return;
        }
        try {
            keyConnection = channel.register(this.getSelector(), SelectionKey.OP_READ);
        }
        catch (ClosedChannelException e) {
            TcpUtil.close(socket);
            TcpUtil.close(channel);
            return;
        }
        try {
            connection = (TcpAcceptor$TcpConnection)acceptor.instantiateConnection();
            connection.setSelectionKey(keyConnection);
            connection.setSocket(socket);
            connection.setSocketChannel(channel);
            connection.open();
        }
        catch (Throwable e) {
            Component._trace(e, "An error occured while creating a TcpConnection");
            TcpUtil.cancel(keyConnection);
            TcpUtil.close(socket);
            TcpUtil.close(channel);
            return;
        }
        keyConnection.attach(connection);
    }

    protected void onEnter() {
        AbstractSelector selector;
        ServerSocketChannel channel;
        super.onEnter();
        try {
            channel = this.getAcceptor().getSocketProvider().openServerSocketChannel();
            this.setServerSocketChannel(channel);
            channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "error opening ServerSocketChannel");
        }
        ServerSocket socket = channel.socket();
        this.setServerSocket(socket);
        this.getAcceptor().configureSocket(socket);
        try {
            selector = channel.provider().openSelector();
            this.setSelector(selector);
        }
        catch (Throwable t) {
            throw Base.ensureRuntimeException(t, "error opening Selector");
        }
        try {
            this.setServerSocketKey(channel.register(selector, SelectionKey.OP_ACCEPT));
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "error registering ServerSocketChannel");
        }
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            super.onException(e);
        } else {
            ((TcpAcceptor)this.get_Module()).onException(e);
        }
    }

    protected void onExit() {
        TcpUtil.cancel(this.getServerSocketKey());
        TcpUtil.close(this.getServerSocketChannel());
        TcpUtil.close(this.getServerSocket());
        Selector selector = this.getSelector();
        if (selector != null) {
            this.releaseConnections();
            Iterator iter = selector.keys().iterator();
            while (iter.hasNext()) {
                SelectionKey key = (SelectionKey)iter.next();
                Object o = key.attachment();
                if (!(o instanceof TcpAcceptor$TcpConnection)) continue;
                this.getAcceptor().getConnectionReleaseQueue().add(o);
            }
            this.releaseConnections();
        }
        TcpUtil.close(selector);
    }

    protected void onNotify() {
        Selector selector = this.getSelector();
        Component._assert(selector != null);
        while (this.isExiting() ^ true) {
            try {
                selector.select(500L);
                this.onSelect(selector.selectedKeys());
                this.flushConnections();
                this.releaseConnections();
            }
            catch (IOException e) {
                if (!(this.isExiting() ^ true)) continue;
                Component._trace(e, String.valueOf("Caught an I/O exception while processing a Socket; ") + "the exception has been logged and will be ignored");
            }
            catch (ClosedSelectorException e) {
                this.onException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onRead(SelectionKey key) {
        int iBuffer;
        WriteBuffer[] awb;
        int nState;
        int cbTotal;
        int cbRead;
        TcpAcceptor$TcpConnection connection;
        block34: {
            block33: {
                block32: {
                    if (key.isValid() ^ true) {
                        return;
                    }
                    connection = (TcpAcceptor$TcpConnection)key.attachment();
                    if (connection == null ? true : connection.isOpen() ^ true) {
                        key.interestOps(key.interestOps() & ~SelectionKey.OP_READ);
                        return;
                    }
                    TcpAcceptor acceptor = this.getAcceptor();
                    SocketChannel channel = (SocketChannel)key.channel();
                    TcpAcceptor$BufferPool pool = acceptor.getBufferPoolIn();
                    ByteBuffer bb = connection.getIncomingByteBuffer();
                    cbRead = connection.getIncomingBytesRead();
                    cbTotal = connection.getIncomingBytesTotal();
                    nState = connection.getIncomingState();
                    awb = connection.getIncomingWriteBufferArray();
                    iBuffer = connection.getIncomingWriteBufferIndex();
                    try {
                        block35: {
                            try {
                                switch (nState) {
                                    default: {
                                        throw new IllegalStateException(String.valueOf("unknown state: ") + nState);
                                    }
                                    case 0: {
                                        if (bb == null) {
                                            bb = ByteBuffer.allocate(5);
                                            connection.setIncomingByteBuffer(bb);
                                        }
                                        if (channel.read(bb) == -1) {
                                            connection.close(false, null);
                                            Object var16_12 = null;
                                            connection.setIncomingBytesRead(cbRead);
                                            connection.setIncomingBytesTotal(cbTotal);
                                            connection.setIncomingState(nState);
                                            connection.setIncomingWriteBufferArray((ByteBufferWriteBuffer[])awb);
                                            connection.setIncomingWriteBufferIndex(iBuffer);
                                            return;
                                        }
                                        cbTotal = TcpAcceptor$TcpProcessor.readMessageLength(bb);
                                        if (cbTotal < 0) {
                                            break block32;
                                        }
                                        nState = TcpAcceptor$TcpConnection.IN_DECODED;
                                    }
                                    case 1: {
                                        int cbBuffer = pool.getBufferSize();
                                        int cBuffer = cbTotal / cbBuffer;
                                        int cbLast = cbTotal % cbBuffer;
                                        if (cbLast > 0) {
                                            ++cBuffer;
                                        }
                                        awb = new ByteBufferWriteBuffer[cBuffer];
                                        awb[0] = (ByteBufferWriteBuffer)pool.acquire();
                                        if (!(cBuffer == 1) ? false : cbLast > 0) {
                                            ((Buffer)((ByteBufferWriteBuffer)awb[0]).getByteBuffer()).limit(cbLast);
                                        }
                                        if ((cbRead = bb.remaining()) > 0) {
                                            ((ByteBufferWriteBuffer)awb[0]).getByteBuffer().put(bb);
                                        }
                                        ((Buffer)bb).clear();
                                        nState = TcpAcceptor$TcpConnection.IN_PREPARED;
                                        break;
                                    }
                                    case 2: 
                                }
                                int c = awb.length;
                                while (true) {
                                    ByteBuffer bbMsg;
                                    int cb;
                                    block36: {
                                        if (iBuffer < c) break block36;
                                    }
                                    ByteBufferWriteBuffer wb = awb[iBuffer];
                                    if (wb == null) {
                                        wb = (ByteBufferWriteBuffer)pool.acquire();
                                        awb[iBuffer] = wb;
                                        if (iBuffer + 1 == c) {
                                            ((Buffer)wb.getByteBuffer()).limit(cbTotal - cbRead);
                                        }
                                    }
                                    if ((cb = channel.read(bbMsg = wb.getByteBuffer())) == -1) {
                                        connection.close(false, null);
                                        break block33;
                                    }
                                    cbRead += cb;
                                    if (bbMsg.hasRemaining()) {
                                        break block34;
                                    }
                                    ++iBuffer;
                                }
                                if (cbRead == cbTotal) {
                                    TcpAcceptor$MessageBuffer mb = new TcpAcceptor$MessageBuffer();
                                    mb.setBufferPool(pool);
                                    mb.set_WriteBuffer(awb);
                                    int cBuffer = awb.length;
                                    if (cBuffer == 1) {
                                        mb.set_ReadBuffer(((ByteBufferWriteBuffer)awb[0]).getUnsafeReadBuffer());
                                    } else {
                                        ReadBuffer[] arb = new ByteBufferReadBuffer[cBuffer];
                                        int i = 0;
                                        while (true) {
                                            if (!(i < cBuffer)) {
                                                mb.set_ReadBuffer(new MultiBufferReadBuffer(arb));
                                                break;
                                            }
                                            arb[i] = (ByteBufferReadBuffer)((ByteBufferWriteBuffer)awb[i]).getUnsafeReadBuffer();
                                            ++i;
                                        }
                                    }
                                    acceptor.receive(mb, connection);
                                    awb = null;
                                    iBuffer = 0;
                                    cbTotal = 0;
                                    cbRead = 0;
                                    nState = TcpAcceptor$TcpConnection.IN_INITIAL;
                                    break block35;
                                }
                                if (cbRead < cbTotal) {
                                    Component._assert(iBuffer < awb.length);
                                } else {
                                    Component._assert(false, String.valueOf("expected to read ") + cbTotal + " bytes; " + "read " + cbRead + " bytes instead");
                                }
                            }
                            catch (SSLException e) {
                                Socket socket = connection.getSocket();
                                if (socket == null) {
                                    Component._trace(String.valueOf("Exception receiving from peer: ") + e, 2);
                                } else {
                                    Component._trace(String.valueOf("Exception regarding peer ") + socket.getRemoteSocketAddress() + ": " + e, 2);
                                }
                                connection.close(false, new ConnectionException(e, (Connection)connection));
                            }
                            catch (Exception e) {
                                connection.close(false, new ConnectionException(e, (Connection)connection));
                            }
                        }
                        Object var16_16 = null;
                        connection.setIncomingBytesRead(cbRead);
                        connection.setIncomingBytesTotal(cbTotal);
                        connection.setIncomingState(nState);
                        connection.setIncomingWriteBufferArray((ByteBufferWriteBuffer[])awb);
                        connection.setIncomingWriteBufferIndex(iBuffer);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        connection.setIncomingBytesRead(cbRead);
                        connection.setIncomingBytesTotal(cbTotal);
                        connection.setIncomingState(nState);
                        connection.setIncomingWriteBufferArray((ByteBufferWriteBuffer[])awb);
                        connection.setIncomingWriteBufferIndex(iBuffer);
                        throw throwable;
                    }
                }
                Object var16_13 = null;
                connection.setIncomingBytesRead(cbRead);
                connection.setIncomingBytesTotal(cbTotal);
                connection.setIncomingState(nState);
                connection.setIncomingWriteBufferArray((ByteBufferWriteBuffer[])awb);
                connection.setIncomingWriteBufferIndex(iBuffer);
                return;
            }
            Object var16_14 = null;
            connection.setIncomingBytesRead(cbRead);
            connection.setIncomingBytesTotal(cbTotal);
            connection.setIncomingState(nState);
            connection.setIncomingWriteBufferArray((ByteBufferWriteBuffer[])awb);
            connection.setIncomingWriteBufferIndex(iBuffer);
            return;
        }
        Object var16_15 = null;
        connection.setIncomingBytesRead(cbRead);
        connection.setIncomingBytesTotal(cbTotal);
        connection.setIncomingState(nState);
        connection.setIncomingWriteBufferArray((ByteBufferWriteBuffer[])awb);
        connection.setIncomingWriteBufferIndex(iBuffer);
    }

    protected void onSelect(Set setKey) {
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            SelectionKey key = (SelectionKey)iter.next();
            iter.remove();
            if (key.isValid() ^ true) continue;
            if (key.readyOps() == 0) {
                TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)key.attachment();
                if (connection == null ? true : connection.isOpen() ^ true) {
                    TcpUtil.close(key.channel());
                    continue;
                }
                connection.close(false, null);
                continue;
            }
            try {
                if (key.isAcceptable()) {
                    this.onAccept(key);
                }
                if (key.isReadable()) {
                    this.onRead(key);
                }
                if (!key.isWritable()) continue;
                this.onWrite(key);
            }
            catch (CancelledKeyException e) {
                // empty catch block
            }
        }
    }

    protected void onWait() throws InterruptedException {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onWrite(SelectionKey key) {
        if (key.isValid() ^ true) {
            return;
        }
        connection = (TcpAcceptor$TcpConnection)key.attachment();
        if (connection == null != false ? true : connection.isOpen() ^ true) {
            key.interestOps(key.interestOps() & ~SelectionKey.OP_WRITE);
            return;
        }
        acceptor = this.getAcceptor();
        channel = (SocketChannel)key.channel();
        pool = acceptor.getBufferPoolOut();
        bb = connection.getOutgoingByteBuffer();
        cbTotal = connection.getOutgoingBytesTotal();
        cbWritten = connection.getOutgoingBytesWritten();
        mwb = connection.getOutgoingMessage();
        queue = connection.getOutgoingQueue();
        nState = connection.getOutgoingState();
        awb = connection.getOutgoingWriteBufferArray();
        iBuffer = connection.getOutgoingWriteBufferIndex();
        cSent = connection.getStatsSent();
        cbSent = connection.getStatsBytesSent();
        try {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            try {
                                block10: while (true) {
                                    switch (nState) {
                                        default: {
                                            throw new IllegalStateException(String.valueOf("unknown state: ") + nState);
                                        }
                                        case 0: {
                                            if (bb == null) {
                                                bb = ByteBuffer.allocate(5);
                                                connection.setOutgoingByteBuffer(bb);
                                            }
                                            if ((mwb = (MultiBufferWriteBuffer)queue.removeNoWait()) == null) {
                                                key.interestOps(key.interestOps() & ~SelectionKey.OP_WRITE);
                                                var22_25 = null;
                                                connection.setOutgoingBytesTotal(cbTotal);
                                                connection.setOutgoingBytesWritten(cbWritten);
                                                connection.setOutgoingMessage(mwb);
                                                connection.setOutgoingState(nState);
                                                connection.setOutgoingWriteBufferArray(awb);
                                                connection.setOutgoingWriteBufferIndex(iBuffer);
                                                connection.setStatsSent(cSent);
                                                connection.setStatsBytesSent(cbSent);
                                                return;
                                            }
                                            cbTotal = mwb.length() - 5;
                                            if (cbTotal <= 0) continue block10;
                                            cBuffer = mwb.getBufferCount();
                                            awb = new ByteBufferWriteBuffer[cBuffer];
                                            i = 0;
                                            while (true) {
                                                if (!(i < cBuffer)) {
                                                    TcpAcceptor$TcpProcessor.writeMessageLength(bb, cbTotal);
                                                    nState = TcpAcceptor$TcpConnection.OUT_PREPARED;
                                                    break;
                                                }
                                                wb = (ByteBufferWriteBuffer)mwb.getBuffer(i);
                                                wb.getByteBuffer().flip();
                                                awb[i] = wb;
                                                ++i;
                                            }
                                        }
                                        case 1: {
                                            cb = bb.remaining();
                                            of = bb.capacity() - cb;
                                            bbMsg = awb[0].getByteBuffer();
                                            bbMsg.position(of);
                                            bbMsg.put(bb);
                                            bbMsg.position(of);
                                            cbTotal += cb;
                                            cbSent += (long)of;
                                            bb.clear();
                                            nState = TcpAcceptor$TcpConnection.OUT_ENCODED;
                                        }
                                        case 2: {
                                            c = awb.length;
                                            while (true) {
                                                if (iBuffer < c) ** GOTO lbl80
lbl80:
                                                // 1 sources

                                                wbMsg = awb[iBuffer];
                                                bbMsg = wbMsg.getByteBuffer();
                                                cb = channel.write(bbMsg);
                                                cbWritten += cb;
                                                cbSent += (long)cb;
                                                if (bbMsg.hasRemaining()) {
                                                    break block23;
                                                }
                                                awb[iBuffer] = null;
                                                pool.release(wbMsg);
                                                ++iBuffer;
                                            }
                                            if (cbWritten == cbTotal) {
                                                ++cSent;
                                                mwb = null;
                                                awb = null;
                                                iBuffer = 0;
                                                cbTotal = 0;
                                                cbWritten = 0;
                                                nState = TcpAcceptor$TcpConnection.OUT_INITIAL;
                                                break;
                                            }
                                            if (cbWritten < cbTotal) {
                                                Component._assert(iBuffer < awb.length);
                                                break block24;
                                            }
                                            Component._assert(false, String.valueOf("expected to write ") + cbTotal + " bytes; " + "wrote " + cbWritten + " bytes instead");
                                            break block25;
                                        }
                                    }
                                }
                            }
                            catch (SSLException e) {
                                socket = connection.getSocket();
                                if (socket == null) {
                                    Component._trace(String.valueOf("Exception sending to peer: ") + e, 2);
                                } else {
                                    Component._trace(String.valueOf("Exception regarding peer ") + socket.getRemoteSocketAddress() + ": " + e, 2);
                                }
                                connection.close(false, new ConnectionException(e, (Connection)connection));
                                break block26;
                            }
                            catch (Exception e) {
                                connection.close(false, new ConnectionException(e, (Connection)connection));
                                break block26;
                            }
                        }
                        var22_26 = null;
                        connection.setOutgoingBytesTotal(cbTotal);
                        connection.setOutgoingBytesWritten(cbWritten);
                        connection.setOutgoingMessage(mwb);
                        connection.setOutgoingState(nState);
                        connection.setOutgoingWriteBufferArray(awb);
                        connection.setOutgoingWriteBufferIndex(iBuffer);
                        connection.setStatsSent(cSent);
                        connection.setStatsBytesSent(cbSent);
                        return;
                    }
                    var22_27 = null;
                    connection.setOutgoingBytesTotal(cbTotal);
                    connection.setOutgoingBytesWritten(cbWritten);
                    connection.setOutgoingMessage(mwb);
                    connection.setOutgoingState(nState);
                    connection.setOutgoingWriteBufferArray(awb);
                    connection.setOutgoingWriteBufferIndex(iBuffer);
                    connection.setStatsSent(cSent);
                    connection.setStatsBytesSent(cbSent);
                    return;
                }
                var22_28 = null;
                connection.setOutgoingBytesTotal(cbTotal);
                connection.setOutgoingBytesWritten(cbWritten);
                connection.setOutgoingMessage(mwb);
                connection.setOutgoingState(nState);
                connection.setOutgoingWriteBufferArray(awb);
                connection.setOutgoingWriteBufferIndex(iBuffer);
                connection.setStatsSent(cSent);
                connection.setStatsBytesSent(cbSent);
                return;
            }
            var22_29 = null;
            connection.setOutgoingBytesTotal(cbTotal);
            connection.setOutgoingBytesWritten(cbWritten);
            connection.setOutgoingMessage(mwb);
            connection.setOutgoingState(nState);
            connection.setOutgoingWriteBufferArray(awb);
            connection.setOutgoingWriteBufferIndex(iBuffer);
            connection.setStatsSent(cSent);
            connection.setStatsBytesSent(cbSent);
            return;
        }
        catch (Throwable var18_19) {
            var22_30 = null;
            connection.setOutgoingBytesTotal(cbTotal);
            connection.setOutgoingBytesWritten(cbWritten);
            connection.setOutgoingMessage(mwb);
            connection.setOutgoingState(nState);
            connection.setOutgoingWriteBufferArray(awb);
            connection.setOutgoingWriteBufferIndex(iBuffer);
            connection.setStatsSent(cSent);
            connection.setStatsBytesSent(cbSent);
            throw var18_19;
        }
    }

    protected static int readMessageLength(ByteBuffer bb) {
        int nPos = bb.position();
        if (nPos == 0) {
            return -1;
        }
        int b = bb.get(0) & 0xFF;
        if ((b & 0x40) != 0) {
            throw new IllegalArgumentException("Received a message with a negative length");
        }
        int cb = b & 0x3F;
        int i = 1;
        int cBits = 6;
        while ((b & 0x80) != 0) {
            if (i == nPos) {
                return -1;
            }
            b = bb.get(i++) & 0xFF;
            cb |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        ((Buffer)bb).limit(bb.position());
        ((Buffer)bb).position(i);
        if (cb == 0) {
            throw new IllegalArgumentException("Received a message with a length of zero");
        }
        return cb;
    }

    protected void releaseConnections() {
        TcpAcceptor acceptor = this.getAcceptor();
        TcpAcceptor$BufferPool poolIn = acceptor.getBufferPoolIn();
        TcpAcceptor$BufferPool poolOut = acceptor.getBufferPoolOut();
        Queue queue = acceptor.getConnectionReleaseQueue();
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        while (connection != null) {
            ByteBufferWriteBuffer wb;
            int c;
            int i;
            TcpUtil.cancel(connection.getSelectionKey());
            TcpUtil.close(connection.getSocket());
            TcpUtil.close(connection.getSocketChannel());
            ByteBufferWriteBuffer[] awb = connection.getIncomingWriteBufferArray();
            if (awb != null) {
                i = 0;
                c = awb.length;
                while (i < c) {
                    wb = awb[i];
                    if (wb != null) {
                        poolIn.release(wb);
                    }
                    ++i;
                }
            }
            if ((awb = connection.getOutgoingWriteBufferArray()) != null) {
                i = 0;
                c = awb.length;
                while (i < c) {
                    wb = awb[i];
                    if (wb != null) {
                        poolOut.release(wb);
                    }
                    ++i;
                }
            }
            Queue queueOut = connection.getOutgoingQueue();
            MultiBufferWriteBuffer mwb = (MultiBufferWriteBuffer)queueOut.removeNoWait();
            while (mwb != null) {
                int i2 = 0;
                int c2 = mwb.getBufferCount();
                while (i2 < c2) {
                    poolOut.release(mwb.getBuffer(i2));
                    ++i2;
                }
                mwb = (MultiBufferWriteBuffer)queueOut.removeNoWait();
            }
            if (!Component._isTraceEnabled(6) ? false : connection.getId() != null) {
                Component._trace(String.valueOf("Released: ") + connection, 6);
            }
            connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        }
    }

    protected void setAcceptor(TcpAcceptor acceptor) {
        this.__m_Acceptor = acceptor;
    }

    protected void setSelector(Selector selector) {
        this.__m_Selector = selector;
    }

    protected void setServerSocket(ServerSocket socket) {
        this.__m_ServerSocket = socket;
    }

    protected void setServerSocketChannel(ServerSocketChannel channel) {
        this.__m_ServerSocketChannel = channel;
    }

    protected void setServerSocketKey(SelectionKey key) {
        this.__m_ServerSocketKey = key;
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            this.setExiting(true);
            Thread thread = this.getThread();
            if (!(thread != null) ? false : thread != Thread.currentThread()) {
                this.wakeup();
            }
        }
    }

    public void wakeup() {
        Selector selector = this.getSelector();
        if (selector != null) {
            selector.wakeup();
        }
    }

    protected static void writeMessageLength(ByteBuffer bb, int cb) {
        Component._assert(cb >= 0);
        int b = cb & 0x3F;
        cb >>>= 6;
        while (cb != 0) {
            bb.put((byte)(b |= 0x80));
            b = cb & 0x7F;
            cb >>>= 7;
        }
        bb.put((byte)b);
        ((Buffer)bb).flip();
    }
}

