/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.ValuesKeyIndex;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.extractor.IndexAwareExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ValuesKeyExtractor
implements IndexAwareExtractor,
ExternalizableLite,
PortableObject {
    private TableInfo m_table;
    private static final Map<TableInfo, ValuesKeyIndex> m_mapIndexes = new ConcurrentHashMap<TableInfo, ValuesKeyIndex>();

    public ValuesKeyExtractor() {
    }

    public ValuesKeyExtractor(TableInfo table) {
        this.m_table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapIndex createIndex(boolean fOrdered, Comparator comparator, Map mapIndex, BackingMapContext ctx) {
        Map<TableInfo, ValuesKeyIndex> map = m_mapIndexes;
        synchronized (map) {
            if (m_mapIndexes.get(this.m_table) == null) {
                ValuesKeyIndex index = new ValuesKeyIndex(this);
                mapIndex.put(this, index);
                m_mapIndexes.put(this.m_table, index);
                return index;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapIndex destroyIndex(Map mapIndex) {
        Map<TableInfo, ValuesKeyIndex> map = m_mapIndexes;
        synchronized (map) {
            m_mapIndexes.remove(this.m_table);
            return (MapIndex)mapIndex.remove(this);
        }
    }

    @Override
    public Object extract(Object oTarget) {
        throw new UnsupportedOperationException("ValuesKeyExtractor may not be used as an extractor.");
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_table = (TableInfo)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_table);
    }

    public static ValuesKeyIndex getIndex(TableInfo table) {
        return m_mapIndexes.get(table);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_table = (TableInfo)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(1, this.m_table);
    }

    @Override
    public String toString() {
        return "ValuesKeyExtractor(" + this.m_table + ")";
    }

    @Override
    public int hashCode() {
        return this.m_table.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ValuesKeyExtractor && this.m_table.equals(((ValuesKeyExtractor)o).m_table);
    }
}

