/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.xa;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Session;
import com.tangosol.net.NamedCache;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.filter.EqualsFilter;
import java.util.HashSet;
import java.util.Set;

public class ReconstructedSession
extends Session {
    private ServiceContext m_context;
    private Set<String> m_setTables = new HashSet<String>();

    public ReconstructedSession(ServiceContext context) {
        this.m_context = context;
    }

    protected void recoverSyntheticKeys(TransactionId xid) {
        Schema schema = this.m_context.getSchema();
        Set<String> setTables = schema.getLogicalTableNames();
        for (String sTable : setTables) {
            KeyExtractor extractor;
            NamedCache valuesTable = schema.getValuesTableByName(sTable);
            Set setKeys = valuesTable.keySet(new EqualsFilter(extractor = new KeyExtractor("getXid"), (Object)xid));
            if (setKeys == null || setKeys.isEmpty()) continue;
            this.m_setTables.add(sTable);
            this.m_mapSyntheticKeys.put(sTable, new HashSet(setKeys));
        }
        this.setCommitVersion(this.m_context.getMemberState().getCurrentWriteVersion() + 1L);
    }

    @Override
    public Set<String> getModifiedTables() {
        return this.m_setTables;
    }
}

