/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.lh.LHBuffer;
import com.tangosol.io.lh.LHException;
import com.tangosol.io.lh.LHGroupCalculationException;
import com.tangosol.io.lh.LHGroupFormatException;
import com.tangosol.io.lh.LHGroupLock;
import com.tangosol.io.lh.LHIOException;
import com.tangosol.io.lh.LHOSFile;
import com.tangosol.io.lh.LHTable;
import com.tangosol.util.Base;
import java.io.IOException;

class LHSubs
implements Runnable {
    private static Object syncFreeQueue = new Object();
    private static LHSubs FreeQueueHead = null;
    private LHSubs FreeQueueNext;
    private LHTable Table;
    LHBuffer F;
    LHBuffer M;
    LHBuffer Group0Header = new LHBuffer(26);
    private LHBuffer S;
    private LHBuffer FB;
    private LHGroupLock Group0Lock;
    private LHGroupLock GroupFLock;
    private LHGroupLock FreeListLock;
    private int l;
    private int n;
    private int p;
    private int seed;
    int reclength;
    int len_reclength;
    int recidlength;
    int len_recidlength;
    private int groupreccount;
    private int groupkeyidslength;
    int grouplength;
    boolean overflowsave;
    int framesave;
    int indexsave;
    private boolean skip_buffer_needed;
    private boolean skip_ptr;
    private boolean FreeListInited;
    private boolean updatefreelist;
    private int nreleased;
    private boolean extended;
    private int maxfree;
    private int halfmax;
    private int quartermax;
    private int halffreelist;
    private static Object syncResizeQueue = new Object();
    private static boolean ResizeThreadActive = false;
    private static boolean ResizeThreadSuspended;
    private static boolean ResizeThreadStop;
    private static LHTable ResizeQueueHead;
    private static LHTable ResizeQueueTail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LHSubs InitData(LHTable Table) {
        Object object = syncFreeQueue;
        synchronized (object) {
            LHSubs D;
            if (FreeQueueHead == null) {
                D = new LHSubs();
                D.F = new LHBuffer(Table.FrameSize);
            } else {
                D = FreeQueueHead;
                FreeQueueHead = D.FreeQueueNext;
                if (D.F.buffer.length < Table.FrameSize) {
                    D.F = new LHBuffer(Table.FrameSize);
                    D.M = null;
                    D.S = null;
                    D.FB = null;
                }
            }
            D.Table = Table;
            return D;
        }
    }

    private LHSubs() {
        this.Group0Header.group = 0;
        this.Group0Header.overflow = false;
        this.Group0Header.frame = 0;
        this.Group0Lock = new LHGroupLock();
        this.GroupFLock = new LHGroupLock();
        this.FreeListLock = new LHGroupLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startResize() {
        Object object = syncResizeQueue;
        synchronized (object) {
            if (!ResizeThreadActive) {
                ResizeThreadActive = true;
                ResizeThreadSuspended = false;
                ResizeThreadStop = false;
                ResizeQueueHead = null;
                ResizeQueueTail = null;
                Thread thread = Base.makeThread(null, new LHSubs(), "ResizeLH");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopResize() {
        Object object = syncResizeQueue;
        synchronized (object) {
            if (ResizeThreadActive) {
                ResizeThreadStop = true;
                if (ResizeThreadSuspended) {
                    ResizeThreadSuspended = false;
                    syncResizeQueue.notifyAll();
                }
                ResizeThreadActive = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void CheckForResize(LHTable Table) {
        if (Table.ReadOnly) {
            return;
        }
        Object object = syncResizeQueue;
        synchronized (object) {
            if (ResizeThreadActive) {
                boolean Queued = false;
                Object object2 = Table.syncResize;
                synchronized (object2) {
                    if (Table.ResizeState == 0 && Table.SelectLocks == 0 && (Table.SizeLock <= 1 && Table.NewAlpha > Table.HighThreshold * Table.Modulo || Table.SizeLock == 0 && Table.NewAlpha < Table.LowThreshold * (Table.Modulo - 1))) {
                        if (ResizeQueueHead == null) {
                            ResizeQueueHead = Table;
                        } else {
                            LHSubs.ResizeQueueTail.ResizeQueueNext = Table;
                        }
                        ResizeQueueTail = Table;
                        Table.ResizeQueueNext = null;
                        Table.ResizeState = 1;
                        Queued = true;
                    }
                }
                if (Queued && ResizeThreadSuspended) {
                    ResizeThreadSuspended = false;
                    syncResizeQueue.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void UnlinkFromResize(LHTable Table) {
        while (true) {
            boolean bWaited = false;
            boolean bLinked = true;
            Object object = Table.syncResize;
            synchronized (object) {
                if (ResizeThreadActive) {
                    if (Table.ResizeState >= 2) {
                        Table.ResizeState = 3;
                        try {
                            Table.syncResize.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        bWaited = true;
                    }
                    if (Table.ResizeState == 0) {
                        bLinked = false;
                    }
                } else {
                    bLinked = false;
                }
            }
            if (bWaited) continue;
            if (!bLinked) {
                return;
            }
            object = syncResizeQueue;
            synchronized (object) {
                if (ResizeThreadActive) {
                    Object object2 = Table.syncResize;
                    synchronized (object2) {
                        if (Table.ResizeState == 0) {
                            bLinked = false;
                        } else if (Table.ResizeState == 1) {
                            if (ResizeQueueHead == Table) {
                                ResizeQueueHead = Table.ResizeQueueNext;
                                if (ResizeQueueHead == null) {
                                    ResizeQueueTail = null;
                                }
                            } else {
                                LHTable ResizeTable = ResizeQueueHead;
                                while (ResizeTable.ResizeQueueNext != null) {
                                    if (ResizeTable.ResizeQueueNext == Table) {
                                        ResizeTable.ResizeQueueNext = Table.ResizeQueueNext;
                                        if (ResizeTable.ResizeQueueNext != null) break;
                                        ResizeQueueTail = ResizeTable;
                                        break;
                                    }
                                    ResizeTable = ResizeTable.ResizeQueueNext;
                                }
                            }
                            Table.ResizeState = 0;
                            bLinked = false;
                        }
                    }
                } else {
                    bLinked = false;
                }
            }
            if (!bLinked) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LHBuffer[] MBuffers = null;
        LHGroupLock[] GroupLocks = new LHGroupLock[4];
        for (int i = 0; i < GroupLocks.length; ++i) {
            GroupLocks[i] = new LHGroupLock();
        }
        while (true) {
            Object object;
            boolean Empty = true;
            boolean Resize = false;
            boolean Expand = false;
            Object object2 = syncResizeQueue;
            synchronized (object2) {
                if (ResizeThreadStop) {
                    return;
                }
                Resize = false;
                this.Table = ResizeQueueHead;
                if (this.Table == null) {
                    ResizeThreadSuspended = true;
                    try {
                        syncResizeQueue.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (ResizeThreadStop) {
                        return;
                    }
                } else {
                    Empty = false;
                    object = this.Table.syncResize;
                    synchronized (object) {
                        ResizeQueueHead = this.Table.ResizeQueueNext;
                        if (ResizeQueueHead == null) {
                            ResizeQueueTail = null;
                        }
                        if (this.Table.SelectLocks == 0) {
                            if (this.Table.SizeLock <= 1 && this.Table.NewAlpha > this.Table.HighThreshold * this.Table.Modulo) {
                                Resize = true;
                                Expand = true;
                            } else if (this.Table.SizeLock == 0 && this.Table.NewAlpha < this.Table.LowThreshold * (this.Table.Modulo - 1)) {
                                Resize = true;
                                Expand = false;
                            }
                        }
                        this.Table.ResizeState = Resize ? 2 : 0;
                    }
                }
            }
            if (Empty) continue;
            if (Resize) {
                try {
                    this.Table.InitializeFileUse();
                    if (this.F == null) {
                        this.F = new LHBuffer(this.Table.FrameSize);
                    } else if (this.Table.FrameSize > this.F.buffer.length) {
                        this.F = new LHBuffer(this.Table.FrameSize);
                        this.M = null;
                        this.S = null;
                        this.FB = null;
                        MBuffers = null;
                    }
                    if (MBuffers == null) {
                        MBuffers = new LHBuffer[3];
                        MBuffers[0] = new LHBuffer(this.F.buffer.length);
                        MBuffers[1] = new LHBuffer(this.F.buffer.length);
                    }
                    if (Expand) {
                        this.Expand(MBuffers, GroupLocks);
                    } else {
                        if (MBuffers[2] == null) {
                            MBuffers[2] = new LHBuffer(this.F.buffer.length);
                        }
                        this.Contract(MBuffers, GroupLocks);
                    }
                }
                catch (Throwable t) {
                    Resize = false;
                }
            }
            object2 = syncResizeQueue;
            synchronized (object2) {
                object = this.Table.syncResize;
                synchronized (object) {
                    boolean bWaiting;
                    boolean bl = bWaiting = this.Table.ResizeState == 3;
                    if (Resize) {
                        Resize = false;
                        if (this.Table.SelectLocks == 0) {
                            if (Expand) {
                                if (this.Table.SizeLock <= 1 && this.Table.NewAlpha > this.Table.HighThreshold * this.Table.Modulo) {
                                    Resize = true;
                                }
                            } else if (this.Table.SizeLock == 0 && this.Table.NewAlpha < this.Table.LowThreshold * (this.Table.Modulo - 1)) {
                                Resize = false;
                            }
                        }
                    }
                    if (Resize) {
                        if (ResizeQueueHead == null) {
                            ResizeQueueHead = this.Table;
                        } else {
                            LHSubs.ResizeQueueTail.ResizeQueueNext = this.Table;
                        }
                        ResizeQueueTail = this.Table;
                        this.Table.ResizeQueueNext = null;
                        this.Table.ResizeState = 1;
                    } else {
                        this.Table.ResizeState = 0;
                    }
                    if (bWaiting) {
                        this.Table.syncResize.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Expand(LHBuffer[] MBuffers, LHGroupLock[] GroupLocks) throws LHException {
        block21: {
            int iGroup;
            try {
                int stepsize;
                int bucketmin;
                this.CalculateLNP(this.Table.Modulo);
                if (this.p == -1) {
                    bucketmin = 0;
                    stepsize = 1;
                } else {
                    bucketmin = this.p;
                    stepsize = 1 << this.l;
                }
                int bucket = bucketmin;
                iGroup = 0;
                while (bucket <= this.Table.Modulo) {
                    if (bucket == 0) {
                        this.LockGroup0(true);
                    } else {
                        this.LockGroup(bucket, true, GroupLocks[iGroup]);
                    }
                    bucket += stepsize;
                    ++iGroup;
                }
                if (this.Table.NewAlpha <= this.Table.HighThreshold * this.Table.Modulo) break block21;
                int NewModulo = this.Table.Modulo + 1;
                this.CalculateLNP(NewModulo);
                this.Table.Modulo = NewModulo;
                Object object = this.Table.syncVerified;
                synchronized (object) {
                    if (this.Table.ModuloVerified == NewModulo - 1) {
                        this.Table.ModuloVerified = NewModulo;
                    }
                }
                MBuffers[0].group = NewModulo - 1;
                MBuffers[0].overflow = false;
                MBuffers[0].frame = NewModulo - 1;
                LHBuffer cfr_ignored_0 = MBuffers[0];
                MBuffers[0].index = 13;
                LHBuffer cfr_ignored_1 = MBuffers[0];
                MBuffers[0].putType(13);
                MBuffers[0].putDataForward(0);
                MBuffers[0].putDataForwardSkip(0);
                MBuffers[0].putPrimaryModulo(NewModulo);
                LHBuffer cfr_ignored_2 = MBuffers[0];
                int length1 = 13 + 1;
                bucket = bucketmin;
                iGroup = 0;
                while (bucket < NewModulo - 1) {
                    this.F.group = bucket;
                    this.GetPrimaryFrame();
                    MBuffers[1].group = this.F.group;
                    MBuffers[1].overflow = this.F.overflow;
                    MBuffers[1].frame = this.F.frame;
                    MBuffers[1].index = this.F.index;
                    System.arraycopy(this.F.buffer, 0, MBuffers[1].buffer, 0, this.F.index);
                    MBuffers[1].putPrimaryModulo(NewModulo);
                    int length2 = this.grouplength;
                    while (!this.CheckEndOfGroup()) {
                        int NewGroup = this.HashKeyId(this.GetNextKeyId());
                        if (NewGroup == NewModulo - 1) {
                            this.M = MBuffers[0];
                            this.CopyLengthsKeyIdRecord();
                            length1 += this.len_reclength + this.reclength + 1;
                            MBuffers[0] = this.M;
                            continue;
                        }
                        if (NewGroup == bucket) {
                            this.M = MBuffers[1];
                            this.CopyLengthsKeyIdRecord();
                            length2 += this.len_reclength + this.reclength + 1;
                            MBuffers[1] = this.M;
                            continue;
                        }
                        throw new LHGroupCalculationException(this.Table.Name(), this.F.group);
                    }
                    this.M = MBuffers[1];
                    this.OutByte(128);
                    this.ReleaseOverflowFrames();
                    this.ComputeDelta(this.grouplength, length2);
                    if (bucket != 0) {
                        this.UnlockGroup(GroupLocks[iGroup]);
                    }
                    bucket += stepsize;
                    ++iGroup;
                }
                this.M = MBuffers[0];
                this.OutByte(128);
                this.ReleaseOverflowFrames();
                this.SaveFreeList();
                this.ComputeDelta(0, length1);
                this.UnlockGroup(GroupLocks[iGroup]);
                this.LoadGroup0Header(true);
                this.UnloadGroup0Header();
                if (this.Table.Volume.m_FlushAllUpdates) {
                    this.FlushFile(false);
                    this.FlushFile(true);
                } else if (this.Table.Volume.m_FlushFileSizeUpdates) {
                    this.FlushFile(false);
                }
            }
            finally {
                this.UnlockFreeList();
                for (iGroup = 0; iGroup < 4; ++iGroup) {
                    this.UnlockGroup(GroupLocks[iGroup]);
                }
                this.UnlockGroup0();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Contract(LHBuffer[] MBuffers, LHGroupLock[] GroupLocks) throws LHException {
        block24: {
            int iGroup;
            try {
                int stepsize;
                int bucketmin;
                int NewModulo = this.Table.Modulo - 1;
                this.CalculateLNP(NewModulo);
                if (this.p == -1) {
                    bucketmin = 0;
                    stepsize = 1;
                } else {
                    bucketmin = this.p;
                    stepsize = 1 << this.l;
                }
                int bucket = bucketmin;
                iGroup = 0;
                while (bucket <= this.Table.Modulo) {
                    if (bucket == 0) {
                        this.LockGroup0(true);
                    } else {
                        this.LockGroup(bucket, true, GroupLocks[iGroup]);
                    }
                    bucket += stepsize;
                    ++iGroup;
                }
                if (this.Table.NewAlpha >= this.Table.LowThreshold * (this.Table.Modulo - 1)) break block24;
                this.Table.Modulo = NewModulo;
                int[] oldlengths = new int[3];
                int[] lengths = new int[3];
                bucket = bucketmin;
                iGroup = 0;
                while (bucket < this.Table.Modulo) {
                    this.F.group = bucket;
                    this.GetPrimaryFrame();
                    this.F.putPrimaryModulo(NewModulo);
                    if (bucket != 0 && this.F.getDataForward() != 0) {
                        this.WriteFrame(this.F, 13);
                    }
                    while (!this.CheckEndOfGroup()) {
                        this.GetRecordLengths(false);
                        this.SkipCount(this.recidlength);
                        this.SkipRecord();
                    }
                    LHBuffer save = MBuffers[iGroup];
                    MBuffers[iGroup] = this.F;
                    this.F = save;
                    oldlengths[iGroup] = this.grouplength;
                    lengths[iGroup] = this.grouplength;
                    bucket += stepsize;
                    ++iGroup;
                }
                this.F.group = NewModulo;
                this.GetPrimaryFrame();
                int Free = this.F.getDataForward();
                while (!this.CheckEndOfGroup()) {
                    int NewGroup = this.HashKeyId(this.GetNextKeyId());
                    if (NewGroup >= NewModulo || (NewGroup & stepsize - 1) != bucketmin) {
                        throw new LHGroupCalculationException(this.Table.Name(), this.F.group);
                    }
                    iGroup = NewGroup >> this.l;
                    this.M = MBuffers[iGroup];
                    this.CopyLengthsKeyIdRecord();
                    int n = iGroup;
                    lengths[n] = lengths[n] + (this.len_reclength + this.reclength + 1);
                    MBuffers[iGroup] = this.M;
                }
                this.M = this.F;
                this.ComputeDelta(this.grouplength, 0);
                bucket = bucketmin;
                iGroup = 0;
                while (bucket < this.Table.Modulo) {
                    this.M = MBuffers[iGroup];
                    this.OutByte(128);
                    this.ReleaseOverflowFrames();
                    this.ComputeDelta(oldlengths[iGroup], lengths[iGroup]);
                    if (bucket != 0) {
                        this.UnlockGroup(GroupLocks[iGroup]);
                    }
                    bucket += stepsize;
                    ++iGroup;
                }
                while (Free != 0) {
                    this.F.overflow = true;
                    this.F.frame = Free;
                    this.ReadFrame(this.F, 14);
                    Free = this.F.getDataForward();
                }
                this.SaveFreeList();
                this.SetFileSize(false, NewModulo);
                Object object = this.Table.syncVerified;
                synchronized (object) {
                    if (this.Table.ModuloVerified == NewModulo + 1) {
                        this.Table.ModuloVerified = NewModulo;
                    }
                }
                this.UnlockGroup(GroupLocks[iGroup]);
                this.LoadGroup0Header(true);
                this.UnloadGroup0Header();
                if (this.Table.Volume.m_FlushAllUpdates) {
                    this.FlushFile(false);
                    this.FlushFile(true);
                } else if (this.Table.Volume.m_FlushFileSizeUpdates) {
                    this.FlushFile(false);
                }
            }
            finally {
                this.UnlockFreeList();
                for (iGroup = 0; iGroup < 4; ++iGroup) {
                    this.UnlockGroup(GroupLocks[iGroup]);
                }
                this.UnlockGroup0();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void TermData() {
        this.UnlockFreeList();
        this.UnlockGroupF();
        this.UnlockGroup0();
        Object object = syncFreeQueue;
        synchronized (object) {
            this.FreeQueueNext = FreeQueueHead;
            FreeQueueHead = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean CheckEndOfGroup() throws LHException {
        if (this.F.index >= this.Table.FrameSize) {
            this.GetNextOverflowFrame();
        }
        if (!this.F.EndOfGroup()) {
            return false;
        }
        if (this.Table.SizeLock > 1 || this.Table.SelectLocks > 0) {
            Object object = this.Table.syncVerified;
            synchronized (object) {
                if (this.F.group == this.Table.ModuloVerified) {
                    ++this.Table.ModuloVerified;
                    this.Table.AlphaVerified = this.Table.AlphaVerified + (this.grouplength <= this.Table.FrameSize ? this.grouplength : this.Table.FrameSize);
                    this.Table.RecordCountVerified += this.groupreccount;
                    if (this.Table.ModuloVerified == this.Table.Modulo) {
                        Object object2 = this.Table.syncAlpha;
                        synchronized (object2) {
                            this.Table.NewAlpha = this.Table.AlphaVerified;
                        }
                        object2 = this.Table.syncRecordCount;
                        synchronized (object2) {
                            this.Table.NewRecordCount = this.Table.RecordCountVerified;
                        }
                    }
                }
            }
        }
        return true;
    }

    boolean FindKeyId(byte[] key, boolean exclusive) throws LHException {
        this.SetupKeyId(key, exclusive);
        while (true) {
            if (this.CheckEndOfGroup()) {
                this.indexsave = 0;
                return false;
            }
            this.overflowsave = this.F.overflow;
            this.framesave = this.F.frame;
            this.indexsave = this.F.index;
            this.GetRecordLengths(false);
            int i = this.recidlength;
            if (i == key.length) {
                int offset = 0;
                while (true) {
                    if (i == 0) {
                        return true;
                    }
                    int c = this.NextByte(false);
                    --i;
                    if ((key[offset] & 0xFF) != c) break;
                    ++offset;
                }
            }
            this.SkipCount(i);
            this.SkipRecord();
        }
    }

    private void SetupKeyId(byte[] key, boolean exclusive) throws LHException {
        int iKeyId = this.CalcKeyId(key, 0, key.length, 0);
        int modulo = this.Table.Modulo;
        this.CalculateLNP(modulo);
        this.F.group = this.HashKeyId(iKeyId);
        while (true) {
            if (this.F.group == 0) {
                this.LockGroup0(exclusive);
            } else {
                this.LockGroupF(exclusive);
            }
            if (modulo == this.Table.Modulo) break;
            modulo = this.Table.Modulo;
            this.CalculateLNP(modulo);
            int NewGroup = this.HashKeyId(iKeyId);
            if (NewGroup == this.F.group) break;
            if (this.F.group == 0) {
                this.UnlockGroup0();
            } else {
                this.UnlockGroupF();
            }
            this.F.group = NewGroup;
        }
        this.GetPrimaryFrame();
        int groupModulo = this.F.getPrimaryModulo();
        if (groupModulo == modulo) {
            return;
        }
        this.CalculateLNP(groupModulo);
        if (this.HashKeyId(iKeyId) != this.F.group) {
            throw new LHGroupCalculationException(this.Table.Name(), this.F.group, key);
        }
    }

    private int CalcKeyId(byte[] key, int offset, int length, int hashid) {
        while (length > 0) {
            hashid += (hashid << 3) + key[offset];
            ++offset;
            --length;
        }
        return hashid;
    }

    private int GetNextKeyId() throws LHException {
        int i;
        this.overflowsave = this.F.overflow;
        this.framesave = this.F.frame;
        this.indexsave = this.F.index;
        this.GetRecordLengths(false);
        int iHashId = 0;
        for (int length = this.recidlength; length > 0; length -= i) {
            if (this.F.index >= this.Table.FrameSize) {
                this.GetNextOverflowFrame();
            }
            if (length < (i = this.Table.FrameSize - this.F.index)) {
                i = length;
            }
            iHashId = this.CalcKeyId(this.F.buffer, this.F.index, i, iHashId);
            this.F.index += i;
        }
        return iHashId;
    }

    private void CopyLengthsKeyIdRecord() throws LHException {
        int i;
        if (this.F.overflow != this.overflowsave || this.F.frame != this.framesave) {
            this.F.overflow = this.overflowsave;
            this.F.frame = this.framesave;
            this.ReadFrame(this.F, this.Table.FrameSize);
        }
        this.F.index = this.indexsave;
        this.indexsave = 0;
        for (int length = this.len_reclength + this.len_recidlength + this.recidlength; length > 0; length -= i) {
            if (this.F.index >= this.Table.FrameSize) {
                this.GetNextOverflowFrame();
            }
            if (length < (i = this.Table.FrameSize - this.F.index)) {
                i = length;
            }
            this.MoveToFile(this.F.buffer, this.F.index, i);
            this.F.index += i;
        }
        this.CopyRecord();
    }

    void GetRecordLengths(boolean copy) throws LHException {
        int c = this.NextByte(copy);
        this.reclength = c & 0x7F;
        this.len_reclength = 1;
        while ((c & 0x80) == 0) {
            c = this.NextByte(copy);
            this.reclength = this.reclength << 7 | c & 0x7F;
            ++this.len_reclength;
        }
        c = this.NextByte(copy);
        this.recidlength = c & 0x7F;
        this.len_recidlength = 1;
        while ((c & 0x80) == 0) {
            c = this.NextByte(copy);
            this.recidlength = this.recidlength << 7 | c & 0x7F;
            ++this.len_recidlength;
        }
        ++this.groupreccount;
        this.grouplength += this.len_reclength + this.reclength + 1;
        this.groupkeyidslength += this.recidlength + 1;
    }

    void SkipCount(int length) throws LHException {
        while (length > 0) {
            int i;
            if (this.F.index >= this.Table.FrameSize) {
                this.GetNextOverflowFrame();
            }
            if (length < (i = this.Table.FrameSize - this.F.index)) {
                i = length;
            }
            this.F.index += i;
            length -= i;
        }
    }

    byte[] ExtractRecord() throws LHException {
        int length = this.reclength - this.recidlength - this.len_recidlength;
        byte[] object = new byte[length];
        this.MoveFromFile(object, 0, length);
        this.CheckRecordMarker(false);
        return object;
    }

    void SkipRecord() throws LHException {
        int length = this.reclength - this.recidlength - this.len_recidlength;
        int i = this.Table.FrameSize - this.F.index;
        if (length <= i) {
            this.F.index += length;
        } else {
            this.F.putDataForward(this.F.getDataForwardSkip());
            this.GetNextOverflowFrame();
            this.F.index = (length - i) % (this.Table.FrameSize - 14) + 14;
        }
        this.CheckRecordMarker(false);
    }

    void CheckRecordMarker(boolean copy) throws LHException {
        int ch = this.NextByte(copy);
        if (ch != 255) {
            throw new LHGroupFormatException(this.Table.Name(), this.F.group, this.F.overflow, this.F.frame, this.F.index - 1, "Expecting End Of Record marker (0xff), found 0x" + Integer.toHexString(ch));
        }
    }

    void MoveFromFile(byte[] buffer, int offset, int length) throws LHException {
        while (length > 0) {
            int i;
            if (this.F.index >= this.Table.FrameSize) {
                this.GetNextOverflowFrame();
            }
            if (length < (i = this.Table.FrameSize - this.F.index)) {
                i = length;
            }
            System.arraycopy(this.F.buffer, this.F.index, buffer, offset, i);
            this.F.index += i;
            offset += i;
            length -= i;
        }
    }

    void CopyKeyId() throws LHException {
        int i;
        for (int length = this.recidlength; length > 0; length -= i) {
            if (this.F.index >= this.Table.FrameSize) {
                this.GetNextOverflowFrame();
            }
            if (length < (i = this.Table.FrameSize - this.F.index)) {
                i = length;
            }
            this.MoveToFile(this.F.buffer, this.F.index, i);
            this.F.index += i;
        }
    }

    void CopyRecord() throws LHException {
        int i;
        int length;
        this.SkipCheck(length);
        for (length = this.reclength - this.recidlength - this.len_recidlength; length > 0; length -= i) {
            if (this.F.index >= this.Table.FrameSize) {
                this.GetNextOverflowFrame();
            }
            if (length < (i = this.Table.FrameSize - this.F.index)) {
                i = length;
            }
            this.MoveToFile(this.F.buffer, this.F.index, i);
            this.F.index += i;
        }
        this.CheckRecordMarker(true);
        this.SkipFinish();
    }

    void SkipCheck(int length) {
        this.skip_ptr = length >= this.Table.FrameSize - this.M.index + this.Table.FrameSize - 14;
        this.skip_buffer_needed = this.skip_ptr;
    }

    void SkipFinish() throws LHException {
        if (this.skip_ptr) {
            this.skip_ptr = false;
            this.S.putDataForwardSkip(this.M.frame);
            this.WriteFrame(this.S, this.Table.FrameSize);
        }
    }

    void MoveToFile(byte[] buffer, int offset, int length) throws LHException {
        while (length > 0) {
            int i;
            if (this.M.index >= this.Table.FrameSize) {
                this.FlushFrame();
            }
            if (length < (i = this.Table.FrameSize - this.M.index)) {
                i = length;
            }
            System.arraycopy(buffer, offset, this.M.buffer, this.M.index, i);
            this.M.index += i;
            offset += i;
            length -= i;
        }
    }

    private int NextByte(boolean copy) throws LHException {
        if (this.F.index >= this.Table.FrameSize) {
            this.GetNextOverflowFrame();
        }
        if (copy) {
            int c = this.F.GetNextByte();
            this.OutByte(c);
            return c;
        }
        return this.F.GetNextByte();
    }

    void PutRecordLengths(int recidlength, int reclength) throws LHException {
        byte[] temp = new byte[20];
        int i = 20;
        int total = recidlength + reclength + 1;
        temp[--i] = (byte)(recidlength | 0x80);
        while ((recidlength >>= 7) > 0) {
            ++total;
            temp[--i] = (byte)(recidlength & 0x7F);
        }
        this.reclength = total;
        this.len_reclength = i--;
        temp[i] = (byte)(total | 0x80);
        while ((total >>= 7) > 0) {
            temp[--i] = (byte)(total & 0x7F);
        }
        this.len_reclength -= i;
        if (this.M.index < this.Table.FrameSize) {
            this.indexsave = this.M.index;
        } else {
            this.OutByte(temp[i++]);
            this.indexsave = this.M.index - 1;
        }
        this.overflowsave = this.M.overflow;
        this.framesave = this.M.frame;
        this.MoveToFile(temp, i, 20 - i);
    }

    void OutByte(int c) throws LHException {
        if (this.M.index >= this.Table.FrameSize) {
            this.FlushFrame();
        }
        this.M.PutNextByte(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ComputeDelta(int before, int after) {
        if (before > this.Table.FrameSize) {
            before = this.Table.FrameSize;
        }
        if (after > this.Table.FrameSize) {
            after = this.Table.FrameSize;
        }
        if (after > before) {
            after -= before;
            Object object = this.Table.syncAlpha;
            synchronized (object) {
                this.Table.NewAlpha += after;
            }
            object = this.Table.syncVerified;
            synchronized (object) {
                if (this.M.group < this.Table.ModuloVerified) {
                    this.Table.AlphaVerified += after;
                }
            }
        }
        if (before > after) {
            before -= after;
            Object object = this.Table.syncAlpha;
            synchronized (object) {
                this.Table.NewAlpha = before <= this.Table.NewAlpha ? (this.Table.NewAlpha -= before) : 0;
            }
            object = this.Table.syncVerified;
            synchronized (object) {
                if (this.M.group < this.Table.ModuloVerified) {
                    this.Table.AlphaVerified = before <= this.Table.AlphaVerified ? (this.Table.AlphaVerified -= before) : 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void FlushGroup0() throws LHException {
        int delta;
        boolean flush = false;
        Object object = this.Table.syncAlpha;
        synchronized (object) {
            delta = this.Table.NewAlpha >= this.Table.Alpha ? this.Table.NewAlpha - this.Table.Alpha : this.Table.Alpha - this.Table.NewAlpha;
        }
        if (delta > 2 * this.Table.FrameSize) {
            flush = true;
        }
        if (this.Table.Group0HeaderSize == 26) {
            object = this.Table.syncRecordCount;
            synchronized (object) {
                delta = this.Table.NewRecordCount >= this.Table.RecordCount ? this.Table.NewRecordCount - this.Table.RecordCount : (this.Table.RecordCount = this.Table.NewRecordCount);
            }
            if (delta > 20) {
                flush = true;
            }
        }
        if (!flush) {
            return;
        }
        this.LoadGroup0Header(true);
        flush = false;
        object = this.Table.syncAlpha;
        synchronized (object) {
            delta = this.Table.NewAlpha >= this.Table.Alpha ? this.Table.NewAlpha - this.Table.Alpha : this.Table.Alpha - this.Table.NewAlpha;
        }
        if (delta > 2 * this.Table.FrameSize) {
            flush = true;
        }
        if (this.Table.Group0HeaderSize == 26) {
            object = this.Table.syncRecordCount;
            synchronized (object) {
                delta = this.Table.NewRecordCount >= this.Table.RecordCount ? this.Table.NewRecordCount - this.Table.RecordCount : (this.Table.RecordCount = this.Table.NewRecordCount);
            }
            if (delta > 20) {
                flush = true;
            }
        }
        if (flush) {
            this.UnloadGroup0Header();
        }
    }

    void LoadGroup0Header(boolean exclusive) throws LHException {
        this.LockGroup0(exclusive);
        this.ReadFrame(this.Group0Header, this.Table.Group0HeaderSize);
        int type = this.Group0Header.getType();
        if (type != this.Table.Group0HeaderSize) {
            throw new LHGroupFormatException(this.Table.Name(), 0, false, 0, 0, "Frame type \"" + type + "\" invalid");
        }
    }

    void UnloadGroup0Header() throws LHException {
        this.WriteFrame(this.Group0Header, this.Table.Group0HeaderSize);
    }

    void GetPrimaryFrame() throws LHException {
        this.F.overflow = false;
        this.F.frame = this.F.group;
        this.ReadFrame(this.F, this.Table.FrameSize);
        this.F.index = this.F.getType();
        if (this.F.group == 0) {
            if (this.F.index != 26) {
                if (this.F.index != 22) {
                    throw new LHGroupFormatException(this.Table.Name(), 0, false, 0, 0, "Frame type \"" + this.F.index + "\" invalid");
                }
            }
        } else if (this.F.index != 13) {
            throw new LHGroupFormatException(this.Table.Name(), this.F.group, false, this.F.frame, 0, "Frame type \"" + this.F.index + "\" invalid");
        }
        this.groupreccount = 0;
        this.grouplength = this.F.index + 1;
        this.groupkeyidslength = 0;
    }

    void GetNextOverflowFrame() throws LHException {
        int nextf = this.F.getDataForward();
        if (nextf == 0) {
            throw new LHGroupFormatException(this.Table.Name(), this.F.group, this.F.overflow, this.F.frame, 1, "No forward link");
        }
        this.Table.EnsureOVOpen();
        this.F.overflow = true;
        this.F.frame = nextf;
        this.ReadFrame(this.F, this.Table.FrameSize);
        this.F.index = this.F.getType();
        if (this.F.index != 14) {
            throw new LHGroupFormatException(this.Table.Name(), this.F.group, this.F.overflow, this.F.frame, 0, "Frame type \"" + this.F.index + "\" invalid");
        }
        int group = this.F.getOverflowGroup();
        if (group != this.F.group) {
            throw new LHGroupFormatException(this.Table.Name(), this.F.group, this.F.overflow, this.F.frame, 9, "Frame group number \"" + group + "\" invalid");
        }
    }

    private void FlushFrame() throws LHException {
        boolean newFrame = false;
        int next = this.M.getDataForward();
        if (next <= 0) {
            newFrame = true;
            next = this.GetFreeFrame(this.M.overflow ? this.M.frame : 0);
            this.M.putDataForward(next);
        }
        if (this.skip_buffer_needed) {
            this.skip_buffer_needed = false;
            LHBuffer save = this.S;
            if (save == null) {
                save = new LHBuffer(this.F.buffer.length);
            }
            this.S = this.M;
            this.M = save;
            this.M.group = this.S.group;
        } else {
            this.M.putDataForwardSkip(next);
            this.WriteFrame(this.M, this.Table.FrameSize);
        }
        this.M.overflow = true;
        this.M.frame = next;
        if (newFrame) {
            this.M.putType(14);
            this.M.putDataForward(0);
            this.M.putDataForwardSkip(0);
            this.M.putOverflowGroup(this.M.group);
            this.M.index = 14;
        } else {
            this.ReadFrame(this.M, 14);
            this.M.index = this.M.getType();
            if (this.M.index != 14) {
                throw new LHGroupFormatException(this.Table.Name(), this.M.group, this.M.overflow, this.M.frame, 0, "Frame type \"" + this.M.index + "\" invalid");
            }
            int group = this.M.getOverflowGroup();
            if (group != this.M.group) {
                throw new LHGroupFormatException(this.Table.Name(), this.M.group, this.M.overflow, this.M.frame, 9, "Frame group number \"" + group + "\" invalid");
            }
        }
    }

    void ReleaseOverflowFrames() throws LHException {
        int free = this.M.getDataForward();
        this.M.putDataForward(0);
        this.M.putDataForwardSkip(0);
        this.M.fill(this.M.index, this.Table.FrameSize - this.M.index, this.Table.Volume.m_FillCharacter);
        this.WriteFrame(this.M, this.Table.FrameSize);
        while (free > 0) {
            this.M.overflow = true;
            this.M.frame = free;
            this.ReadFrame(this.M, 14);
            int index = this.M.getType();
            if (index != 14) {
                throw new LHGroupFormatException(this.Table.Name(), this.M.group, this.M.overflow, this.M.frame, 0, "Frame type \"" + index + "\" invalid");
            }
            int group = this.M.getOverflowGroup();
            if (group != this.M.group) {
                throw new LHGroupFormatException(this.Table.Name(), this.M.group, this.M.overflow, this.M.frame, 9, "Frame group number \"" + group + "\" invalid");
            }
            this.PutFreeFrame(free);
            free = this.M.getDataForward();
        }
    }

    private int GetFreeFrame(int lastframe) throws LHException {
        int nextframe;
        this.GetFreeList();
        this.updatefreelist = true;
        this.SortFreeList();
        int size = this.FB.getFreeListSize();
        if (this.FB.getFreeListNextList() != 0 && size <= this.quartermax) {
            this.ReadNextList();
            size = this.FB.getFreeListSize();
        }
        int i = size;
        int frame = 0;
        while (i > 0 && (frame = this.FB.getFreeListElement(--i)) <= lastframe) {
        }
        if (i + 1 < size && lastframe - (nextframe = this.FB.getFreeListElement(i + 1)) < frame - lastframe) {
            frame = nextframe;
            ++i;
        }
        if (i == 0) {
            this.FB.putFreeListElement(0, frame + 1);
            this.extended = true;
        } else {
            while (++i < size) {
                this.FB.putFreeListElement(i - 1, this.FB.getFreeListElement(i));
            }
            this.FB.putFreeListElement(i - 1, 0);
            this.FB.putFreeListSize(size - 1);
        }
        return frame;
    }

    private void PutFreeFrame(int ovframe) throws LHException {
        this.GetFreeList();
        int size = this.FB.getFreeListSize();
        if (size >= this.maxfree) {
            this.SplitHalf();
            size = this.FB.getFreeListSize();
        }
        this.updatefreelist = true;
        this.FB.putFreeListElement(size, ovframe);
        this.FB.putFreeListSize(size + 1);
        ++this.nreleased;
    }

    private void GetFreeList() throws LHException {
        if (!this.FreeListInited) {
            this.Table.EnsureOVOpen();
            this.LockFreeList();
            this.updatefreelist = false;
            this.nreleased = 0;
            this.extended = false;
            this.maxfree = (this.Table.FrameSize - 7) / 4;
            this.halfmax = this.maxfree / 2;
            this.quartermax = this.halfmax / 2;
            this.halffreelist = 7 + this.halfmax * 4;
            if (this.FB == null) {
                this.FB = new LHBuffer(this.F.buffer.length);
            }
            this.FB.group = -1;
            this.FB.overflow = true;
            this.FB.frame = 0;
            if (this.FileSize(true) == 0) {
                this.FB.putType(14);
                this.FB.putFreeListSize(1);
                this.FB.putFreeListNextList(0);
                this.FB.putFreeListElement(0, 1);
                int i = 7 + 4;
                this.FB.fill(i, this.Table.FrameSize - i, this.Table.Volume.m_FillCharacter);
            } else {
                this.ReadFrame(this.FB, this.Table.FrameSize);
            }
            this.FreeListInited = true;
        }
    }

    void SaveFreeList() throws LHException {
        if (!this.FreeListInited) {
            return;
        }
        this.FreeListInited = false;
        if (this.updatefreelist) {
            while (true) {
                this.SortFreeList();
                this.CheckFreeEndOfFile();
                int nextlist = this.FB.getFreeListNextList();
                if (nextlist <= 0 || nextlist != this.FB.getFreeListElement(0) - 1) break;
                if (this.FB.getFreeListSize() > this.halfmax) {
                    this.SplitHalf();
                }
                this.ReadNextList();
            }
            this.FB.frame = 0;
            if (this.FB.getFreeListSize() == 1 && this.FB.getFreeListElement(0) == 1) {
                this.SetFileSize(true, 0);
                this.extended = true;
                this.WriteFrame(this.FB, this.Table.FrameSize);
            } else {
                this.WriteFrame(this.FB, this.Table.FrameSize);
            }
            if (this.extended && this.Table.Volume.m_FlushFileSizeUpdates) {
                this.FlushFile(true);
            }
        }
        this.UnlockFreeList();
    }

    private void SortFreeList() throws LHException {
        int size = this.FB.getFreeListSize();
        for (int i = size - this.nreleased; i < size; ++i) {
            int v_j_1;
            int v_i = this.FB.getFreeListElement(i);
            int j = i;
            while ((v_j_1 = this.FB.getFreeListElement(j - 1)) < v_i) {
                this.FB.putFreeListElement(j, v_j_1);
                --j;
            }
            this.FB.putFreeListElement(j, v_i);
        }
        this.nreleased = 0;
    }

    void CheckFreeEndOfFile() throws LHException {
    }

    private void SplitHalf() throws LHException {
        int i;
        this.SortFreeList();
        int size = this.FB.getFreeListSize();
        int j = this.maxfree - size;
        this.FB.putFreeListSize(size -= this.halfmax);
        int prev_nextlist = this.FB.getFreeListNextList();
        int e1 = this.FB.getFreeListElement(size);
        if (prev_nextlist < e1) {
            this.FB.putFreeListNextList(e1);
        }
        this.FB.frame = 0;
        this.WriteFrame(this.FB, this.Table.FrameSize);
        if (j > 0) {
            for (i = this.maxfree - 1; i >= this.halfmax; --i) {
                this.FB.putFreeListElement(i, this.FB.getFreeListElement(i - j));
            }
        }
        while (prev_nextlist > 0) {
            this.FB.frame = prev_nextlist;
            this.ReadFrame(this.FB, this.halffreelist);
            this.FB.putFreeListSize(this.maxfree);
            this.nreleased = this.halfmax;
            e1 = this.FB.getFreeListElement(this.halfmax);
            int e2 = this.FB.getFreeListElement(0);
            if (e1 > e2) {
                this.FB.putFreeListElement(0, e1);
                this.FB.putFreeListElement(this.halfmax, e2);
            }
            this.SortFreeList();
            prev_nextlist = this.FB.getFreeListNextList();
            e1 = this.FB.getFreeListElement(this.halfmax);
            if (prev_nextlist < e1) {
                this.FB.putFreeListNextList(e1);
            }
            this.FB.putFreeListSize(this.halfmax);
            this.FB.frame = this.FB.getFreeListElement(0);
            this.WriteFrame(this.FB, this.Table.FrameSize);
        }
        this.FB.putFreeListNextList(0);
        for (i = 0; i < this.halfmax; ++i) {
            this.FB.putFreeListElement(i, this.FB.getFreeListElement(i + this.halfmax));
        }
        this.FB.putFreeListSize(this.halfmax);
        this.FB.frame = this.FB.getFreeListElement(0);
        this.WriteFrame(this.FB, this.Table.FrameSize);
        this.FB.frame = 0;
        this.ReadFrame(this.FB, this.Table.FrameSize);
    }

    private void ReadNextList() throws LHException {
        int i;
        this.nreleased = this.FB.getFreeListSize();
        for (i = 0; i < this.nreleased; ++i) {
            this.FB.putFreeListElement(this.halfmax + i, this.FB.getFreeListElement(i));
        }
        this.FB.frame = this.FB.getFreeListNextList();
        this.ReadFrame(this.FB, this.halffreelist);
        this.FB.putFreeListSize(this.FB.getFreeListSize() + this.nreleased);
        i = this.FB.getFreeListElement(this.halfmax);
        this.FB.putFreeListElement(this.halfmax, this.FB.getFreeListElement(0));
        this.FB.putFreeListElement(0, i);
        this.SortFreeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InitAllFrames(boolean modulo1) throws LHException {
        this.LockGroupAll();
        try {
            this.F.overflow = false;
            this.F.group = 0;
            this.F.frame = 0;
            this.F.putType(26);
            this.F.putDataForward(0);
            this.F.putDataForwardSkip(0);
            this.F.putGroup0FrameSize(this.Table.FrameSize);
            this.F.putGroup0Threshold(this.Table.Threshold);
            this.F.putGroup0SizeLock(this.Table.SizeLock);
            this.F.putGroup0RecordCount(0);
            this.F.putInt(26, 1, 128);
            this.F.fill(26 + 1, this.Table.FrameSize - (26 + 1), this.Table.Volume.m_FillCharacter);
            this.Table.Group0HeaderSize = 26;
            Object object = this.Table.syncRecordCount;
            synchronized (object) {
                this.Table.RecordCount = 0;
                this.Table.NewRecordCount = 0;
            }
            if (modulo1) {
                this.Table.Modulo = 1;
                object = this.Table.syncAlpha;
                synchronized (object) {
                    this.Table.Alpha = 26;
                    this.Table.NewAlpha = 26;
                }
                this.F.putPrimaryModulo(this.Table.Modulo);
                this.F.putGroup0Alpha(this.Table.Alpha);
                this.WriteFrame(this.F, this.Table.FrameSize);
                this.SetFileSize(false, 1);
                if (this.Table.Volume.m_FlushAllUpdates || this.Table.Volume.m_FlushFileSizeUpdates) {
                    this.FlushFile(false);
                }
            } else {
                object = this.Table.syncAlpha;
                synchronized (object) {
                    this.Table.NewAlpha = this.Table.Alpha = 26 + 1 + (13 + 1) * (this.Table.Modulo - 1);
                }
                this.F.putPrimaryModulo(this.Table.Modulo);
                this.F.putGroup0Alpha(this.Table.Alpha);
                this.WriteFrame(this.F, this.Table.FrameSize);
                this.F.putType(13);
                this.F.putInt(13, 1, 128);
                this.F.fill(13 + 1, 26 - (13 + 1), this.Table.Volume.m_FillCharacter);
                while (++this.F.group < this.Table.Modulo) {
                    this.F.frame = this.F.group;
                    this.WriteFrame(this.F, this.Table.FrameSize);
                }
                if (this.Table.Volume.m_FlushAllUpdates) {
                    this.FlushFile(false);
                }
            }
            object = this.Table.syncVerified;
            synchronized (object) {
                this.Table.ModuloVerified = this.Table.Modulo;
                this.Table.AlphaVerified = this.Table.Alpha;
                this.Table.RecordCountVerified = this.Table.RecordCount;
            }
            this.Table.EnsureOVOpen();
            this.SetFileSize(true, 0);
            this.F.overflow = true;
            this.F.frame = 0;
            this.F.putType(14);
            this.F.putFreeListNextList(0);
            this.F.putFreeListSize(1);
            this.F.putFreeListElement(0, 1);
            this.WriteFrame(this.F, this.Table.FrameSize);
            if (this.Table.Volume.m_FlushAllUpdates || this.Table.Volume.m_FlushFileSizeUpdates) {
                this.FlushFile(true);
            }
        }
        finally {
            this.UnlockGroupAll();
        }
    }

    void ReadFrame(LHBuffer buffer, int length) throws LHException {
        LHOSFile fh = buffer.overflow ? this.Table.OV : this.Table.LK;
        try {
            fh.read((long)buffer.frame * (long)this.Table.FrameSize, buffer.buffer, length);
        }
        catch (IOException ioe) {
            throw new LHIOException(this.Table.Name(), buffer.overflow, "Reading", buffer.group, buffer.frame, ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void WriteFrame(LHBuffer buffer, int length) throws LHException {
        Object object;
        LHOSFile fh;
        int type = buffer.getType();
        int NewAlpha = 0;
        int NewRecordCount = 0;
        if (buffer.overflow) {
            fh = this.Table.OV;
            if (type != 14) {
                throw new LHGroupFormatException(this.Table.Name(), buffer.group, buffer.overflow, buffer.frame, 0, "Writing invalid frame type " + type);
            }
        } else {
            fh = this.Table.LK;
            if (buffer.frame == 0) {
                if (type != this.Table.Group0HeaderSize) {
                    throw new LHGroupFormatException(this.Table.Name(), buffer.group, buffer.overflow, buffer.frame, 0, "Writing invalid frame type " + type);
                }
                buffer.putPrimaryModulo(this.Table.Modulo);
                object = this.Table.syncAlpha;
                synchronized (object) {
                    NewAlpha = this.Table.NewAlpha;
                }
                buffer.putGroup0Alpha(NewAlpha);
                if (this.Table.Group0HeaderSize == 26) {
                    object = this.Table.syncRecordCount;
                    synchronized (object) {
                        NewRecordCount = this.Table.NewRecordCount;
                    }
                    buffer.putGroup0RecordCount(NewRecordCount);
                }
                buffer.putGroup0SizeLock(this.Table.SizeLock);
            } else if (type != 13) {
                throw new LHGroupFormatException(this.Table.Name(), buffer.group, buffer.overflow, buffer.frame, 0, "Writing invalid frame type " + type);
            }
        }
        try {
            fh.write((long)buffer.frame * (long)this.Table.FrameSize, buffer.buffer, length);
        }
        catch (IOException ioe) {
            throw new LHIOException(this.Table.Name(), buffer.overflow, "Writing", buffer.group, buffer.frame, ioe.getMessage());
        }
        if (buffer.overflow) {
            this.Table.OVUpdated = true;
        } else {
            this.Table.LKUpdated = true;
            if (buffer.frame == 0) {
                object = this.Table.syncAlpha;
                synchronized (object) {
                    this.Table.Alpha = NewAlpha;
                }
                if (this.Table.Group0HeaderSize == 26) {
                    object = this.Table.syncRecordCount;
                    synchronized (object) {
                        this.Table.RecordCount = NewRecordCount;
                    }
                }
            }
        }
    }

    private int FileSize(boolean overflow) throws LHException {
        LHOSFile fh = overflow ? this.Table.OV : this.Table.LK;
        try {
            return (int)(fh.length() / (long)this.Table.FrameSize);
        }
        catch (IOException ioe) {
            throw new LHIOException(this.Table.Name(), overflow, "Getting File Size", ioe.getMessage());
        }
    }

    private void SetFileSize(boolean overflow, int frames) throws LHException {
        LHOSFile fh = overflow ? this.Table.OV : this.Table.LK;
        try {
            fh.chsize((long)frames * (long)this.Table.FrameSize);
        }
        catch (IOException ioe) {
            throw new LHIOException(this.Table.Name(), overflow, "Setting File Size", ioe.getMessage());
        }
    }

    void FlushFile(boolean overflow) throws LHException {
        try {
            if (overflow) {
                if (this.Table.OVUpdated) {
                    this.Table.OVUpdated = false;
                    this.Table.OV.flush();
                }
            } else if (this.Table.LKUpdated) {
                this.Table.LKUpdated = false;
                this.Table.LK.flush();
            }
        }
        catch (IOException ioe) {
            throw new LHIOException(this.Table.Name(), overflow, "Flushing", ioe.getMessage());
        }
    }

    private void LockGroup0(boolean exclusive) throws LHException {
        if (this.Group0Lock.locked && exclusive && !this.Group0Lock.exclusive) {
            this.UnlockGroup(this.Group0Lock);
        }
        if (!this.Group0Lock.locked) {
            this.LockGroup(0, exclusive, this.Group0Lock);
        }
    }

    void LockGroupF(boolean exclusive) throws LHException {
        this.LockGroup(this.F.group, exclusive, this.GroupFLock);
    }

    private void LockFreeList() throws LHException {
        this.LockGroup(-1, true, this.FreeListLock);
    }

    private void LockGroupAll() throws LHException {
        this.LockGroup(-2, true, this.Group0Lock);
    }

    private void UnlockGroup0() {
        this.UnlockGroup(this.Group0Lock);
    }

    void UnlockGroupF() {
        this.UnlockGroup(this.GroupFLock);
    }

    private void UnlockFreeList() {
        this.UnlockGroup(this.FreeListLock);
    }

    private void UnlockGroupAll() {
        this.UnlockGroup(this.Group0Lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void LockGroup(int group, boolean exclusive, LHGroupLock OurLock) throws LHException {
        LHGroupLock lHGroupLock = OurLock;
        synchronized (lHGroupLock) {
            OurLock.group = group;
            OurLock.exclusive = exclusive;
            OurLock.locked = false;
            boolean bWaitForLock = false;
            Object object = this.Table.syncGroupLocks;
            synchronized (object) {
                if (this.Table.GroupLocks == null) {
                    this.Table.GroupLocks = OurLock;
                    OurLock.NextLock = null;
                    OurLock.locked = true;
                } else {
                    if (group == -2) {
                        bWaitForLock = true;
                    }
                    LHGroupLock GroupLock = this.Table.GroupLocks;
                    LHGroupLock PrevLock = null;
                    do {
                        if (GroupLock.group == -2) {
                            if (PrevLock != null) {
                                if (group != -2) break;
                            }
                            bWaitForLock = true;
                        }
                        if (!bWaitForLock && GroupLock.group == group && (exclusive || GroupLock.exclusive)) {
                            bWaitForLock = true;
                        }
                        PrevLock = GroupLock;
                    } while ((GroupLock = GroupLock.NextLock) != null);
                    PrevLock.NextLock = OurLock;
                    OurLock.NextLock = GroupLock;
                }
            }
            if (bWaitForLock) {
                try {
                    OurLock.wait();
                }
                catch (InterruptedException ie) {}
            } else {
                OurLock.locked = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void UnlockGroup(LHGroupLock OurLock) {
        if (!OurLock.locked) {
            return;
        }
        Object object = this.Table.syncGroupLocks;
        synchronized (object) {
            LHGroupLock GroupLock;
            boolean bInUse = false;
            if (OurLock == this.Table.GroupLocks) {
                this.Table.GroupLocks = OurLock.NextLock;
                if (this.Table.GroupLocks != null) {
                    LHGroupLock cfr_ignored_0 = this.Table.GroupLocks;
                    if (this.Table.GroupLocks.group == -2) {
                        LHGroupLock lHGroupLock = this.Table.GroupLocks;
                        synchronized (lHGroupLock) {
                            this.Table.GroupLocks.locked = true;
                            this.Table.GroupLocks.notifyAll();
                        }
                        OurLock.locked = false;
                        return;
                    }
                }
            } else {
                GroupLock = this.Table.GroupLocks;
                while (GroupLock != null) {
                    if (GroupLock.group == OurLock.group) {
                        bInUse = true;
                    }
                    if (GroupLock.NextLock == OurLock) {
                        GroupLock.NextLock = OurLock.NextLock;
                        break;
                    }
                    GroupLock = GroupLock.NextLock;
                }
            }
            if (bInUse || OurLock.NextLock == null) {
                OurLock.locked = false;
                return;
            }
            if (OurLock.group == -2) {
                GroupLock = OurLock.NextLock;
                while (GroupLock != null) {
                    if (GroupLock.group == -2) break;
                    GroupLock.unlocked = true;
                    GroupLock = GroupLock.NextLock;
                }
                OurLock = OurLock.NextLock;
                while (OurLock != null) {
                    if (OurLock.group == -2) break;
                    if (OurLock.unlocked) {
                        OurLock.unlocked = false;
                        LHGroupLock lHGroupLock = OurLock;
                        synchronized (lHGroupLock) {
                            OurLock.locked = true;
                            OurLock.notifyAll();
                        }
                        bInUse = OurLock.exclusive;
                        GroupLock = OurLock.NextLock;
                        while (GroupLock != null) {
                            if (GroupLock.group == -2) break;
                            if (GroupLock.group == OurLock.group) {
                                GroupLock.unlocked = false;
                                if (!bInUse) {
                                    if (GroupLock.exclusive) {
                                        bInUse = true;
                                    } else {
                                        lHGroupLock = GroupLock;
                                        synchronized (lHGroupLock) {
                                            GroupLock.locked = true;
                                            GroupLock.notifyAll();
                                        }
                                    }
                                }
                            }
                            GroupLock = GroupLock.NextLock;
                        }
                    }
                    OurLock = OurLock.NextLock;
                }
                return;
            }
            GroupLock = OurLock.NextLock;
            while (GroupLock != null) {
                if (GroupLock.group == OurLock.group) {
                    LHGroupLock lHGroupLock;
                    if (GroupLock.exclusive) {
                        if (bInUse) break;
                        lHGroupLock = GroupLock;
                        synchronized (lHGroupLock) {
                            GroupLock.locked = true;
                            GroupLock.notifyAll();
                            break;
                        }
                    }
                    if (!OurLock.exclusive) break;
                    lHGroupLock = GroupLock;
                    synchronized (lHGroupLock) {
                        GroupLock.locked = true;
                        GroupLock.notifyAll();
                    }
                    bInUse = true;
                }
                GroupLock = GroupLock.NextLock;
            }
            OurLock.locked = false;
        }
    }

    private void CalculateLNP(int modulo) {
        this.l = 0;
        if (modulo <= 1) {
            this.p = -1;
            this.n = 2;
        } else {
            int x = modulo >> 1;
            while ((x >>= 1) > 0) {
                ++this.l;
            }
            this.p = modulo & (1 << this.l) - 1;
            this.n = modulo - this.p >> this.l;
        }
    }

    private int HashKeyId(int iHashId) {
        int urand;
        this.seed = iHashId;
        if (this.p == -1) {
            return 0;
        }
        int group = this.seed & 1;
        int stepsize = 0;
        int stepmask = 0;
        int u = 1;
        while (u++ <= this.l) {
            urand = this.RandomMod4();
            if (urand >= 2) {
                group = (group & stepmask) + (urand << stepsize);
            }
            stepmask = (stepmask << 1) + 1;
            ++stepsize;
        }
        u = this.p > (group & stepmask) ? this.n + 1 : this.n;
        while ((urand = this.RandomMod4()) >= u) {
        }
        if (urand >= 2) {
            return (group & stepmask) + (urand << stepsize);
        }
        return group;
    }

    private int RandomMod4() {
        this.seed = this.seed * 314159621 + 6700417;
        return this.seed >> 16 & 3;
    }
}

