/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.lh.JLHFile;
import com.tangosol.io.lh.JLHSelect;
import com.tangosol.io.lh.LHBuffer;
import com.tangosol.io.lh.LHException;
import com.tangosol.io.lh.LHGroupFormatException;
import com.tangosol.io.lh.LHGroupLock;
import com.tangosol.io.lh.LHIOException;
import com.tangosol.io.lh.LHLock;
import com.tangosol.io.lh.LHOSFile;
import com.tangosol.io.lh.LHSubs;
import com.tangosol.io.lh.LHVolume;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

class LHTable {
    LHVolume Volume;
    String strName;
    Object syncLHQueues;
    JLHFile LHFileQueueHead;
    JLHFile LHFileQueueTail;
    JLHSelect LHSelectQueueHead;
    JLHSelect LHSelectQueueTail;
    File FileLK;
    Object syncLK;
    LHOSFile LK;
    volatile boolean LKUpdated;
    File FileOV;
    Object syncOV;
    LHOSFile OV;
    volatile boolean OVUpdated;
    boolean ReadOnly;
    boolean DeleteOnExit;
    int Group0HeaderSize;
    int FrameSize;
    int Threshold;
    int HighThreshold;
    int LowThreshold;
    volatile int Modulo;
    volatile int Alpha;
    volatile int RecordCount;
    Object syncAlpha;
    volatile int NewAlpha;
    Object syncRecordCount;
    volatile int NewRecordCount;
    Object syncVerified;
    int ModuloVerified;
    int AlphaVerified;
    int RecordCountVerified;
    Object syncResize;
    int SelectLocks;
    int SizeLock;
    LHTable ResizeQueueNext;
    int ResizeState;
    static final int RESIZE_STATE_NONE = 0;
    static final int RESIZE_STATE_IN_QUEUE = 1;
    static final int RESIZE_STATE_RESIZING = 2;
    static final int RESIZE_STATE_WAITING = 3;
    Object syncGroupLocks;
    LHGroupLock GroupLocks;
    Object syncLocks;
    LHLock FileLocks;
    Hashtable RecordLocks;
    public static final String TYPE_PRIMARY = ".tp";
    public static final String TYPE_OVERFLOW = ".to";

    LHTable(LHVolume Volume, String Name2) {
        this.Volume = Volume;
        this.strName = Name2;
        this.syncLHQueues = new Object();
        this.syncLK = new Object();
        this.syncOV = new Object();
        this.syncAlpha = new Object();
        this.syncRecordCount = new Object();
        this.syncVerified = new Object();
        this.syncGroupLocks = new Object();
        this.syncResize = new Object();
        this.syncLocks = new Object();
        this.RecordLocks = new Hashtable();
    }

    String Name() {
        return new File(this.Volume.m_Name, this.strName).getPath();
    }

    boolean isLKOpen() {
        return this.LK != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InitializeFileUse() throws LHException {
        Object object = this.syncLK;
        synchronized (object) {
            if (this.LK == null) {
                SecurityManager security;
                String PathLK = this.Name() + TYPE_PRIMARY;
                this.ReadOnly = this.Volume.m_ReadOnly;
                if (!this.ReadOnly && (security = System.getSecurityManager()) != null) {
                    try {
                        security.checkWrite(PathLK);
                    }
                    catch (SecurityException se) {
                        this.ReadOnly = true;
                    }
                }
                try {
                    this.LK = new LHOSFile(PathLK, this.ReadOnly);
                }
                catch (IOException ioe) {
                    throw new LHIOException(this.Name(), false, "Opening", ioe.getMessage());
                }
            }
            if (this.Group0HeaderSize == 0) {
                LHBuffer Group0Header = new LHBuffer(26);
                try {
                    this.LK.read(0L, Group0Header.buffer, 26);
                }
                catch (IOException ioe) {
                    throw new LHIOException(this.Name(), false, "Reading", 0, 0, ioe.getMessage());
                }
                this.Group0HeaderSize = Group0Header.getType();
                if (this.Group0HeaderSize != 26) {
                    if (this.Group0HeaderSize != 22) {
                        LHGroupFormatException lhe = new LHGroupFormatException(this.Name(), 0, false, 0, 0, "Frame type \"" + this.Group0HeaderSize + "\" invalid");
                        this.Group0HeaderSize = 0;
                        throw lhe;
                    }
                }
                this.FrameSize = Group0Header.getGroup0FrameSize();
                this.Threshold = Group0Header.getGroup0Threshold();
                this.Modulo = Group0Header.getPrimaryModulo();
                this.Alpha = Group0Header.getGroup0Alpha();
                int MinAlpha = this.Group0HeaderSize + 1 + (13 + 1) * (this.Modulo - 1);
                if (this.Alpha < MinAlpha) {
                    this.Alpha = MinAlpha;
                } else if (this.Alpha > this.Modulo * this.FrameSize) {
                    this.Alpha = this.Modulo * this.FrameSize;
                }
                this.RecordCount = this.Group0HeaderSize == 26 ? Group0Header.getGroup0RecordCount() : 0;
                this.SizeLock = Group0Header.getGroup0SizeLock();
                this.HighThreshold = this.Threshold * this.FrameSize / 256;
                this.LowThreshold = this.HighThreshold * 9 / 10;
                this.NewAlpha = this.Alpha;
                this.NewRecordCount = this.RecordCount;
                this.ModuloVerified = 0;
                this.AlphaVerified = 0;
                this.RecordCountVerified = 0;
                LHSubs.CheckForResize(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void EnsureOVOpen() throws LHException {
        Object object = this.syncOV;
        synchronized (object) {
            if (this.OV == null) {
                String PathOV = this.Name() + TYPE_OVERFLOW;
                try {
                    this.OV = new LHOSFile(PathOV, this.ReadOnly);
                }
                catch (IOException ioe) {
                    throw new LHIOException(this.Name(), false, "Opening", ioe.getMessage());
                }
            }
        }
    }

    void CloseFiles() {
        if (this.OV != null) {
            try {
                this.OV.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.OV = null;
        }
        this.Group0HeaderSize = 0;
        if (this.LK != null) {
            try {
                this.LK.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.LK = null;
        }
    }
}

