/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.license;

import com.tangosol.run.xml.SimpleDocument;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class UpdateLicense
extends Base {
    private static final String LICENSE = "tangosol-license.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] asArg) throws IOException {
        if (asArg.length == 0) {
            UpdateLicense.usage();
            return;
        }
        if (asArg.length == 1) {
            InputStream stream = UpdateLicense.class.getResourceAsStream("/tangosol-license.xml");
            String sTarget = asArg[0];
            UpdateLicense.updateTarget(stream, sTarget);
        } else {
            String sSource = asArg[0];
            String sTarget = asArg[1];
            JarFile jarSource = null;
            try {
                jarSource = new JarFile(sSource);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (jarSource == null) {
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(sSource);
                    UpdateLicense.updateTarget(stream, sTarget);
                }
                catch (IOException e) {
                    UpdateLicense.err("Invalid source " + e);
                    return;
                }
                finally {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
            }
            JarEntry entry = jarSource.getJarEntry(LICENSE);
            if (entry == null) {
                UpdateLicense.err("Missing license in archive " + sSource);
                return;
            }
            try {
                InputStream stream = jarSource.getInputStream(entry);
                UpdateLicense.updateTarget(stream, sTarget);
            }
            finally {
                jarSource.close();
            }
        }
    }

    private static void usage() {
        UpdateLicense.out("Usage:");
        UpdateLicense.out("    java com.tangosol.license.UpdateLicense [<license-source>] <license-target>");
        UpdateLicense.out();
        UpdateLicense.out("where");
        UpdateLicense.out("   license-source  path to a 'coherence.jar' archive or 'tangosol-license.xml'");
        UpdateLicense.out("                   descriptor to copy the license from. If not specified, the");
        UpdateLicense.out("                   'coherence.jar' specified in the class path is assumed.");
        UpdateLicense.out("   license-target   path to a 'coherence.jar' archive to copy the license into.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTarget(InputStream streamSource, String sPathTarget) throws IOException {
        XmlElement xmlTarget;
        JarFile jarTarget;
        XmlDocument xmlSource;
        if (streamSource == null) {
            UpdateLicense.out("Invalid source - operation canceled");
            return;
        }
        try {
            xmlSource = new SimpleParser().parseXml(streamSource);
        }
        catch (IOException e) {
            UpdateLicense.out("Invalid source license " + e);
            return;
        }
        try {
            jarTarget = new JarFile(sPathTarget);
        }
        catch (IOException e) {
            UpdateLicense.out("Invalid target " + e);
            return;
        }
        try {
            JarEntry entry = jarTarget.getJarEntry(LICENSE);
            if (entry != null) {
                InputStream streamLicense = jarTarget.getInputStream(entry);
                xmlTarget = new SimpleParser().parseXml(streamLicense);
            } else {
                xmlTarget = new SimpleDocument("license-document");
            }
        }
        catch (IOException e) {
            UpdateLicense.out("Invalid target license " + e);
            return;
        }
        xmlTarget = UpdateLicense.mergeLicense(xmlSource, xmlTarget);
        File fileTarget = new File(jarTarget.getName());
        File fileTargetTmp = File.createTempFile("tangosol", ".tmp", fileTarget.getParentFile());
        FileOutputStream streamRaw = new FileOutputStream(fileTargetTmp);
        JarOutputStream streamTarget = null;
        try {
            try {
                streamTarget = new JarOutputStream(streamRaw);
                JarEntry entry = new JarEntry(LICENSE);
                String sXml = ((Object)xmlTarget).toString();
                entry.setTime(System.currentTimeMillis());
                entry.setSize(sXml.length());
                entry.setMethod(8);
                streamTarget.putNextEntry(entry);
                UpdateLicense.copyEntryData(new ByteArrayInputStream(sXml.getBytes()), streamTarget);
                Enumeration<JarEntry> enmr = jarTarget.entries();
                while (enmr.hasMoreElements()) {
                    JarEntry entry2 = enmr.nextElement();
                    if (entry2.getName().equals(LICENSE)) continue;
                    JarEntry je = new JarEntry(entry2);
                    je.setCompressedSize(-1L);
                    streamTarget.putNextEntry(je);
                    UpdateLicense.copyEntryData(jarTarget.getInputStream(entry2), streamTarget);
                }
                jarTarget.close();
                streamTarget.close();
                fileTarget.delete();
                if (fileTargetTmp.renameTo(fileTarget)) {
                    fileTargetTmp = null;
                } else {
                    UpdateLicense.out("failed to rename " + fileTargetTmp);
                }
                streamTarget = null;
                jarTarget = null;
            }
            catch (IOException e) {
                UpdateLicense.out("Invalid target " + e);
                if (jarTarget != null) {
                    jarTarget.close();
                }
                if (streamTarget != null) {
                    streamTarget.close();
                }
                if (fileTargetTmp != null) {
                    fileTargetTmp.delete();
                }
                return;
            }
        }
        finally {
            if (jarTarget != null) {
                jarTarget.close();
            }
            if (streamTarget != null) {
                streamTarget.close();
            }
            if (fileTargetTmp != null) {
                fileTargetTmp.delete();
            }
        }
    }

    private static void copyEntryData(InputStream streamIn, JarOutputStream streamOut) throws IOException {
        int BLOCK = 4096;
        byte[] ab = new byte[BLOCK];
        try {
            int cb;
            while ((cb = streamIn.read(ab, 0, BLOCK)) >= 0) {
                if (cb <= 0) continue;
                streamOut.write(ab, 0, cb);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        streamIn.close();
        streamOut.closeEntry();
    }

    private static XmlElement mergeLicense(XmlElement xmlSource, XmlElement xmlTarget) {
        for (XmlElement xmlLicense : xmlSource.getElementList()) {
            String sSoftware = xmlLicense.getSafeElement("software").getString();
            XmlElement xmlSoftware = XmlHelper.findElement(xmlTarget, "license/software", sSoftware);
            if (xmlSoftware != null) {
                xmlTarget.getElementList().remove(xmlSoftware.getParent());
            }
            xmlTarget.getElementList().add(xmlLicense.clone());
        }
        return xmlTarget;
    }
}

