/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.NonBlockingTcpDatagramSocket;
import com.tangosol.net.TcpDatagramSocket;
import com.tangosol.net.WrapperSocketProvider;
import com.tangosol.run.xml.XmlElement;
import java.io.IOException;
import java.net.DatagramSocket;

public class TcpSocketProvider
extends WrapperSocketProvider {
    protected boolean m_fBlocking = false;
    protected int m_nAdvanceFrequency;
    public static final String XML_NAME = "tcp";

    @Override
    public DatagramSocket openDatagramSocket() throws IOException {
        return this.configure(this.m_fBlocking ? new TcpDatagramSocket(this) : new NonBlockingTcpDatagramSocket(this));
    }

    @Override
    public void setConfig(XmlElement xml) {
        if (this.m_xml != null) {
            throw new IllegalStateException("Already configured");
        }
        if (xml == null) {
            throw new IllegalArgumentException("Missing configuration");
        }
        if (!xml.getName().equals(XML_NAME) && this.getClass() == TcpSocketProvider.class) {
            throw new IllegalArgumentException("Invalid configuration: " + xml);
        }
        super.setConfig(xml);
        XmlElement xmlCat = xml.getSafeElement("datagram-socket");
        XmlElement xmlSub = xmlCat.getElement("blocking");
        if (xmlSub != null) {
            this.m_fBlocking = xmlSub.getBoolean(true);
        }
        if ((xmlSub = xmlCat.getElement("advance-frequency")) != null) {
            this.m_nAdvanceFrequency = xmlSub.getInt();
        }
    }

    public String toString() {
        return "TcpSocketProvider";
    }

    protected TcpDatagramSocket configure(TcpDatagramSocket socket) {
        int nAdvanceFrequency = this.m_nAdvanceFrequency;
        if (nAdvanceFrequency > 0) {
            socket.setAdvanceFrequency(nAdvanceFrequency);
        }
        return socket;
    }
}

