/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.proxy;

import com.tangosol.net.Member;
import com.tangosol.net.proxy.AbstractProxyServiceLoadBalancer;
import com.tangosol.net.proxy.ProxyServiceLoad;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefaultProxyServiceLoadBalancer
extends AbstractProxyServiceLoadBalancer {
    protected ProxyServiceLoad m_loadLocal;
    protected final Map<Member, ProxyServiceLoad> m_mapLoad = new HashMap<Member, ProxyServiceLoad>();
    protected final SortedMap<ProxyServiceLoad, Member> m_mapMember;

    public DefaultProxyServiceLoadBalancer() {
        this(null);
    }

    public DefaultProxyServiceLoadBalancer(Comparator comparator) {
        this.m_mapMember = new TreeMap<ProxyServiceLoad, Member>(comparator);
    }

    @Override
    public void update(Member member, ProxyServiceLoad load) {
        if (this.isLocalMember(member)) {
            if (load == null) {
                this.m_mapLoad.clear();
                this.m_mapMember.clear();
            }
            this.m_loadLocal = load;
        } else {
            Map<Member, ProxyServiceLoad> mapLoad = this.m_mapLoad;
            SortedMap<ProxyServiceLoad, Member> mapMember = this.m_mapMember;
            ProxyServiceLoad loadOld = mapLoad.remove(member);
            if (loadOld != null) {
                mapMember.remove(loadOld);
            }
            if (load != null) {
                mapLoad.put(member, load);
                mapMember.put(load, member);
            }
        }
    }

    @Override
    public List<Member> getMemberList(Member client) {
        Map.Entry entry;
        ProxyServiceLoad loadThat;
        ProxyServiceLoad loadLocal = this.m_loadLocal;
        if (loadLocal == null) {
            return null;
        }
        SortedMap<ProxyServiceLoad, Member> mapMember = this.m_mapMember;
        if (mapMember.isEmpty()) {
            return null;
        }
        ArrayList<Member> list = new ArrayList<Member>(mapMember.size());
        Iterator i$ = mapMember.entrySet().iterator();
        while (i$.hasNext() && (loadThat = (ProxyServiceLoad)(entry = i$.next()).getKey()).compareTo(loadLocal) < 0) {
            list.add((Member)entry.getValue());
        }
        if (!list.isEmpty()) {
            list.add(this.getLocalMember());
        }
        return list;
    }
}

